/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.fi.ar.formplugin.info.FilterColumnInfo;
import org.apache.commons.lang.StringUtils;

public class ForwarderList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ForwarderList.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isOpenByHyperLink;
        super.filterContainerInit(args);
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        Object target = customParams.get("isOpenByHyperLink");
        boolean bl = isOpenByHyperLink = target == null ? false : (Boolean)target;
        if (isOpenByHyperLink) {
            ArrayList<CommonFilterColumn> custFilterColumns = new ArrayList<CommonFilterColumn>(64);
            List commonFilterColumns = args.getCommonFilterColumns();
            List commonList = null;
            try {
                commonList = (List)JSONUtils.cast((String)customParams.get("commonList").toString(), ArrayList.class, (Class[])new Class[]{FilterColumnInfo.class});
            }
            catch (IOException e) {
                logger.error("context", (Throwable)e);
            }
            if (commonList != null) {
                for (FilterColumnInfo filterInfo : commonList) {
                    CommonFilterColumn filterColumn = this.getOrCreateFilterColumn(filterInfo, commonFilterColumns);
                    custFilterColumns.add(filterColumn);
                }
            }
            args.getCommonFilterColumns().clear();
            args.getCommonFilterColumns().addAll(custFilterColumns);
        }
    }

    private CommonFilterColumn getOrCreateFilterColumn(FilterColumnInfo filterInfo, List<FilterColumn> commonFilterColumns) {
        CommonFilterColumn column = null;
        String pk = filterInfo.getValue().toString();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (StringUtils.indexOf((String)fieldName, (String)".") != -1) {
                fieldName = StringUtils.substringBefore((String)commonFilter.getFieldName(), (String)".");
            }
            if (!fieldName.equals(filterInfo.getKey())) continue;
            commonFilter.getComboItems().clear();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            comboItems.add(new ComboItem(new LocaleString(filterInfo.getValueName()), pk));
            commonFilter.setMustInput(true);
            commonFilter.setComboItems(comboItems);
            commonFilter.setDefaultValue(pk);
            column = commonFilter;
            break;
        }
        if (column == null) {
            column = new CommonFilterColumn();
            column.setFieldName(filterInfo.getKey());
            column.setKey(filterInfo.getKey());
            column.setCaption(new LocaleString(filterInfo.getCaption()));
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            column.setMustInput(true);
            ArrayList<String> defaultValues = new ArrayList<String>();
            if (filterInfo.getValue() instanceof List) {
                List value = (List)filterInfo.getValue();
                for (Object o : value) {
                    String s = o.toString();
                    defaultValues.add(s);
                    comboItems.add(new ComboItem(new LocaleString(filterInfo.getValueName()), s));
                }
            } else {
                defaultValues.add(pk);
                comboItems.add(new ComboItem(new LocaleString(filterInfo.getValueName()), pk));
            }
            column.setDefaultValues(defaultValues);
            column.setComboItems(comboItems);
        }
        return column;
    }
}

