/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.formplugin.formservice.GLTEditService;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class GLTEditPlugin
extends AbstractBillPlugIn {
    private GLTEditService arfService = new GLTEditService();

    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        switch (key) {
            case "materiel": {
                this.arfService.materialChanged(changeData, this.getModel(), this.getView());
                if (newValue == null) break;
                this.setInvName((DynamicObject)newValue);
                break;
            }
            case "expenseitem": {
                this.arfService.expenseitemChanged(changeData, this.getModel(), this.getView());
                if (newValue == null) break;
                this.setInvName((DynamicObject)newValue);
                break;
            }
            case "taxsupertypenum": {
                this.arfService.taxsupertypenumChanged(changeData, this.getModel());
                break;
            }
            case "istax": {
                this.arfService.istaxChanged(changeData, this.getModel(), this.getView());
                break;
            }
            case "taxratef7": {
                this.arfService.taxrateChanged(changeData, this.getModel());
            }
        }
    }

    private void setInvName(DynamicObject newValue) {
        this.getModel().setValue("invname", (Object)newValue.getLocaleString("name").getLocaleValue());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save"});
        this.filterMeasureUnit();
        this.filterMateriel();
    }

    private void filterMeasureUnit() {
        BasedataEdit measureUnitEdit = (BasedataEdit)this.getControl("measureunit");
        FormServiceHelper.addMeasureUnitFilter((IDataModel)this.getModel(), (String)"materiel", (String)"entry", (BasedataEdit)measureUnitEdit);
    }

    private void filterMateriel() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("materiel");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setCustomParam("isShowAllNoOrg", (Object)"true"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if ("btn_save".equals(key)) {
            OperateOption option = OperateOption.create();
            String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
            option.setVariableValue("type", type);
            this.getView().invokeOperation("save", option);
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"taxsupertypenum"});
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Map data = e.getSourceData();
        this.goodsLinkTaxTypeImport(data);
    }

    private void goodsLinkTaxTypeImport(Map<String, Object> data) {
        String taxSupertypeNumber;
        DynamicObject taxSupertype;
        JSONObject materielJson = (JSONObject)data.get("materiel");
        JSONObject expenseitemJson = (JSONObject)data.get("expenseitem");
        JSONObject measureUnitJson = (JSONObject)data.get("measureunit");
        JSONObject taxSupertypeJson = (JSONObject)data.get("taxsupertypenum");
        Object isTaxJson = data.get("istax");
        Long id = (Long)data.get("id");
        JSONObject taxrateJson = (JSONObject)data.get("taxratef7");
        if (materielJson == null && expenseitemJson == null || materielJson != null && expenseitemJson != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u548c\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\u6216\u5168\u90e8\u4e0d\u4e3a\u7a7a\u3002", (String)"GLTEditPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        if (materielJson != null) {
            this.checkMaterielByImport(materielJson, measureUnitJson, id);
        }
        if (expenseitemJson != null) {
            this.checkExpenseItemByImport(expenseitemJson, id);
        }
        if (ObjectUtils.isEmpty((Object)(taxSupertype = QueryServiceHelper.queryOne((String)"er_taxclasscode", (String)"status,enable,parent,name,vatspecialmanagement,taxrate", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(taxSupertypeNumber = taxSupertypeJson.getString("number")))})))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"GLTEditPlugin_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        this.setTaxSpNameByImport(taxSupertype);
        if (ObjectUtils.isEmpty((Object)isTaxJson)) {
            this.setIsTaxByImport(taxSupertype);
        }
        if (taxrateJson == null) {
            this.setTaxRateByImport(taxSupertype);
        } else {
            this.checkTaxRateByImport(taxrateJson);
        }
    }

    private void setTaxSpNameByImport(DynamicObject taxSupertype) {
        long parent = taxSupertype.getLong("parent");
        if (parent == 0L) {
            this.getModel().setValue("taxsupertypename", (Object)taxSupertype.getString("name"));
        } else {
            DynamicObject taxSupertypeParent = QueryServiceHelper.queryOne((String)"er_taxclasscode", (String)"name,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parent)});
            this.setTaxSpNameByImport(taxSupertypeParent);
        }
    }

    private void setTaxRateByImport(DynamicObject taxSupertype) {
        BigDecimal calculTax = taxSupertype.getBigDecimal("taxrate");
        QFilter[] filters = new QFilter[]{new QFilter("taxrate", "=", (Object)(calculTax = calculTax.multiply(BigDecimal.valueOf(100L)))).and(new QFilter("enable", "=", (Object)Boolean.TRUE)).and(new QFilter("activedate", "<=", (Object)new Date())).and(new QFilter("expdate", ">", (Object)new Date()).or(new QFilter("expdate", "is null", null)))};
        DynamicObjectCollection taxRate = QueryServiceHelper.query((String)"bd_taxrate", (String)"id", (QFilter[])filters);
        if (!ObjectUtils.isEmpty((Object)taxRate) && taxRate.size() == 1) {
            this.getModel().setValue("taxratef7", (Object)((DynamicObject)taxRate.get(0)).getLong("id"));
            this.getModel().setValue("taxrate", taxSupertype.get("taxrate"));
        } else {
            this.getModel().setValue("taxratef7", null);
            this.getModel().setValue("taxrate", null);
        }
    }

    private void setIsTaxByImport(DynamicObject taxSupertype) {
        String vsManageMent = taxSupertype.getString("vatspecialmanagement");
        if ("".equals(vsManageMent) || vsManageMent == null) {
            this.getModel().setValue("istax", (Object)Boolean.TRUE);
        } else {
            this.getModel().setValue("istax", (Object)Boolean.FALSE);
        }
    }

    private void checkMaterielByImport(JSONObject materielJson, JSONObject measureUnitJson, Long id) {
        String modelNum;
        String materielNumber = materielJson.getString("number");
        DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"status,enable,baseunit,modelnum", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)materielNumber)});
        if (ObjectUtils.isEmpty((Object)material)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u5b58\u5728\u3002", (String)"GLTEditPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        if (!"C".equals(material.getString("status")) || !"1".equals(material.getString("enable"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u5b58\u5728\u3002", (String)"GLTEditPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        QFilter materielQFilter = new QFilter("materiel.number", "=", (Object)materielNumber);
        if (!ObjectUtils.isEmpty((Object)id)) {
            materielQFilter.and(new QFilter("id", "!=", (Object)id));
        }
        if (!ObjectUtils.isEmpty((Object)(modelNum = material.getString("modelnum"))) && EmptyUtils.isEmpty((Object)this.getModel().getValue("spectype"))) {
            this.getModel().setValue("spectype", (Object)modelNum);
        }
        long baseUnit = material.getLong("baseunit");
        if (ObjectUtils.isEmpty((Object)measureUnitJson) && EmptyUtils.isEmpty((Object)this.getModel().getValue("measureunit"))) {
            this.getModel().setValue("measureunit", (Object)baseUnit);
        }
    }

    private void checkExpenseItemByImport(JSONObject expenseitemJson, Long id) {
        String expenseitemNumber = expenseitemJson.getString("number");
        DynamicObject expenseitem = QueryServiceHelper.queryOne((String)"er_expenseitemedit", (String)"status,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)expenseitemNumber)});
        if (ObjectUtils.isEmpty((Object)expenseitem)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"GLTEditPlugin_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        if (!"C".equals(expenseitem.getString("status")) || !"1".equals(expenseitem.getString("enable"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"GLTEditPlugin_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        QFilter expenseitemQFilter = new QFilter("expenseitem.number", "=", (Object)expenseitemNumber);
        if (!ObjectUtils.isEmpty((Object)id)) {
            expenseitemQFilter.and(new QFilter("id", "!=", (Object)id));
        }
    }

    private void checkTaxRateByImport(JSONObject taxrateJson) {
        String taxrateNumber = taxrateJson.getString("number");
        DynamicObject taxrate = QueryServiceHelper.queryOne((String)"bd_taxrate", (String)"status,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)taxrateNumber)});
        if (ObjectUtils.isEmpty((Object)taxrate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u5b58\u5728\u3002", (String)"GLTEditPlugin_6", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        if (!"C".equals(taxrate.getString("status")) || !"1".equals(taxrate.getString("enable"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u5b58\u5728\u3002", (String)"GLTEditPlugin_6", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }
}

