/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.business.baddebt.impl.InitAsstactAdvancesAmtDetail;
import kd.fi.ar.business.baddebt.impl.InitAsstactBaddebtAmtDetail;
import kd.fi.ar.business.baddebt.impl.InitAsstactRecAmtDetail;
import kd.fi.ar.business.baddebt.info.InitAmtPair;
import kd.fi.ar.formplugin.info.FilterColumnInfo;
import kd.fi.ar.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.init.InitServiceHelper;
import kd.fi.arapcommon.init.info.InitEntryInfo;
import kd.fi.arapcommon.init.info.MergeKey;
import kd.fi.arapcommon.service.AdjExchService;
import org.apache.commons.lang.StringUtils;

public class InitEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(InitEdit.class);
    private static final String adjExchCallBack = "adjExchCallBack";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        boolean isInit = (Boolean)this.getModel().getValue("isfinishinit");
        if (!isInit) {
            IDataModel model = this.getModel();
            long orgPk = (Long)((DynamicObject)model.getValue("org")).getPkValue();
            InitAsstactRecAmtDetail recAmtDetail = new InitAsstactRecAmtDetail("ar_finarbill", orgPk);
            InitAsstactRecAmtDetail bizAmtDetail = new InitAsstactRecAmtDetail("ar_busbill", orgPk);
            InitAsstactAdvancesAmtDetail advancesAmtDetail = new InitAsstactAdvancesAmtDetail(orgPk);
            InitAsstactBaddebtAmtDetail baddebtAmtDetail = new InitAsstactBaddebtAmtDetail(orgPk);
            List entries = BaddebtHelper.merge((List)recAmtDetail.getAsstDetail(), (List)advancesAmtDetail.getAsstDetail(), (List)baddebtAmtDetail.getAsstDetail(), (List)bizAmtDetail.getAsstDetail());
            if (!entries.isEmpty()) {
                for (InitEntryInfo info : entries) {
                    int iRow = model.createNewEntryRow("entryentity");
                    MergeKey mergeKey = info.getMergeKey();
                    model.setValue("e_asstacttype", (Object)mergeKey.getAsstActType(), iRow);
                    model.setValue("e_asstact", (Object)mergeKey.getAsst(), iRow);
                    model.setValue("e_currency", (Object)mergeKey.getCurrency(), iRow);
                    InitAmtPair pair = (InitAmtPair)info.getAmtPair();
                    model.setValue("e_finrecamt", (Object)pair.getRecAmt(), iRow);
                    model.setValue("e_recamt", (Object)pair.getAdvancesAmt(), iRow);
                    model.setValue("businessamount", (Object)pair.getBizAmt(), iRow);
                    BigDecimal recAmt = ObjectUtils.isEmpty((Object)pair.getRecAmt()) ? BigDecimal.ZERO : pair.getRecAmt();
                    BigDecimal bizAmt = ObjectUtils.isEmpty((Object)pair.getBizAmt()) ? BigDecimal.ZERO : pair.getBizAmt();
                    BigDecimal advancesAmt = ObjectUtils.isEmpty((Object)pair.getAdvancesAmt()) ? BigDecimal.ZERO : pair.getAdvancesAmt();
                    model.setValue("e_balanceamt", (Object)recAmt.add(bizAmt).subtract(advancesAmt), iRow);
                    model.setValue("e_baddebtamt", (Object)pair.getBaddebtAmt(), iRow);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("submit".equals(operateKey)) {
            IDataModel m = this.getModel();
            m.deleteEntryData("entryentity");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        OperationResult opResult = args.getOperationResult();
        String operateKey = op.getOperateKey().toLowerCase(Locale.ENGLISH);
        if ("submit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("reconciliation".equals(operateKey) && opResult.isSuccess()) {
            InitServiceHelper.reconciliation((boolean)true, (IFormView)this.getView(), null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int iRow = evt.getRowIndex();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject policytype = (DynamicObject)this.getModel().getValue("policytype");
        Object asstactPk = ((DynamicObject)this.getModel().getValue("e_asstact", iRow)).getPkValue();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("e_currency", iRow);
        String asstacttype = (String)this.getModel().getValue("e_asstacttype", iRow);
        String fieldName = evt.getFieldName();
        String entityKey = null;
        if ("e_finrecamt".equals(fieldName)) {
            entityKey = "ar_finarbill";
        } else if ("e_recamt".equals(fieldName)) {
            entityKey = "ar_receivedbill";
        } else if ("e_baddebtamt".equals(fieldName)) {
            entityKey = "ar_baddebtlossbill";
        } else if ("businessamount".equals(fieldName)) {
            entityKey = "ar_busbill";
        }
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(entityKey);
        lsp.setHasRight(true);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (StringUtils.isNotEmpty((String)entityKey)) {
            if ("ar_baddebtlossbill".contains(entityKey)) {
                lsp.setCaption(ResManager.loadKDString((String)"\u671f\u521d\u574f\u8d26", (String)"InitEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                lsp.setCustomParam("isPeriod", (Object)"true");
            } else if ("ar_finarbill".contains(entityKey)) {
                lsp.setCaption(ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u6536\u5355", (String)"InitEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                lsp.setCustomParam("isPeriod", (Object)"true");
            } else if ("ar_busbill".contains(entityKey)) {
                lsp.setCaption(ResManager.loadKDString((String)"\u671f\u521d\u6682\u4f30\u5e94\u6536\u5355", (String)"InitEdit_7", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                lsp.setCustomParam("isPeriod", (Object)"true");
            }
        }
        lsp.setCustomParam("isOpenByHyperLink", (Object)Boolean.TRUE);
        lsp.setCustomParam("commonList", this.getCommonList(entityKey, org, policytype, currency, asstacttype, asstactPk));
        ListFilterParameter lfp = new ListFilterParameter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org.id", "=", org.getPkValue()));
        if (!"ar_receivedbill".equals(entityKey)) {
            filters.add(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        }
        filters.add(new QFilter("asstacttype", "=", (Object)asstacttype));
        QFilter qf = new QFilter("masterid", "=", asstactPk);
        DynamicObjectCollection customers = QueryServiceHelper.query((String)asstacttype, (String)"id", (QFilter[])new QFilter[]{qf});
        if (!ObjectUtils.isEmpty((Object)customers)) {
            logger.info("InitEdit.customers:" + ArApHelper.getPks((Object)customers));
            filters.add(new QFilter("asstact", "in", (Object)ArApHelper.getPks((Object)customers)));
        } else {
            logger.info("InitEdit.customers is empty");
            filters.add(new QFilter("asstact", "=", asstactPk));
        }
        filters.add(new QFilter("currency", "=", currency.getPkValue()));
        lfp.setQFilters(filters);
        lsp.setListFilterParameter(lfp);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<FilterColumnInfo> getCommonList(String entityKey, DynamicObject org, DynamicObject policytype, DynamicObject currency, String asstacttype, Object asstactPk) {
        ArrayList<FilterColumnInfo> commonList = new ArrayList<FilterColumnInfo>();
        commonList.add(new FilterColumnInfo("org", org.getPkValue(), org.getLocaleString("name").getLocaleValue(), ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7", (String)"InitEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        if ("ar_baddebtreservebill".equals(entityKey)) {
            commonList.add(new FilterColumnInfo("policytype", policytype.getPkValue(), policytype.getLocaleString("name").getLocaleValue(), ResManager.loadKDString((String)"\u653f\u7b56\u7c7b\u578b", (String)"InitEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        }
        commonList.add(new FilterColumnInfo("currency", currency.getPkValue(), currency.getLocaleString("name").getLocaleValue(), ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"InitEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        String asstactTypeName = asstacttype;
        if ("bd_supplier".equals(asstacttype)) {
            asstactTypeName = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"InitEdit_21", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        } else if ("bd_customer".equals(asstacttype)) {
            asstactTypeName = ResManager.loadKDString((String)"\u5ba2\u6237", (String)"InitEdit_22", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        } else if ("bos_user".equals(asstacttype)) {
            asstactTypeName = ResManager.loadKDString((String)"\u4eba\u5458", (String)"InitEdit_23", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        }
        commonList.add(new FilterColumnInfo("asstacttype", asstacttype, asstactTypeName, ResManager.loadKDString((String)"\u5f80\u6765\u7c7b\u578b", (String)"InitEdit_5", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        QFilter qf = new QFilter("masterid", "=", asstactPk);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)asstacttype, (String)"id, name", (QFilter[])new QFilter[]{qf});
        commonList.add(new FilterColumnInfo("asstact.id", ArApHelper.getPks((Object)objs), objs[0].getLocaleString("name").getLocaleValue(), ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"InitEdit_6", (String)"fi-ar-formplugin", (Object[])new Object[0])));
        return commonList;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String bill = "";
        String title = "";
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (StringUtils.equals((String)"bar_ar_finarbill", (String)evt.getItemKey())) {
            if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)"ar_finarbill", (String)"47150e89000000ac")) {
                String entityName = MetadataServiceHelper.getDataEntityType((String)"ar_finarbill").getDisplayName().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"InitEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityName);
                this.getView().showErrorNotification(message);
                return;
            }
            bill = "ar_finarbill";
            title = ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u6536\u5355", (String)"InitEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equals((String)"bar_ar_busbill", (String)evt.getItemKey())) {
            if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)"ar_busbill", (String)"47150e89000000ac")) {
                String entityName = MetadataServiceHelper.getDataEntityType((String)"ar_busbill").getDisplayName().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"InitEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityName);
                this.getView().showErrorNotification(message);
                return;
            }
            bill = "ar_busbill";
            title = ResManager.loadKDString((String)"\u671f\u521d\u6682\u4f30\u5e94\u6536\u5355", (String)"InitEdit_7", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equals((String)"bar_ar_receivedbill", (String)evt.getItemKey())) {
            if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)"ar_receivedbill", (String)"47150e89000000ac")) {
                String entityName = MetadataServiceHelper.getDataEntityType((String)"ar_receivedbill").getDisplayName().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"InitEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityName);
                this.getView().showErrorNotification(message);
                return;
            }
            bill = "ar_receivedbill";
            title = ResManager.loadKDString((String)"\u671f\u521d\u9884\u6536\u5355", (String)"InitEdit_10", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equals((String)"bar_ar_baddebtreservebill", (String)evt.getItemKey())) {
            if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)"ar_baddebtreservebill", (String)"47150e89000000ac")) {
                String entityName = MetadataServiceHelper.getDataEntityType((String)"ar_baddebtreservebill").getDisplayName().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"InitEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityName);
                this.getView().showErrorNotification(message);
                return;
            }
            bill = "ar_baddebtreservebill";
            title = ResManager.loadKDString((String)"\u671f\u521d\u574f\u8d26\u51c6\u5907", (String)"InitEdit_9", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equals((String)"bar_ar_adjustexch", (String)evt.getItemKey())) {
            bill = "ap_adjustexch";
            title = ResManager.loadKDString((String)"\u671f\u521d\u8c03\u6c47", (String)"InitEdit_11", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        } else {
            if (StringUtils.equals((String)"antiinit_btn", (String)evt.getItemKey())) {
                if (org != null) {
                    Boolean isAdj;
                    ArrayList<Long> orgIds = new ArrayList<Long>(8);
                    orgIds.add(org.getLong("id"));
                    Map result = InitHelper.checkDataVolume((boolean)true, (boolean)false, orgIds);
                    boolean isOver = (Boolean)result.get("isOver");
                    String message = "";
                    String confirmTitle = ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u91cf\u8f83\u5927\uff0c\u9884\u8ba1\u6267\u884c\u65f6\u95f4\u8f83\u957f\u3002\u672c\u6b21\u64cd\u4f5c\u5c06\u540e\u53f0\u6267\u884c\uff0c\u6267\u884c\u7ed3\u679c\u4f1a\u7ed9\u64cd\u4f5c\u7528\u6237\u53d1\u9001\u6d88\u606f\u901a\u77e5\u3002", (String)"InitEdit_15", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                    if (isOver) {
                        long finBillCount = Long.parseLong(result.get("ar_finarbill").toString());
                        long busBillCount = Long.parseLong(result.get("ar_busbill").toString());
                        long recBillCount = Long.parseLong(result.get("ar_receivedbill").toString());
                        String periodMsg = ResManager.loadKDString((String)"\u671f\u521d\u5355\u636e\u6570\u91cf\uff1a", (String)"InitEdit_20", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                        String messageFin = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\uff1a%s\u5f20\uff1b", (String)"InitEdit_16", (String)"fi-ar-formplugin", (Object[])new Object[]{finBillCount});
                        String messageBus = ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\u5f20\uff1b", (String)"InitEdit_17", (String)"fi-ar-formplugin", (Object[])new Object[]{busBillCount});
                        String messageRec = ResManager.loadKDString((String)"\u671f\u521d\u9884\u6536\u5355\uff1a%s\u5f20\uff1b", (String)"InitEdit_18", (String)"fi-ar-formplugin", (Object[])new Object[]{recBillCount});
                        message = periodMsg + messageFin + messageBus + messageRec;
                    }
                    if ((isAdj = this.participateInAdjExch(org.getLong("id"))) != null && isAdj.booleanValue()) {
                        String adjMessage = ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u4f1a\u81ea\u52a8\u5220\u9664\u671f\u521d\u8c03\u6c47\u5355\u548c\u671f\u521d\u574f\u8d26\u51c6\u5907\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InitEdit_12", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                        message = message + "\n" + adjMessage;
                    } else {
                        String badMessage = ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u4f1a\u81ea\u52a8\u5220\u9664\u671f\u521d\u574f\u8d26\u51c6\u5907\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InitEdit_19", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                        message = message + "\n" + badMessage;
                    }
                    String callBackListenerName = isOver ? "adjExchCallBackOver" : adjExchCallBack;
                    this.getView().showConfirm(confirmTitle, message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(callBackListenerName));
                }
                return;
            }
            if (StringUtils.equals((String)"finishinit_btn", (String)evt.getItemKey())) {
                ArrayList<Long> orgIds = new ArrayList<Long>(8);
                if (org != null) {
                    orgIds.add(org.getLong("id"));
                    Map result = InitHelper.checkDataVolume((boolean)true, (boolean)true, orgIds);
                    boolean isOver = (Boolean)result.get("isOver");
                    if (isOver) {
                        long finBillCount = Long.parseLong(result.get("ar_finarbill").toString());
                        long busBillCount = Long.parseLong(result.get("ar_busbill").toString());
                        long recBillCount = Long.parseLong(result.get("ar_receivedbill").toString());
                        String confirmTitle = ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u91cf\u8f83\u5927\uff0c\u9884\u8ba1\u6267\u884c\u65f6\u95f4\u8f83\u957f\u3002\u672c\u6b21\u64cd\u4f5c\u5c06\u540e\u53f0\u6267\u884c\uff0c\u6267\u884c\u7ed3\u679c\u4f1a\u7ed9\u64cd\u4f5c\u7528\u6237\u53d1\u9001\u6d88\u606f\u901a\u77e5\u3002", (String)"InitEdit_15", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                        String periodMsg = ResManager.loadKDString((String)"\u671f\u521d\u5355\u636e\u6570\u91cf\uff1a", (String)"InitEdit_20", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                        String messageFin = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\uff1a%s\u5f20\uff1b", (String)"InitEdit_16", (String)"fi-ar-formplugin", (Object[])new Object[]{finBillCount});
                        String messageBus = ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\u5f20\uff1b", (String)"InitEdit_17", (String)"fi-ar-formplugin", (Object[])new Object[]{busBillCount});
                        String messageRec = ResManager.loadKDString((String)"\u671f\u521d\u9884\u6536\u5355\uff1a%s\u5f20\uff1b", (String)"InitEdit_18", (String)"fi-ar-formplugin", (Object[])new Object[]{recBillCount});
                        String message = periodMsg + messageFin + messageBus + messageRec;
                        this.getView().showConfirm(confirmTitle, message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("submitCallBack"));
                    } else {
                        InitHelper.invokeInitializeOp(this.getDataPk(), (String)"ar_init", (String)"initinitialize", (String)"submit", (boolean)true, (IFormView)this.getView(), (boolean)false);
                    }
                }
                return;
            }
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        lsp.setBillFormId(bill);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setCaption(title);
        customParams.put("isPeriod", "true");
        customParams.put("dateFilter", Boolean.TRUE);
        customParams.put("bizSystem", "AR");
        if (!ObjectUtils.isEmpty((Object)org)) {
            customParams.put("initOrg", org.getPkValue());
        }
        lsp.setCustomParams(customParams);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (isOK && Objects.equals(callBackID, adjExchCallBack)) {
            InitHelper.invokeInitializeOp(this.getDataPk(), (String)"ar_init", (String)"initinitialize", (String)"anticloseinit", (boolean)false, (IFormView)this.getView(), (boolean)false);
            return;
        }
        if (isOK && Objects.equals(callBackID, "adjExchCallBackOver")) {
            InitHelper.invokeInitializeOp(this.getDataPk(), (String)"ar_init", (String)"initinitialize", (String)"anticloseinit", (boolean)false, (IFormView)this.getView(), (boolean)true);
            return;
        }
        if (isOK && Objects.equals(callBackID, "submitCallBack")) {
            InitHelper.invokeInitializeOp(this.getDataPk(), (String)"ar_init", (String)"initinitialize", (String)"submit", (boolean)true, (IFormView)this.getView(), (boolean)true);
        }
    }

    private Boolean participateInAdjExch(Long orgId) {
        AdjExchService adjExchService = new AdjExchService("ar");
        Boolean param = adjExchService.getIsParticipateInAdjExch(orgId);
        return param;
    }

    private Set<Long> getDataPk() {
        HashSet<Long> ids = new HashSet<Long>(8);
        Long id = (Long)this.getModel().getValue("id");
        ids.add(id);
        return ids;
    }
}

