/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.util.EmptyUtils;

public class InitList4Upgrade
extends AbstractListPlugin {
    private static String selector = "id, org, policytype, standardcurrency, exratetable, periodtype, startperiod, curperiod, startdate, currentdate, baddebtpolicy, isfinishinit, policyid";
    private MainEntityType dt = null;
    private String userID = null;
    private Date currentDate = new Date();
    private static String p_selector = "id, policytype, periodtype, startperiod, currentperiod, baddebtpolicy";

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String key = op.getOperateKey();
        if ("upgrade".equals(key)) {
            this.upgrade();
        }
    }

    private void upgrade() {
        this.delDupData();
        this.delNotExistOrg();
        this.doUpgrade();
    }

    private void delDupData() {
        String sql = "select FOrgID from t_ar_init group by FOrgID having count(*) > 1;";
        ArrayList<Long> idList = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)InitList4Upgrade.class.getName(), (DBRoute)DBRouteConst.AR, (String)sql);){
            Iterator rowIterator = ds.iterator();
            if (rowIterator != null) {
                while (rowIterator.hasNext()) {
                    Row data = (Row)rowIterator.next();
                    idList.add(data.getLong("FOrgID"));
                }
            }
        }
        if (!idList.isEmpty()) {
            QFilter qFilter = new QFilter("org", "in", idList);
            DynamicObject[] inits = BusinessDataServiceHelper.load((String)"ar_init", (String)selector, (QFilter[])new QFilter[]{qFilter}, (String)"org");
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject init : inits) {
                if (!EmptyUtils.isEmpty((Object)init.getLong("policyid"))) continue;
                pks.add(init.getPkValue());
            }
            if (!pks.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ar_init"), (Object[])pks.toArray());
            }
        }
    }

    private void delNotExistOrg() {
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", null);
        ArrayList<Object> orgPks = new ArrayList<Object>(orgs.length);
        for (DynamicObject org : orgs) {
            orgPks.add(org.getPkValue());
        }
        QFilter qFilter = new QFilter("org", "not in", orgPks);
        Object[] inits = BusinessDataServiceHelper.load((String)"ar_init", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object[])inits)) {
            ArrayList<Object> pks = new ArrayList<Object>(inits.length);
            for (Object init : inits) {
                pks.add(init.getPkValue());
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ar_init"), (Object[])pks.toArray());
        }
    }

    private void doUpgrade() {
        QFilter filter = QFilter.isNull((String)"policyid");
        filter.or(new QFilter("policyid", "=", (Object)0));
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)"ar_init", (String)selector, (QFilter[])new QFilter[]{filter}, (String)"isfinishinit");
        if (inits.length > 0) {
            this.dt = EntityMetadataCache.getDataEntityType((String)"ar_policy");
            this.userID = String.valueOf(RequestContext.get().getCurrUserId());
            ArrayList<Object> delPks = new ArrayList<Object>();
            ArrayList<Long> delOrgPks = new ArrayList<Long>();
            ArrayList<DynamicObject> policyList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> updateInits = new ArrayList<DynamicObject>();
            for (DynamicObject init : inits) {
                long orgPk = (Long)init.getDynamicObject("org").getPkValue();
                QFilter qFilter = new QFilter("org", "=", (Object)orgPk);
                if (!init.getBoolean("isfinishinit")) {
                    if (ObjectUtils.isEmpty((Object)init.getDate("startdate"))) {
                        delPks.add(init.getPkValue());
                        delOrgPks.add(orgPk);
                        continue;
                    }
                    QFilter pFilter = new QFilter("isperiod", "=", (Object)Boolean.TRUE);
                    if (QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter[]{qFilter, pFilter})) {
                        DynamicObject policy = this.getPolicy(orgPk);
                        if (ObjectUtils.isEmpty((Object)policy)) {
                            policyList.add(this.buildPolicy(init));
                            continue;
                        }
                        updateInits.add(this.setInit(init, policy));
                        continue;
                    }
                    delPks.add(init.getPkValue());
                    delOrgPks.add(orgPk);
                    continue;
                }
                DynamicObject policy = this.getPolicy(orgPk);
                if (ObjectUtils.isEmpty((Object)policy)) {
                    policyList.add(this.buildPolicy(init));
                    continue;
                }
                updateInits.add(this.setInit(init, policy));
            }
            if (!delPks.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ar_init"), (Object[])delPks.toArray());
            }
            if (!delOrgPks.isEmpty()) {
                DeleteServiceHelper.delete((String)"ar_policy", (QFilter[])new QFilter[]{new QFilter("org", "in", delOrgPks)});
            }
            ArrayList<DynamicObject> initList = new ArrayList<DynamicObject>();
            if (!policyList.isEmpty()) {
                Object[] objs = SaveServiceHelper.save((IDataEntityType)this.dt, (Object[])policyList.toArray());
                for (DynamicObject init : inits) {
                    Object orgPk = init.getDynamicObject("org").getPkValue();
                    for (Object obj : objs) {
                        DynamicObject policy = (DynamicObject)obj;
                        Object p_orgPk = policy.getDynamicObject("org").getPkValue();
                        if (!orgPk.equals(p_orgPk)) continue;
                        this.setInit(init, policy);
                        initList.add(init);
                    }
                }
            }
            if (!updateInits.isEmpty()) {
                initList.addAll(updateInits);
            }
            if (!initList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])initList.toArray(new DynamicObject[0]));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"InitList4Upgrade_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            ((ListView)this.getView()).refresh();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u6570\u636e\u3002", (String)"InitList4Upgrade_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject setInit(DynamicObject init, DynamicObject policy) {
        init.set("policytype", policy.get("policytype"));
        init.set("periodtype", (Object)policy.getDynamicObject("periodtype"));
        DynamicObject period = policy.getDynamicObject("startperiod");
        init.set("startperiod", (Object)period);
        if (init.getBoolean("isfinishinit")) {
            init.set("curperiod", (Object)period);
            period = BusinessDataServiceHelper.loadSingleFromCache((Object)period.getPkValue(), (String)"bd_period");
            init.set("currentdate", (Object)period.getDate("begindate"));
        }
        init.set("baddebtpolicy", (Object)policy.getString("baddebtpolicy"));
        init.set("policyid", policy.getPkValue());
        return init;
    }

    private DynamicObject getPolicy(long orgPk) {
        Object policy = null;
        QFilter qFilter = new QFilter("org", "=", (Object)orgPk);
        Object[] policys = BusinessDataServiceHelper.load((String)"ar_policy", (String)p_selector, (QFilter[])new QFilter[]{qFilter}, (String)"policytype.type");
        if (!ObjectUtils.isEmpty((Object[])policys)) {
            policy = policys[0];
        }
        return policy;
    }

    private DynamicObject buildPolicy(DynamicObject init) {
        Object[] periodtypes;
        DynamicObject policy = new DynamicObject((DynamicObjectType)this.dt);
        DynamicObject org = init.getDynamicObject("org");
        policy.set("useorg", (Object)org);
        policy.set("org", (Object)org);
        policy.set("createorg", (Object)org);
        policy.set("creator", (Object)this.userID);
        policy.set("modifier", (Object)this.userID);
        policy.set("enable", (Object)1);
        policy.set("createtime", (Object)this.currentDate);
        policy.set("modifytime", (Object)this.currentDate);
        policy.set("currency", init.get("standardcurrency"));
        policy.set("exratetable", init.get("exratetable"));
        Object periodtype = init.getDynamicObject("periodtype");
        if (periodtype == null && (periodtype = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"bd_period_type")) == null && !ObjectUtils.isEmpty((Object[])(periodtypes = BusinessDataServiceHelper.load((String)"bd_period_type", (String)"id, number", null)))) {
            periodtype = periodtypes[0];
        }
        policy.set("periodtype", periodtype);
        if (periodtype != null) {
            policy.set("startperiod", (Object)this.getPeriodByDate(periodtype.getLong("id"), init.getDate("startdate")));
        }
        policy.set("baddebtpolicy", (Object)"allowance");
        DynamicObject[] policytypes = BusinessDataServiceHelper.load((String)"ar_policytype", (String)"id, number", null, (String)"isdefault desc");
        policy.set("policytype", (Object)policytypes[0]);
        policy.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        return policy;
    }

    private DynamicObject getPeriodByDate(long periodTypeId, Date date) {
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }
}

