/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.formplugin.formservice.InvoiceCardService;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.DynamicListHelper;

public class InvoiceBuyerEdit
extends AbstractFormPlugin {
    private static final String OK = "btnok";
    private boolean isBuyerNameChangedByF7 = false;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (parentModel.getProperty(propName) == null) continue;
            Object propValue = parentModel.getValue(propName);
            if (propValue instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)propValue;
                model.setValue(propName, obj.getPkValue());
                continue;
            }
            model.setValue(propName, propValue);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buyerbank", OK});
        this.addClickListeners(new String[]{"buyername", OK});
        this.addClickListeners(new String[]{"buyeracct", OK});
        Long orgId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("orgId"));
        this.filterBuyer(orgId);
    }

    private void filterBuyer(Long orgId) {
        BasedataEdit baseDataCtr = (BasedataEdit)this.getControl("buyer");
        baseDataCtr.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter baseDataFilter = BaseDataHelper.getBasedataFilter((String)showParameter.getBillFormId(), (long)orgId);
            showParameter.getListFilterParameter().getQFilters().add(baseDataFilter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        BasedataEdit control = null;
        switch (key) {
            case "buyername": {
                control = (BasedataEdit)this.getControl("buyer");
                control.click();
                break;
            }
            case "buyerbank": {
                control = (BasedataEdit)this.getControl("buyerbankf7");
                control.click();
                break;
            }
            case "btnok": {
                this.btnOk();
                break;
            }
            case "buyeracct": {
                this.buyerAcctShowF7();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "buyerAcctCallBack": {
                this.buyerAcctCallBack(returnData);
            }
        }
    }

    private void buyerAcctCallBack(Object returnData) {
        ListSelectedRowCollection returnColl = (ListSelectedRowCollection)returnData;
        if (!ObjectUtils.isEmpty((Object)returnColl)) {
            DynamicObject payeerInfo;
            ListSelectedRow rowInfo = returnColl.get(0);
            Object entryKey = rowInfo.getEntryPrimaryKeyValue();
            Object pk = rowInfo.getPrimaryKeyValue();
            DynamicObject basedata = (DynamicObject)this.getModel().getValue("buyer");
            String asstactType = basedata.getDataEntityType().getName();
            if (asstactType.equals("bd_customer") || asstactType.equals("bd_supplier")) {
                DynamicObject cutstomer = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)asstactType, (String)"bankaccount,accountname,bank,name,entry_bank");
                DynamicObjectCollection bankEntry = cutstomer.getDynamicObjectCollection("entry_bank");
                for (DynamicObject row : bankEntry) {
                    if (!row.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue("buyeracct", (Object)row.getString("bankaccount"));
                    this.getModel().setValue("buyerbank", (Object)row.getString("bank.name"));
                    break;
                }
            } else if (asstactType.equals("bos_user") && !ObjectUtils.isEmpty((Object)(payeerInfo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"er_payeer", (String)"id,payerbank,payeraccount")))) {
                this.getModel().setValue("buyeracct", (Object)payeerInfo.getString("payeraccount"));
                this.getModel().setValue("buyerbank", (Object)payeerInfo.getString("payerbank.name"));
            }
        }
    }

    private void buyerAcctShowF7() {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue("buyer");
        if (ObjectUtils.isEmpty((Object)basedata)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d2d\u4e70\u65b9\u3002", (String)"InvoiceBuyerEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
        String asstactType = basedata.getDataEntityType().getName();
        if ("bos_user".equals(asstactType)) {
            DynamicObject[] infos = this.getErPayeeInfo(basedata);
            if (infos == null || infos.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u4eba\u5458\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"InvoiceBuyerEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"er_payeer", (boolean)false, (int)2);
            ListFilterParameter lfp = new ListFilterParameter();
            lfp.setFilter(new QFilter("payer", "=", basedata.getPkValue()));
            lsp.setListFilterParameter(lfp);
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "buyerAcctCallBack");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        } else if ("bd_customer".equals(asstactType)) {
            DynamicObjectCollection coll = DynamicListHelper.getBankCollInfo((Object)basedata.getPkValue(), (String)asstactType);
            if (coll == null || coll.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u6237\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"InvoiceBuyerEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = DynamicListHelper.getCustomerBankInfoShowParameter((Object)basedata.getPkValue());
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "buyerAcctCallBack");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        } else if ("bd_supplier".equals(asstactType)) {
            DynamicObjectCollection coll = DynamicListHelper.getBankCollInfo((Object)basedata.getPkValue(), (String)asstactType);
            if (coll == null || coll.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u4f9b\u5e94\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"InvoiceBuyerEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = DynamicListHelper.getSupplierBankInfoShowParameter((Object)basedata.getPkValue());
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "buyerAcctCallBack");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void btnOk() {
        Map<String, Object> map = InvoiceCardService.initBuyerParamMap(this.getModel());
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "buyername": {
                this.buyerChanged((String)newValue);
                break;
            }
            case "buyer": {
                this.buyerF7Changed(newValue);
                break;
            }
            case "buyerbankf7": {
                this.buyerbankf7Changed(newValue);
                break;
            }
        }
    }

    private void buyerChanged(String newValue) {
        if (!this.isBuyerNameChangedByF7) {
            this.getModel().setValue("buyer", null);
        }
    }

    private void buyerF7Changed(Object newValue) {
        IDataModel model = this.getModel();
        if (newValue == null) {
            return;
        }
        DynamicObject customer = (DynamicObject)newValue;
        String name = customer.getString("name");
        if (customer != null && !"bos_user".equals(model.getValue("asstacttype"))) {
            customer = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)model.getValue("asstacttype").toString());
            model.setValue("buyertin", customer.get("tx_register_no"));
            model.setValue("buyeraddr", (Object)customer.getString("bizpartner_address"));
            model.setValue("buyertel", customer.get("bizpartner_phone"));
            this.setBankInfo(customer);
            this.isBuyerNameChangedByF7 = true;
            model.setValue("buyername", (Object)name);
            this.isBuyerNameChangedByF7 = false;
        } else if (customer != null && "bos_user".equals(model.getValue("asstacttype"))) {
            Object[] erPayeeInfo = this.getErPayeeInfo(customer);
            this.isBuyerNameChangedByF7 = true;
            model.setValue("buyername", (Object)name);
            this.isBuyerNameChangedByF7 = false;
            if (!ObjectUtils.isEmpty((Object[])erPayeeInfo) && erPayeeInfo[0] != null) {
                model.setValue("buyeracct", (Object)erPayeeInfo[0].getString("payeraccount"));
                model.setValue("buyerbank", (Object)erPayeeInfo[0].getDynamicObject("payerbank").getString("name"));
                model.setValue("buyerbankf7", erPayeeInfo[0].getPkValue());
            } else {
                model.setValue("buyeracct", null);
                model.setValue("buyerbank", null);
                model.setValue("buyerbankf7", null);
            }
        }
    }

    private void setBankInfo(DynamicObject customer) {
        String acctBank = null;
        String bank = null;
        DynamicObjectCollection bankColls = customer.getDynamicObjectCollection("entry_bank");
        if (bankColls != null && bankColls.size() > 0) {
            if (bankColls.size() == 1) {
                DynamicObject bankInfo = (DynamicObject)bankColls.get(0);
                acctBank = bankInfo.getString("bankaccount");
                bank = bankInfo.getString("bank.name");
            } else {
                for (int i = 0; i < bankColls.size(); ++i) {
                    DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                    if (bankInfo.getBoolean("isdefault_bank")) {
                        acctBank = bankInfo.getString("bankaccount");
                        bank = bankInfo.getString("bank.name");
                        break;
                    }
                    if (i != 0) continue;
                    acctBank = bankInfo.getString("bankaccount");
                    bank = bankInfo.getString("bank.name");
                }
            }
        }
        this.getModel().setValue("buyeracct", acctBank);
        this.getModel().setValue("buyerbank", bank);
    }

    private void buyerbankf7Changed(Object newValue) {
        DynamicObject bank = (DynamicObject)newValue;
        if (bank != null) {
            this.getModel().setValue("buyerbank", bank.get("name"));
        }
    }

    private DynamicObject[] getErPayeeInfo(DynamicObject basedata) {
        QFilter uFilter = new QFilter("name", "=", (Object)basedata.getString("name"));
        uFilter = uFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        uFilter.and(new QFilter("payer", "=", (Object)basedata.getLong("id")));
        QFilter[] qFilters = new QFilter[]{uFilter};
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number";
        String orderBys = "isdefault desc";
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)orderBys);
        return defaultAccounts;
    }
}

