/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.business.invoice.InvoiceFacadeMock;
import kd.fi.ar.business.invoice.InvoiceVoConverter;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.invoice.InvoiceResult;
import kd.fi.arapcommon.util.BeanConfig;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceCloudDataViewPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.getModel().setValue("billno", parameter.getCustomParam("billno"));
        this.getModel().setValue("taxno", parameter.getCustomParam("taxno"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if ("execute".equals(e.getOperateKey()) && operationResult.isSuccess()) {
            Object object = "";
            HashMap<String, String> resultMap = new HashMap<String, String>(2);
            String type = (String)this.getModel().getValue("type");
            String billno = (String)this.getModel().getValue("billno");
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)this.getSelector(), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno), new QFilter("billstatus", "=", (Object)"C")});
            if (invoice == null) {
                throw new KDBizException("Wrong Number: " + billno);
            }
            switch (type) {
                case "0": {
                    InvoiceVoConverter invoiceVoConverter = new InvoiceVoConverter();
                    object = invoiceVoConverter.convertInvoiceVo(new DynamicObject[]{invoice}, true);
                    break;
                }
                case "1": {
                    InvoiceResult invoiceResult;
                    InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
                    String billNo = invoice.getString("billno");
                    String taxRegNum = invoice.getString("sellertin");
                    String srcbillno = invoice.getString("srcbillno");
                    if (StringUtils.isNotEmpty((String)srcbillno) && !invoice.getBoolean("isabandonreissue")) {
                        billNo = srcbillno;
                    }
                    if ((invoiceResult = invoiceFacade.query(taxRegNum, billNo)) == null) break;
                    object = invoiceResult.getOriginalResult();
                    break;
                }
                case "2": {
                    DynamicObject asyncTx = QueryServiceHelper.queryOne((String)"arap_asynctx", (String)"params,params_tag", (QFilter[])new QFilter[]{new QFilter("xid", "=", (Object)billno), new QFilter("action", "=", (Object)"IssueCallBack"), new QFilter("group", "=", (Object)"ar_invoice")});
                    if (asyncTx == null) break;
                    String tag = asyncTx.getString("params_tag");
                    object = JSON.parseArray((String)tag);
                    break;
                }
                case "91": {
                    BeanFactory.registerBean((String)InvoiceFacade.class.getSimpleName(), InvoiceFacadeMock.class);
                    OperationResult issueResult = OperationServiceHelper.executeOperate((String)"issue", (String)"ar_invoice", (Object[])new Object[]{invoice.getPkValue()}, (OperateOption)OperateOption.create());
                    if (issueResult.isSuccess()) {
                        object = "Success.";
                    } else {
                        List allErrorInfo = issueResult.getAllErrorInfo();
                        if (!allErrorInfo.isEmpty()) {
                            OperateErrorInfo info = (OperateErrorInfo)allErrorInfo.get(0);
                            if ("1004".equals(info.getErrorCode())) {
                                object = "Success.";
                            } else {
                                resultMap.put("Result", "Issue failed.");
                                resultMap.put("Msg", issueResult.getMessage());
                                object = resultMap;
                            }
                        } else {
                            List allErrorOrValidateInfos = issueResult.getAllErrorOrValidateInfo();
                            if (!allErrorOrValidateInfos.isEmpty()) {
                                resultMap.put("Result", "Issue failed.");
                                resultMap.put("Msg", ((IOperateInfo)allErrorOrValidateInfos.get(0)).getMessage());
                                object = resultMap;
                            }
                        }
                    }
                    BeanConfig.remove((String)InvoiceFacade.class.getSimpleName());
                    break;
                }
                case "93": {
                    BeanFactory.registerBean((String)InvoiceFacade.class.getSimpleName(), InvoiceFacadeMock.class);
                    OperationResult applyabandonResult = OperationServiceHelper.executeOperate((String)"applyabandon", (String)"ar_invoice", (Object[])new Object[]{invoice.getPkValue()}, (OperateOption)OperateOption.create());
                    if (applyabandonResult.isSuccess()) {
                        object = "Success.";
                    } else {
                        resultMap.put("Result", "Abandon failed.");
                        resultMap.put("Msg", applyabandonResult.getMessage());
                        object = resultMap;
                    }
                    BeanConfig.remove((String)InvoiceFacade.class.getSimpleName());
                }
            }
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl("data");
            if (ObjectUtils.isEmpty((Object)object)) {
                codeEdit.setText("No Data.");
            } else {
                String pretty = JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                codeEdit.setText(pretty);
            }
        }
    }

    private String getSelector() {
        ArrayList<String> fieldKeys = new ArrayList<String>(81);
        fieldKeys.add("biztype");
        fieldKeys.add("invoicestatus");
        fieldKeys.add("e_invresult");
        fieldKeys.add("applydate");
        fieldKeys.add("invoicecode");
        fieldKeys.add("billno");
        fieldKeys.add("blueinvoicecode");
        fieldKeys.add("blueinvoiceno");
        fieldKeys.add("invoicetype");
        fieldKeys.add("redinvoice");
        fieldKeys.add("selleracct");
        fieldKeys.add("selleraddr");
        fieldKeys.add("seller");
        fieldKeys.add("sellertel");
        fieldKeys.add("sellertin");
        fieldKeys.add("buyeracct");
        fieldKeys.add("buyeraddr");
        fieldKeys.add("email");
        fieldKeys.add("buyertel");
        fieldKeys.add("buyer");
        fieldKeys.add("buyertin");
        fieldKeys.add("currency");
        fieldKeys.add("exratedate");
        fieldKeys.add("exchangerate");
        fieldKeys.add("amount");
        fieldKeys.add("recamount");
        fieldKeys.add("tax");
        fieldKeys.add("e_ispresent");
        fieldKeys.add("e_measureunit");
        fieldKeys.add("e_spectype");
        fieldKeys.add("e_taxclass");
        fieldKeys.add("e_actunitprice");
        fieldKeys.add("e_quantity");
        fieldKeys.add("e_amount");
        fieldKeys.add("e_taxrate");
        fieldKeys.add("e_tax");
        fieldKeys.add("e_discountmode");
        fieldKeys.add("asstact");
        fieldKeys.add("duedate");
        fieldKeys.add("asstacttype");
        fieldKeys.add("paymode");
        fieldKeys.add("paycond");
        fieldKeys.add("recorg");
        fieldKeys.add("salesgroup");
        fieldKeys.add("salesman");
        fieldKeys.add("salesorg");
        fieldKeys.add("drawer");
        fieldKeys.add("payer");
        fieldKeys.add("checker");
        fieldKeys.add("auditor");
        fieldKeys.add("auditdate");
        fieldKeys.add("createtime");
        fieldKeys.add("creator");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("invoiceno");
        fieldKeys.add("inventoryflag");
        fieldKeys.add("serialno");
        fieldKeys.add("remark");
        fieldKeys.add("e_remark");
        fieldKeys.add("e_unitprice");
        fieldKeys.add("e_acttaxunitprice");
        fieldKeys.add("e_material");
        fieldKeys.add("e_expenseitem");
        fieldKeys.add("e_discountamount");
        fieldKeys.add("e_recamount");
        fieldKeys.add("pdfurl");
        fieldKeys.add("elepreviewurl");
        fieldKeys.add("bizdate");
        fieldKeys.add("e_taxunitprice");
        fieldKeys.add("sellername");
        fieldKeys.add("buyerbank");
        fieldKeys.add("sellerbank");
        fieldKeys.add("org");
        fieldKeys.add("e_itemname");
        fieldKeys.add("splitormergeflag");
        fieldKeys.add("buyername");
        fieldKeys.add("e_rowtype");
        fieldKeys.add("e_invspectype");
        fieldKeys.add("e_invoiceunit");
        fieldKeys.add("deduction");
        fieldKeys.add("srcbillno");
        fieldKeys.add("isabandonreissue");
        fieldKeys.add("taxationstyle");
        return String.join((CharSequence)",", fieldKeys);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }
}

