/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.business.invoice.InvoiceSourceAppointor;
import kd.fi.ar.business.invoice.TaxClassMatcher;
import kd.fi.ar.enums.BillStatusEnum;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.ar.formplugin.ArBaseEdit;
import kd.fi.ar.formplugin.formservice.Invoice.ArInvoiceBillImportHelper;
import kd.fi.ar.formplugin.formservice.InvoiceBizService;
import kd.fi.ar.formplugin.formservice.InvoiceCardService;
import kd.fi.ar.helper.OrgHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.PrecisionHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.BillStatusCtrlService;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceEdit
extends ArBaseEdit {
    private InitHelper init;
    private ArInvoiceBillImportHelper importHelper;
    private static final String INVOICETYPE = "invoiceType";
    private static final String BIZTYPE = "bizType";
    private boolean isCopyEntryRow = false;
    private static final String[] ENTRY = new String[]{"e_unitprice", "e_amount", "e_localamt", "e_taxunitprice", "e_tax", "e_discountamount", "e_discountlocalamt", "e_recamount", "e_reclocalamt", "e_unverifiedwriteoffamt"};
    private static final String[] HEAD = new String[]{"recamount", "reclocalamt", "amount", "localamt", "tax", "redinvoice"};
    private BillStatusCtrlService billStatusCtrlService = new BillStatusCtrlService();

    private ArInvoiceBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new ArInvoiceBillImportHelper(this.getView(), this.getPageCache());
        }
        return this.importHelper;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterMaterialVersion();
        this.addClickListeners(new String[]{"withtax1", "withtax2", "addseller1", "addseller2", "changeseller", "addbuyer1", "addbuyer2", "changebuyer"});
        this.addClickListeners(new String[]{"e_corebillno"});
        this.filterMeasureUnit();
        this.taxratefilter();
    }

    private void filterMeasureUnit() {
        BasedataEdit measureUnitEdit = (BasedataEdit)this.getControl("e_measureunit");
        FormServiceHelper.addMeasureUnitFilter((IDataModel)this.getModel(), (String)"e_material", (String)"entry", (BasedataEdit)measureUnitEdit);
    }

    private void taxratefilter() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        BasedataEdit taxrateF7 = (BasedataEdit)this.getControl("taxrateid");
        BaseDataHelper.taxratefilter((Date)bizdate, (BasedataEdit)taxrateF7);
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            if (!ObjectUtils.isEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (parameter.isInitialized()) {
            this.afterCreateNewModel();
        }
    }

    private void afterCreateNewModel() {
        QFilter[] qFilters;
        DynamicObject cur;
        boolean isBankOrg;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        long orgId = (Long)org.getPkValue();
        this.init = new InitHelper(orgId, "ar_init");
        if (ObjectUtils.isEmpty((Object)this.init.getInitId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"InvoiceEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew", "baritemap"});
            return;
        }
        model.setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
        model.setValue("org", (Object)orgId);
        boolean isPurOrg = org.getBoolean("fissale");
        if (isPurOrg) {
            model.setValue("salesorg", (Object)orgId);
        }
        if (isBankOrg = org.getBoolean("fisbankroll")) {
            model.setValue("recorg", (Object)orgId);
        }
        Object pkValue = (cur = this.init.getStandardCurrency()) == null ? null : cur.getPkValue();
        this.getModel().setValue("currency", pkValue);
        this.getModel().setValue("basecurrency", pkValue);
        this.getModel().setValue("exratetable", this.init.getExrateTable().getPkValue());
        Date currentDate = this.init.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = this.init.getStartDate();
        }
        if (currentDate != null) {
            DateEdit dateEdit = (DateEdit)this.getControl("applydate");
            dateEdit.setMinDate(currentDate);
            this.getModel().setValue("applydate", (Object)(currentDate.compareTo(new Date()) > 0 ? currentDate : new Date()));
        }
        if (QueryServiceHelper.exists((String)"bos_org", (QFilter[])(qFilters = new QFilter[]{new QFilter("orgpattern", "in", (Object)OrgHelper.getOrgPattern()), new QFilter("id", "=", (Object)orgId)}))) {
            InvoiceCardService.fillSellerInfo(model, org);
        }
        this.getModel().setValue("bizdate", this.getModel().getValue("applydate"));
        int precision = 2;
        if (cur != null) {
            precision = cur.getInt("amtprecision");
        }
        model.setValue("reclocalamt", (Object)BigDecimal.ZERO.setScale(precision, 4));
        this.dateChanged(this.getModel().getValue("bizdate"));
        this.switchOtherInvoice();
        InvoiceBizService service = new InvoiceBizService();
        DynamicObject config = service.getStaffCfg(org);
        if (!ObjectUtils.isEmpty((Object)config)) {
            this.getModel().setValue("payer", config.get("payer"));
            this.getModel().setValue("checker", config.get("checker"));
            this.getModel().setValue("drawer", config.get("drawer"));
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        model.setValue("bizdate", model.getValue("applydate"));
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            this.init = new InitHelper(org.getLong("id"), "ar_init");
            model.setValue("basecurrency", this.init.getStandardCurrency().getPkValue());
        }
        DynamicObjectCollection entrys = model.getEntryEntity("entry");
        for (DynamicObject entry : entrys) {
            entry.set("e_unverifiedwriteoffamt", (Object)entry.getBigDecimal("e_recamount"));
            entry.set("e_unverifiedwriteoffqty", (Object)entry.getBigDecimal("e_quantity"));
        }
        this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!ObjectUtils.isEmpty((Object)this.init) && ObjectUtils.isEmpty((Object)this.init.getInitId())) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"InvoiceEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
            return;
        }
        if (this.init == null) {
            this.init = new InitHelper(((Long)org.getPkValue()).longValue(), "ar_init");
            if (ObjectUtils.isEmpty((Object)this.init.getInitId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"InvoiceEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
                return;
            }
        }
        DateEdit applyDateEdit = (DateEdit)this.getControl("applydate");
        Date currentDate = this.init.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = this.init.getStartDate();
        }
        applyDateEdit.setMinDate(currentDate);
        if (this.getModel().getValue("bizdate") != null) {
            Date issueDate = (Date)this.getModel().getValue("bizdate");
            DateEdit dateEdit = (DateEdit)this.getControl("duedate");
            dateEdit.setMinDate(issueDate);
        }
        this.setLocalAmt();
        if (this.isCopy()) {
            this.getModel().setValue("sourcebillid", null);
        }
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if (this.isBotpNew() && !"ar_invoice".equals(sourceBillType) && !"ar_finarbill".equals(sourceBillType)) {
            boolean isRecalculate = false;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                boolean isPartPush;
                BigDecimal qty = (BigDecimal)this.getModel().getValue("e_quantity", i);
                BigDecimal price = (BigDecimal)this.getModel().getValue("e_unitprice", i);
                BigDecimal amt = (BigDecimal)this.getModel().getValue("e_amount", i);
                BigDecimal tax = (BigDecimal)this.getModel().getValue("e_tax", i);
                BigDecimal recamt = (BigDecimal)this.getModel().getValue("e_recamount", i);
                boolean isNotAllowed = price.multiply(qty).subtract(amt).abs().compareTo(new BigDecimal("0.01")) > 0;
                boolean bl = isPartPush = amt.add(tax).compareTo(recamt) != 0;
                if (!isNotAllowed && !isPartPush) continue;
                isRecalculate = true;
                this.calculatorEntryAmt(this.getModel(), i, true);
            }
            if (isRecalculate) {
                this.calculateHeadAmt();
            }
            this.setRedInvoice();
        }
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
        InvoiceCardService.setBuyerLabel(this);
        InvoiceCardService.setSellerLabel(this);
        String bizType = (String)this.getModel().getValue("biztype");
        this.setEntryFieldState(bizType);
        BasedataEdit control = (BasedataEdit)this.getView().getControl("e_taxclass");
        boolean isOther = this.isOtrType();
        control.setMustInput(!isOther);
        String status = ((BillView)e.getSource()).getFormShowParameter().getStatus().name();
        if (!"ADDNEW".equals(status)) {
            this.getModel().setDataChanged(false);
        }
        this.switchOtherInvoice();
        this.fillToolBar();
        this.fillToolBarByInvoice();
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
    }

    private void switchOtherInvoice() {
        if (this.isOtrType()) {
            this.getModel().setValue("biztype", (Object)"EXP");
            this.getModel().setValue("invoicetype", (Object)"OTHER");
            this.setCollapsible("fs_baseinfo", false);
            this.setCollapsible("fs_amtinfo", false);
            FieldEdit ptt = (FieldEdit)this.getControl("recamount");
            ptt.setMustInput(true);
            FieldEdit expense = (FieldEdit)this.getControl("expense");
            expense.setMustInput(true);
            IFormView view = this.getView();
            FieldEdit ctlBizDate = (FieldEdit)view.getControl("bizdate");
            ctlBizDate.setMustInput(false);
            view.setVisible(Boolean.FALSE, new String[]{"bizdate"});
        } else if (!this.isAllType()) {
            InvoiceType[] invoiceTypeArr;
            String invoiceTypes = StdConfig.get((String)"arInvoiceTypes");
            invoiceTypes = invoiceTypes != null ? invoiceTypes : "1,2,3,4,26,27";
            String[] split = invoiceTypes.split(",");
            Set invoiceTypeSet = Arrays.stream(split).collect(Collectors.toSet());
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            for (InvoiceType invoiceType : invoiceTypeArr = InvoiceType.values()) {
                String invoiceTypeValue = invoiceType.getValue();
                String typeNo = InvoiceType.getTypeNo((String)invoiceTypeValue);
                if (!invoiceTypeSet.contains(typeNo)) continue;
                items.add(new ComboItem(new LocaleString(invoiceType.getName()), invoiceTypeValue));
            }
            ComboEdit item = (ComboEdit)this.getControl("invoicetype");
            item.setComboItems(items);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "withtax1": {
                this.getModel().setValue("isincludetax", (Object)Boolean.TRUE);
                break;
            }
            case "withtax2": {
                this.getModel().setValue("isincludetax", (Object)Boolean.FALSE);
                break;
            }
            case "addseller1": 
            case "addseller2": 
            case "changeseller": {
                this.changeSellerPage();
                break;
            }
            case "addbuyer1": 
            case "addbuyer2": 
            case "changebuyer": {
                this.changeBuyerPage();
                break;
            }
            case "e_corebillno": {
                this.showCoreBillF7();
                break;
            }
        }
    }

    private void showCoreBillF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("entry");
        String corebilltype = (String)this.getModel().getValue("e_corebilltype", currrow);
        ArApCorebillHelper.showCoreBillF7((String)corebilltype, (IFormView)this.getView(), (String)this.getPluginName());
    }

    private void changeBuyerPage() {
        if (this.getModel().getValue("billstatus").equals(BillStatusEnum.SAVE.getValue())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ar_addbuyer");
            parameter.setStatus(OperationStatus.ADDNEW);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            parameter.setCustomParam("orgId", (Object)String.valueOf(org.getPkValue()));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changeBuyer"));
            this.getView().showForm(parameter);
        }
    }

    private void changeSellerPage() {
        if (this.getModel().getValue("billstatus").equals(BillStatusEnum.SAVE.getValue())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ar_changeseller");
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changeSeller"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "changeBuyer": {
                Map buyerMap = (Map)e.getReturnData();
                if (EmptyUtils.isEmpty((Object)buyerMap)) break;
                InvoiceCardService.setBuyerInfo(this, buyerMap);
                Object buyer = buyerMap.get("buyer");
                if (this.isPushedBill()) break;
                this.getModel().setValue("asstact", buyer);
                break;
            }
            case "changeSeller": {
                Map sellerMap = (Map)e.getReturnData();
                if (sellerMap == null) break;
                InvoiceCardService.setSellerInfo(this, sellerMap);
                break;
            }
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
                break;
            }
            case "confirmInvoiced": {
                if (returnData == null) {
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5df2\u5f00\u7968\u6210\u529f\u3002", (String)"InvoiceEdit_14", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object oldVal = changeData[0].getOldValue();
        Object newVal = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!this.billStatusCtrlService.isCanChange(billStatus)) {
            return;
        }
        IDataModel m = this.getModel();
        switch (key) {
            case "applydate": {
                if (newVal == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"applydate", (Object)oldVal);
                    return;
                }
                m.setValue("bizdate", newVal);
                break;
            }
            case "bizdate": {
                if (newVal == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"bizdate", (Object)oldVal);
                    return;
                }
                this.dateChanged(newVal);
                break;
            }
            case "biztype": {
                this.bizTypeChanged(changeData[0]);
                break;
            }
            case "asstacttype": {
                this.asstactTypeChanged(newVal);
                break;
            }
            case "currency": {
                int n;
                if (newVal == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"currency", (Object)oldVal);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldVal)) {
                    return;
                }
                int o = ((DynamicObject)oldVal).getInt("priceprecision");
                if (o > (n = ((DynamicObject)newVal).getInt("priceprecision"))) {
                    for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                        this.initPrice(this.getModel(), n, i);
                    }
                }
                this.setLocalAmt();
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "exratedate": {
                if (Objects.isNull(newVal)) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"exratedate", (Object)oldVal);
                    return;
                }
                this.setLocalAmt();
                break;
            }
            case "exratetable": {
                if (!ObjectUtils.isEmpty((Object)newVal)) {
                    this.setLocalAmt();
                    break;
                }
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"exratetable", (Object)oldVal);
                break;
            }
            case "invoicetype": {
                String type = (String)newVal;
                String typeNo = InvoiceType.getTypeNo((String)type);
                if (typeNo == null) {
                    typeNo = type;
                }
                Long invoiceTypePK = InvoiceTypeHelper.getInvoiceTypePK((String)typeNo);
                this.getModel().setValue("invoicetypef7", (Object)invoiceTypePK);
                if (invoiceTypePK != 0L) break;
                this.getModel().beginInit();
                this.getModel().setValue("invoicetypef7", null);
                this.getModel().endInit();
                this.getView().updateView("invoicetypef7");
                break;
            }
            case "invoicetypef7": {
                DynamicObject invoicetype = (DynamicObject)newVal;
                if (invoicetype != null) {
                    String number = invoicetype.getString("number");
                    String value = InvoiceType.getValue((String)number);
                    if (value == null) {
                        value = number;
                    }
                    this.getModel().setValue("invoicetype", (Object)value);
                    break;
                }
                this.getModel().setValue("invoicetype", null);
                break;
            }
            case "invoicetypeview": {
                m.setValue("invoicetype", newVal);
                break;
            }
            case "recamount": {
                this.pricetaxtotalChanged(newVal);
                if (!this.isOtrType()) break;
                break;
            }
            case "exchangerate": {
                if (EmptyUtils.isEmpty((Object)newVal)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"InvoiceEdit_10", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.calculateAmt(this.getModel(), -1);
                break;
            }
            case "expense": {
                if (!this.isOtrType()) break;
                m.setValue("e_expenseitem", newVal, 0);
                break;
            }
            case "e_material": {
                this.getModel().setValue("e_materialversion", null, rowIndex);
                this.getModel().setValue("e_productline", null, rowIndex);
                this.materialChanged(changeData[0]);
                this.calculateBaseQty(rowIndex);
                break;
            }
            case "e_expenseitem": {
                this.fillTaxClass(changeData[0]);
                break;
            }
            case "e_measureunit": {
                this.calculateBaseQty(rowIndex);
                this.calculateQty(rowIndex);
                break;
            }
            case "e_discountamount": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(rowIndex, this.getModel(), key, BillModelFactory.getModel((String)"ar_invoice"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "e_discountmode": {
                m.setValue("e_discountrate", (Object)BigDecimal.ZERO, rowIndex);
                if ("TOTAL".equals(newVal)) {
                    m.setValue("e_discountamount", (Object)BigDecimal.ZERO, rowIndex);
                }
                this.calculateAmt(m, rowIndex);
                break;
            }
            case "e_ispresent": {
                boolean curIsPresent = (Boolean)newVal;
                BigDecimal rice = (BigDecimal)m.getValue("e_unitprice", rowIndex);
                BigDecimal priceTax = (BigDecimal)m.getValue("e_taxunitprice", rowIndex);
                if ((BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) && curIsPresent) {
                    m.setValue("e_discountmode", (Object)"PERCENT", rowIndex);
                    m.setValue("e_discountrate", (Object)new BigDecimal(100), rowIndex);
                    break;
                }
                m.setValue("e_discountmode", (Object)"NULL", rowIndex);
                break;
            }
            case "e_discountrate": {
                if (DiscountModeEnum.NULL.getValue().equals(m.getValue("e_discountmode"))) {
                    this.getModel().setValue("e_discountrate", (Object)BigDecimal.ZERO, rowIndex);
                }
            }
            case "e_quantity": {
                if (BigDecimal.ZERO.compareTo((BigDecimal)m.getValue("e_quantity", rowIndex)) == 0) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_quantity", (Object)oldVal, (int)rowIndex);
                    return;
                }
                this.getModel().setValue("e_unverifiedwriteoffqty", newVal, rowIndex);
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(rowIndex, this.getModel(), key, BillModelFactory.getModel((String)"ar_invoice"));
                this.calculateBaseQty(rowIndex);
            }
            case "e_taxrate": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(rowIndex, this.getModel(), key, BillModelFactory.getModel((String)"ar_invoice"));
                this.calculateAmt(m, rowIndex);
                this.setRedInvoice();
                break;
            }
            case "e_unitprice": {
                boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", rowIndex);
                if (isPresent) {
                    BigDecimal price = (BigDecimal)newVal;
                    if (BigDecimal.ZERO.compareTo(price) == 0) {
                        m.setValue("e_discountmode", (Object)"NULL", rowIndex);
                    } else {
                        m.setValue("e_discountmode", (Object)"PERCENT", rowIndex);
                        m.setValue("e_discountrate", (Object)new BigDecimal(100), rowIndex);
                    }
                }
                this.calculateAmt(m, rowIndex);
                this.setRedInvoice();
                break;
            }
            case "e_recamount": {
                if (!((Boolean)m.getValue("isincludetax")).booleanValue()) {
                    return;
                }
                this.calculateAmt(m, rowIndex);
                this.setRedInvoice();
                break;
            }
            case "e_tax": {
                this.changeTax(newVal, changeData[0].getRowIndex());
                break;
            }
            case "e_taxclass": {
                this.taxClassChanged(newVal, m, rowIndex);
                break;
            }
            case "e_corebilltype": {
                m.setValue("e_corebillno", null, rowIndex);
                m.setValue("e_corebillentryseq", null, rowIndex);
                break;
            }
        }
    }

    private void taxClassChanged(Object newVal, IDataModel m, int rowIndex) {
        String entryItemType;
        DynamicObject itemValue;
        if (newVal == null) {
            return;
        }
        DynamicObject tax = (DynamicObject)newVal;
        Object taxrateid = m.getValue("taxrateid", rowIndex);
        if (EmptyUtils.isNotEmpty((Object)taxrateid)) {
            return;
        }
        String bizType = (String)m.getValue("biztype");
        DynamicObject asstact = (DynamicObject)m.getValue("asstact");
        TaxClassMatcher taxClassMatcher = new TaxClassMatcher(asstact, Collections.singleton(itemValue = (DynamicObject)m.getValue(entryItemType = "SAL".equals(bizType) ? "e_material" : "e_expenseitem", rowIndex)));
        DynamicObject taxClassMappingInfo = taxClassMatcher.getTaxClassMappingInfo(itemValue);
        if (taxClassMappingInfo != null) {
            Long taxrateId = taxClassMappingInfo.getLong("taxratef7.id");
            m.setValue("taxrateid", (Object)taxrateId, rowIndex);
        } else {
            String selectors = "id,number,name,taxrate,enable,activedate,expdate";
            BigDecimal calculTax = tax.getBigDecimal("taxrate").multiply(new BigDecimal(100));
            QFilter[] filters = new QFilter[]{new QFilter("taxrate", "=", (Object)calculTax).and(new QFilter("enable", "=", (Object)Character.valueOf('1'))).and(new QFilter("activedate", "<=", (Object)new Date())).and(new QFilter("expdate", ">", (Object)new Date()).or(new QFilter("expdate", "is null", null)))};
            Object[] taxrate = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)selectors, (QFilter[])filters);
            if (!ObjectUtils.isEmpty((Object[])taxrate) && taxrate.length == 1) {
                this.getModel().setValue("taxrateid", taxrate[0].getPkValue(), rowIndex);
            }
        }
    }

    private void changeTax(Object newValue, int rowIndex) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            return;
        }
        IDataModel m = this.getModel();
        BigDecimal e_recamount = (BigDecimal)m.getValue("e_recamount", rowIndex);
        BigDecimal exchangerate = (BigDecimal)m.getValue("exchangerate");
        if (ObjectUtils.isEmpty((Object)exchangerate)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"InvoiceEdit_10", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal e_amount = e_recamount.subtract((BigDecimal)newValue);
        m.setValue("e_amount", (Object)e_amount, rowIndex);
        DynamicObject basecurrency = (DynamicObject)m.getValue("basecurrency");
        if (basecurrency == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u7ed3\u7b97\u5e01\u3002", (String)"InvoiceEdit_11", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
        int localprecision = basecurrency.getInt("amtprecision");
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        BigDecimal amountbase = "1".equals(quotation) ? e_amount.divide(exchangerate, localprecision, RoundingMode.HALF_UP) : e_amount.multiply(exchangerate).setScale(localprecision, RoundingMode.HALF_UP);
        m.setValue("e_localamt", (Object)amountbase, rowIndex);
        this.calculateHeadAmt();
        this.setRedInvoice();
    }

    private void initPrice(IDataModel m, int newPriceprecision, int currentRow) {
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        if (includeTax) {
            BigDecimal oldrecamount = (BigDecimal)m.getValue("e_recamount", currentRow);
            m.setValue("e_recamount", (Object)oldrecamount.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        } else {
            BigDecimal oldUnitprice = (BigDecimal)m.getValue("e_unitprice", currentRow);
            m.setValue("e_unitprice", (Object)oldUnitprice.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        }
    }

    private void calculateAmt(IDataModel m, int index) {
        m.beginInit();
        if (index != -1) {
            this.calculatorEntryAmt(m, index, false);
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                this.calculatorEntryAmt(m, i, false);
            }
        }
        this.calculateHeadAmt();
        m.endInit();
        IFormView v = this.getView();
        if (index != -1) {
            for (String e : ENTRY) {
                v.updateView(e, index);
            }
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                String[] stringArray = ENTRY;
                int n = stringArray.length;
                for (int e = 0; e < n; ++e) {
                    String e2 = stringArray[e];
                    v.updateView(e2, i);
                }
            }
        }
        for (String h : HEAD) {
            v.updateView(h);
        }
    }

    private void fillTaxClass(ChangeData changeData) {
        Object newValue;
        DynamicObject em;
        int currentIndex = changeData.getRowIndex();
        if (this.isOtrType()) {
            currentIndex = 0;
        }
        if ((em = (DynamicObject)(newValue = changeData.getNewValue())) == null) {
            this.getModel().setValue("e_taxclass", null, currentIndex);
            return;
        }
        this.getModel().setValue("e_itemname", (Object)em.getLocaleString("name").getLocaleValue(), currentIndex);
        this.updateTaxClass(em, currentIndex);
    }

    private void pricetaxtotalChanged(Object newValue) {
        if (this.isOtrType()) {
            IDataModel m = this.getModel();
            m.beginInit();
            m.setValue("isincludetax", (Object)Boolean.TRUE);
            m.setValue("e_amount", newValue, 0);
            m.setValue("e_recamount", newValue, 0);
            this.calculatorEntryAmt(this.getModel(), 0, false);
            this.calculateHeadAmt();
            m.endInit();
            this.getView().updateView("entry");
        }
    }

    private void dateChanged(Object newValue) {
        if (newValue != null) {
            Date issueDate = (Date)newValue;
            DateEdit dateEdit = (DateEdit)this.getControl("duedate");
            dateEdit.setMinDate(issueDate);
            Date lastpayDate = (Date)this.getModel().getValue("duedate");
            if (lastpayDate != null && lastpayDate.before(issueDate)) {
                this.getModel().setValue("duedate", (Object)issueDate);
            }
        }
    }

    private void bizTypeChanged(ChangeData bizType) {
        String newValue = bizType.getNewValue().toString();
        if (newValue != null) {
            if ("SAL".equals(newValue)) {
                this.getModel().setValue("asstacttype", (Object)"bd_customer");
            }
            this.getPageCache().put(BIZTYPE, bizType.getOldValue().toString());
            if (this.getModel().getEntryRowCount("entry") != 0 && !this.isOtrType()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u7c7b\u578b\u5c06\u5220\u9664\u6240\u6709\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InvoiceEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clearEntry"));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("clearEntry".equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData("entry");
                this.getView().updateView();
                this.getModel().createNewEntryRow("entry");
                this.getModel().setEntryCurrentRowIndex("entry", 0);
                this.calculateHeadAmt();
                this.setRedInvoice();
                String bizType = (String)this.getModel().getValue("biztype");
                this.setEntryFieldState(bizType);
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("biztype", (Object)this.getPageCache().get(BIZTYPE));
                this.getModel().endInit();
                this.getView().updateView();
            }
        }
        String callBackID = messageBoxClosedEvent.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, messageBoxClosedEvent.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = messageBoxClosedEvent.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ar_invoice", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    private void setEntryFieldState(String bizType) {
        boolean flag;
        IFormView view = this.getView();
        if ("SAL".equals(bizType)) {
            flag = true;
        } else if ("EXP".equals(bizType)) {
            flag = false;
            view.setEnable(Boolean.valueOf(!flag), new String[]{"e_expenseitem"});
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b\uff1a\u201c%s\u201d", (String)"InvoiceEdit_9", (String)"fi-ar-formplugin", (Object[])new Object[]{bizType}));
        }
        view.setVisible(Boolean.valueOf(flag), new String[]{"e_material", "e_spectype"});
        view.setVisible(Boolean.valueOf(!flag), new String[]{"e_expenseitem"});
        view.setEnable(Boolean.valueOf(!flag), new String[]{"asstacttype"});
    }

    private void asstactTypeChanged(Object newVal) {
        if (newVal != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_buyerinfo"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_addbuyer"});
            this.getModel().setValue("buyer", null);
            this.getModel().setValue("asstact", null);
            this.getModel().setValue("buyertel", null);
            this.getModel().setValue("buyertin", null);
            this.getModel().setValue("buyeracct", null);
            this.getModel().setValue("buyeraddr", null);
            this.getModel().setValue("buyerbank", null);
            this.getModel().setValue("buyername", null);
        }
    }

    private void setLocalAmt() {
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (srcCurrency != null && destCurrency != null) {
            this.getView().setVisible(Boolean.valueOf(srcCurrency.getLong("id") != destCurrency.getLong("id")), new String[]{"localamt", "reclocalamt", "e_discountlocalamt", "e_localamt", "e_reclocalamt"});
        }
    }

    private void materialChanged(ChangeData changeData) {
        int currentIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        DynamicObject material = (DynamicObject)newValue;
        if (material != null) {
            DynamicObject productline;
            this.getModel().setValue("e_spectype", (Object)material.getLocaleString("modelnum").getLocaleValue(), currentIndex);
            if (material.getDynamicObject("baseunit") != null) {
                Object pkValue = material.getDynamicObject("baseunit").getPkValue();
                this.getModel().setValue("e_measureunit", pkValue, currentIndex);
                this.getModel().setValue("e_baseunit", pkValue, currentIndex);
            }
            if ((productline = material.getDynamicObject("productline")) != null) {
                this.getModel().setValue("e_productline", productline.getPkValue(), currentIndex);
            }
            this.getModel().setValue("e_itemname", (Object)material.getLocaleString("name").getLocaleValue(), currentIndex);
            this.getModel().setValue("e_invspectype", (Object)material.getLocaleString("modelnum").getLocaleValue(), currentIndex);
            this.updateTaxClass(material, currentIndex);
        } else {
            this.getModel().setValue("e_spectype", (Object)"", currentIndex);
        }
    }

    private void updateTaxClass(DynamicObject item, int currentIndex) {
        IDataModel m = this.getModel();
        DynamicObject asstact = (DynamicObject)m.getValue("asstact");
        TaxClassMatcher taxClassMatcher = new TaxClassMatcher(asstact, Collections.singleton(item));
        DynamicObject taxClassMappingInfo = taxClassMatcher.getTaxClassMappingInfo(item);
        if (taxClassMappingInfo != null) {
            DynamicObject taxratef7 = taxClassMappingInfo.getDynamicObject("taxratef7");
            DynamicObject taxsupertypenum = taxClassMappingInfo.getDynamicObject("taxsupertypenum");
            m.beginInit();
            m.setValue("e_taxclass", taxsupertypenum.getPkValue(), currentIndex);
            m.endInit();
            m.setValue("e_invspectype", (Object)taxClassMappingInfo.getString("spectype"), currentIndex);
            m.setValue("e_itemname", (Object)taxClassMappingInfo.getString("invname"), currentIndex);
            m.setValue("taxrateid", taxratef7 == null ? null : taxratef7.getPkValue(), currentIndex);
            this.getView().updateView();
        }
    }

    private void calculateBaseQty(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        DynamicObject material = (DynamicObject)model.getValue("e_material", rowIndex);
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit", rowIndex);
        if (baseUnit == null && (baseUnit = material.getDynamicObject("baseunit")) != null) {
            model.setValue("e_baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit == null) {
            return;
        }
        long baseUnitID = (Long)baseUnit.getPkValue();
        long measureUnitID = (Long)measureUnit.getPkValue();
        long materialID = (Long)material.getPkValue();
        BigDecimal convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (convertRate != null) {
            model.setValue("e_unitcoefficient", (Object)convertRate, rowIndex);
            if (quantity != null) {
                model.setValue("e_baseunitqty", (Object)convertRate.multiply(quantity), rowIndex);
                Boolean flag = (Boolean)model.getValue("redinvoice");
                if (!flag.booleanValue()) {
                    model.setValue("e_unverifiedwriteoffqty", (Object)convertRate.multiply(quantity), rowIndex);
                }
            }
        }
    }

    private void calculateQty(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (quantity != null) {
            model.setValue("e_quantity", (Object)quantity.setScale(measureUnit.getInt("precision"), 4), rowIndex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.calculateHeadAmt();
        this.setRedInvoice();
    }

    private boolean isOtrType() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object operate = billShowParameter.getCustomParam(INVOICETYPE);
        return "OTHER".equals(operate) || "OTHER".equals(this.getModel().getValue("invoicetype"));
    }

    private boolean isAllType() {
        String ignore = StdConfig.get((String)"ignoreInvoiceType");
        if (StringUtils.isNotEmpty((String)ignore) && ignore.contains("ar")) {
            return true;
        }
        Object param = this.getView().getFormShowParameter().getCustomParam(INVOICETYPE);
        return "ALL".equals(param);
    }

    private boolean isCopy() {
        boolean isCopy = false;
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object operate = billShowParameter.getCustomParam("iscopy");
        if (operate instanceof Boolean) {
            isCopy = (Boolean)operate;
        }
        return isCopy;
    }

    private void calculatorEntryAmt(IDataModel m, int index, boolean isbotpPush) {
        UnitPriceCalculator calculator;
        DynamicObject basecurrency;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = ObjectUtils.isEmpty((Object)currency) ? 2 : currency.getInt("amtprecision");
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int localprecision = ObjectUtils.isEmpty((Object)(basecurrency = (DynamicObject)m.getValue("basecurrency"))) ? 2 : basecurrency.getInt("amtprecision");
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        BigDecimal discountAmt = (BigDecimal)m.getValue("e_discountamount", index);
        BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
        BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
        if (includeTax) {
            BigDecimal pricetaxtotal = (BigDecimal)m.getValue("e_recamount", index);
            calculator = new PriceTaxTotalCalculator(isbotpPush, unitPrice, taxUnitPrice, qty, pricetaxtotal, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else {
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, quotation);
        localCalculator.calculate();
        this.resetEntryProp(m, localCalculator, index);
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
        m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("e_actunitprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice(), index);
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
        m.setValue("e_amount", (Object)localCalculator.getAmount(), index);
        m.setValue("e_localamt", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_recamount", (Object)localCalculator.getPricetaxtotal(), index);
        m.setValue("e_reclocalamt", (Object)localCalculator.getPricetaxtotallocal(), index);
        m.setValue("e_unverifiedwriteoffamt", (Object)localCalculator.getPricetaxtotal(), index);
        m.setValue("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
    }

    private void calculateHeadAmt() {
        IDataModel m = this.getModel();
        int count = m.getEntryRowCount("entry");
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal reclocalamt = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            amount = amount.add((BigDecimal)m.getValue("e_amount", i));
            tax = tax.add((BigDecimal)m.getValue("e_tax", i));
            recamount = recamount.add((BigDecimal)m.getValue("e_recamount", i));
            reclocalamt = reclocalamt.add((BigDecimal)m.getValue("e_reclocalamt", i));
            localamt = localamt.add((BigDecimal)m.getValue("e_localamt", i));
        }
        m.setValue("amount", (Object)amount);
        m.setValue("tax", (Object)tax);
        m.setValue("recamount", (Object)recamount);
        m.setValue("reclocalamt", (Object)reclocalamt);
        m.setValue("localamt", (Object)localamt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("invoicewriteoff".equals(key) || "applyabandon".equals(key)) {
            BigDecimal qty = (BigDecimal)this.getModel().getValue("e_quantity", 0);
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u62c6\u5206\u540e\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u64cd\u4f5c\u3002", (String)"InvoiceEdit_12", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        } else if ("syncdata".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
        if (Objects.equals("copyentryrow", key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u590d\u5236\u3002", (String)"InvoiceEdit_13", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            boolean isPriceTotal = (Boolean)this.getModel().getValue("isincludetax");
            String discountType = (String)this.getModel().getValue("e_discountmode", entryCurrentRowIndex);
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("e_discountrate", entryCurrentRowIndex);
            if (isPriceTotal && "PERCENT".equals(discountType) && new BigDecimal("100").compareTo(discountRate) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InvoiceEdit_20", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("audit".equals(operateKey)) {
            this.fillToolBarByInvoice();
        }
        switch (operateKey) {
            case "cancelinvoiced": 
            case "confirmabandon": 
            case "applyabandon": 
            case "issue": 
            case "cancelabandon": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "confirmissuevalidate": {
                OperationResult operationResult = e.getOperationResult();
                if (operationResult.getSuccessPkIds().isEmpty()) break;
                operationResult.setShowMessage(false);
                if (!this.canConfirmInvoiced(this.getModel().getDataEntity())) {
                    return;
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("ar_invoice_showlist");
                ArrayList<Object> ids = new ArrayList<Object>();
                Object id = this.getModel().getDataEntity().getPkValue();
                ids.add(id);
                fsp.setCustomParam("successfulIds", ids);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "confirmInvoiced");
                fsp.setCloseCallBack(closeCallBack);
                this.getView().showForm(fsp);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "invoicecloud": {
                if (!e.getOperationResult().isSuccess()) break;
                this.jumpInvoiceCloud();
                break;
            }
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "unaudit": 
            case "audit": {
                this.fillToolBar();
                break;
            }
            case "reissue": {
                if (!e.getOperationResult().isSuccess()) break;
                this.reissue();
                break;
            }
            case "appointsrc": {
                if (!e.getOperationResult().isSuccess()) break;
                this.appointSource();
                break;
            }
            case "antiappointsrc": {
                if (!e.getOperationResult().isSuccess()) break;
                this.antiAppointSource();
                break;
            }
        }
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
        OperationResult operationResult = e.getOperationResult();
        if ("submit".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void antiAppointSource() {
        DynamicObject invoice = this.getModel().getDataEntity();
        InvoiceSourceAppointor invoiceSourceAppointor = new InvoiceSourceAppointor();
        invoiceSourceAppointor.antiAppointValidate(invoice);
        invoiceSourceAppointor.antiAppoint(invoice);
        String message = ResManager.loadKDString((String)"\u53d6\u6d88\u6307\u5b9a\u6e90\u5355\u6210\u529f\u3002 ", (String)"InvoiceEdit_15", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(message);
    }

    private void appointSource() {
        DynamicObject invoice = this.getModel().getDataEntity();
        InvoiceSourceAppointor invoiceSourceAppointor = new InvoiceSourceAppointor();
        invoiceSourceAppointor.appointValidate(invoice, new DynamicObject[0]);
        long mainOrgId = invoice.getLong("org.id");
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"ar_finarbill", (boolean)true, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(new QFilter("billstatus", "=", (Object)"C"));
        lfp.setFilter(new QFilter("org", "=", (Object)mainOrgId));
        lfp.setFilter(new QFilter("uninvoicedamt", ">", (Object)0));
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.setListFilterParameter(lfp);
        CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "appointsourcebill");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void reissue() {
        InvoiceBizService service = new InvoiceBizService();
        DynamicObject invoice = this.getModel().getDataEntity(true);
        BillShowParameter parameter = service.reissue(invoice);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void jumpInvoiceCloud() {
        String taxNo = (String)this.getModel().getValue("sellertin");
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        String authCode = invoiceFacade.getAuthCode(taxNo);
        String domain = KingdeeInvoiceCloudConfig.getDomain();
        String invoiceCloudUrl = domain + "/portal-web-h5/web/saler-manage/bill?auth_code=" + authCode;
        this.getView().openUrl(invoiceCloudUrl);
    }

    private boolean canConfirmInvoiced(DynamicObject entity) {
        return "C".equals(entity.getString("billstatus")) && "0".equals(entity.getString("invoicestatus"));
    }

    private void fillToolBarByInvoice() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        long orgPk = this.getModel().getDataEntity().getLong("org.id");
        boolean para = SystemParameterHelper.getParameterBoolean((long)orgPk, (String)"ar_001");
        if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.valueOf(!para), new String[]{"bar_pushar"});
        }
    }

    private void fillToolBar() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_pushar", "bar_applyissue", "tblinvmanage", "bar_confirminvoiced"});
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_unsubmit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_submitandnew"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submitandnew", "bar_unaudit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unsubmit", "bar_audit"});
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_submitandnew"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit", "bar_applyissue", "tblinvmanage", "bar_confirminvoiced"});
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            boolean ar001 = SystemParameterHelper.getParameterBoolean((long)((Long)org.getPkValue()), (String)"ar_001");
            this.getView().setVisible(Boolean.valueOf(!ar001), new String[]{"bar_pushar"});
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.getImportHelper().afterImportData(e);
    }

    protected Optional<DynamicObject> getDynamicObjectFromDb(String entityName, String properties, QFilter[] filters) {
        if (filters.length == 0) {
            return Optional.empty();
        }
        DynamicObject result = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)properties, (QFilter[])filters);
        return Optional.ofNullable(result);
    }

    protected QFilter[] getQFilter(String entityName, String name, String number) {
        String numberName;
        QFilter filters = null;
        String string = numberName = "bd_operator".equals(entityName) ? "operatornumber" : "number";
        if (!EmptyUtils.isEmpty((Object)number)) {
            filters = new QFilter(numberName, "=", (Object)number);
        }
        if (!EmptyUtils.isEmpty((Object)name)) {
            QFilter nameFilter = new QFilter("name", "=", (Object)name);
            if (filters == null) {
                return nameFilter.toArray();
            }
            filters.and(nameFilter);
        }
        if (filters == null) {
            return new QFilter[0];
        }
        return filters.toArray();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        if (this.isCopyEntryRow && "entry".equals(entryProp.getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                this.calculatorEntryAmt(this.getModel(), index, false);
                BigDecimal qty = (BigDecimal)this.getModel().getValue("e_quantity", index);
                this.getModel().setValue("e_unverifiedwriteoffqty", (Object)qty, index);
                this.calculateBaseQty(index);
            }
            this.calculateHeadAmt();
            this.setRedInvoice();
        }
    }

    private void setRedInvoice() {
        this.getModel().setValue("redinvoice", (Object)(BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("recamount")) > 0 ? 1 : 0));
    }

    private boolean isPushedBill() {
        long sourceBillId = this.getModel().getDataEntity().getLong("sourcebillid");
        return sourceBillId > 0L;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int rowIndex = e.getRowIndex();
        switch (key) {
            case "e_discountrate": {
                if (!DiscountModeEnum.PERCENT.getValue().equals(this.getModel().getValue("e_discountmode"))) break;
                if (value == null) {
                    return;
                }
                BigDecimal discountrate = new BigDecimal(value.toString());
                if (discountrate.compareTo(BigDecimal.valueOf(100L)) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u5b57\u6bb5\u5f55\u5165\u7684\u6570\u5b57\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"InvoiceEdit_6", (String)"fi-ar-formplugin", (Object[])new Object[]{rowIndex + 1}));
                    e.setCancel(true);
                    this.getView().updateView("e_discountrate", rowIndex);
                    break;
                }
                if (!((Boolean)this.getModel().getValue("isincludetax")).booleanValue() || discountrate.compareTo(BigDecimal.valueOf(100L)) != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InvoiceEdit_16", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("e_discountrate", rowIndex);
            }
        }
    }
}

