/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.ar.business.invoice.InvoiceHelper;
import kd.fi.ar.business.invoice.InvoiceSourceAppointor;
import kd.fi.ar.business.piaozone.SnapshotAction;
import kd.fi.ar.formplugin.ArBaseList;
import kd.fi.ar.formplugin.formservice.InvoiceBizService;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.APIHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceList
extends ArBaseList {
    private static final String BILLLIST = "billlistap";
    private static final String invoiceType = "invoiceType";
    private static final Log logger = LogFactory.getLog(InvoiceList.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isOtrInvoice()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoicestatus", "tbl_issue", "tblinvmanage"});
        }
        OperationUtils.setListButtonUnvisibleByAppId((String)"ar_invoice", (IFormView)this.getView());
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "tblvieweleinv": {
                this.viewEleInvoice();
                break;
            }
            case "tbldownload": {
                this.downloadPDF();
                break;
            }
            case "tblsendemail": {
                break;
            }
            case "tblclose": {
                ConfigCache.clear();
                break;
            }
        }
    }

    private void jumpInvoiceCloud() {
        ListSelectedRow selectedRow = this.requireJustOneRow();
        Object pk = selectedRow.getPrimaryKeyValue();
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ar_invoice", (String)"sellertin");
        String taxNo = invoice.getString("sellertin");
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        String authCode = invoiceFacade.getAuthCode(taxNo);
        String domain = KingdeeInvoiceCloudConfig.getDomain();
        String invoiceCloudUrl = domain + "/portal-web-h5/web/saler-manage/bill?auth_code=" + authCode;
        this.getView().openUrl(invoiceCloudUrl);
    }

    private ListSelectedRow requireJustOneRow() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<Object> pks = new HashSet<Object>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            pks.add(row.getPrimaryKeyValue());
        }
        if (pks.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceList_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        if (pks.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"InvoiceList_21", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        return selectedRows.get(0);
    }

    private Set<Long> requireRows() {
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        HashSet<Long> pks = new HashSet<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            pks.add(Long.parseLong(row.getPrimaryKeyValue().toString()));
        }
        if (pks.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceList_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        if (pks.size() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c11\u4e8e100\u6761\u6570\u636e\u3002", (String)"InvoiceList_27", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        return pks;
    }

    private void downloadPDF() {
        ListSelectedRow selectedRow = this.requireJustOneRow();
        Object pk = selectedRow.getPrimaryKeyValue();
        DynamicObject invDown = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ar_invoice", (String)"billno,serialno,sellertin,elepreviewurl,pdfurl,isoffline,invoicetype");
        String invType = invDown.getString("invoicetype");
        if (invDown.getBoolean("isoffline") || !"ELE".equals(invType) && !"SE".equals(invType) && !"NOELETIC".equals(invType) && !"MAELETIC".equals(invType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ebf\u4e0b\u5f00\u7968\u53ca\u7eb8\u7968\u4e0d\u652f\u6301\u4e0b\u8f7d\u3002", (String)"InvoiceList_19", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
        String urlDown = invDown.getString("pdfurl");
        if (StringUtils.isNotEmpty((String)urlDown)) {
            this.getView().download(urlDown);
        } else {
            boolean existValue;
            boolean existMap;
            SnapshotAction snapshotAction = new SnapshotAction(invDown.getString("sellertin"), invDown.getString("serialno"));
            Map shotMap = APIHelper.invokeAction((AbstractAction)snapshotAction);
            boolean bl = existMap = !ObjectUtils.isEmpty((Object)shotMap);
            boolean existTarget = existMap ? shotMap.get("errcode") != null : false;
            boolean bl2 = existValue = existTarget ? "0000".equals(shotMap.get("errcode")) : false;
            if (existValue) {
                String shotData = shotMap.get("data").toString();
                Map shotDataMap = (Map)JsonUtils.jsonToObj((String)shotData, Map.class);
                String pdfURL = shotDataMap.get("pdfUrl").toString();
                if (StringUtils.isNotEmpty((String)pdfURL)) {
                    invDown.set("pdfurl", (Object)pdfURL);
                    SaveServiceHelper.save((IDataEntityType)invDown.getDataEntityType(), (Object[])new DynamicObject[]{invDown});
                    this.getView().download(pdfURL);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f00\u7968\u540e\u518d\u8fdb\u884c\u67e5\u770b\u3002", (String)"InvoiceList_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                }
            } else if (shotMap.containsKey("errcode") || shotMap.containsKey("description")) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u53d1\u7968 \u201c%1$s\u201d \u4e0b\u8f7d\u53d1\u7968\u5931\u8d25\u3002\uff08%2$s : %3$s\uff09", (String)"InvoiceList_3", (String)"fi-ar-formplugin", (Object[])new Object[0]), invDown.get("billno"), shotMap.get("errcode"), shotMap.get("description")));
            }
        }
    }

    private void viewEleInvoice() {
        Set<Long> pks = this.requireRows();
        DynamicObject[] invViews = BusinessDataServiceHelper.load((String)"ar_invoice", (String)"billno,invoicecode,invoiceno,serialno,sellertin,elepreviewurl,invoicetype,isoffline", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        Set sellertInSet = Arrays.stream(invViews).map(t -> t.getString("sellertin")).collect(Collectors.toSet());
        if (sellertInSet.size() > 1) {
            String message = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u5173\u8054\u7684\u5f00\u7968\u5355\u6709\u591a\u4e2a\u4e0d\u540c\u7684\u9500\u65b9\u7a0e\u53f7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InvoiceList_29", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showErrorNotification(message);
            return;
        }
        if (!InvoiceHelper.isMicroService()) {
            this.viewEleInvoiceH5(invViews);
        } else {
            this.viewEleInvoiceXh(invViews);
        }
    }

    private void viewEleInvoiceH5(DynamicObject[] invViews) {
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        ArrayList<String> serialNums = new ArrayList<String>();
        for (DynamicObject invView : invViews) {
            if (invView.getBoolean("isoffline") || !StringUtils.isNotEmpty((String)invView.getString("serialno"))) continue;
            serialNums.add(invView.getString("serialno"));
        }
        if (serialNums.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f00\u7968\u540e\u518d\u8fdb\u884c\u67e5\u770b\u3002", (String)"InvoiceList_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
        String taxNo = invViews[0].getString("sellertin");
        String uid = invoiceFacade.getUid(taxNo, serialNums);
        String authCode = invoiceFacade.getAuthCode(taxNo);
        String domain = KingdeeInvoiceCloudConfig.getDomain();
        String urlView = domain + "/portal-web-h5/web/saler-manage/invoices/show?invoices_uid=" + uid + "&auth_code=" + authCode;
        this.getView().openUrl(urlView);
    }

    private void viewEleInvoiceXh(DynamicObject[] invViews) {
        ArrayList<Pair> invoiceCodeNoPair = new ArrayList<Pair>();
        for (DynamicObject invView : invViews) {
            if (invView.getBoolean("isoffline")) continue;
            String invoiceCode = invView.getString("invoicecode");
            String invoiceNo = invView.getString("invoiceno");
            if (!StringUtils.isNotEmpty((String)invoiceNo)) continue;
            invoiceCodeNoPair.add(Pair.of((Object)invoiceCode, (Object)invoiceNo));
        }
        List responseIds = (List)DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"IssuedInvoiceQueryServiceImpl", (String)"queryInvoicePk", (Object[])new Object[]{invoiceCodeNoPair});
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("sim_vatinvoice");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        ListFilterParameter param = new ListFilterParameter();
        param.setFilter(new QFilter("id", "in", (Object)responseIds));
        parameter.setListFilterParameter(param);
        parameter.setLookUp(true);
        parameter.setShowTitle(true);
        parameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void antiAppointSource() {
        BillList list = (BillList)this.getControl(BILLLIST);
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if (currentSelectedRowInfo == null) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002 ", (String)"InvoiceList_13", (String)"fi-ar-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        Long invoiceId = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        InvoiceSourceAppointor invoiceSourceAppointor = new InvoiceSourceAppointor();
        invoiceSourceAppointor.antiAppointValidate(invoiceId);
        invoiceSourceAppointor.antiAppoint(invoiceId);
        String message = ResManager.loadKDString((String)"\u53d6\u6d88\u6307\u5b9a\u6e90\u5355\u6210\u529f\u3002 ", (String)"InvoiceList_14", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(message);
    }

    private void appointSource() {
        BillList list = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection rows = list.getSelectedRows();
        if (rows == null) {
            String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002 ", (String)"InvoiceList_13", (String)"fi-ar-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
        } else if (rows.getPrimaryKeyValues().length > 1) {
            String message = ResManager.loadKDString((String)"\u5f00\u7968\u5355\u4e0d\u652f\u6301\u591a\u5355\u6307\u5b9a\u3002 ", (String)"InvoiceList_22", (String)"fi-ar-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
        } else {
            ListSelectedRow currentSelectedRowInfo = rows.get(0);
            if (currentSelectedRowInfo == null) {
                String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002 ", (String)"InvoiceList_13", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            Object pk = currentSelectedRowInfo.getPrimaryKeyValue();
            InvoiceSourceAppointor invoiceSourceAppointor = new InvoiceSourceAppointor();
            List invoiceRequiredFields = invoiceSourceAppointor.getInvoiceRequiredFields();
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)String.join((CharSequence)",", invoiceRequiredFields), (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
            invoiceSourceAppointor.appointValidate(invoice, new DynamicObject[0]);
            long mainOrgId = currentSelectedRowInfo.getMainOrgId();
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"ar_finarbill", (boolean)true, (int)2);
            ListFilterParameter lfp = new ListFilterParameter();
            lfp.setFilter(this.getAssignFilter(mainOrgId, invoice));
            lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
            lsp.setListFilterParameter(lfp);
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "appointsourcebill");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private QFilter getAssignFilter(long mainOrgId, DynamicObject invoice) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and(new QFilter("org", "=", (Object)mainOrgId));
        filter.and(new QFilter("asstacttype", "=", (Object)invoice.getString("asstacttype")));
        filter.and(new QFilter("asstact", "=", (Object)invoice.getLong("asstact.id")));
        filter.and(new QFilter("currency", "=", (Object)invoice.getLong("currency.id")));
        BigDecimal recamount = invoice.getBigDecimal("recamount");
        if (recamount.compareTo(BigDecimal.ZERO) > 0) {
            filter.and(new QFilter("uninvoicedamt", ">", (Object)BigDecimal.ZERO));
        } else {
            filter.and(new QFilter("uninvoicedamt", "<", (Object)BigDecimal.ZERO));
        }
        return filter;
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String firstOrgId = null;
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator commonIterator = commonFilterColumns.iterator();
        while (commonIterator.hasNext()) {
            CommonFilterColumn filterColumn = (CommonFilterColumn)commonIterator.next();
            String fieldName = filterColumn.getFieldName();
            List items = filterColumn.getComboItems();
            if (fieldName.startsWith("org") && items != null && items.size() > 0) {
                String loginOrg = String.valueOf(RequestContext.get().getOrgId());
                for (int i = 0; i < items.size(); ++i) {
                    ComboItem item = (ComboItem)items.get(i);
                    if (!item.getValue().equals(loginOrg)) continue;
                    firstOrgId = loginOrg;
                    break;
                }
                if (firstOrgId == null) {
                    firstOrgId = ((ComboItem)items.get(0)).getValue();
                }
            }
            if (!"biztype".equals(fieldName) && !"invoicetype".equals(fieldName) || items == null || items.size() <= 0 || !this.isOtrInvoice()) continue;
            commonIterator.remove();
        }
        List schemeFilterColumns = args.getFilterContainerInitEvent().getSchemeFilterColumns();
        Iterator schemeIterator = schemeFilterColumns.iterator();
        while (schemeIterator.hasNext()) {
            SchemeFilterColumn filterColumn = (SchemeFilterColumn)schemeIterator.next();
            String fieldName = filterColumn.getFieldName();
            List items = filterColumn.getComboItems();
            if (!"biztype".equals(fieldName) && !"invoicetype".equals(fieldName) || items == null || items.size() <= 0) continue;
            if (this.isOtrInvoice()) {
                schemeIterator.remove();
                continue;
            }
            if (this.isAllInvoice()) continue;
            Iterator typeIterator = items.iterator();
            while (typeIterator.hasNext()) {
                ComboItem next = (ComboItem)typeIterator.next();
                if (!"OTHER".equals(next.getValue())) continue;
                typeIterator.remove();
            }
        }
        String arInvoiceFilterInit = this.getPageCache().get("arinvoicefilterinit");
        if (StringUtils.isNotEmpty(firstOrgId) && StringUtils.isEmpty((String)arInvoiceFilterInit) && SystemParameterHelper.getParameterBoolean((long)Long.parseLong(firstOrgId), (String)"ar_001")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblpushap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblcancelconfirm"});
            this.getPageCache().put("arinvoicefilterinit", "true");
        }
        if (InvoiceHelper.isMicroService()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblinvmanage"});
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List schemefilter;
        super.filterContainerSearchClick(args);
        List customfilter = (List)args.getSearchClickEvent().getFilterValues().get("customfilter");
        if (customfilter != null) {
            for (Map filteritem : customfilter) {
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                List values = (List)filteritem.get("Value");
                if (!fieldName.startsWith("org") || values == null || values.isEmpty()) continue;
                ArrayList<Long> orgIdList = new ArrayList<Long>(8);
                for (Object value : values) {
                    if ("".equals(value)) continue;
                    Long org2 = Long.valueOf(value.toString());
                    orgIdList.add(org2);
                }
                this.setAutoArVisible(orgIdList);
            }
        }
        if ((schemefilter = (List)args.getSearchClickEvent().getFilterValues().get("schemefilter")) != null) {
            boolean queryAllOrg = true;
            for (Map filteritem : schemefilter) {
                DynamicObjectCollection orgCol;
                List<Long> orgIdList;
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                List values = (List)filteritem.get("Value");
                if (!fieldName.startsWith("org") || values == null || values.isEmpty() || ObjectUtils.isEmpty(orgIdList = (orgCol = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "in", (Object)values)})).stream().map(org -> org.getLong("id")).collect(Collectors.toList()))) continue;
                queryAllOrg = false;
                this.setAutoArVisible(orgIdList);
            }
            if (queryAllOrg) {
                this.setAutoArVisible(new ArrayList<Long>(1));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("listoperation".equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
        } else if ("appointsourcebill".equals(e.getActionId())) {
            this.appointSourceCallBack(e);
        } else if ("confirmInvoiced".equals(e.getActionId())) {
            if (e.getReturnData() == null) {
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u5df2\u5f00\u7968\u6210\u529f\u3002", (String)"InvoiceList_18", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private void appointSourceCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection selectedSourceRows = (ListSelectedRowCollection)e.getReturnData();
        if (selectedSourceRows == null || selectedSourceRows.isEmpty()) {
            return;
        }
        Long[] sourceBillIds = new Long[selectedSourceRows.size()];
        for (int i = 0; i < sourceBillIds.length; ++i) {
            sourceBillIds[i] = (Long)selectedSourceRows.get(i).getPrimaryKeyValue();
        }
        BillList list = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection invoiceList = list.getSelectedRows();
        ListSelectedRow currentSelectedRowInfo = invoiceList.get(0);
        InvoiceSourceAppointor invoiceSourceAppointor = new InvoiceSourceAppointor();
        Long invoiceId = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        invoiceSourceAppointor.appoint(invoiceId, sourceBillIds);
        String message = ResManager.loadKDString((String)"\u53d1\u7968\u6307\u5b9a\u6e90\u5355\u6210\u529f\u3002 ", (String)"InvoiceList_15", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(message);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(!this.isOtrInvoice()), new String[]{"tblnew", "tblcreate", "tblvieweleinv"});
        view.setVisible(Boolean.valueOf(this.isOtrInvoice()), new String[]{"tblnew4otr"});
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (!"botp_trackerlist".equals(this.getView().getFormShowParameter().getFormId())) {
            List qFilters = e.getQFilters();
            if (this.isOtrInvoice()) {
                qFilters.add(new QFilter("invoicetype", "=", (Object)"OTHER"));
            } else if (!this.isAllInvoice()) {
                qFilters.add(new QFilter("invoicetype", "!=", (Object)"OTHER"));
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        parameter.setHasRight(true);
        if (this.isOtrInvoice()) {
            e.getParameter().setCaption(ResManager.loadKDString((String)"\u5176\u4ed6\u53d1\u7968", (String)"InvoiceList_7", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            parameter.getCustomParams().put(invoiceType, "OTHER");
        }
        if (this.isAllInvoice()) {
            parameter.getCustomParams().put(invoiceType, "ALL");
        }
    }

    private boolean isOtrInvoice() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return false;
        }
        Object target = customParams.get(invoiceType);
        if (target == null) {
            return false;
        }
        return "OTHER".equals(target);
    }

    private boolean isAllInvoice() {
        String ignore = StdConfig.get((String)"ignoreInvoiceType");
        if (StringUtils.isNotEmpty((String)ignore) && ignore.contains("ar")) {
            return true;
        }
        Object param = this.getView().getFormShowParameter().getCustomParam(invoiceType);
        return "ALL".equals(param);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.isOtrInvoice()) {
            List columns = args.getListColumns();
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                IListColumn iListColumn = (IListColumn)iterator.next();
                String key = iListColumn.getListFieldKey();
                if (!"seller.name".equals(key) && !"salesorg.name".equals(key) && !"purorg.name".equals(key) && !"amount".equals(key) && !"tax".equals(key) && !"asstactname".equals(key) && !"buyer.name".equals(key)) continue;
                iterator.remove();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        block8: {
            BillList list;
            ListSelectedRowCollection selectedRows;
            String key;
            block11: {
                block10: {
                    block9: {
                        super.beforeDoOperation(e);
                        String ignoreCheck = this.getPageCache().get("ignoreCheck");
                        if (Objects.equals("true", ignoreCheck)) {
                            this.getPageCache().put("ignoreCheck", null);
                        } else {
                            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)e, (String)"SZJK-PRE-0057");
                        }
                        AbstractOperate source = (AbstractOperate)e.getSource();
                        key = source.getOperateKey();
                        if ("pushfinbill".equals(key)) break block8;
                        if (!"invoicewriteoff".equals(key) && !"applyabandon".equals(key)) break block9;
                        BillList apBillList = (BillList)this.getControl(BILLLIST);
                        ListSelectedRowCollection billRows = apBillList.getSelectedRows();
                        HashSet<Object> invoiceIds = new HashSet<Object>(1);
                        for (int i = 0; i < billRows.size(); ++i) {
                            invoiceIds.add(billRows.get(i).getPrimaryKeyValue());
                        }
                        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ar_invoice", (String)"id,e_unitprice,e_quantity", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
                        Map<Long, DynamicObject> invoiceMap = Arrays.stream(invoices).collect(Collectors.toMap(temp -> temp.getLong("id"), temp -> temp));
                        for (int i = 0; i < billRows.size(); ++i) {
                            Object keyValue = billRows.get(i).getPrimaryKeyValue();
                            DynamicObject invoice = invoiceMap.get(keyValue);
                            DynamicObjectCollection entry = invoice.getDynamicObjectCollection("entry");
                            BigDecimal qty = ((DynamicObject)entry.get(0)).getBigDecimal("e_quantity");
                            if (qty.compareTo(BigDecimal.ZERO) != 0) continue;
                            e.setCancel(true);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u62c6\u5206\u540e\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u64cd\u4f5c\u3002", (String)"InvoiceList_17", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                            break block8;
                        }
                        break block8;
                    }
                    if (!"issueandprint".equals(key)) break block10;
                    BillList billList = (BillList)this.getControl(BILLLIST);
                    ListSelectedRowCollection billRows = billList.getSelectedRows();
                    Object[] keys = billRows.getPrimaryKeyValues();
                    QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)keys)};
                    DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ar_invoice", (String)"invoicetype", (QFilter[])filters);
                    HashSet<String> typeSet = new HashSet<String>(5);
                    for (DynamicObject invoice : invoices) {
                        typeSet.add(invoice.getString("invoicetype"));
                    }
                    if (typeSet.size() != 1) {
                        e.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u53d1\u7968\u7c7b\u578b\u7684\u5355\u636e\u3002", (String)"InvoiceList_23", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!typeSet.contains(InvoiceType.GE.getValue()) && !typeSet.contains(InvoiceType.SP.getValue())) {
                        e.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7684\u53d1\u7968\u6253\u5370\u53ea\u652f\u6301\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff0c\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u3002", (String)"InvoiceList_24", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    break block8;
                }
                if (!"syncdata".equals(key)) break block11;
                this.getView().invokeOperation("refresh");
                break block8;
            }
            if (!"copy".equals(key) || (selectedRows = (list = (BillList)this.getView().getControl(BILLLIST)).getSelectedRows()) == null) break block8;
            Object[] pks = selectedRows.getPrimaryKeyValues();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pks[0], (String)"ar_invoice");
            boolean isPriceTotal = obj.getBoolean("isincludetax");
            DynamicObjectCollection detailEntries = obj.getDynamicObjectCollection("entry");
            for (DynamicObject entry : detailEntries) {
                String discountType = entry.getString("e_discountmode");
                BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
                if (!isPriceTotal || !"PERCENT".equals(discountType) || new BigDecimal("100").compareTo(discountRate) != 0) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InvoiceList_28", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "issue": 
            case "invoicewriteoff": 
            case "applyabandon": 
            case "syncdata": 
            case "cancelinvoiced": 
            case "confirmabandon": 
            case "submitcloud": 
            case "cancelabandon": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "confirmissuevalidate": {
                OperationResult operationResult = e.getOperationResult();
                if (operationResult.getSuccessPkIds().isEmpty()) break;
                operationResult.setShowMessage(false);
                this.showConfirmInvoicedList(this.getView(), this.getPluginName());
                break;
            }
            case "invoicecloud": {
                if (!e.getOperationResult().isSuccess()) break;
                this.jumpInvoiceCloud();
                break;
            }
            case "appointsrc": {
                if (!e.getOperationResult().isSuccess()) break;
                this.appointSource();
                break;
            }
            case "antiappointsrc": {
                if (!e.getOperationResult().isSuccess()) break;
                this.antiAppointSource();
                break;
            }
            case "reissue": {
                if (!e.getOperationResult().isSuccess()) break;
                this.reissue();
                break;
            }
            case "issueandprint": {
                if (!e.getOperationResult().isSuccess()) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f00\u7968\u6210\u529f\uff0c\u662f\u5426\u7ee7\u7eed\u6253\u5370\uff1f", (String)"InvoiceList_25", (String)"fi-ar-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("printoption"));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "printoption")) {
            if (isOK) {
                this.getView().invokeOperation("applyprint");
            }
            this.getView().invokeOperation("refresh");
        } else if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] billNos = selectedRows.stream().map(selectedRow -> selectedRow.getBillNo()).toArray();
            LogUtil.addOpLog((String)"ar_invoice", (Object)(billNos.length > 0 ? billNos[0] : null), (String)operateKey, (String)("billnos\uff1a" + JSONObject.toJSONString((Object)billNos) + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    private void reissue() {
        ListSelectedRow selectedRow = this.requireJustOneRow();
        Object pk = selectedRow.getPrimaryKeyValue();
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ar_invoice");
        InvoiceBizService service = new InvoiceBizService();
        BillShowParameter parameter = service.reissue(invoice);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showConfirmInvoicedList(IFormView view, String pluginName) {
        BillList list = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection rows = list.getSelectedRows();
        if (rows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceList_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            Object id = row.getPrimaryKeyValue();
            ids.add(id);
        }
        List successfulIds = QueryServiceHelper.queryPrimaryKeys((String)"ar_invoice", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("billstatus", "=", (Object)"C"), new QFilter("invoicestatus", "=", (Object)"0")}, (String)"", (int)-1);
        if (successfulIds.size() == 0) {
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ar_invoice_showlist");
        fsp.setCustomParam("successfulIds", (Object)successfulIds);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "confirmInvoiced");
        fsp.setCloseCallBack(closeCallBack);
        view.showForm(fsp);
    }

    private void setAutoArVisible(List<Long> orgIdList) {
        if (ObjectUtils.isEmpty(orgIdList)) {
            orgIdList = OrgHelper.getAuthorizedInitializedOrgIds((String)"ar_invoice", (String)"47150e89000000ac", (boolean)true);
        }
        logger.info("InvoiceList setAutoArVisible orgIdList " + orgIdList);
        Map enableOrgParam = kd.fi.arapcommon.helper.SystemParameterHelper.batchGetAppParameter((Boolean)true, (List)orgIdList, (String)"ar_001");
        logger.info("InvoiceList setAutoArVisible enableOrgParam " + SerializationUtils.toJsonString((Object)enableOrgParam));
        HashSet<Boolean> orgParamSet = new HashSet<Boolean>(2);
        for (Map.Entry entry : enableOrgParam.entrySet()) {
            Object param = entry.getValue();
            if (param == null) continue;
            orgParamSet.add((Boolean)param);
        }
        logger.info("InvoiceList setAutoArVisible orgParamSet " + orgParamSet);
        if (orgParamSet.contains(false)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblpushap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblpushap"});
        }
    }
}

