/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.BeforeDrawOpResult;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceRedEdit
extends AbstractBillPlugIn {
    private static final String ruleId = "762872803660698624";
    private static final String entityNumber = "ar_invoice";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"blueinvoicecode"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey()) {
            case "blueinvoicecode": {
                this.doBeforeDraw();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equalsIgnoreCase("draw")) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.doDraw(rows);
        }
    }

    private void doBeforeDraw() {
        BeforeDrawArgs args = new BeforeDrawArgs();
        args.setSourceEntityNumber(entityNumber);
        args.setTargetEntityNumber(entityNumber);
        BillModel m = (BillModel)this.getModel();
        args.setTargetPageId(m.getPageId());
        args.setRuleId(ruleId);
        ConvertOperationResult opResult = ConvertServiceHelper.beforeDraw((BeforeDrawArgs)args);
        BeforeDrawOpResult result = (BeforeDrawOpResult)opResult;
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
        } else {
            DynamicObject org;
            String filter = result.getDrawFilter();
            QFilter qFilter = QFilter.fromSerializedString((String)filter);
            String sourceFormId = kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)result.getDrawSourceLayout()) ? result.getDrawSourceLayout() : entityNumber;
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)sourceFormId, (boolean)false);
            showParameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.getListFilterParameter().setOrderBy("bizdate desc");
            if (result.getDrawSelectedEntity().size() > 0) {
                String selectEntity = (String)result.getDrawSelectedEntity().get(result.getDrawSelectedEntity().size() - 1);
                showParameter.getListFilterParameter().setSelectEntity(selectEntity);
                showParameter.getCustomParams().put("ismergerows", Boolean.FALSE);
            }
            if (null != (org = (DynamicObject)m.getValue("org"))) {
                showParameter.setIsolationOrg(true);
                showParameter.setUseOrgId(org.getLong("id"));
            } else {
                showParameter.setIsolationOrg(false);
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "draw");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void doDraw(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        BillModel m = (BillModel)this.getModel();
        String srcBillId = (String)m.getValue("sourcebillid");
        if (!StringUtils.isEmpty((String)srcBillId)) {
            ListSelectedRow row = rows.get(0);
            if (row != null) {
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)entityNumber);
                m.setValue("blueinvoicecode", blueInvoice.get("invoicecode"));
                m.setValue("blueinvoiceno", blueInvoice.get("invoiceno"));
            }
            return;
        }
        m.deleteEntryData("entry");
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber(entityNumber);
        args.setTargetEntityNumber(entityNumber);
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.getSelectedRows().addAll(rows);
        args.setTargetPageId(m.getPageId());
        args.setRuleId(ruleId);
        args.setBuildConvReport(true);
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        } else {
            IRefrencedataProvider refProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                    BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                }
            };
            List dataEntitys = result.loadTargetDataObjects(refProvider, m.getDataEntityType());
            m.push(dataEntitys.get(0));
            this.getView().updateView();
        }
    }
}

