/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ar.formplugin.formservice.InvoiceCardService;
import kd.fi.ar.helper.OrgHelper;

public class InvoiceSellerEdit
extends AbstractFormPlugin {
    private static final String OK = "btnok";
    private static final String SELLERACCTF7 = "selleracctf7";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (parentModel.getProperty(propName) == null) continue;
            Object propValue = parentModel.getValue(propName);
            if (propValue instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)propValue;
                model.setValue(propName, obj.getPkValue());
                continue;
            }
            model.setValue(propName, propValue);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sellername", "sellerbank", OK, "selleracct"});
        this.initOrgF7();
        this.initAcctF7();
    }

    private void initOrgF7() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("seller");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("orgpattern", "in", (Object)OrgHelper.getOrgPattern());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void initAcctF7() {
        DynamicObject seller = (DynamicObject)this.getModel().getValue("seller");
        if (seller == null) {
            return;
        }
        DynamicObject inoviceCurrency = (DynamicObject)this.getView().getParentView().getModel().getValue("currency");
        BasedataEdit acctF7 = (BasedataEdit)this.getControl(SELLERACCTF7);
        acctF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)seller.getLong("id"));
            qFilter.and("acctstatus", "=", (Object)"normal");
            qFilter.and("currencyname", "like", (Object)("%" + inoviceCurrency.get("name") + "%"));
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        BasedataEdit control = null;
        switch (key) {
            case "sellername": {
                control = (BasedataEdit)this.getControl("seller");
                control.click();
                break;
            }
            case "sellerbank": {
                control = (BasedataEdit)this.getControl("sellerbankf7");
                control.click();
                break;
            }
            case "selleracct": {
                DynamicObject seller = (DynamicObject)this.getModel().getValue("seller");
                if (seller == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u65b9\u3002", (String)"InvoiceSellerEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                control = (BasedataEdit)this.getControl(SELLERACCTF7);
                control.click();
                break;
            }
            case "btnok": {
                this.btnOk();
                break;
            }
        }
    }

    private void btnOk() {
        Map<String, Object> map = InvoiceCardService.initSellerParamMap(this.getModel());
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "seller": {
                this.sellerChanged(newValue);
                break;
            }
            case "sellername": {
                if (!"".equals(newValue)) break;
                this.getModel().setValue("seller", null);
                break;
            }
            case "sellerbankf7": {
                this.sellerbankf7Changed(newValue);
                break;
            }
            case "selleracctf7": {
                this.selleraccf7Change(newValue);
                break;
            }
        }
    }

    private void sellerChanged(Object newValue) {
        DynamicObject org = (DynamicObject)newValue;
        if (org != null) {
            InvoiceCardService.fillSellerInfo(this.getModel(), org);
        }
    }

    private void sellerbankf7Changed(Object newValue) {
        DynamicObject bank = (DynamicObject)newValue;
        if (bank != null) {
            this.getModel().setValue("sellerbank", bank.get("name"));
        }
    }

    private void selleraccf7Change(Object newValue) {
        DynamicObject bankacct = (DynamicObject)newValue;
        if (bankacct != null) {
            this.getModel().setValue("selleracct", bankacct.get("bankaccountnumber"));
            this.getModel().setValue("sellerbank", bankacct.get("bank.name"));
        }
    }
}

