/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.fi.ar.helper.ViewsettleHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;

public class LiquidationEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        String entityId;
        super.afterBindData(e);
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        if (entrys != null && entrys.size() > 0) {
            Date maxDate = null;
            for (DynamicObject entry : entrys) {
                Date billDate = entry.getDate("sourcebilldate");
                if (maxDate == null) {
                    maxDate = billDate;
                    continue;
                }
                if (!maxDate.before(billDate)) continue;
                maxDate = billDate;
            }
            DateEdit date = (DateEdit)this.getControl("liquidationdate");
            date.setMinDate(maxDate);
        }
        if ("botp_lookuptracker".equals(entityId = this.getView().getParentView().getEntityId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
        }
        if ("ar_handsettle".equals(entityId) || "ar_settleconsole".equals(entityId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"deleteentry"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"deleteentry"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("submit".equals(key) && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ar_liquidation", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        IDataModel m = this.getModel();
        switch (key) {
            case "exchangerate": {
                if (oldValue == newValue) {
                    return;
                }
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"LiquidationEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                BigDecimal exchangerate = (BigDecimal)this.getModel().getValue("exchangerate");
                String quotation = (String)this.getModel().getValue("quotation");
                DynamicObject bascur = (DynamicObject)m.getValue("basecurrency");
                int baseprecision = bascur.getInt("amtprecision");
                BigDecimal liquidationlocalamt = BigDecimal.ZERO;
                int entryRowCount = m.getEntryRowCount("entryentity");
                for (int i = 0; i < entryRowCount; ++i) {
                    BigDecimal unsettleamt = (BigDecimal)m.getValue("unsettleamt", i);
                    BigDecimal e_lqdlocalamt = BigDecimal.ZERO;
                    if ("1".equals(quotation)) {
                        e_lqdlocalamt = unsettleamt.divide(exchangerate, baseprecision, RoundingMode.HALF_UP);
                        liquidationlocalamt = liquidationlocalamt.add(e_lqdlocalamt);
                    } else {
                        e_lqdlocalamt = unsettleamt.multiply(exchangerate).setScale(baseprecision, RoundingMode.HALF_UP);
                        liquidationlocalamt = liquidationlocalamt.add(e_lqdlocalamt);
                    }
                    m.setValue("e_lqdlocalamt", (Object)e_lqdlocalamt, i);
                }
                m.setValue("liquidationlocalamt", (Object)liquidationlocalamt);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (billstatus != null && !"".equals(billstatus)) {
            e.setCheckDataChange(false);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("looksettle".equals(key)) {
            ViewsettleHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        }
    }
}

