/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.util.DateUtils;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.exception.ManaulSettleQueryException;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.ManualVerifyPluginHelper;
import kd.fi.arapcommon.util.StdConfig;

public class ManualVerifyPlugin4Query
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnquery"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_refresh": {
                Button btnQuery = (Button)this.getControl("btnquery");
                btnQuery.click();
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnquery": {
                this.btnQueryClick();
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (evt.getParentNodeId() == null || "".equals(evt.getParentNodeId())) {
            return;
        }
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put("node", nodeId);
        this.getModel().deleteEntryData("mainbill");
        this.getModel().deleteEntryData("asstbill");
        this.getModel().deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter mainVS = this.getMainVS(nodeId);
        TableValueSetter asstVS = this.getAsstVS(nodeId);
        model.batchCreateNewEntryRow("mainbill", mainVS);
        model.batchCreateNewEntryRow("asstbill", asstVS);
        model.endInit();
        this.getView().updateView("mainbill");
        this.getView().updateView("asstbill");
    }

    private TableValueSetter getMainVS(String nodeId) {
        String verifyRelation = (String)this.getModel().getValue("verifyrelation");
        TableValueSetter mainVS = ManualVerifyPluginHelper.getMainBillSetter();
        if (VerifyRelationEnum.ARSALOUT.getValue().equals(verifyRelation) || VerifyRelationEnum.SALSELF.getValue().equals(verifyRelation)) {
            DataSet imPurDS = this.getImSalBills(nodeId, true);
            this.processImPurVS(mainVS, imPurDS);
        } else if (VerifyRelationEnum.ARSALRETURN.getValue().equals(verifyRelation)) {
            DataSet imPurDS = this.getImSalBills(nodeId, false);
            this.processImPurVS(mainVS, imPurDS);
        } else {
            DataSet apFinDS = this.getArFinBills(nodeId, true);
            this.processArFinVS(mainVS, apFinDS);
        }
        return mainVS;
    }

    private TableValueSetter getAsstVS(String nodeId) {
        String verifyRelation = (String)this.getModel().getValue("verifyrelation");
        TableValueSetter asstVS = ManualVerifyPluginHelper.getAsstBillSetter();
        if (VerifyRelationEnum.ARSALRETURN.getValue().equals(verifyRelation) || VerifyRelationEnum.ARFINSELF.getValue().equals(verifyRelation)) {
            DataSet apFinDS = this.getArFinBills(nodeId, false);
            this.processArFinVS(asstVS, apFinDS);
        } else if (VerifyRelationEnum.ARSALOUT.getValue().equals(verifyRelation)) {
            DataSet apFinDS = this.getArFinBills(nodeId, true);
            this.processArFinVS(asstVS, apFinDS);
        } else {
            DataSet imPurDS = this.getImSalBills(nodeId, false);
            this.processImPurVS(asstVS, imPurDS);
        }
        return asstVS;
    }

    private DataSet getArFinBills(String nodeId, boolean positive) {
        QFilter apFinFilter = this.getArFinFilter(nodeId, positive);
        this.checkMaxCount("ar_revcfmbill", apFinFilter.toArray());
        String selector = "id,billno,bizdate,currency,quotation,exchangerate,basecurrency,entry.id,entry.e_material,entry.e_actunitprice,entry.e_material.modelnum,entry.e_measureunit,entry.e_material.baseunit,entry.e_materialversion,entry.e_corebillno,entry.e_assistantattr,entry.e_unitcoefficient,entry.e_unverifyqty,entry.e_unverifyamt,entry.configuredcode,entry.tracknumber";
        if (nodeId == null) {
            selector = "id,asstacttype,asstact";
        }
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"manual_queryfin", (String)"ar_revcfmbill", (String)selector, (QFilter[])apFinFilter.toArray(), (String)"billno,bizdate,entry.e_material", (int)this.getQueryEntryCount());
        return finDataSet;
    }

    private DataSet getImSalBills(String nodeId, boolean positive) {
        QFilter purFilter = this.getSalFinFilter(nodeId, positive);
        ArrayList<String> invBillnos = new ArrayList<String>(2);
        invBillnos.add("211");
        invBillnos.add("2111");
        purFilter.and("invscheme.number", "not in", invBillnos);
        this.checkMaxCount("im_saloutbill", purFilter.toArray());
        String selector = "id,billno,biztime,settlecurrency,quotation,exchangerate,currency,billentry.id,billentry.material.id,billentry.material.masterid,billentry.material.masterid.modelnum,billentry.qty,billentry.amount,billentry.mainbillnumber,billentry.unit,billentry.baseunit,billentry.baseqty,billentry.unverifyqty,billentry.actualprice,billentry.mversion,billentry.auxpty,billentry.configuredcode,billentry.tracknumber";
        String orderBy = "billno,biztime,billentry.material";
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"manual_querypur", (String)"im_saloutbill", (String)selector, (QFilter[])purFilter.toArray(), (String)orderBy, (int)this.getQueryEntryCount());
        DataSet multUnitDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "getmultimeasureunit"), (String)"bd_multimeasureunit", (String)"materialid.id,measureunitid.id,denominator,numerator", (QFilter[])new QFilter[]{new QFilter("converttype", "=", (Object)"1")}, null);
        finDataSet = finDataSet.join(multUnitDataSet, JoinType.LEFT).on("billentry.material.masterid", "materialid.id").on("billentry.unit", "measureunitid.id").select(new String[]{"id", "billno", "biztime", "settlecurrency", "quotation", "exchangerate", "currency", "billentry.id", "billentry.mainbillnumber", "billentry.material.masterid", "billentry.material.masterid.modelnum", "billentry.qty", "billentry.amount", "billentry.unit", "billentry.baseunit", "billentry.baseqty", "billentry.unverifyqty", "billentry.actualprice", "billentry.mversion", "billentry.auxpty", "billentry.configuredcode", "billentry.tracknumber"}, new String[]{"1.0*numerator/denominator unitrate"}).finish();
        return finDataSet;
    }

    private DynamicObject[] getImSalBills4Customer(boolean positive) {
        QFilter purFilter = this.getSalFinFilter(null, positive);
        String selector = "id,customer";
        String orderBy = "customer";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)selector, (QFilter[])purFilter.toArray(), (String)orderBy, (int)10000);
        return bills;
    }

    private DynamicObject[] getArFinBills4Customer(boolean positive) {
        QFilter arFinFilter = this.getArFinFilter(null, positive);
        String selector = "id,asstacttype,asstact";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)selector, (QFilter[])arFinFilter.toArray(), (String)"asstact", (int)10000);
        return bills;
    }

    private void processImPurVS(TableValueSetter vs, DataSet dataSet) {
        if (dataSet.hasNext()) {
            for (Row row : dataSet) {
                BigDecimal unverifyQuantity = row.getBigDecimal("billentry.unverifyqty");
                BigDecimal convertrate = row.getBigDecimal("unitrate");
                if (convertrate == null) {
                    convertrate = BigDecimal.ONE;
                }
                BigDecimal price = row.getBigDecimal("billentry.actualprice");
                Object[] rowData = new Object[]{row.getLong("id"), row.getLong("billentry.id"), row.get("billno"), row.getString("billentry.mainbillnumber"), row.get("biztime"), row.get("settlecurrency"), row.get("quotation"), row.get("exchangerate"), row.get("currency"), row.get("billentry.material.masterid"), row.get("billentry.mversion"), row.get("billentry.material.masterid.modelnum"), row.get("billentry.auxpty"), row.get("billentry.configuredcode"), row.get("billentry.tracknumber"), row.get("billentry.unit"), convertrate, row.get("billentry.baseunit"), price, unverifyQuantity, unverifyQuantity, unverifyQuantity.multiply(convertrate), price.multiply(unverifyQuantity), price.multiply(unverifyQuantity)};
                vs.addRow(rowData);
            }
        }
    }

    private void processArFinVS(TableValueSetter vs, DataSet dataSet) {
        if (dataSet.hasNext()) {
            for (Row row : dataSet) {
                BigDecimal unverifyQuantity = row.getBigDecimal("entry.e_unverifyqty");
                BigDecimal convertrate = row.getBigDecimal("entry.e_unitcoefficient");
                Object[] rowData = new Object[]{row.getLong("id"), row.getLong("entry.id"), row.get("billno"), row.getString("entry.e_corebillno"), row.get("bizdate"), row.get("currency"), row.get("quotation"), row.get("exchangerate"), row.get("basecurrency"), row.get("entry.e_material"), row.get("entry.e_materialversion"), row.getString("entry.e_material.modelnum"), row.get("entry.e_assistantattr"), row.get("entry.configuredcode"), row.get("entry.tracknumber"), row.get("entry.e_measureunit"), convertrate, row.get("entry.e_material.baseunit"), row.get("entry.e_actunitprice"), unverifyQuantity, unverifyQuantity, unverifyQuantity.multiply(convertrate), row.get("entry.e_unverifyamt"), row.get("entry.e_unverifyamt")};
                vs.addRow(rowData);
            }
        }
    }

    protected QFilter getArFinFilter(String asstactId, boolean positive) {
        boolean verifyPresent;
        String coreBill;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and(new QFilter("billtype.number", "in", (Object)VerifyServiceHelper.getVerifyBillTypeNum()));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            filter.and(new QFilter("currency", "=", currency.getPkValue()));
        }
        filter.and(new QFilter("verifystatus", "in", (Object)new String[]{"unverify", "partverify"}));
        if (asstactId != null) {
            filter.and(new QFilter("asstact", "in", (Object)BaseDataHelper.getBaseDataIds((String)"bd_customer", (long)Long.parseLong(asstactId))));
        }
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        filter.and(new QFilter("bizdate", ">=", (Object)startDate));
        filter.and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        if (positive) {
            filter.and(new QFilter("entry.e_unverifyqty", ">", (Object)0));
        } else {
            filter.and(new QFilter("entry.e_unverifyqty", "<", (Object)0));
        }
        if (this.getModel().getValue("material") != null) {
            DynamicObjectCollection materialColl = (DynamicObjectCollection)this.getModel().getValue("material");
            if (materialColl.size() > 0) {
                filter.and(new QFilter("entry.e_material", "in", (Object)ArApHelper.getIdList4MultiBase((DynamicObjectCollection)materialColl)));
            } else {
                filter.and(new QFilter("entry.e_material", ">", (Object)0));
            }
        }
        if ((coreBill = (String)this.getModel().getValue("corebillid")) != null && !"".equals(coreBill.trim())) {
            filter.and(new QFilter("entry.e_corebillno", "like", (Object)coreBill));
        }
        if (verifyPresent = ((Boolean)this.getModel().getValue("verifypresent")).booleanValue()) {
            filter.and(new QFilter("entry.e_ispresent", "=", (Object)Boolean.TRUE));
        } else {
            filter.and(new QFilter("entry.e_ispresent", "=", (Object)Boolean.FALSE));
        }
        return filter;
    }

    protected QFilter getSalFinFilter(String asstactId, boolean positive) {
        boolean verifyPresent;
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            filter.and(new QFilter("settlecurrency", "=", currency.getPkValue()));
        }
        if (asstactId != null) {
            String verifyQuery = StdConfig.get((String)"newManualVerify4Query");
            if ("true".equals(verifyQuery)) {
                filter.and(new QFilter("billentry.settlecustomer", "in", (Object)BaseDataHelper.getBaseDataIds((String)"bd_customer", (long)Long.parseLong(asstactId))));
            } else {
                filter.and(new QFilter("customer", "in", (Object)BaseDataHelper.getBaseDataIds((String)"bd_customer", (long)Long.parseLong(asstactId))));
            }
        }
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        filter.and(new QFilter("biztime", ">=", (Object)startDate));
        filter.and(new QFilter("biztime", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        filter.and(new QFilter("billentry.entrysettleorg", "=", org.getPkValue()));
        if (this.getModel().getValue("material") != null) {
            DynamicObjectCollection materialColl = (DynamicObjectCollection)this.getModel().getValue("material");
            if (materialColl.size() > 0) {
                ArrayList<Long> masterIds = new ArrayList<Long>(materialColl.size());
                for (DynamicObject obj : materialColl) {
                    masterIds.add(obj.getDynamicObject("fbasedataid").getLong("masterid"));
                }
                Map materialInbentoryMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "in", masterIds)});
                ArrayList<Long> materialInbentoryIds = new ArrayList<Long>(materialInbentoryMap.size());
                for (Map.Entry keySet : materialInbentoryMap.entrySet()) {
                    DynamicObject obj = (DynamicObject)keySet.getValue();
                    materialInbentoryIds.add(obj.getLong("id"));
                }
                filter.and(new QFilter("billentry.material", "in", materialInbentoryIds));
            } else {
                filter.and(new QFilter("billentry.material", ">", (Object)0));
            }
        }
        if (positive) {
            filter.and(new QFilter("billentry.unverifyqty", ">", (Object)0));
        } else {
            filter.and(new QFilter("billentry.unverifyqty", "<", (Object)0));
        }
        String coreBill = (String)this.getModel().getValue("corebillid");
        if (coreBill != null && !"".equals(coreBill.trim())) {
            filter.and(new QFilter("billentry.mainbillnumber", "like", (Object)coreBill));
        }
        if (verifyPresent = ((Boolean)this.getModel().getValue("verifypresent")).booleanValue()) {
            filter.and(new QFilter("billentry.ispresent", "=", (Object)Boolean.TRUE));
        } else {
            filter.and(new QFilter("billentry.ispresent", "=", (Object)Boolean.FALSE));
        }
        filter.and("billentry.logisticsbill", "=", (Object)Boolean.FALSE);
        QFilter isnotVmiDomianFilter = new QFilter("biztype.domain", "<>", (Object)"6");
        QFilter virtualBillFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.TRUE);
        QFilter isnotvirtualBillFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE);
        QFilter vmiFilter = isnotVmiDomianFilter.and(isnotvirtualBillFilter);
        filter.and(vmiFilter.or(virtualBillFilter));
        return filter;
    }

    private void btnQueryClick() {
        Container queryPanel = (Container)this.getControl("querypanel");
        queryPanel.setCollapse(true);
        this.getModel().deleteEntryData("mainbill");
        this.getModel().deleteEntryData("asstbill");
        this.getModel().deleteEntryData("entryentity");
        this.getView().setVisible(Boolean.TRUE, new String[]{"toolbarpanel", "contentpanel"});
        this.loadTreeView();
    }

    private void loadTreeView() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.deleteAllNodes();
        TreeNode root = new TreeNode(null, "customer", ResManager.loadKDString((String)"\u5ba2\u6237", (String)"ManualVerifyPlugin4Query_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        ArrayList<TreeNode> childs = new ArrayList<TreeNode>();
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand("customer");
        DynamicObjectCollection customerColl = (DynamicObjectCollection)this.getModel().getValue("customer");
        if (customerColl != null && customerColl.size() > 0) {
            for (DynamicObject customer : customerColl) {
                childs.add(new TreeNode("customer", customer.getDynamicObject("fbasedataid").getString("masterid"), customer.getDynamicObject("fbasedataid").getLocaleString("name").toString()));
            }
        } else {
            Map<String, String> mainMap = this.getMainCustomerMap();
            Map<String, String> asstMap = this.getAsstCustomerMap();
            for (Map.Entry<String, String> entry2 : asstMap.entrySet()) {
                mainMap.put(entry2.getKey(), entry2.getValue());
            }
            mainMap.entrySet().forEach(entry -> childs.add(new TreeNode("customer", (String)entry.getKey(), (String)entry.getValue())));
        }
        root.addChildren(childs);
        if (childs.size() > 0) {
            TreeNode focusNode = (TreeNode)childs.get(0);
            if (this.getPageCache().get("node") != null) {
                String nodeId = this.getPageCache().get("node");
                for (TreeNode node : childs) {
                    if (!nodeId.equals(node.getId())) continue;
                    focusNode = node;
                    break;
                }
            }
            treeView.focusNode(focusNode);
            treeView.treeNodeClick("customer", focusNode.getId());
        }
    }

    private Map<String, String> getMainCustomerMap() {
        HashMap<String, String> mainMap = new HashMap<String, String>();
        String verifyRelation = (String)this.getModel().getValue("verifyrelation");
        DynamicObject[] bills = null;
        String fieldName = null;
        if (VerifyRelationEnum.ARSALOUT.getValue().equals(verifyRelation) || VerifyRelationEnum.SALSELF.getValue().equals(verifyRelation)) {
            bills = this.getImSalBills4Customer(true);
            fieldName = "customer";
        } else if (VerifyRelationEnum.ARSALRETURN.getValue().equals(verifyRelation)) {
            bills = this.getImSalBills4Customer(false);
            fieldName = "customer";
        } else {
            bills = this.getArFinBills4Customer(true);
            fieldName = "asstact";
        }
        if (bills != null && bills.length > 0) {
            for (DynamicObject bill : bills) {
                DynamicObject asstact = bill.getDynamicObject(fieldName);
                if (asstact == null) continue;
                mainMap.put(asstact.getString("masterid"), asstact.getString("name"));
            }
        }
        return mainMap;
    }

    private Map<String, String> getAsstCustomerMap() {
        HashMap<String, String> asstMap = new HashMap<String, String>();
        String verifyRelation = (String)this.getModel().getValue("verifyrelation");
        DynamicObject[] bills = null;
        String fieldName = null;
        if (VerifyRelationEnum.ARSALRETURN.getValue().equals(verifyRelation) || VerifyRelationEnum.ARFINSELF.getValue().equals(verifyRelation)) {
            bills = this.getArFinBills4Customer(false);
            fieldName = "asstact";
        } else if (VerifyRelationEnum.ARSALOUT.getValue().equals(verifyRelation)) {
            bills = this.getArFinBills4Customer(true);
            fieldName = "asstact";
        } else {
            bills = this.getImSalBills4Customer(false);
            fieldName = "customer";
        }
        if (bills != null && bills.length > 0) {
            for (DynamicObject bill : bills) {
                DynamicObject asstact = bill.getDynamicObject(fieldName);
                if (asstact == null) continue;
                asstMap.put(asstact.getString("masterid"), asstact.getString("name"));
            }
        }
        return asstMap;
    }

    private void checkMaxCount(String entityKey, QFilter[] filter) {
        int queryEntryCount;
        int totalCnt = QueryServiceHelper.queryDataSet((String)"checkMaxCount", (String)entityKey, (String)"id", (QFilter[])filter, null).count("id", false);
        if (totalCnt > (queryEntryCount = this.getQueryEntryCount())) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
            ErrorCode ec = new ErrorCode("MANUALVERIFY_QUERY", ResManager.loadKDString((String)"[%1$s]\u67e5\u8be2\u7684\u5355\u636e\u5206\u5f55\u6570\u91cf\u8d85\u8fc7\u4e86\u8bbe\u7f6e\u7684\u6700\u5927\u503c%2$s\u3002", (String)"ManualVerifyPlugin4Query_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            throw new ManaulSettleQueryException(ec, new Object[]{dataEntityType.getDisplayName(), queryEntryCount});
        }
    }

    private int getQueryEntryCount() {
        int queryEntryCount = 50000;
        String queryEntryCountConfig = StdConfig.get((String)"queryEntryCount");
        if (!ObjectUtils.isEmpty((Object)queryEntryCountConfig)) {
            queryEntryCount = Integer.parseInt(queryEntryCountConfig);
        }
        return queryEntryCount;
    }
}

