/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.formplugin.ArAppHomeBasePlugin;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.util.DateUtils;

public class MatureRankingPlugin
extends ArAppHomeBasePlugin {
    public void afterCreateNewData(EventObject e) {
        this.drawChart();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.drawChart();
        }
    }

    private void drawChart() {
        this.getModel().deleteEntryData("entryentity");
        DynamicObject[] infos = this.getFinBillData();
        if (infos.length < 1) {
            return;
        }
        int[] index = this.getModel().batchCreateNewEntryRow("entryentity", infos.length);
        this.getModel().beginInit();
        Date compareDate = new Date();
        for (int i = 0; i < infos.length; ++i) {
            DynamicObject dy = infos[i];
            this.getModel().setValue("billno", (Object)dy.getString("billno"), index[i]);
            this.getModel().setValue("asstactname", (Object)dy.getDynamicObject("asstact").getString("name"), index[i]);
            compareDate = DateUtils.getDataFormat((Date)compareDate, (boolean)true);
            Date dueDate = DateUtils.getDataFormat((Date)dy.getDate("duedate"), (boolean)true);
            this.getModel().setValue("matureday", (Object)DateUtils.getDiffDays((Date)compareDate, (Date)dueDate), index[i]);
            this.getModel().setValue("currency", dy.getDynamicObject("currency").getPkValue(), index[i]);
            this.getModel().setValue("amount", (Object)dy.getBigDecimal("recamount"), index[i]);
            this.getModel().setValue("unsettleamount", (Object)dy.getBigDecimal("unsettleamount"), index[i]);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    protected DynamicObject[] getFinBillData() {
        List<String> selector = this.getSelector();
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", this.getOrgIds()), new QFilter("unsettleamount", ">", (Object)0), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("duedate", "is not null", (Object)Boolean.TRUE)};
        return BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", selector), (QFilter[])filters, (String)"duedate", (int)10);
    }

    private List<String> getSelector() {
        ArrayList<String> queryFields = new ArrayList<String>();
        queryFields.add("billno");
        queryFields.add("asstacttype");
        queryFields.add("asstact");
        queryFields.add("unsettleamount");
        queryFields.add("recamount");
        queryFields.add("currency");
        queryFields.add("duedate");
        return queryFields;
    }
}

