/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.helper.BadDebtAccrualHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class PolicySettingEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map custParams = parameter.getCustomParams();
        OperationStatus status = parameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Object showFrom;
            DynamicObject org;
            long orgId = 0L;
            Object target = custParams.get("SELECT_ORG_ID");
            orgId = target != null ? Long.parseLong(target.toString()) : RequestContext.get().getOrgId();
            if ("ar".equals(parameter.getAppId()) && "bos_list".equals(parameter.getParentFormId()) && !ObjectUtils.isEmpty((Object)(org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org"))) && org.getBoolean("fisaccounting")) {
                this.getModel().setValue("orgs", (Object)new Object[]{orgId});
                this.orgsF7Changed(this.getModel().getValue("orgs"));
            }
            if ("arPolicy".equals(showFrom = custParams.get("SHOW_FROM"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"settlemodel"});
            }
        } else {
            Object target = custParams.get("policyPk");
            if (target == null) {
                return;
            }
            DynamicObject policy = BusinessDataServiceHelper.loadSingleFromCache(target, (String)"ar_policy");
            if (ObjectUtils.isEmpty((Object)policy)) {
                policy = BusinessDataServiceHelper.loadSingle(target, (String)"ar_policy");
            }
            DynamicObject init = QueryServiceHelper.queryOne((String)"ar_init", (String)"settlemodel", (QFilter[])new QFilter[]{new QFilter("org", "=", policy.getDynamicObject("org").getPkValue())});
            this.getModel().setValue("orgs", (Object)new Object[]{policy.getDynamicObject("org").getPkValue()});
            this.getModel().setValue("policytype", policy.getDynamicObject("policytype").getPkValue());
            this.getModel().setValue("currency", policy.getDynamicObject("currency").getPkValue());
            this.getModel().setValue("exratetable", policy.getDynamicObject("exratetable").getPkValue());
            this.getModel().setValue("periodtype", policy.getDynamicObject("periodtype").getPkValue());
            this.getModel().setValue("startperiod", policy.getDynamicObject("startperiod").getPkValue());
            this.getModel().setValue("baddebtpolicy", (Object)policy.getString("baddebtpolicy"));
            this.getModel().setValue("settlemodel", (Object)init.getInt("settlemodel"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.orgsF7();
        }
        this.startPeriodF7();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        if (newCustomerUseNewSettle) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"settlemodel"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"settlemodel"});
        }
    }

    private void orgsF7() {
        MulBasedataEdit orgsF7 = (MulBasedataEdit)this.getControl("orgs");
        if (!ObjectUtils.isEmpty((Object)orgsF7)) {
            orgsF7.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    List permOrgIds = OrgHelper.getAuthorizedBankOrgIds((String)"ar", (String)"ar_policy", (String)"47156aff000000ac");
                    if (!permOrgIds.isEmpty()) {
                        QFilter qFilter = new QFilter("id", "in", (Object)permOrgIds);
                        showParameter.getListFilterParameter().setFilter(qFilter);
                    }
                }
            });
        }
    }

    private void startPeriodF7() {
        BasedataEdit periodF7 = (BasedataEdit)this.getControl("startperiod");
        periodF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
            DynamicObject type = (DynamicObject)this.getModel().getValue("periodtype");
            if (!EmptyUtils.isEmpty((Object)type)) {
                qFilter.and(new QFilter("periodtype", "=", type.getPkValue()));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            AdjExchService adjExchService = new AdjExchService("ar");
            adjExchService.insertAdjExchRecord(this.getModel());
            DynamicObjectCollection orgInfos = (DynamicObjectCollection)this.getModel().getValue("orgs");
            for (DynamicObject orgBaseData : orgInfos) {
                DynamicObject org = orgBaseData.getDynamicObject("fbasedataid");
                Long orgId = (Long)org.getPkValue();
                String beforePeriod = ResManager.loadKDString((String)"\u671f\u521d", (String)"PolicySettingEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                DynamicObject exratetable = (DynamicObject)this.getModel().getValue("exratetable");
                BadDebtAccrualHelper.insertNextPeriodBadDebtAccrue((Long)orgId, (Long)0L, (Long)0L, (Long)0L, (Boolean)Boolean.TRUE, (String)beforePeriod, (Long)exratetable.getLong("id"));
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("settlemodel", (String)this.getModel().getValue("settlemodel"));
            if (OperationStatus.ADDNEW.equals((Object)parameter.getStatus())) {
                this.getView().invokeOperation("save4mulorg", option);
            } else {
                option.setVariableValue("policyPk", parameter.getCustomParam("policyPk").toString());
                this.getView().invokeOperation("modify", option);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("orgs".equals(key) && !ObjectUtils.isEmpty((Object)newValue)) {
            this.orgsF7Changed(newValue);
        }
        if ("periodtype".equals(key)) {
            this.getModel().setValue("startperiod", null);
        }
    }

    private void orgsF7Changed(Object newValue) {
        DynamicObject firstOrg = (DynamicObject)((DynamicObjectCollection)newValue).get(0);
        DynamicObject acctOrgSetting = this.getAcctOrgSetting(firstOrg.getLong("fbasedataid_id"));
        if (acctOrgSetting != null) {
            this.getModel().setValue("currency", (Object)acctOrgSetting.getLong("basecurrrency"));
            this.getModel().setValue("exratetable", (Object)acctOrgSetting.getLong("exratetable"));
        } else {
            this.getModel().setValue("currency", (Object)1L);
        }
    }

    private DynamicObject getAcctOrgSetting(Long orgId) {
        QFilter qFilter = new QFilter("baseacctorg", "=", (Object)orgId);
        return QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)"exratetable,basecurrrency", (QFilter[])new QFilter[]{qFilter});
    }
}

