/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.SubmitAndNew;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.errorcode.SystemErrorCode;
import kd.fi.ar.formplugin.ArBaseEdit;
import kd.fi.ar.formplugin.formservice.received.ReceivedBillImportHelper;
import kd.fi.ar.helper.BaseDataHelper;
import kd.fi.ar.util.DateUtils;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;

public class ReceivedBillEdit
extends ArBaseEdit {
    private InitHelper init;
    private boolean isImport = false;
    private ReceivedBillImportHelper importHelper;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterOrg();
        this.filterMaterialVersion();
        this.addClickListeners(new String[]{"e_corebillno"});
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            if (!ObjectUtils.isEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void filterOrg() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List orgIds = OrgHelper.getAuthorizedBankOrgIds((String)"ar", (String)"ar_receivedbill", (String)"47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)orgIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("e_corebillno".equals(key)) {
            int row = this.getModel().getEntryCurrentRowIndex("entry");
            String coreBillType = (String)this.getModel().getValue("e_corebilltype", row);
            ArApCorebillHelper.showCoreBillF7((String)coreBillType, (IFormView)this.getView(), (String)this.getPluginName());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (parameter.isInitialized()) {
            this.fillDefaultValue();
        }
    }

    private void fillDefaultValue() {
        IDataModel model = this.getModel();
        DynamicObject settlementType = BaseDataHelper.getDefaultSettlementType();
        model.setValue("settletype", settlementType == null ? null : settlementType.getPkValue());
        this.orgChanged();
        Object baseCurrency = model.getValue("basecurrency");
        this.getModel().setValue("currency", baseCurrency == null ? null : ((DynamicObject)baseCurrency).getPkValue());
        model.setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            this.init = new InitHelper(org.getLong("id"), "ar_init");
            model.setValue("basecurrency", this.init.getStandardCurrency().getPkValue());
        }
        int count = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < count; ++i) {
            BigDecimal entryAmount = (BigDecimal)model.getValue("e_amount", i);
            model.setValue("e_unsettledamt", (Object)entryAmount, i);
        }
    }

    private void setEntryCellEnable() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            this.setCtrlEnable(row.get("e_material"), "e_material", i);
            this.setCtrlEnable(row.get("e_expenseitem"), "e_expenseitem", i);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("org"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ReceivedBillEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = this.getPk("org");
        if (this.init == null) {
            this.init = new InitHelper(orgId, "ar_init");
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"entry"});
        Date startDate = this.init.getStartDate();
        if (startDate != null) {
            Date maxBizDate = DateUtils.getLastDay((Date)startDate, (int)1);
            DateEdit bizDateEdit = (DateEdit)this.getControl("bizdate");
            bizDateEdit.setMaxDate(maxBizDate);
        }
        if (this.init.isFinishInit()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
            if (OperationStatus.ADDNEW.equals((Object)parameter.getStatus())) {
                String errMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"ReceivedBillEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{"entry"});
                this.getView().showErrorNotification(errMessage);
            } else if (OperationStatus.VIEW.equals((Object)parameter.getStatus()) || OperationStatus.EDIT.equals((Object)parameter.getStatus())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel m = this.getModel();
        switch (key) {
            case "org": {
                this.orgChanged();
                break;
            }
            case "currency": {
                int n;
                if (newValue == null) {
                    m.setValue("currency", oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int o = ((DynamicObject)oldValue).getInt("priceprecision");
                if (o <= (n = ((DynamicObject)newValue).getInt("priceprecision"))) break;
                for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                    this.initPrice(this.getModel(), o, n, i);
                }
                break;
            }
            case "exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ed3\u7b97\u5e01\u6c47\u7387\u4e3a\u7a7a\u3002", (String)"ReceivedBillEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.calculateAmount();
                break;
            }
            case "e_amount": {
                this.calculateAmount();
                break;
            }
            case "e_material": {
                DynamicObject material;
                DynamicObject productline;
                m.setValue("e_materialversion", null, rowIndex);
                m.setValue("e_productline", null, rowIndex);
                if (!EmptyUtils.isEmpty((Object)newValue) && (productline = (material = (DynamicObject)newValue).getDynamicObject("productline")) != null) {
                    this.getModel().setValue("e_productline", productline.getPkValue(), rowIndex);
                }
                this.setCtrlEnable(newValue, key, rowIndex);
                break;
            }
            case "e_expenseitem": {
                this.setCtrlEnable(newValue, key, rowIndex);
                break;
            }
            case "asstact": {
                String asstactType = (String)m.getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)m.getValue("asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    return;
                }
                long asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"));
                if (asstactSettleTypeId == 0L) {
                    return;
                }
                m.setValue("settletype", (Object)asstactSettleTypeId);
                break;
            }
            case "e_corebilltype": {
                m.setValue("e_corebillno", null, rowIndex);
                m.setValue("e_corebillentryseq", null, rowIndex);
                break;
            }
        }
    }

    private void initPrice(IDataModel m, int oldPriceprecision, int newPriceprecision, int currentRow) {
        BigDecimal oldamount = (BigDecimal)m.getValue("e_amount", currentRow);
        m.setValue("e_amount", (Object)oldamount.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
    }

    private void setCtrlEnable(Object value, String fieldName, int rowIndex) {
        boolean enable = false;
        if (value == null) {
            enable = true;
        }
        String ctrlName = "e_material";
        if ("e_material".equals(fieldName)) {
            ctrlName = "e_expenseitem";
        }
        this.getView().setEnable(Boolean.valueOf(enable), rowIndex, new String[]{ctrlName});
    }

    private void orgChanged() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        boolean hasNewPermission = BaseDataHelper.hasNewPermission((long)((Long)org.getPkValue()), (String)"ar_receivedbill");
        if (!hasNewPermission) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
            return;
        }
        if (org.getBoolean("fisbankroll")) {
            this.getModel().setValue("recorg", org.getPkValue());
        }
        if (this.init == null) {
            this.init = new InitHelper(org.getLong("id"), "ar_init");
        }
        if (this.init.isFinishInit()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
            String errMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"ReceivedBillEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue());
            this.getView().showErrorNotification(errMessage);
            return;
        }
        DynamicObject baseCurrency = this.init.getStandardCurrency();
        if (baseCurrency == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
            String errMessage = String.format(SystemErrorCode.ORGNAME_NOT_FINISHSET().getMessage(), org.getLocaleString("name").getLocaleValue());
            this.getView().showErrorNotification(errMessage);
            return;
        }
        this.getModel().setValue("basecurrency", baseCurrency.getPkValue());
        this.getModel().setValue("exratetable", this.init.getExrateTable().getPkValue());
        Date maxBizDate = DateUtils.getLastDay((Date)this.init.getStartDate(), (int)1);
        this.getModel().setValue("bizdate", (Object)maxBizDate);
        DateEdit bizDateEdit = (DateEdit)this.getControl("bizdate");
        bizDateEdit.setMaxDate(maxBizDate);
        this.getModel().setValue("exratedate", (Object)maxBizDate);
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
        this.getModel().putContextVariable("IGNORE_RELOADDATAMODEL", (Object)Boolean.TRUE);
    }

    private void calculateAmount() {
        IDataModel model = this.getModel();
        int precision = 2;
        DynamicObject currency = (DynamicObject)model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal localamount = BigDecimal.ZERO;
        BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
        String quotation = (String)model.getValue("quotation");
        if ("1".equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            BigDecimal e_amount = row.getBigDecimal("e_amount");
            BigDecimal e_settledAmt = row.getBigDecimal("e_settledamt");
            BigDecimal e_localamount = BigDecimal.ZERO;
            e_localamount = "1".equals(quotation) ? e_amount.divide(exchangerate, precision, RoundingMode.HALF_UP) : e_amount.multiply(exchangerate).setScale(precision, RoundingMode.HALF_UP);
            model.setValue("e_localamount", (Object)e_localamount, i);
            model.setValue("e_unsettledamt", (Object)e_amount.subtract(e_settledAmt), i);
            totalAmount = totalAmount.add(e_amount);
            localamount = localamount.add(e_localamount);
        }
        if (this.isImport) {
            if (EmptyUtils.isEmpty((Object)model.getValue("recamount"))) {
                model.setValue("recamount", (Object)totalAmount);
            }
            if (EmptyUtils.isEmpty((Object)model.getValue("localamount"))) {
                model.setValue("localamount", (Object)localamount);
            }
        } else {
            model.setValue("recamount", (Object)totalAmount);
            model.setValue("localamount", (Object)localamount);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        if (!"entry".equals(entryProp.getName())) {
            return;
        }
        this.calculateAmount();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ar_receivedbill", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IBillModel model;
        DynamicObject payee;
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        Object source = args.getSource();
        if ((source instanceof Save || source instanceof Submit || source instanceof SubmitAndNew) && (payee = (DynamicObject)(model = (IBillModel)this.getModel()).getValue("asstact")) != null) {
            model.setValue("payername", (Object)payee.getLocaleString("name"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.setEntryCellEnable();
    }

    private Long getPk(String key) {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue(key);
        return basedata == null ? null : (Long)basedata.getPkValue();
    }

    private ReceivedBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new ReceivedBillImportHelper(this.getModel(), this.getPageCache());
        }
        return this.importHelper;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.getImportHelper().afterImportData(e);
    }
}

