/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ar.formplugin.ArAbstractImport;
import kd.fi.ar.helper.BaseDataHelper;
import kd.fi.ar.util.DateUtils;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.EmptyUtils;

@Deprecated
public class ReceivedBillImportPlugin
extends ArAbstractImport
implements IImportPlugin {
    private Map<String, Object> importData;

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        this.importData = data;
        try {
            this.checkAndFillData();
        }
        catch (Exception exc) {
            importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            return false;
        }
        return true;
    }

    private void checkAndFillData() {
        DynamicObject currency;
        DynamicObject baseCurrency;
        this.validateData();
        DynamicObject mainOrg = this.loadSingleByNameOrNumber("org");
        long orgPk = (Long)mainOrg.getPkValue();
        InitHelper init = new InitHelper(orgPk, "ar_init");
        if (init.isFinishInit()) {
            this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ReceivedBillImportPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), mainOrg.getLocaleString("name").getLocaleValue()));
        }
        if ((baseCurrency = init.getStandardCurrency()) == null) {
            this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ReceivedBillImportPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), mainOrg.getLocaleString("name").getLocaleValue()));
        }
        JSONObject jsonBaseCurrency = new JSONObject();
        if (baseCurrency != null) {
            jsonBaseCurrency.put("number", baseCurrency.get("number"));
        }
        this.importData.put("basecurrency", jsonBaseCurrency);
        Date bizdate = new Date();
        if (!ObjectUtils.isEmpty((Object)this.getDate("bizdate"))) {
            bizdate = this.getDate("bizdate");
            Date startDate = init.getStartDate();
            Date perviousDayOfStartDate = DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)startDate, (int)-1), (boolean)false);
            SimpleDateFormat short_date = new SimpleDateFormat("yyyy-MM-dd");
            if (!ObjectUtils.isEmpty((Object)bizdate) && bizdate.after(perviousDayOfStartDate)) {
                String message = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u201c%1$s\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u65e5\u671f\u201c%2$s\u201d\u7684\u524d\u4e00\u5929\u3002", (String)"ReceivedBillImportPlugin_3", (String)"fi-ar-formplugin", (Object[])new Object[0]), short_date.format(bizdate), short_date.format(startDate));
                this.addErrMessage(message);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(currency = this.loadSingleByNameOrNumber("currency"))) && !ObjectUtils.isEmpty((Object)baseCurrency)) {
            if (this.importData.containsKey("exchangerate")) {
                BigDecimal exchangerate = this.getBigDecimal("exchangerate");
                boolean isCurrencySame = currency.getPkValue().equals(baseCurrency.getPkValue());
                if (isCurrencySame && BigDecimal.ONE.compareTo(exchangerate) != 0) {
                    this.importData.put("exchangerate", BigDecimal.ONE);
                }
                if (BigDecimal.ZERO.compareTo(exchangerate) >= 0) {
                    this.addErrMessage(ResManager.loadKDString((String)"\u6c47\u7387\u5e94\u8be5\u5927\u4e8e0\u3002", (String)"ReceivedBillImportPlugin_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                }
            } else {
                BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)currency.getLong("id"), (Long)baseCurrency.getLong("id"), (Long)mainOrg.getLong("id"), (Date)bizdate);
                if (exchangeRate == null) {
                    this.addErrMessage(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u6c47\u7387\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ReceivedBillImportPlugin_6", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                }
                this.importData.put("exchangerate", exchangeRate);
            }
        }
        this.calculateAmount();
    }

    private void calculateAmount() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalLocalAmount = BigDecimal.ZERO;
        BigDecimal exchangerate = this.getBigDecimal("exchangerate");
        JSONArray entry = (JSONArray)this.importData.get("entry");
        for (int i = 0; i < entry.size(); ++i) {
            JSONObject row = (JSONObject)entry.get(i);
            if (row.get((Object)"e_material") != null && row.get((Object)"e_expenseitem") != null) {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u7269\u6599\u4e0e\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\u3002", (String)"ReceivedBillImportPlugin_11", (String)"fi-ar-formplugin", (Object[])new Object[0]), i + 1));
            }
            BigDecimal e_amount = row.getBigDecimal("e_amount");
            BigDecimal localAmount = e_amount.multiply(exchangerate).setScale(this.baseCurrencyPrecision, 4);
            row.put("e_localamount", (Object)localAmount);
            row.put("e_unsettledamt", (Object)e_amount);
            totalAmount = totalAmount.add(e_amount);
            totalLocalAmount = totalLocalAmount.add(localAmount);
        }
        if (this.importData.containsKey("recamount")) {
            BigDecimal recAmount = this.getBigDecimal("recamount");
            if (!ObjectUtils.isEmpty((Object)recAmount) && totalAmount.compareTo(recAmount) != 0) {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u8868\u5934\u7684\u91d1\u989d\u201c%1$s\u201d\u4e0d\u7b49\u4e8e\u5206\u5f55\u7684\u91d1\u989d\u4e4b\u548c\u201c%2$s\u201d\u3002", (String)"ReceivedBillImportPlugin_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), recAmount.toPlainString(), totalAmount.toPlainString()));
            }
        } else {
            this.importData.put("recamount", totalAmount);
        }
        this.importData.put("localamount", totalLocalAmount);
    }

    private DynamicObject loadSingleByNameOrNumber(String key) {
        return this.loadSingleByNameOrNumber(key, 0, "id,name,number");
    }

    private DynamicObject loadSingleByNameOrNumber(String key, int rowIndex, String selectors) {
        BasedataProp property = (BasedataProp)this.getProperty(key);
        String basedataEntityKey = property.getBaseEntityId();
        JSONObject jsonObject = (JSONObject)this.importData.get(key);
        String number = jsonObject.getString("number");
        String name = jsonObject.getString("name");
        QFilter[] filters = this.getQFilter(basedataEntityKey, name, number);
        Optional<DynamicObject> singleOptional = this.getDynamicObjectFromDb(basedataEntityKey, selectors, filters);
        if (!singleOptional.isPresent()) {
            String displayName = MetadataServiceHelper.getDataEntityType((String)basedataEntityKey).getDisplayName().getLocaleValue();
            if (rowIndex == 0) {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684%2$s\u3002", (String)"ReceivedBillImportPlugin_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), number, displayName));
            } else {
                this.addErrMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\uff0c\u7cfb\u7edf\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684%3$s\u3002", (String)"ReceivedBillImportPlugin_9", (String)"fi-ar-formplugin", (Object[])new Object[0]), rowIndex, number, displayName));
            }
        }
        jsonObject.put("number", (Object)singleOptional.get().getString("number"));
        return singleOptional.get();
    }

    private DynamicProperty getProperty(String key) {
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"ar_receivedbill");
        DynamicProperty property = dt.getProperty(key);
        if (property == null) {
            EntryProp agentEntryProp = (EntryProp)dt.getProperty("");
            property = agentEntryProp._collectionItemPropertyType.getProperty(key);
            if (property == null) {
                ErrorCode errCode = new ErrorCode("NoSuchProperty", String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a\u201c%2$s\u201d\u7684\u5c5e\u6027\u3002", (String)"ReceivedBillImportPlugin_10", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]));
                throw new KDException(errCode, new Object[]{dt.getDisplayName().getLocaleValue(), key});
            }
        }
        return property;
    }

    @Override
    protected BigDecimal getBigDecimal(String key) {
        Object value = this.importData.get(key);
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value != null) {
            try {
                return BigDecimal.valueOf(Double.parseDouble(value.toString()));
            }
            catch (NumberFormatException nfe) {
                this.addErrMessage(nfe.getMessage());
            }
        }
        return BigDecimal.ZERO;
    }

    private Date getDate(String key) {
        Object value = this.importData.get(key);
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value != null) {
            try {
                SimpleDateFormat short_date = new SimpleDateFormat("yyyy-MM-dd");
                return short_date.parse(value.toString());
            }
            catch (ParseException e) {
                this.addErrMessage(e.getMessage());
            }
        }
        return new Date();
    }

    private void addErrMessage(String message) {
        throw new KDBizException(message);
    }

    private void validateData() {
        Object target = this.importData.get("settlenumber");
        if (target == null) {
            return;
        }
        String settleNumber = target.toString();
        if (!EmptyUtils.isEmpty((Object)settleNumber)) {
            this.validateLength(settleNumber, 25, ResManager.loadKDString((String)"\u7ed3\u7b97\u53f7\u6700\u5927\u957f\u5ea6\u4e3a50\u4f4d\u3002", (String)"ReceivedBillImportPlugin_12", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateLength(String target, int maxLength, String errorMessage) {
        if (EmptyUtils.isEmpty((Object)target)) {
            return;
        }
        if (target.length() > maxLength) {
            throw new KDBizException(errorMessage);
        }
    }
}

