/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReserveAmtAdjust
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object pk = this.getView().getFormShowParameter().getCustomParam("pk");
        DynamicObject reserve = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ar_baddebtreservebill", (String)"sourcebillno, basecurrency, unsettlelocalamt, baddebtreserveamt");
        this.getModel().setValue("sourcebillno", (Object)reserve.getString("sourcebillno"));
        this.getModel().setValue("basecurrency", reserve.getDynamicObject("basecurrency").getPkValue());
        this.getModel().setValue("unsettlelocalamt", (Object)reserve.getBigDecimal("unsettlelocalamt"));
        this.getModel().setValue("baddebtreserveamt", (Object)reserve.getBigDecimal("baddebtreserveamt"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("adjust".equals(key)) {
            boolean cancel = false;
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("baddebtreserveamt"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u574f\u8d26\u51c6\u5907\u91d1\u201d\u3002", (String)"ReserveAmtAdjust_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                cancel = true;
            } else if (((BigDecimal)this.getModel().getValue("baddebtreserveamt")).compareTo((BigDecimal)this.getModel().getValue("unsettlelocalamt")) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u574f\u8d26\u51c6\u5907\u91d1\u4e0d\u80fd\u5927\u4e8e\u672a\u7ed3\u7b97\u91d1\u989d(\u672c\u4f4d\u5e01)\u3002", (String)"ReserveAmtAdjust_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                cancel = true;
            } else if (((BigDecimal)this.getModel().getValue("baddebtreserveamt")).compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u574f\u8d26\u51c6\u5907\u91d1\u5e94\u5927\u4e8e0\u3002", (String)"ReserveAmtAdjust_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                cancel = true;
            }
            args.setCancel(cancel);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("adjust".equals(key)) {
            Object pk = this.getView().getFormShowParameter().getCustomParam("pk");
            DynamicObject reserve = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"ar_baddebtreservebill");
            BigDecimal reserveAmt = (BigDecimal)this.getModel().getValue("baddebtreserveamt");
            reserve.set("baddebtreserveamt", (Object)reserveAmt);
            DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
            int precision = 2;
            if (basecurrency != null) {
                precision = basecurrency.getInt("amtprecision");
            }
            if (reserve.getBigDecimal("unsettlelocalamt").compareTo(BigDecimal.ZERO) != 0) {
                reserve.set("referencerate", (Object)reserveAmt.divide(reserve.getBigDecimal("unsettlelocalamt"), 2 + precision, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(precision, RoundingMode.HALF_UP));
            } else {
                reserve.set("referencerate", (Object)BigDecimal.ZERO);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reserve});
            this.getView().close();
        }
    }
}

