/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.ar.formplugin.formservice.revcfm.RevCfmBillImportHelper;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.ar.helper.RevcfmWriteOffVerify;
import kd.fi.ar.helper.ViewverHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.vo.CheckResult;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.MTOHelper;
import kd.fi.arapcommon.helper.MaterialFilterHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.PrecisionHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.BillStatusCtrlService;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StdConfig;

public class RevCfmBillEdit
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
EntryGridSetRowDataListener {
    private boolean isCopyEntryRow = false;
    private InitHelper init;
    private RevCfmBillImportHelper importHelper;
    private Map<String, Object> customersMap;
    private BillStatusCtrlService billStatusCtrlService = new BillStatusCtrlService();
    private QuotationHelper quotationHelper;

    private RevCfmBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new RevCfmBillImportHelper(this.getModel(), this.getPageCache());
        }
        return this.importHelper;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_corebillno"});
        this.materialFilter();
        this.filterMeasureUnit();
        this.filterMaterialVersion();
        this.configuredCodeFilter();
        this.asstactFilter();
        this.taxratefilter();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
            entryGrid.addSetRowDataListener((EntryGridSetRowDataListener)this);
        }
    }

    private void asstactFilter() {
        ItemClassEdit asstactF7 = (ItemClassEdit)this.getControl("asstact");
        asstactF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String asstactType = this.getModel().getValue("asstacttype").toString();
            if ("bd_customer".equals(asstactType)) {
                QFilter filter = new QFilter("bizfunction", "ilike", (Object)"%2%");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    private void filterMeasureUnit() {
        BasedataEdit measureUnitEdit = (BasedataEdit)this.getControl("e_measureunit");
        FormServiceHelper.addMeasureUnitFilter((IDataModel)this.getModel(), (String)"e_material", (String)"entry", (BasedataEdit)measureUnitEdit);
    }

    private void materialFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org) && LineTypeHelper.getParam((long)org.getLong("id"), (boolean)true).booleanValue()) {
            return;
        }
        BasedataEdit materialF7 = (BasedataEdit)this.getControl("e_material");
        materialF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
            if (ObjectUtils.isEmpty((Object)billType)) {
                return;
            }
            QFilter filter = null;
            if ("ar_revcfmbill_standard_BT_S".equals(billType.getString("number"))) {
                filter = new QFilter("materialtype", "in", (Object)MaterialFilterHelper.getMaterialTypes());
            } else if ("ar_revcfmbill_service_BT_S".equals(billType.getString("number"))) {
                filter = new QFilter("materialtype", "=", (Object)"9");
            }
            if (filter != null) {
                ListFilterParameter showParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                showParameter.getQFilters().add(filter);
            }
        });
    }

    private void configuredCodeFilter() {
        BasedataEdit billTypeF7 = (BasedataEdit)this.getControl("configuredcode");
        billTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (EmptyUtils.isNotEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material.id", "=", (Object)materialId);
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        BaseDataHelper.filterMaterialVersion((IDataModel)this.getModel(), (BasedataEdit)materialVersionF7, (String)"ar");
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.getImportHelper().afterImportData(e);
    }

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!ObjectUtils.isEmpty((Object)this.init) && ObjectUtils.isEmpty((Object)this.init.getInitId())) {
            return;
        }
        this.setMinBizdate();
        BillView source = (BillView)e.getSource();
        this.fillToolBar();
        this.setAsstactCaption();
        DynamicObject payproperty = (DynamicObject)this.getModel().getValue("payproperty");
        String billsrctype = (String)this.getModel().getValue("billsrctype");
        if (!BillSrcTypeEnum.VERIFY.getValue().equals(billsrctype)) {
            this.setConfirmwayComboItem(payproperty);
        }
        this.setConfirmAmtEnable();
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
        BookDateHelper.setBookDateRange((IFormView)this.getView(), (boolean)true);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals("entry")) {
            this.deleteEntry(e.getRowIndexs());
        }
    }

    private void deleteEntry(int[] rowIndexs) {
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal deletePriceTaxTotalSum = BigDecimal.ZERO;
        BigDecimal deleteAmountSum = BigDecimal.ZERO;
        BigDecimal deleteTaxSum = BigDecimal.ZERO;
        BigDecimal deletePriceTaxTotalBaseSum = BigDecimal.ZERO;
        BigDecimal deleteAmoutBaseSum = BigDecimal.ZERO;
        BigDecimal deleteTaxBaseSum = BigDecimal.ZERO;
        BigDecimal deleteCfmAmountSum = BigDecimal.ZERO;
        BigDecimal deleteCfmAmountBaseSum = BigDecimal.ZERO;
        for (int rowIndex : rowIndexs) {
            deletePriceTaxTotalSum = deletePriceTaxTotalSum.add((BigDecimal)model.getValue("e_pricetaxtotal", rowIndex));
            deleteAmountSum = deleteAmountSum.add((BigDecimal)model.getValue("e_amount", rowIndex));
            deleteTaxSum = deleteTaxSum.add((BigDecimal)model.getValue("e_tax", rowIndex));
            deletePriceTaxTotalBaseSum = deletePriceTaxTotalBaseSum.add((BigDecimal)model.getValue("e_pricetaxtotalbase", rowIndex));
            deleteAmoutBaseSum = deleteAmoutBaseSum.add((BigDecimal)model.getValue("e_localamt", rowIndex));
            deleteTaxBaseSum = deleteTaxBaseSum.add((BigDecimal)model.getValue("e_taxlocalamt", rowIndex));
            deleteCfmAmountSum = deleteCfmAmountSum.add((BigDecimal)model.getValue("e_confirmamt", rowIndex));
            deleteCfmAmountBaseSum = deleteCfmAmountBaseSum.add((BigDecimal)model.getValue("e_confirmlocamt", rowIndex));
        }
        BigDecimal priceTaxTotal = ((BigDecimal)model.getValue("pricetaxtotal")).subtract(deletePriceTaxTotalSum);
        BigDecimal amount = ((BigDecimal)model.getValue("amount")).subtract(deleteAmountSum);
        BigDecimal tax = ((BigDecimal)model.getValue("tax")).subtract(deleteTaxSum);
        BigDecimal priceTaxTotalBase = ((BigDecimal)model.getValue("pricetaxtotalbase")).subtract(deletePriceTaxTotalBaseSum);
        BigDecimal amountBase = ((BigDecimal)model.getValue("localamt")).subtract(deleteAmoutBaseSum);
        BigDecimal taxBase = ((BigDecimal)model.getValue("taxlocamt")).subtract(deleteTaxBaseSum);
        BigDecimal cfmAmount = ((BigDecimal)model.getValue("confirmamt")).subtract(deleteCfmAmountSum);
        BigDecimal cfmAmountBase = ((BigDecimal)model.getValue("confirmlocamt")).subtract(deleteCfmAmountBaseSum);
        model.setValue("pricetaxtotal", (Object)priceTaxTotal);
        model.setValue("amount", (Object)amount);
        model.setValue("tax", (Object)tax);
        model.setValue("pricetaxtotalbase", (Object)priceTaxTotalBase);
        model.setValue("localamt", (Object)amountBase);
        model.setValue("taxlocamt", (Object)taxBase);
        model.setValue("confirmamt", (Object)cfmAmount);
        model.setValue("confirmlocamt", (Object)cfmAmountBase);
        model.setValue("unverifyamt", (Object)cfmAmount);
        BigDecimal confirmRate = amount.compareTo(BigDecimal.ZERO) != 0 ? cfmAmount.multiply(BigDecimal.valueOf(100L)).divide(amount, 2, 4) : BigDecimal.valueOf(100L);
        int count = this.getModel().getEntryRowCount("entry");
        if (count == rowIndexs.length) {
            confirmRate = BigDecimal.valueOf(0L);
        }
        model.beginInit();
        model.setValue("confirmrate", (Object)confirmRate);
        model.endInit();
        this.getView().updateView("confirmrate");
    }

    private void setAsstactCaption() {
        ItemClassEdit asstact;
        String asstName;
        String asstactType = (String)this.getModel().getValue("asstacttype");
        String customerCaption = ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237", (String)"RevCfmBillEdit_17", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        String asstactCaption = ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"RevCfmBillEdit_18", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        if (!asstactCaption.equals(asstName = (asstact = (ItemClassEdit)this.getControl("asstact")).getProperty().getDisplayName().getLocaleValue())) {
            return;
        }
        if ("bd_customer".equals(asstactType)) {
            asstact.setCaption(new LocaleString(customerCaption));
        } else {
            asstact.setCaption(new LocaleString(asstactCaption));
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        this.controlEnableForMTO(entities);
    }

    public void entryGridSetRowData(EntryGridSetRowDataEvent e) {
        Map copyDataMap = e.getValues();
        if (copyDataMap == null || copyDataMap.size() == 0) {
            return;
        }
        IBillModel model = (IBillModel)this.getModel();
        List confirmamtList = (List)copyDataMap.get("e_confirmamt");
        String errMessage = ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7684\u786e\u8ba4\u91d1\u989d\u987b\u4e0e\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u8d85\u8fc7\u91d1\u989d\u3002", (String)"RevCfmBillEdit_19", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        this.cfmFiedCheck(model, confirmamtList, "e_amount", errMessage);
        List confirmqtyList = (List)copyDataMap.get("e_confirmqty");
        errMessage = ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7684\u786e\u8ba4\u6570\u91cf\u987b\u4e0e\u6570\u91cf\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u8d85\u8fc7\u6570\u91cf\u3002", (String)"RevCfmBillEdit_12", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        this.cfmFiedCheck(model, confirmqtyList, "e_quantity", errMessage);
        List cfmpricetaxList = (List)copyDataMap.get("e_cfmpricetax");
        errMessage = ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7684\u786e\u8ba4\u4ef7\u7a0e\u5408\u8ba1\u987b\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u8d85\u8fc7\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"RevCfmBillEdit_20", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        this.cfmFiedCheck(model, cfmpricetaxList, "e_pricetaxtotal", errMessage);
    }

    private void cfmFiedCheck(IBillModel model, List<Tuple<Integer, Object>> copyDataList, String fieldName, String errMessage) {
        boolean isErr = false;
        if (copyDataList != null && copyDataList.size() > 0) {
            Iterator<Tuple<Integer, Object>> iterator = copyDataList.iterator();
            while (iterator.hasNext()) {
                BigDecimal cfmField;
                Tuple<Integer, Object> tuple = iterator.next();
                BigDecimal field = (BigDecimal)model.getValue(fieldName, ((Integer)tuple.item1).intValue());
                if (field.multiply(cfmField = new BigDecimal(tuple.item2.toString())).compareTo(BigDecimal.ZERO) >= 0 && field.abs().compareTo(cfmField.abs()) >= 0) continue;
                isErr = true;
                iterator.remove();
            }
        }
        if (isErr) {
            this.getView().showTipNotification(errMessage);
        }
    }

    private void controlEnableForMTO(List<RowDataEntity> entries) {
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if (StringUtils.isNotEmpty((CharSequence)sourceBillType)) {
            for (int i = 0; i < entries.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"configuredcode"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"tracknumber"});
            }
        }
    }

    public void changeMtoEnable(DynamicObject material, int row) {
        String configproperties = material.getString("configproperties");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long masterid = material.getLong("masterid");
        HashSet<Long> masterids = new HashSet<Long>(1);
        masterids.add(masterid);
        Map tracewayMap = MTOHelper.getMaterialToTraceWayMap(masterids, (DynamicObject)org);
        List tracewayNumbers = (List)tracewayMap.get(masterid);
        if ("2".equals(configproperties)) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"configuredcode"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"configuredcode"});
        }
        if (EmptyUtils.isNotEmpty((Object)tracewayNumbers) && tracewayNumbers.contains("GZ001")) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"tracknumber"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"tracknumber"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)true);
        if (!"true".equals(this.getPageCache().get("isWebApi"))) {
            this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
            if (ObjectUtils.isEmpty((Object)org) && !ObjectUtils.isEmpty((Object)(org = OrgHelper.getAuthorizedBankOrg((String)"ar", (String)"ar_revcfmbill", (String)"47156aff000000ac")))) {
                this.getModel().setValue("org", (Object)org.getLong("id"));
            }
        }
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"RevCfmBillEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
            return;
        }
        this.init = new InitHelper(org.getLong("id"), "ar_init");
        if (ObjectUtils.isEmpty((Object)this.init.getInitId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"RevCfmBillEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew", "getinventorycost"});
            return;
        }
        if (!"true".equals(this.getPageCache().get("isWebApi"))) {
            this.setDefaultValue(this.getModel(), org);
            Date currentDate = ObjectUtils.isEmpty((Object)this.init.getCurrentDate()) ? this.init.getStartDate() : this.init.getCurrentDate();
            Date bizDate = (Date)this.getModel().getValue("bizdate");
            this.getModel().setValue("bizdate", (Object)(currentDate.after(bizDate) ? currentDate : bizDate));
        }
        Object currencyPk = this.init.getStandardCurrency().getPkValue();
        this.getModel().setValue("currency", currencyPk);
        this.getModel().setValue("basecurrency", currencyPk);
        this.getModel().setValue("confirmrate", (Object)BigDecimal.valueOf(100L));
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("exratetable"))) {
            this.getModel().setValue("exratetable", (Object)this.init.getExrateTable());
        }
        this.getModel().setValue("e_confirmrate", (Object)BigDecimal.valueOf(100L), 0);
        this.getModel().setValue("e_unverifyqty", (Object)BigDecimal.valueOf(1L), 0);
        this.getModel().setValue("e_unverifybaseqty", (Object)BigDecimal.valueOf(1L), 0);
        this.getModel().setValue("e_confirmqty", (Object)BigDecimal.valueOf(1L), 0);
        this.getModel().setValue("e_confirmbaseqty", (Object)BigDecimal.valueOf(1L), 0);
        this.getModel().setValue("e_unrecqty", (Object)BigDecimal.valueOf(1L), 0);
        this.getModel().setValue("e_unrecbaseqty", (Object)BigDecimal.valueOf(1L), 0);
    }

    private void setDefaultValue(IDataModel model, DynamicObject org) {
        if (ObjectUtils.isEmpty((Object)model.getValue("recorg")) && org.getBoolean("fisbankroll")) {
            model.setValue("recorg", (Object)org.getLong("id"));
        }
        if (ObjectUtils.isEmpty((Object)model.getValue("salesorg")) && org.getBoolean("fissale")) {
            model.setValue("salesorg", (Object)org.getLong("id"));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("viewver".equals(key) || "viewver_arrev".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        } else if ("tblwriteoff".equals(key)) {
            DynamicObject revcBill = this.getModel().getDataEntity();
            Object pk = revcBill.getPkValue();
            CheckResult result = RevcfmWriteOffVerify.check((Object[])new Object[]{pk});
            if (!result.isIspass()) {
                this.getView().showErrorNotification(result.getMessage());
            } else {
                this.getView().invokeOperation("writeoff");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int iRow = changeData[0].getRowIndex();
        IDataModel m = this.getModel();
        String billStatus = (String)m.getValue("billstatus");
        if (!this.billStatusCtrlService.isCanChange(billStatus)) {
            return;
        }
        String confirmWay = (String)m.getValue("confirmway");
        switch (key) {
            case "billtype": {
                if (newValue != null) break;
                m.beginInit();
                m.setValue("billtype", oldValue);
                m.endInit();
                this.getView().updateView("billtype");
                return;
            }
            case "currency": {
                int newPrecision;
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"currency", (Object)oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int oldPrecision = ((DynamicObject)oldValue).getInt("amtprecision");
                if (oldPrecision != (newPrecision = ((DynamicObject)newValue).getInt("amtprecision"))) {
                    this.calculateAllRow(m, false);
                }
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "exratetable": {
                if (newValue == null) {
                    m.beginInit();
                    m.setValue("exratetable", oldValue);
                    m.endInit();
                    this.getView().updateView("exratetable");
                    return;
                }
            }
            case "exratedate": {
                if (newValue != null) break;
                m.beginInit();
                m.setValue("exratedate", oldValue);
                m.endInit();
                this.getView().updateView("exratedate");
                return;
            }
            case "exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"RevCfmBillEdit_10", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                BigDecimal amount = (BigDecimal)m.getValue("amount");
                if (amount.compareTo(BigDecimal.ZERO) == 0) break;
                this.calculateLocAmt();
                break;
            }
            case "e_taxrate": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(iRow, this.getModel(), key, BillModelFactory.getModel((String)"ar_revcfmbill"));
                this.calculateRow(m, iRow, key, oldValue, true);
                break;
            }
            case "confirmrate": {
                if ("AMOUNT".equals(confirmWay)) {
                    return;
                }
                this.calculateAllRow(m, false);
                break;
            }
            case "e_material": {
                m.setValue("configuredcode", null, iRow);
                m.setValue("tracknumber", null, iRow);
                m.setValue("e_materialversion", null, iRow);
                m.setValue("e_productline", null, iRow);
                this.entries_materialChanged((DynamicObject)newValue, iRow);
                break;
            }
            case "e_measureunit": {
                this.calculateBaseQty((DynamicObject)newValue, iRow);
                break;
            }
            case "e_discountamount": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(iRow, this.getModel(), key, BillModelFactory.getModel((String)"ar_revcfmbill"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "e_discountmode": {
                m.setValue("e_discountrate", (Object)BigDecimal.ZERO, iRow);
                if ("TOTAL".equals(newValue)) {
                    m.setValue("e_discountamount", (Object)BigDecimal.ZERO, iRow);
                }
                this.calculateRow(m, iRow, key, oldValue, true);
                break;
            }
            case "e_discountrate": {
                String discountmode = (String)m.getValue("e_discountmode", iRow);
                BigDecimal discountrate = (BigDecimal)m.getValue("e_discountrate", iRow);
                if (DiscountModeEnum.PERCENT.getValue().equals(discountmode) && discountrate.compareTo(new BigDecimal(100)) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e0d\u8d85\u8fc7100\u7684\u6570\u5b57\u3002", (String)"RevCfmBillEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    m.setValue("e_discountrate", (Object)BigDecimal.ZERO, iRow);
                    return;
                }
            }
            case "e_quantity": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(iRow, this.getModel(), key, BillModelFactory.getModel((String)"ar_revcfmbill"));
                this.calculateBaseQty((DynamicObject)m.getValue("e_measureunit", iRow), iRow);
            }
            case "e_unitprice": 
            case "e_taxunitprice": {
                boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", iRow);
                if (isPresent) {
                    BigDecimal unitPrice = (BigDecimal)newValue;
                    if (BigDecimal.ZERO.compareTo(unitPrice) == 0) {
                        m.setValue("e_discountmode", (Object)"NULL", iRow);
                    } else {
                        m.setValue("e_discountmode", (Object)"PERCENT", iRow);
                        m.setValue("e_discountrate", (Object)new BigDecimal(100), iRow);
                    }
                }
                this.calculateRow(m, iRow, key, oldValue, true);
                break;
            }
            case "e_confirmqty": {
                this.calculateRow(m, iRow, key, oldValue, false);
                break;
            }
            case "e_confirmamt": {
                this.calculateRow(m, iRow, key, oldValue, false);
                break;
            }
            case "e_cfmpricetax": {
                this.calculateRow(m, iRow, key, oldValue, false);
                break;
            }
            case "e_pricetaxtotal": 
            case "e_amount": {
                this.calculateRow(m, iRow, key, oldValue, true);
                break;
            }
            case "e_ispresent": {
                boolean curIsPresent = (Boolean)newValue;
                boolean isPriceTotal = (Boolean)this.getModel().getValue("ispricetotal");
                BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", iRow);
                if (isPriceTotal) {
                    this.getModel().beginInit();
                    if (curIsPresent && BigDecimal.ZERO.compareTo(unitPrice) != 0) {
                        m.setValue("e_discountmode", (Object)"PERCENT", iRow);
                        m.setValue("e_discountrate", (Object)new BigDecimal(100), iRow);
                    } else {
                        m.setValue("e_discountmode", (Object)"NULL", iRow);
                        this.getModel().setValue("e_discountrate", (Object)BigDecimal.ZERO, iRow);
                        this.getModel().setValue("e_discountamount", (Object)BigDecimal.ZERO, iRow);
                    }
                    this.getModel().endInit();
                    this.calculateRow(m, iRow, key, oldValue, true);
                    this.getView().updateView("entry");
                } else if (curIsPresent && BigDecimal.ZERO.compareTo(unitPrice) != 0) {
                    m.setValue("e_discountmode", (Object)"PERCENT", iRow);
                    m.setValue("e_discountrate", (Object)new BigDecimal(100), iRow);
                } else {
                    m.setValue("e_discountmode", (Object)"NULL", iRow);
                }
                if (curIsPresent) {
                    if (!"AMOUNT".equals(confirmWay)) break;
                    this.getView().setEnable(Boolean.FALSE, iRow, new String[]{"e_confirmamt"});
                    this.getView().setEnable(Boolean.FALSE, iRow, new String[]{"e_cfmpricetax"});
                    break;
                }
                if (!"AMOUNT".equals(confirmWay)) break;
                this.getView().setEnable(Boolean.TRUE, iRow, new String[]{"e_confirmamt"});
                this.getView().setEnable(Boolean.TRUE, iRow, new String[]{"e_cfmpricetax"});
                break;
            }
            case "confirmway": {
                if (!"AMOUNT".equals(confirmWay)) break;
                this.setConfirmAmtEnable();
                break;
            }
            case "e_corebilltype": {
                m.setValue("e_corebillno", null, iRow);
                m.setValue("e_corebillentryseq", null, iRow);
                break;
            }
            case "biztype": {
                DynamicObject oldBizType;
                if (!Objects.equals(newValue, oldValue)) {
                    DynamicObject supplier;
                    oldBizType = (DynamicObject)oldValue;
                    String type = (String)m.getValue("asstacttype");
                    String message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"RevCfmBillEdit_7", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                    if ("bd_supplier".equals(type) && !this.isVmi((DynamicObject)newValue, supplier = (DynamicObject)m.getValue("asstact"))) {
                        message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u5f80\u6765\u6237\u4fe1\u606f\u53ca\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"RevCfmBillEdit_11", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                    }
                    this.getPageCache().put("OLDBIZTYPEID", String.valueOf(oldValue == null ? Long.valueOf(0L) : oldBizType.getPkValue()));
                    this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
                }
                if (Objects.equals(newValue, oldValue)) break;
                oldBizType = (DynamicObject)oldValue;
                this.getPageCache().put("OLDBIZTYPEID", String.valueOf(oldValue == null ? Long.valueOf(0L) : oldBizType.getPkValue()));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"RevCfmBillEdit_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
                break;
            }
            case "bizdate": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"bizdate", (Object)oldValue);
                    return;
                }
                BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)true);
                break;
            }
            case "payproperty": {
                String billsrctype = (String)m.getValue("billsrctype");
                if (BillSrcTypeEnum.VERIFY.getValue().equals(billsrctype)) break;
                DynamicObject payproperty = (DynamicObject)newValue;
                DynamicObject oldpayproperty = (DynamicObject)oldValue;
                if (ObjectUtils.isEmpty((Object)payproperty) || ObjectUtils.isEmpty((Object)oldpayproperty)) {
                    m.setValue("confirmway", (Object)"RATE");
                } else if (payproperty.getBoolean("isbasedonamt") != oldpayproperty.getBoolean("isbasedonamt")) {
                    m.setValue("confirmway", (Object)"RATE");
                }
                FormServiceHelper.paypropertyChanged((IDataModel)m, (String)"entry", (String)"e_quantity");
                this.setConfirmwayComboItem(payproperty);
                break;
            }
            case "asstact": {
                DynamicObjectCollection entrys;
                String asstactType = (String)m.getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)m.getValue("asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    this.clearAssLinkcustomer();
                    return;
                }
                if (!"bd_customer".equals(asstactType)) break;
                this.customersMap = FinArBillHelper.setCustomersToViewCash((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
                if (this.customersMap == null || this.customersMap.size() <= 0 || (entrys = this.getModel().getEntryEntity("entry")) == null || entrys.size() <= 0) break;
                for (int i = 0; i < entrys.size(); ++i) {
                    this.getModel().setValue("e_invoicecustomerid", this.customersMap.get("invoiceCustomerId"), i);
                    this.getModel().setValue("e_delivercustomerid", this.customersMap.get("deliverCustomerId"), i);
                }
                break;
            }
            case "asstacttype": {
                this.setAsstactCaption();
                this.clearAssLinkcustomer();
            }
        }
    }

    private void clearAssLinkcustomer() {
        this.getModel().setValue("paymentcustomerid", null);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (entrys != null && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("e_invoicecustomerid", null, i);
                this.getModel().setValue("e_delivercustomerid", null, i);
            }
        }
    }

    private boolean isVmi(DynamicObject bizType, DynamicObject asstact) {
        boolean isMatch = true;
        if (ObjectUtils.isEmpty((Object)bizType) || ObjectUtils.isEmpty((Object)asstact)) {
            return isMatch;
        }
        String domain = bizType.getString("domain");
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstact.getLong("id"))});
        boolean enableVmi = supplier.getBoolean("enablevmi");
        if (!enableVmi && "6".equals(domain)) {
            isMatch = false;
        }
        return isMatch;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        DynamicObject payproperty;
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int i = e.getRowIndex();
        IDataModel m = this.getModel();
        if ("e_quantity".equals(key)) {
            DynamicObject curPayproperty;
            String discountMode = (String)this.getModel().getValue("e_discountmode", i);
            if ("TOTAL".equals(discountMode) && (value == null || BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u56fa\u5b9a\u6298\u6263\u989d\uff0c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RevCfmBillEdit_9", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("e_quantity", i);
            }
            if ((curPayproperty = (DynamicObject)m.getValue("payproperty")) != null && curPayproperty.getBoolean("isbasedonamt") && (value == null || new BigDecimal(value.toString()).abs().compareTo(BigDecimal.ONE) != 0)) {
                Object oldValue = m.getValue(key, i);
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_quantity", (Object)oldValue, (int)i);
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91d1\u989d\u57fa\u51c6\u4e1a\u52a1\uff0c\u6570\u91cf\u5e94\u4e3a1\u6216-1\u3002", (String)"RevCfmBillEdit_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        } else if ("e_discountmode".equals(key)) {
            BigDecimal quantity = (BigDecimal)this.getModel().getValue("e_quantity", i);
            if ("TOTAL".equals(value) && BigDecimal.ZERO.compareTo(quantity) == 0) {
                e.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6570\u91cf\u3002", (String)"RevCfmBillEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        } else if ("confirmrate".equals(key)) {
            BigDecimal confirmrate;
            DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
            if ("ar_revcfmbill_borrowar_BT_S".equals(billtype.getString("number"))) {
                return;
            }
            BigDecimal bigDecimal = confirmrate = EmptyUtils.isEmpty((Object)value) ? BigDecimal.ZERO : new BigDecimal(value.toString());
            if (confirmrate.abs().compareTo(new BigDecimal(100)) > 0) {
                Object oldValue = m.getValue(key, i);
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"confirmrate", (Object)oldValue);
                e.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u5934\u7684\u6536\u5165\u786e\u8ba4\u6bd4\u4f8b(%)\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e-100\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"RevCfmBillEdit_21", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        } else if ("e_confirmqty".equals(key)) {
            BigDecimal confirmqty;
            if (ObjectUtils.isEmpty((Object)value)) {
                return;
            }
            BigDecimal e_quantity = (BigDecimal)this.getModel().getValue("e_quantity", i);
            if (e_quantity.multiply(confirmqty = new BigDecimal(value.toString())).compareTo(BigDecimal.ZERO) < 0 || e_quantity.abs().compareTo(confirmqty.abs()) < 0) {
                Object oldValue = m.getValue(key, i);
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_confirmqty", (Object)oldValue, (int)i);
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7684\u786e\u8ba4\u6570\u91cf\u987b\u4e0e\u6570\u91cf\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u8d85\u8fc7\u6570\u91cf\u3002", (String)"RevCfmBillEdit_14", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        } else if ("e_confirmamt".equals(key)) {
            BigDecimal confirmamt;
            if (ObjectUtils.isEmpty((Object)value)) {
                return;
            }
            BigDecimal amount = (BigDecimal)m.getValue("e_amount", i);
            if (amount.multiply(confirmamt = new BigDecimal(value.toString())).compareTo(BigDecimal.ZERO) < 0 || amount.abs().compareTo(confirmamt.abs()) < 0) {
                Object oldValue = m.getValue(key, i);
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_confirmamt", (Object)oldValue, (int)i);
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7684\u786e\u8ba4\u91d1\u989d\u987b\u4e0e\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u8d85\u8fc7\u91d1\u989d\u3002", (String)"RevCfmBillEdit_19", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        } else if ("e_cfmpricetax".equals(key)) {
            BigDecimal cfmpricetax;
            if (ObjectUtils.isEmpty((Object)value)) {
                return;
            }
            BigDecimal pricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", i);
            if (pricetaxtotal.multiply(cfmpricetax = new BigDecimal(value.toString())).compareTo(BigDecimal.ZERO) < 0 || pricetaxtotal.abs().compareTo(cfmpricetax.abs()) < 0) {
                Object oldValue = m.getValue(key, i);
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_cfmpricetax", (Object)oldValue, (int)i);
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u7684\u786e\u8ba4\u4ef7\u7a0e\u5408\u8ba1\u987b\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u8d85\u8fc7\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"RevCfmBillEdit_20", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        } else if ("confirmway".equals(key) && ObjectUtils.isEmpty((Object)(payproperty = (DynamicObject)this.getModel().getValue("payproperty")))) {
            Object oldValue = m.getValue(key, i);
            FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"confirmway", (Object)oldValue);
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6b3e\u9879\u6027\u8d28\u3002", (String)"RevCfmBillEdit_13", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String key = args.getOperateKey();
        if ("newentry".equals(key)) {
            BigDecimal confirmRate = (BigDecimal)this.getModel().getValue("confirmrate");
            int entryRowCount = this.getModel().getEntryRowCount("entry");
            BigDecimal quantity = (BigDecimal)this.getModel().getValue("e_quantity");
            this.getModel().setValue("e_confirmrate", (Object)confirmRate, entryRowCount - 1);
            this.getModel().setValue("e_unverifyqty", (Object)quantity.multiply(confirmRate).divide(BigDecimal.valueOf(100L)), entryRowCount - 1);
            this.getModel().beginInit();
            this.getModel().setValue("e_confirmqty", (Object)quantity.multiply(confirmRate).divide(BigDecimal.valueOf(100L)), entryRowCount - 1);
            this.getModel().endInit();
        }
        if ("getinventorycost".equals(args.getOperateKey())) {
            this.getView().updateView();
        }
        if ((Objects.equals(key, "unaudit") || Objects.equals(key, "audit")) && operationResult != null && operationResult.isSuccess()) {
            this.getView().getFormShowParameter().getCustomParams().remove("iscopy");
            this.getView().invokeOperation("refresh");
        }
        if ("unsubmit".equals(key)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
        }
        if ("submit".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
        if ("save".equals(key)) {
            this.setConfirmAmtEnable();
            boolean iswrittenoff = (Boolean)this.getModel().getValue("iswrittenoff");
            if (iswrittenoff && operationResult != null && operationResult.isSuccess() && "C".equals(this.getModel().getValue("billstatus"))) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.init = new InitHelper(org.getLong("id"), "ar_init");
            this.getModel().setValue("basecurrency", this.init.getStandardCurrency().getPkValue());
        }
        BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)true);
        this.calculateAllRow(this.getModel(), true);
        this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("e_corebillno".equals(key)) {
            this.corebillShowF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("coreBill".equals(actionId)) {
            ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
        }
        if ("getinventorycost".equals(actionId) && returnData != null) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("fromBack", "false");
            this.getView().invokeOperation("getinventorycost", option);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("biztype".equals(messageBoxClosedEvent.getCallBackId())) {
            String biztypeId;
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String type = (String)this.getModel().getValue("asstacttype");
                if ("bd_supplier".equals(type)) {
                    DynamicObject supplier = (DynamicObject)this.getModel().getValue("asstact");
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (!this.isVmi(bizType, supplier)) {
                        this.getModel().setValue("asstact", null);
                    }
                }
                this.clearEntry();
                this.calculateAllRow(this.getModel(), true);
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel && StringUtils.isNotEmpty((CharSequence)(biztypeId = this.getPageCache().get("OLDBIZTYPEID")))) {
                this.getModel().beginInit();
                this.getModel().setValue("biztype", (Object)Long.parseLong(biztypeId));
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
            this.getPageCache().remove("OLDBIZTYPEID");
        }
        String callBackID = messageBoxClosedEvent.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, messageBoxClosedEvent.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = messageBoxClosedEvent.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ar_revcfmbill", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("entry");
        this.getModel().createNewEntryRow("entry");
    }

    private void corebillShowF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("entry");
        String coreBillType = (String)this.getModel().getValue("e_corebilltype", currrow);
        ArApCorebillHelper.showCoreBillF7((String)coreBillType, (IFormView)this.getView(), (String)this.getPluginName());
    }

    private void calculateAllRow(IDataModel m, boolean isCalculatorAmtField) {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal confirmAmt = BigDecimal.ZERO;
        BigDecimal confirmLocAmt = BigDecimal.ZERO;
        int entryRowCount = m.getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            PriceLocalCalculator localCalculator = this.buildCalculator(m, i);
            this.setRowValue(m, i, isCalculatorAmtField, localCalculator);
            amount = amount.add((BigDecimal)m.getValue("e_amount", i));
            localAmt = localAmt.add((BigDecimal)m.getValue("e_localamt", i));
            tax = tax.add((BigDecimal)m.getValue("e_tax", i));
            taxlocamt = taxlocamt.add((BigDecimal)m.getValue("e_taxlocalamt", i));
            pricetaxtotal = pricetaxtotal.add((BigDecimal)m.getValue("e_pricetaxtotal", i));
            pricetaxtotalbase = pricetaxtotalbase.add((BigDecimal)m.getValue("e_pricetaxtotalbase", i));
            confirmAmt = confirmAmt.add((BigDecimal)m.getValue("e_confirmamt", i));
            confirmLocAmt = confirmLocAmt.add((BigDecimal)m.getValue("e_confirmlocamt", i));
        }
        m.setValue("amount", (Object)amount);
        m.setValue("localamt", (Object)localAmt);
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxlocamt);
        m.setValue("pricetaxtotal", (Object)pricetaxtotal);
        m.setValue("pricetaxtotalbase", (Object)pricetaxtotalbase);
        m.setValue("confirmamt", (Object)confirmAmt);
        m.setValue("confirmlocamt", (Object)confirmLocAmt);
        m.setValue("unverifyamt", (Object)confirmAmt);
        if (entryRowCount == 0) {
            m.setValue("confirmrate", (Object)BigDecimal.ZERO);
        }
    }

    private void calculateRow(IDataModel m, int index, String changeKey, Object oldValue, boolean isCalculatorAmtField) {
        BigDecimal oldEntryConfirmLocAmt;
        BigDecimal oldEntryAmount = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_amount", index);
        BigDecimal oldEntryAmountLocal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_localamt", index);
        BigDecimal oldEntryTax = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_tax", index);
        BigDecimal oldEntryTaxLocal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_taxlocalamt", index);
        BigDecimal oldEntryPriceTaxTotal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_pricetaxtotal", index);
        BigDecimal oldEntryPriceTaxTotalLocal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_pricetaxtotalbase", index);
        BigDecimal oldEntryConfirmAmt = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_confirmamt", index);
        BigDecimal bigDecimal = oldEntryConfirmLocAmt = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_confirmlocamt", index);
        if ("e_amount".equals(changeKey)) {
            oldEntryAmount = (BigDecimal)oldValue;
        }
        if ("e_pricetaxtotal".equals(changeKey)) {
            oldEntryPriceTaxTotal = (BigDecimal)oldValue;
        }
        if ("e_confirmamt".equals(changeKey)) {
            oldEntryConfirmAmt = (BigDecimal)oldValue;
        }
        PriceLocalCalculator localCalculator = this.buildCalculator(m, index, changeKey);
        this.setRowValue(m, index, isCalculatorAmtField, localCalculator);
        BigDecimal amount = ((BigDecimal)m.getValue("amount")).subtract(oldEntryAmount).add((BigDecimal)m.getValue("e_amount", index));
        m.setValue("amount", (Object)amount);
        m.setValue("localamt", (Object)((BigDecimal)m.getValue("localamt")).subtract(oldEntryAmountLocal).add((BigDecimal)m.getValue("e_localamt", index)));
        m.setValue("tax", (Object)((BigDecimal)m.getValue("tax")).subtract(oldEntryTax).add((BigDecimal)m.getValue("e_tax", index)));
        m.setValue("taxlocamt", (Object)((BigDecimal)m.getValue("taxlocamt")).subtract(oldEntryTaxLocal).add((BigDecimal)m.getValue("e_taxlocalamt", index)));
        m.setValue("pricetaxtotal", (Object)((BigDecimal)m.getValue("pricetaxtotal")).subtract(oldEntryPriceTaxTotal).add((BigDecimal)m.getValue("e_pricetaxtotal", index)));
        m.setValue("pricetaxtotalbase", (Object)((BigDecimal)m.getValue("pricetaxtotalbase")).subtract(oldEntryPriceTaxTotalLocal).add((BigDecimal)m.getValue("e_pricetaxtotalbase", index)));
        BigDecimal confirmamt = ((BigDecimal)m.getValue("confirmamt")).subtract(oldEntryConfirmAmt).add((BigDecimal)m.getValue("e_confirmamt", index));
        m.setValue("confirmamt", (Object)confirmamt);
        m.setValue("confirmlocamt", (Object)((BigDecimal)m.getValue("confirmlocamt")).subtract(oldEntryConfirmLocAmt).add((BigDecimal)m.getValue("e_confirmlocamt", index)));
        m.setValue("unverifyamt", (Object)confirmamt);
        String confirmWay = (String)m.getValue("confirmway");
        if ("AMOUNT".equals(confirmWay) || "QUANTITY".equals(confirmWay)) {
            BigDecimal confirmRate = amount.compareTo(BigDecimal.ZERO) != 0 ? confirmamt.multiply(BigDecimal.valueOf(100L)).divide(amount, 2, 4) : BigDecimal.valueOf(100L);
            m.beginInit();
            m.setValue("confirmrate", (Object)confirmRate);
            m.endInit();
            this.getView().updateView("confirmrate");
        }
    }

    private PriceLocalCalculator buildCalculator(IDataModel m, int index) {
        return this.buildCalculator(m, index, null);
    }

    private PriceLocalCalculator buildCalculator(IDataModel m, int index, String changeKey) {
        BigDecimal unitPrice;
        BigDecimal taxUnitPrice;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        boolean isPriceTotal = (Boolean)m.getValue("ispricetotal");
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
        BigDecimal discountAmt = (BigDecimal)m.getValue("e_discountamount", index);
        boolean ispresent = (Boolean)m.getValue("e_ispresent", index);
        boolean existProperty = EntityMetadataUtils.isExistProperty((DynamicObject)m.getDataEntity(), (String)"adjustamount");
        BigDecimal adjustamount = BigDecimal.ZERO;
        if (existProperty) {
            adjustamount = (BigDecimal)m.getValue("e_adjustamount", index);
        }
        int precision = 2;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        int localPrecision = this.getLocalPrecision();
        TaxUnitPriceCalculator calculator = null;
        if ("e_ispresent".equals(changeKey)) {
            if (includeTax) {
                taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            } else {
                unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
                calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            }
        } else if (includeTax) {
            if (isPriceTotal && !ispresent) {
                BigDecimal recamount = (BigDecimal)m.getValue("e_pricetaxtotal", index);
                calculator = new PriceTaxTotalCalculator(qty, recamount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            } else {
                taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            }
        } else if (isPriceTotal && !ispresent) {
            BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        } else {
            unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        }
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, localPrecision, quotation);
        localCalculator.calculate();
        return localCalculator;
    }

    private void setRowValue(IDataModel m, int index, boolean isCalculatorAmtField, PriceLocalCalculator localCalculator) {
        BigDecimal confirmQty;
        BigDecimal confirmRate;
        BigDecimal confirmLocAmt;
        BigDecimal confirmLocTax;
        BigDecimal confirmLocPriceTaxTotal;
        BigDecimal confirmAmt;
        BigDecimal confirmTax;
        BigDecimal confirmPriceTaxTotal;
        if (isCalculatorAmtField) {
            m.beginInit();
            m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
            m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
            m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
            m.setValue("e_amount", (Object)localCalculator.getAmount(), index);
            m.setValue("e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal(), index);
            m.endInit();
            this.getView().updateView("e_unitprice", index);
            this.getView().updateView("e_taxunitprice", index);
            this.getView().updateView("e_amount", index);
            this.getView().updateView("e_pricetaxtotal", index);
            this.getView().updateView("e_discountamount", index);
            m.setValue("e_tax", (Object)localCalculator.getTax(), index);
            m.setValue("e_taxlocalamt", (Object)localCalculator.getTaxlocal(), index);
            m.setValue("e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal(), index);
            m.setValue("e_actunitprice", (Object)localCalculator.getActunitprice(), index);
            m.setValue("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice(), index);
            m.setValue("e_localamt", (Object)localCalculator.getAmountlocal(), index);
        }
        BigDecimal rate = (BigDecimal)this.getModel().getValue("exchangerate");
        String quotation = (String)this.getModel().getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        String confirmWay = (String)m.getValue("confirmway");
        DynamicObject payproperty = (DynamicObject)m.getValue("payproperty");
        boolean isBaseonAmt = payproperty != null && payproperty.getBoolean("isbasedonamt");
        BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
        BigDecimal pricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
        BigDecimal actunitprice = (BigDecimal)m.getValue("e_actunitprice", index);
        BigDecimal acttaxunitprice = (BigDecimal)m.getValue("e_acttaxunitprice", index);
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        BigDecimal taxrate = ((BigDecimal)m.getValue("e_taxrate", index)).divide(new BigDecimal("100"));
        int precision = this.getPrecision();
        int localCurrencyPrecison = this.getLocalPrecision();
        if ("AMOUNT".equals(confirmWay)) {
            boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", index);
            if (includeTax) {
                confirmPriceTaxTotal = (BigDecimal)m.getValue("e_cfmpricetax", index);
                if (pricetaxtotal.signum() != confirmPriceTaxTotal.signum() || confirmPriceTaxTotal.abs().compareTo(pricetaxtotal.abs()) > 0) {
                    confirmPriceTaxTotal = pricetaxtotal;
                }
                confirmTax = confirmPriceTaxTotal.multiply(taxrate).divide(BigDecimal.ONE.add(taxrate), precision, RoundingMode.HALF_UP);
                confirmAmt = confirmPriceTaxTotal.subtract(confirmTax);
                confirmLocPriceTaxTotal = this.getLocalAmt(confirmPriceTaxTotal, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocAmt = confirmLocPriceTaxTotal.subtract(confirmLocTax);
            } else {
                confirmAmt = (BigDecimal)m.getValue("e_confirmamt", index);
                if (amount.signum() != confirmAmt.signum() || confirmAmt.abs().compareTo(amount.abs()) > 0) {
                    confirmAmt = amount;
                }
                confirmTax = confirmAmt.multiply(taxrate).setScale(precision, RoundingMode.HALF_UP);
                confirmPriceTaxTotal = confirmAmt.add(confirmTax);
                confirmLocAmt = this.getLocalAmt(confirmAmt, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocPriceTaxTotal = confirmLocAmt.add(confirmLocTax);
            }
            confirmRate = isPresent ? BigDecimal.valueOf(100L) : (amount.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal(100) : confirmAmt.multiply(BigDecimal.valueOf(100L)).divide(amount, 2, 4));
            confirmQty = quantity.multiply(confirmRate).divide(BigDecimal.valueOf(100L));
            if (isBaseonAmt) {
                confirmQty = quantity;
            }
        } else if ("QUANTITY".equals(confirmWay)) {
            confirmQty = (BigDecimal)m.getValue("e_confirmqty", index);
            if (quantity.signum() != confirmQty.signum() || confirmQty.abs().compareTo(quantity.abs()) > 0) {
                confirmQty = quantity;
            }
            if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                confirmRate = new BigDecimal(100);
                confirmQty = BigDecimal.ZERO;
            } else {
                confirmRate = confirmQty.multiply(BigDecimal.valueOf(100L)).divide(quantity, 2, 4);
            }
            if (includeTax) {
                confirmPriceTaxTotal = confirmQty.multiply(acttaxunitprice).setScale(precision, RoundingMode.HALF_UP);
                confirmTax = confirmPriceTaxTotal.multiply(taxrate).divide(BigDecimal.ONE.add(taxrate), precision, RoundingMode.HALF_UP);
                confirmAmt = confirmPriceTaxTotal.subtract(confirmTax);
                confirmLocPriceTaxTotal = this.getLocalAmt(confirmPriceTaxTotal, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocAmt = confirmLocPriceTaxTotal.subtract(confirmLocTax);
            } else {
                confirmAmt = confirmQty.multiply(actunitprice).setScale(precision, RoundingMode.HALF_UP);
                confirmTax = confirmAmt.multiply(taxrate).setScale(precision, RoundingMode.HALF_UP);
                confirmPriceTaxTotal = confirmAmt.add(confirmTax);
                confirmLocAmt = this.getLocalAmt(confirmAmt, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocPriceTaxTotal = confirmLocAmt.add(confirmLocTax);
            }
        } else {
            confirmRate = (BigDecimal)m.getValue("confirmrate");
            BigDecimal cfmRate = confirmRate.divide(new BigDecimal("100"));
            DynamicObject measureUnit = (DynamicObject)m.getValue("e_measureunit", index);
            BigDecimal bigDecimal = confirmQty = isBaseonAmt ? quantity : quantity.multiply(cfmRate).setScale(UnitConvertHelper.getPrecision((DynamicObject)measureUnit), UnitConvertHelper.getPrecisionType((DynamicObject)measureUnit));
            if (includeTax) {
                confirmPriceTaxTotal = isBaseonAmt || quantity.compareTo(BigDecimal.ZERO) == 0 ? pricetaxtotal.multiply(cfmRate).setScale(precision, RoundingMode.HALF_UP) : confirmQty.multiply(acttaxunitprice).setScale(precision, RoundingMode.HALF_UP);
                confirmTax = confirmPriceTaxTotal.multiply(taxrate).divide(BigDecimal.ONE.add(taxrate), precision, RoundingMode.HALF_UP);
                confirmAmt = confirmPriceTaxTotal.subtract(confirmTax);
                confirmLocPriceTaxTotal = this.getLocalAmt(confirmPriceTaxTotal, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocAmt = confirmLocPriceTaxTotal.subtract(confirmLocTax);
            } else {
                confirmAmt = isBaseonAmt || quantity.compareTo(BigDecimal.ZERO) == 0 ? amount.multiply(cfmRate).setScale(precision, RoundingMode.HALF_UP) : confirmQty.multiply(actunitprice).setScale(precision, RoundingMode.HALF_UP);
                confirmTax = confirmAmt.multiply(taxrate).setScale(precision, RoundingMode.HALF_UP);
                confirmPriceTaxTotal = confirmAmt.add(confirmTax);
                confirmLocAmt = this.getLocalAmt(confirmAmt, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocPriceTaxTotal = confirmLocAmt.add(confirmLocTax);
            }
        }
        m.beginInit();
        m.setValue("e_confirmqty", (Object)confirmQty, index);
        m.setValue("e_confirmrate", (Object)confirmRate, index);
        m.setValue("e_confirmamt", (Object)confirmAmt, index);
        m.setValue("e_cfmpricetax", (Object)confirmPriceTaxTotal, index);
        m.endInit();
        this.getView().updateView("e_confirmrate", index);
        this.getView().updateView("e_confirmamt", index);
        this.getView().updateView("e_confirmqty", index);
        this.getView().updateView("e_cfmpricetax", index);
        m.setValue("e_confirmtax", (Object)confirmTax, index);
        m.setValue("e_confirmlocamt", (Object)confirmLocAmt, index);
        m.setValue("e_confirmloctax", (Object)confirmLocTax, index);
        m.setValue("e_cfmpricetaxbase", (Object)confirmLocPriceTaxTotal, index);
        m.setValue("e_unverifyamt", (Object)confirmAmt, index);
        m.setValue("e_unverifyqty", (Object)confirmQty, index);
        DynamicObject baseunit = (DynamicObject)m.getValue("e_baseunitid", index);
        BigDecimal unitcoefficient = (BigDecimal)m.getValue("e_unitcoefficient", index);
        BigDecimal confirmBaseQty = UnitConvertHelper.getBaseunitqty((BigDecimal)confirmQty, (BigDecimal)unitcoefficient, (DynamicObject)baseunit);
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if ("ar_finarbill".equals(sourceBillType)) {
            m.setValue("e_unrecqty", (Object)BigDecimal.ZERO, index);
            m.setValue("e_unrecbaseqty", (Object)BigDecimal.ZERO, index);
            m.setValue("e_recqty", (Object)confirmQty, index);
            m.setValue("e_recbaseqty", (Object)confirmBaseQty, index);
            m.setValue("e_unrecamt", (Object)BigDecimal.ZERO, index);
            m.setValue("e_recamt", (Object)confirmAmt, index);
        } else {
            m.setValue("e_unrecqty", (Object)confirmQty, index);
            m.setValue("e_unrecbaseqty", (Object)confirmBaseQty, index);
            m.setValue("e_recqty", (Object)BigDecimal.ZERO, index);
            m.setValue("e_recbaseqty", (Object)BigDecimal.ZERO, index);
            m.setValue("e_unrecamt", (Object)confirmAmt, index);
            m.setValue("e_recamt", (Object)BigDecimal.ZERO, index);
        }
        m.setValue("e_confirmbaseqty", (Object)confirmBaseQty, index);
        m.setValue("e_unverifybaseqty", (Object)confirmBaseQty, index);
    }

    private void calculateBaseQty(DynamicObject measureUnit, int iRow) {
        if (measureUnit == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("e_material", iRow);
        if (material == null) {
            return;
        }
        BillModel billModel = BillModelFactory.getModel((String)"ar_revcfmbill");
        DynamicObject baseUnit = (DynamicObject)model.getValue(billModel.E_BASEUNIT, iRow);
        if (baseUnit == null) {
            baseUnit = material.getDynamicObject("baseunit");
            model.setValue(billModel.E_BASEUNIT, (Object)material.getLong("baseunit.id"), iRow);
        }
        BigDecimal convertRate = null;
        if (baseUnit != null) {
            long baseUnitID = (Long)baseUnit.getPkValue();
            long measureUnitID = (Long)measureUnit.getPkValue();
            long materialID = (Long)material.getPkValue();
            convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
        }
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", iRow);
        if (convertRate != null) {
            model.setValue("e_unitcoefficient", convertRate, iRow);
            if (quantity != null) {
                model.setValue("e_baseunitqty", (Object)convertRate.multiply(quantity), iRow);
                model.setValue("e_unverifybaseqty", (Object)convertRate.multiply((BigDecimal)model.getValue("e_unverifyqty", iRow)), iRow);
                model.setValue("e_unrecbaseqty", (Object)convertRate.multiply((BigDecimal)model.getValue("e_unverifyqty", iRow)), iRow);
                model.setValue("e_confirmbaseqty", (Object)convertRate.multiply((BigDecimal)model.getValue("e_confirmqty", iRow)), iRow);
            }
        }
    }

    private void calculateLocAmt() {
        IDataModel m = this.getModel();
        BigDecimal rate = (BigDecimal)this.getModel().getValue("exchangerate");
        String quotation = (String)this.getModel().getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        BigDecimal locAmt = BigDecimal.ZERO;
        BigDecimal locTax = BigDecimal.ZERO;
        BigDecimal locPriceTaxTotal = BigDecimal.ZERO;
        BigDecimal confirmLocAmt = BigDecimal.ZERO;
        int count = this.getModel().getEntryRowCount("entry");
        int localCurrencyPrecison = this.getLocalPrecision();
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        for (int i = 0; i < count; ++i) {
            BigDecimal e_confirmlocamt;
            BigDecimal e_confirmloctax;
            BigDecimal e_cfmpricetaxbase;
            BigDecimal e_localamt;
            BigDecimal e_taxlocalamt;
            BigDecimal e_pricetaxtotalbase;
            DynamicObject row = this.getModel().getEntryRowEntity("entry", i);
            BigDecimal e_amount = row.getBigDecimal("e_amount");
            BigDecimal e_tax = row.getBigDecimal("e_tax");
            BigDecimal e_pricetaxtotal = row.getBigDecimal("e_pricetaxtotal");
            BigDecimal e_confirmamt = row.getBigDecimal("e_confirmamt");
            BigDecimal e_confirmtax = row.getBigDecimal("e_confirmtax");
            BigDecimal e_cfmpricetax = row.getBigDecimal("e_cfmpricetax");
            if (includeTax) {
                e_pricetaxtotalbase = this.getLocalAmt(e_pricetaxtotal, quotation, rate, localCurrencyPrecison);
                e_taxlocalamt = this.getLocalAmt(e_tax, quotation, rate, localCurrencyPrecison);
                e_localamt = e_pricetaxtotalbase.subtract(e_taxlocalamt);
                e_cfmpricetaxbase = this.getLocalAmt(e_cfmpricetax, quotation, rate, localCurrencyPrecison);
                e_confirmloctax = this.getLocalAmt(e_confirmtax, quotation, rate, localCurrencyPrecison);
                e_confirmlocamt = e_cfmpricetaxbase.subtract(e_confirmloctax);
            } else {
                e_localamt = this.getLocalAmt(e_amount, quotation, rate, localCurrencyPrecison);
                e_taxlocalamt = this.getLocalAmt(e_tax, quotation, rate, localCurrencyPrecison);
                e_pricetaxtotalbase = e_localamt.add(e_taxlocalamt);
                e_confirmlocamt = this.getLocalAmt(e_confirmamt, quotation, rate, localCurrencyPrecison);
                e_confirmloctax = this.getLocalAmt(e_confirmtax, quotation, rate, localCurrencyPrecison);
                e_cfmpricetaxbase = e_confirmlocamt.add(e_confirmloctax);
            }
            locAmt = locAmt.add(e_localamt);
            locTax = locTax.add(e_taxlocalamt);
            locPriceTaxTotal = locPriceTaxTotal.add(e_pricetaxtotalbase);
            confirmLocAmt = confirmLocAmt.add(e_confirmlocamt);
            m.setValue("e_localamt", (Object)e_localamt, i);
            m.setValue("e_taxlocalamt", (Object)e_taxlocalamt, i);
            m.setValue("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase, i);
            m.setValue("e_confirmlocamt", (Object)e_confirmlocamt, i);
            m.setValue("e_confirmloctax", (Object)e_confirmloctax, i);
            m.setValue("e_cfmpricetaxbase", (Object)e_cfmpricetaxbase, i);
        }
        m.setValue("localamt", (Object)locAmt);
        m.setValue("taxlocamt", (Object)locTax);
        m.setValue("pricetaxtotalbase", (Object)locPriceTaxTotal);
        m.setValue("confirmlocamt", (Object)confirmLocAmt);
    }

    protected int getPrecision() {
        int precision = 2;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }

    protected int getLocalPrecision() {
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        return localPrecision;
    }

    private void entries_materialChanged(DynamicObject material, int iRow) {
        if (!ObjectUtils.isEmpty((Object)material)) {
            if (!ObjectUtils.isEmpty((Object)material.getDynamicObject("baseunit"))) {
                BillModel billModel = BillModelFactory.getModel((String)"ar_revcfmbill");
                this.getModel().setValue(billModel.E_BASEUNIT, material.getDynamicObject("baseunit").getPkValue(), iRow);
                this.getModel().setValue("e_measureunit", material.getDynamicObject("baseunit").getPkValue(), iRow);
            }
            this.getModel().setValue("e_baseunitqty", this.getModel().getValue("e_quantity", iRow), iRow);
            DynamicObject productline = material.getDynamicObject("productline");
            if (productline != null) {
                this.getModel().setValue("e_productline", productline.getPkValue(), iRow);
            }
        }
    }

    private void confirmAmtChangedByAmount(int rowCount, BigDecimal newRowAmount, BigDecimal oldRowAmount) {
        BigDecimal confirmRate = (BigDecimal)this.getModel().getValue("e_confirmrate", rowCount);
        BigDecimal confirmAmt = newRowAmount.multiply(confirmRate).divide(new BigDecimal(100));
        this.getModel().setValue("e_confirmamt", (Object)confirmAmt, rowCount);
        this.getModel().setValue("e_unverifyamt", (Object)confirmAmt, rowCount);
    }

    private void setMinBizdate() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        InitHelper init = new InitHelper(org.getLong("id"), "ar_init");
        Date currentDate = init.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = init.getStartDate();
        }
        if (currentDate == null) {
            return;
        }
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMinDate(currentDate);
    }

    private void setConfirmAmtEnable() {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        String confirmWay = (String)this.getModel().getValue("confirmway");
        for (int i = 0; i < entryRowCount; ++i) {
            boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", i);
            if (!isPresent || !"AMOUNT".equals(confirmWay)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_confirmamt"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_cfmpricetax"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map variables;
        String fromBack;
        String inventoryCostWeakCheck;
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (Objects.equals("copyentryrow", key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u590d\u5236\u3002", (String)"RevCfmBillEdit_6", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
        }
        if ("getinventorycost".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
        if ("save".equals(key)) {
            Date srcLatestDate = BookDateHelper.getSrcLatestDate((IDataModel)this.getModel());
            Date bookDate = (Date)this.getModel().getValue("bookdate");
            if (srcLatestDate != null && bookDate != null && bookDate.before(srcLatestDate)) {
                this.getModel().setValue("bookdate", (Object)srcLatestDate);
            }
        }
        if ("getinventorycost".equals(key) && "true".equals(inventoryCostWeakCheck = StdConfig.get((String)"inventoryCostWeakCheck")) && !"false".equals(fromBack = (String)(variables = ((AbstractOperate)args.getSource()).getOption().getVariables()).get("fromBack"))) {
            Long billId;
            Map costResult;
            boolean hadCostRecord;
            boolean voucher = (Boolean)this.getModel().getValue("isvoucher");
            boolean hadWrittenOff = (Boolean)this.getModel().getValue("hadwrittenoff");
            boolean isWrittenOff = (Boolean)this.getModel().getValue("iswrittenoff");
            String verifyStatus = (String)this.getModel().getValue("verifystatus");
            if (!(voucher || hadWrittenOff || isWrittenOff || !"verified".equals(verifyStatus) || (hadCostRecord = ((Boolean)(costResult = VerifyServiceHelper.revInventoryCostResult(Collections.singletonList(billId = (Long)this.getModel().getValue("id")))).get(billId)).booleanValue()))) {
                args.setCancel(true);
                ArrayList<String> reasons = new ArrayList<String>(8);
                reasons.add(String.valueOf(ResManager.loadKDString((String)"1.\u7269\u6599\u51fa\u5e93\u7684\u4ed3\u5e93\u201c\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u201d\u5173\u95ed\uff1b", (String)"RevCfmBillEdit_23", (String)"fi-ar-formplugin", (Object[])new Object[0])));
                reasons.add(String.valueOf(ResManager.loadKDString((String)"2.\u7269\u6599\u51fa\u5e93\u7684\u4ed3\u5e93\u201c\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u201d\u6253\u5f00 \u4f46\u662f \u672a\u8fdb\u884c\u51fa\u5e93\u6838\u7b97\uff1b", (String)"RevCfmBillEdit_24", (String)"fi-ar-formplugin", (Object[])new Object[0])));
                reasons.add(String.valueOf(ResManager.loadKDString((String)"3.\u7269\u6599\u51fa\u5e93\u7684\u4ed3\u5e93\u201c\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u201d\u6253\u5f00 \u4f46\u662f \u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6838\u9500\u62c6\u5355\u672a\u5b8c\u6210\u3002", (String)"RevCfmBillEdit_25", (String)"fi-ar-formplugin", (Object[])new Object[0])));
                OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.getView(), (IFormPlugin)this);
                String title = String.valueOf(ResManager.loadKDString((String)"\u5b58\u5728\u83b7\u53d6\u4e0d\u5230\u6210\u672c\u7684\u660e\u7ec6\u884c\u3002\u53ef\u80fd\u7684\u539f\u56e0\uff1a", (String)"RevCfmBillEdit_22", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                operationConfirmHelper.openOperateConfirmByActionId(title, "", reasons, false, key);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int index;
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        if (this.isCopyEntryRow && "entry".equals(entryProp.getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                index = row.getRowIndex();
                this.calculateRow(this.getModel(), index, "", BigDecimal.ZERO, true);
            }
        }
        if (!this.isCopyEntryRow && "entry".equals(entryProp.getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                index = row.getRowIndex();
                this.calculateRow(this.getModel(), index, "", BigDecimal.ZERO, true);
            }
            if (this.customersMap == null || this.customersMap.size() == 0) {
                this.customersMap = FinArBillHelper.setCustomersToViewCash((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
            }
            Object invoiceCustomerId = this.customersMap.get("invoiceCustomerId");
            Object deliverCustomerId = this.customersMap.get("deliverCustomerId");
            for (RowDataEntity row : e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                if (EmptyUtils.isNotEmpty((Object)invoiceCustomerId) && !"0".equals(invoiceCustomerId)) {
                    this.getModel().setValue("e_invoicecustomerid", invoiceCustomerId, rowIndex);
                }
                if (!EmptyUtils.isNotEmpty((Object)deliverCustomerId) || "0".equals(deliverCustomerId)) continue;
                this.getModel().setValue("e_delivercustomerid", deliverCustomerId, rowIndex);
            }
        }
    }

    private void fillToolBar() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit", "bar_audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unaudit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit", "bar_audit"});
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_audit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_unaudit"});
        }
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if (EmptyUtils.isNotEmpty((Object)sourceBillType) && "ar_revcfmbill_borrowar_BT_S".equals(billtype.getString("number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_copy"});
        }
    }

    private void taxratefilter() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        BasedataEdit taxrateF7 = (BasedataEdit)this.getControl("taxrateid");
        BaseDataHelper.taxratefilter((Date)bizdate, (BasedataEdit)taxrateF7);
    }

    private void setConfirmwayComboItem(DynamicObject payproperty) {
        ArrayList<ComboItem> newComboItem = new ArrayList<ComboItem>(3);
        ComboEdit billtypeCbo = (ComboEdit)this.getView().getControl("confirmway");
        newComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u6bd4\u4f8b", (String)"RevCfmBillEdit_16", (String)"fi-ar-formplugin", (Object[])new Object[0])), "RATE"));
        if (payproperty == null) {
            newComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u91d1\u989d", (String)"RevCfmBillEdit_15", (String)"fi-ar-formplugin", (Object[])new Object[0])), "AMOUNT"));
            newComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u6570\u91cf", (String)"RevCfmBillEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0])), "QUANTITY"));
        } else {
            boolean isBaseonAmt = payproperty.getBoolean("isbasedonamt");
            if (isBaseonAmt) {
                newComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u91d1\u989d", (String)"RevCfmBillEdit_15", (String)"fi-ar-formplugin", (Object[])new Object[0])), "AMOUNT"));
            } else {
                newComboItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u6570\u91cf", (String)"RevCfmBillEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0])), "QUANTITY"));
            }
        }
        billtypeCbo.setComboItems(newComboItem);
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }
}

