/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.ar.formplugin.ArAbstractImport;
import kd.fi.ar.formplugin.RevCfmBillImportCheck;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.impt.BillImportPlugin;
import kd.fi.arapcommon.util.StringUtils;

public class RevCfmBillImport
extends BillImportPlugin {
    private List<String> numberList = null;
    private ArAbstractImport arAbstractImport = new ArAbstractImport();

    public RevCfmBillImport() {
        super(true);
    }

    public String bizCheck(JSONObject data) {
        boolean ispricetotal;
        boolean includetax;
        JSONObject currencyData;
        QFilter[] filters;
        Optional<DynamicObject> currencyOptional;
        this.arAbstractImport.data = data;
        ImportContext importtype = this.ctx;
        this.arAbstractImport.importtype = importtype != null ? importtype.getOption().get("importtype").toString() : "new";
        RevCfmBillImportCheck.importCheck((Map<String, Object>)data);
        String operTips = this.checkOperatorAndgroup(data, "salesman", "salesgroup");
        if (operTips != null) {
            return operTips;
        }
        this.arAbstractImport.checkOrgF7("fisaccounting", "org", ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7", (String)"RevCfmBillImport_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, null);
        this.arAbstractImport.init = new InitHelper(this.arAbstractImport.orgId, "ar_init");
        this.arAbstractImport.baseCurrencyPrecision = this.arAbstractImport.baseCurrency.getInt("amtprecision");
        if (this.numberList == null) {
            this.numberList = new ArrayList<String>();
        }
        this.arAbstractImport.checkText("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"RevCfmBillImport_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, 80, null);
        String number = (String)data.get((Object)"billno");
        Date currentDate = this.arAbstractImport.init.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = this.arAbstractImport.init.getStartDate();
        }
        try {
            this.arAbstractImport.checkDate("bizdate", ResManager.loadKDString((String)"\u786e\u8ba4\u65e5\u671f", (String)"RevCfmBillImport_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, currentDate, null, null);
        }
        catch (ParseException e) {
            return e.getMessage();
        }
        this.arAbstractImport.checkNull("billtype", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"RevCfmBillImport_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        this.checkAsstact();
        this.arAbstractImport.checkOrgF7("fisbankroll", "recorg", ResManager.loadKDString((String)"\u6536\u6b3e\u7ec4\u7ec7", (String)"RevCfmBillImport_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), false, null);
        this.arAbstractImport.checkF7("ar_payproperty", "payproperty", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"RevCfmBillImport_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, null);
        this.arAbstractImport.checkText("remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"RevCfmBillImport_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), false, 255, null);
        this.arAbstractImport.checkF7("bd_currency", "currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"RevCfmBillImport_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, null);
        this.arAbstractImport.checkOrgF7("fissale", "salesorg", ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7", (String)"RevCfmBillImport_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), false, null);
        this.arAbstractImport.checkF7("bd_operatorgroup", "salesgroup", ResManager.loadKDString((String)"\u9500\u552e\u7ec4", (String)"RevCfmBillImport_9", (String)"fi-ar-formplugin", (Object[])new Object[0]), false, null);
        String confirmWay = (String)data.get((Object)"confirmway");
        BigDecimal confirmRate = this.arAbstractImport.getBigDecimal("confirmrate");
        if ("RATE".equals(confirmWay)) {
            this.arAbstractImport.checkNull("confirmrate", ResManager.loadKDString((String)"\u786e\u8ba4\u6bd4\u7387%", (String)"RevCfmBillImport_11", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            if (confirmRate.compareTo(BigDecimal.ZERO) < 0 || confirmRate.compareTo(new BigDecimal("100")) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u6bd4\u7387\u8d85\u51fa\u6570\u503c\u8303\u56f4\uff0c\u8bf7\u8f93\u51650\u81f3100\u4e4b\u95f4\u7684\u6570\u503c\u3002", (String)"RevCfmBillImport_12", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
            data.put("confirmrate", (Object)confirmRate);
        }
        if (!(currencyOptional = this.arAbstractImport.getDynamicObjectFromDb("bd_currency", "id,number,name,amtprecision,priceprecision", filters = this.arAbstractImport.getQFilter("bd_currency", (currencyData = (JSONObject)data.get((Object)"currency")).getString("name"), currencyData.getString("number")))).isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"RevCfmBillImport_21", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        currencyData.put("number", (Object)currencyOptional.get().getString("number"));
        this.arAbstractImport.checkExchangeRate(currencyOptional.get().getLong("id"));
        boolean bl = includetax = data.get((Object)"isincludetax") != null ? (Boolean)data.get((Object)"isincludetax") : false;
        if (!data.containsKey((Object)"isincludetax")) {
            data.put("isincludetax", (Object)includetax);
        }
        boolean bl2 = ispricetotal = data.get((Object)"ispricetotal") != null ? (Boolean)data.get((Object)"ispricetotal") : false;
        if (!data.containsKey((Object)"ispricetotal")) {
            data.put("ispricetotal", (Object)ispricetotal);
        }
        JSONArray entryList = (JSONArray)data.get((Object)"entry");
        String importType = this.ctx.getOption().get("importtype").toString();
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                BigDecimal targetAmt;
                boolean ispresent;
                int seq = i + 1;
                JSONObject entry = (JSONObject)entryList.get(i);
                boolean bl3 = ispresent = entry.get((Object)"e_ispresent") != null ? (Boolean)entry.get((Object)"e_ispresent") : false;
                if (!ispresent) {
                    if (includetax && !ispricetotal) {
                        this.checkEntryNull(entry.get((Object)"e_taxunitprice"), ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"RevCfmBillImport_28", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq);
                    } else if (!includetax && !ispricetotal) {
                        this.checkEntryNull(entry.get((Object)"e_unitprice"), ResManager.loadKDString((String)"\u5355\u4ef7", (String)"RevCfmBillImport_29", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq);
                    } else if (!includetax && ispricetotal) {
                        this.checkEntryNull(entry.get((Object)"e_amount"), ResManager.loadKDString((String)"\u91d1\u989d", (String)"RevCfmBillImport_30", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq);
                    } else if (includetax && ispricetotal) {
                        this.checkEntryNull(entry.get((Object)"e_pricetaxtotal"), ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"RevCfmBillImport_31", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq);
                    }
                }
                if ("override".equals(importType)) {
                    this.removeEntryFileds(entry);
                    entry.remove((Object)"taxrateid");
                    entry.remove((Object)"e_taxrate");
                } else {
                    this.removeEntryFileds(entry);
                }
                String isMaterial = this.arAbstractImport.isMaterial();
                Object materialValue = entry.get((Object)"e_material");
                if ("true".equals(isMaterial)) {
                    this.arAbstractImport.checkEntryF7("bd_material", "e_material", ResManager.loadKDString((String)"\u7269\u6599", (String)"RevCfmBillImport_14", (String)"fi-ar-formplugin", (Object[])new Object[0]), entry, i, true, null);
                }
                if (!ObjectUtils.isEmpty((Object)materialValue)) {
                    this.arAbstractImport.checkEntryF7("bd_measureunits", "e_measureunit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"RevCfmBillImport_15", (String)"fi-ar-formplugin", (Object[])new Object[0]), entry, i, true, null);
                }
                entry.putIfAbsent((Object)"e_quantity", (Object)0);
                if (entry.get((Object)"e_unitprice") == null) {
                    entry.put("e_unitprice", (Object)0);
                }
                this.arAbstractImport.checkEntryEnum("e_discountmode", ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f", (String)"RevCfmBillImport_16", (String)"fi-ar-formplugin", (Object[])new Object[0]), entry, i, false, new String[]{"PERCENT", "PERUNIT", "NULL", "TOTAL"}, "NULL");
                this.arAbstractImport.checkEntryEnum("e_corebilltype", ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b", (String)"RevCfmBillImport_17", (String)"fi-ar-formplugin", (Object[])new Object[0]), entry, i, false, new String[]{"sm_salorder", "conm_salcontract"}, "sm_salorder");
                this.arAbstractImport.checkEntryText("e_corebillno", ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u53f7", (String)"RevCfmBillImport_18", (String)"fi-ar-formplugin", (Object[])new Object[0]), entry, i, false, 80, null);
                this.arAbstractImport.checkEntryText("e_remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"RevCfmBillImport_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), entry, i, false, 510, null);
                if (!"AMOUNT".equals(confirmWay)) continue;
                BigDecimal entryConfirmAmt = entry.getBigDecimal("e_confirmamt") == null ? BigDecimal.ZERO : entry.getBigDecimal("e_confirmamt");
                BigDecimal entryPrice = entry.getBigDecimal("e_unitprice") == null ? BigDecimal.ZERO : entry.getBigDecimal("e_unitprice");
                BigDecimal entryQty = entry.getBigDecimal("e_quantity") == null ? BigDecimal.ZERO : entry.getBigDecimal("e_quantity");
                BigDecimal bigDecimal = targetAmt = entryPrice.multiply(entryQty) == null ? BigDecimal.ZERO : entryPrice.multiply(entryQty);
                if (targetAmt.compareTo(BigDecimal.ZERO) > 0 && entryConfirmAmt.compareTo(BigDecimal.ZERO) < 0 || targetAmt.compareTo(BigDecimal.ZERO) < 0 && entryConfirmAmt.compareTo(BigDecimal.ZERO) > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u786e\u8ba4\u91d1\u989d\u4e0e\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\u3002", (String)"RevCfmBillImport_23", (String)"fi-ar-formplugin", (Object[])new Object[]{i + 1}));
                }
                if (entryConfirmAmt.abs().compareTo(entryPrice.multiply(entryQty).abs()) <= 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u786e\u8ba4\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u91d1\u989d\u3002", (String)"RevCfmBillImport_24", (String)"fi-ar-formplugin", (Object[])new Object[]{i + 1}));
            }
            this.numberList.add(number);
        }
        return null;
    }

    private void checkAsstact() {
        JSONObject billType = (JSONObject)this.arAbstractImport.data.get("billtype");
        if (billType.getString("number") != null && "ar_revcfmbill_other_BT_S".equals(billType.getString("number"))) {
            String value = (String)this.arAbstractImport.data.get("asstacttype");
            if (StringUtils.isEmpty((String)value)) {
                this.arAbstractImport.data.put("asstacttype", "bd_customer");
                value = "bd_customer";
            }
            this.arAbstractImport.checkF7(value, "asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"RevCfmBillImport_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, null);
        } else {
            this.arAbstractImport.data.put("asstacttype", "bd_customer");
            this.arAbstractImport.checkF7("bd_customer", "asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"RevCfmBillImport_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, null);
        }
    }

    @Deprecated
    protected void sumEntryAmt(JSONObject row, BigDecimal confirmRate, int amtprecision, int priceprecision, int measureUnitPrecision, String confirmWay) {
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal ONE_HUNDRED = new BigDecimal("100");
        BigDecimal exchangeRate = this.arAbstractImport.getBigDecimal("exchangerate");
        BigDecimal quantity = this.arAbstractImport.getEntryBigDecimal(row, "e_quantity");
        BigDecimal unitprice = this.arAbstractImport.getEntryBigDecimal(row, "e_unitprice");
        BigDecimal discountamount = BigDecimal.ZERO;
        if (DiscountModeEnum.PERCENT.getValue().equals(row.get((Object)"e_discountmode"))) {
            BigDecimal discountrate = this.arAbstractImport.getEntryBigDecimal(row, "e_discountrate").divide(ONE_HUNDRED);
            discountamount = quantity.multiply(unitprice).multiply(discountrate);
            row.put("e_discountamount", (Object)discountamount.setScale(amtprecision, RoundingMode.HALF_UP));
            row.put("e_actunitprice", (Object)unitprice.multiply(BigDecimal.ONE.subtract(discountrate)).setScale(priceprecision, RoundingMode.HALF_UP));
        } else if (DiscountModeEnum.PERUNIT.getValue().equals(row.get((Object)"e_discountmode"))) {
            BigDecimal discountamt = this.arAbstractImport.getEntryBigDecimal(row, "e_discountrate");
            BigDecimal actunitprice = unitprice.subtract(discountamt);
            row.put("e_actunitprice", (Object)actunitprice.setScale(priceprecision, RoundingMode.HALF_UP));
            discountamount = quantity.multiply(discountamt).setScale(amtprecision, RoundingMode.HALF_UP);
            row.put("e_discountamount", (Object)discountamount.toPlainString());
        } else if (DiscountModeEnum.NULL.getValue().equals(row.get((Object)"e_discountmode"))) {
            row.put("e_actunitprice", (Object)unitprice.toPlainString());
            row.put("e_discountrate", (Object)BigDecimal.ZERO);
            row.put("e_discountamount", (Object)BigDecimal.ZERO);
        }
        BigDecimal amount = this.arAbstractImport.getEntryBigDecimal(row, "e_actunitprice").multiply(quantity);
        PriceLocalCalculator localCalculator = null;
        String discountMode = row.getString("e_discountmode");
        BigDecimal discountRate = this.arAbstractImport.getEntryBigDecimal(row, "e_discountrate");
        UnitPriceCalculator calculator = new UnitPriceCalculator(quantity, this.arAbstractImport.getEntryBigDecimal(row, "e_unitprice"), taxRate, discountMode, discountRate, amtprecision);
        localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, this.arAbstractImport.baseCurrencyPrecision);
        localCalculator.calculate();
        amount = localCalculator.getAmount();
        quantity = localCalculator.getQuantity();
        BigDecimal cfmRate = BigDecimal.ZERO;
        BigDecimal rowConfirmAmt = row.getBigDecimal("e_confirmamt");
        if ("AMOUNT".equals(confirmWay)) {
            if (amount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal rowConfirmRate = rowConfirmAmt.multiply(ONE_HUNDRED).divide(amount, 2, 4);
                row.put("e_confirmrate", (Object)rowConfirmRate);
                cfmRate = rowConfirmRate.divide(ONE_HUNDRED);
            }
        } else {
            row.put("e_confirmrate", (Object)confirmRate.toPlainString());
            cfmRate = confirmRate.divide(ONE_HUNDRED);
        }
        row.put("e_quantity", (Object)quantity);
        row.put("e_confirmqty", (Object)quantity.multiply(cfmRate).setScale(measureUnitPrecision, 4));
        row.put("e_unverifyqty", (Object)quantity.multiply(cfmRate).setScale(measureUnitPrecision, 4));
        BigDecimal convertRate = (BigDecimal)row.get((Object)"e_unitcoefficient");
        row.put("e_unverifybaseqty", (Object)convertRate.multiply(quantity.multiply(cfmRate)));
        boolean ispresent = false;
        if (row.get((Object)"e_ispresent") != null) {
            ispresent = (Boolean)row.get((Object)"e_ispresent");
        }
        if (!ispresent) {
            row.put("e_unitprice", (Object)localCalculator.getUnitprice());
            row.put("e_actunitprice", (Object)localCalculator.getActunitprice());
            row.put("e_amount", (Object)amount);
            row.put("e_localamt", (Object)localCalculator.getAmountlocal());
            if ("AMOUNT".equals(confirmWay)) {
                row.put("e_unverifyamt", (Object)rowConfirmAmt.toPlainString());
                row.put("e_confirmamt", (Object)rowConfirmAmt);
            } else {
                row.put("e_unverifyamt", (Object)amount.multiply(cfmRate).setScale(amtprecision, 4));
                row.put("e_confirmamt", (Object)amount.multiply(cfmRate).setScale(amtprecision, 4));
            }
        } else {
            row.put("e_actunitprice", null);
        }
    }

    private void removeEntryFileds(JSONObject entry) {
        entry.remove((Object)"e_confirmtax");
        entry.remove((Object)"e_confirmloctax");
        entry.remove((Object)"e_cfmpricetax");
        entry.remove((Object)"e_cfmpricetaxbase");
        entry.remove((Object)"e_unrecqty");
        entry.remove((Object)"e_unrecbaseqty");
        entry.remove((Object)"e_recqty");
        entry.remove((Object)"e_recbaseqty");
        entry.remove((Object)"e_unrecamt");
        entry.remove((Object)"e_recamt");
        entry.remove((Object)"e_confirmbaseqty");
    }
}

