/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.formplugin.ArBaseList;
import kd.fi.ar.helper.RevcfmWriteOffVerify;
import kd.fi.ar.helper.ViewverHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.vo.CheckResult;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class RevCfmBillList
extends ArBaseList {
    private static final String BILLLIST = "billlistap";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map variables;
        String fromBack;
        String inventoryCostWeakCheck;
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("copy".equals(key)) {
            this.copy(args);
        }
        if ("getinventorycost".equals(key) && "true".equals(inventoryCostWeakCheck = StdConfig.get((String)"inventoryCostWeakCheck")) && !"false".equals(fromBack = (String)(variables = ((AbstractOperate)args.getSource()).getOption().getVariables()).get("fromBack"))) {
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            Object[] pks = selectedRows.getPrimaryKeyValues();
            QFilter filter = new QFilter("id", "in", (Object)pks);
            filter.and(new QFilter("isvoucher", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("verifystatus", "=", (Object)"verified"));
            DynamicObjectCollection bills = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,billno", (QFilter[])new QFilter[]{filter});
            List billIds = bills.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            Map<Long, String> billNoMap = bills.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getString("billno")));
            Map costResult = VerifyServiceHelper.revInventoryCostResult(billIds);
            ArrayList<String> noCostBillNos = new ArrayList<String>(16);
            for (Map.Entry entrySet : costResult.entrySet()) {
                boolean hadCostRecord = (Boolean)entrySet.getValue();
                if (hadCostRecord) continue;
                noCostBillNos.add(billNoMap.get(entrySet.getKey()));
            }
            if (noCostBillNos.size() > 0) {
                args.setCancel(true);
                String title = String.valueOf(ResManager.loadKDString((String)"\u5b58\u5728\u83b7\u53d6\u4e0d\u5230\u6210\u672c\u7684\u660e\u7ec6\u884c\u3002\u53ef\u80fd\u7684\u539f\u56e0\uff1a\n1.\u7269\u6599\u51fa\u5e93\u7684\u4ed3\u5e93\u201c\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u201d\u5173\u95ed\uff1b\n2.\u7269\u6599\u51fa\u5e93\u7684\u4ed3\u5e93\u201c\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u201d\u6253\u5f00,\u4f46\u672a\u8fdb\u884c\u51fa\u5e93\u6838\u7b97\uff1b\n3.\u7269\u6599\u51fa\u5e93\u7684\u4ed3\u5e93\u201c\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u201d\u6253\u5f00,\u4f46\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6838\u9500\u62c6\u5355\u672a\u5b8c\u6210\u3002", (String)"RevCfmBillList_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.getView(), (IFormPlugin)this);
                operationConfirmHelper.openOperateConfirmByActionId(title, "", noCostBillNos, false, key);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if ("getinventorycost".equals(actionId) && returnData != null) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("fromBack", "false");
            this.getView().invokeOperation("getinventorycost", option);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] billNos = selectedRows.stream().map(selectedRow -> selectedRow.getBillNo()).toArray();
            LogUtil.addOpLog((String)"ar_revcfmbill", (Object)(billNos.length > 0 ? billNos[0] : null), (String)operateKey, (String)("billnos\uff1a" + JSONObject.toJSONString((Object)billNos) + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("viewver".equals(key) || "viewver_arrev".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        } else if ("tblwriteoff".equals(key)) {
            BillList billList = (BillList)this.getView().getControl(BILLLIST);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] pks = selectedRows.getPrimaryKeyValues();
            if (pks.length != 1) {
                String message = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u51b2\u9500\u3002", (String)"RevCfmBillList_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            CheckResult result = RevcfmWriteOffVerify.check((Object[])pks);
            if (!result.isIspass()) {
                this.getView().showErrorNotification(result.getMessage());
            } else {
                this.getView().invokeOperation("writeoff");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("getinventorycost".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void copy(BeforeDoOperationEventArgs args) {
        BillList list = (BillList)this.getView().getControl(BILLLIST);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows != null) {
            Object[] pks = selectedRows.getPrimaryKeyValues();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pks[0], (String)"ar_revcfmbill");
            String sourceBillType = obj.getString("sourcebilltype");
            String billType = obj.getString("billtype.number");
            if (EmptyUtils.isNotEmpty((Object)sourceBillType) && "ar_revcfmbill_borrowar_BT_S".equals(billType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u4e0a\u6e38\u5355\u636e\u7684\u8c03\u6574\u5355\u65e0\u6cd5\u590d\u5236\u3002", (String)"RevCfmBillList_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

