/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.formplugin.formservice.TransferEditController;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class TransferOfCreditFormPlugin
extends AbstractFormPlugin {
    private long srcBillId;

    public void afterBindData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (SystemParameterHelper.isPlanSettle((long)org.getLong("id"), (boolean)true)) {
            List<String> controlNames = Arrays.asList("e_quantity", "e_transrecamount", "e_localamount");
            for (String controlName : controlNames) {
                FieldEdit control = (FieldEdit)this.getControl(controlName);
                control.setMustInput(false);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap1"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getFormController().fillModel(this.getModel(), this.getView());
    }

    protected TransferEditController getFormController() {
        return (TransferEditController)BeanFactory.getBean(TransferEditController.class, (Object[])new Object[0]);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int row = e.getChangeSet()[0].getRowIndex();
        String proName = e.getProperty().getName();
        BigDecimal maxamount = (BigDecimal)this.getModel().getValue("e_recamount", row);
        BigDecimal transamount = (BigDecimal)this.getModel().getValue("e_transamount", row);
        BigDecimal transtax = (BigDecimal)this.getModel().getValue("e_transtax", row);
        BigDecimal transrecamount = BigDecimal.ZERO;
        if (!ObjectUtils.isEmpty((Object)transamount)) {
            transrecamount = transamount.add(transtax);
        }
        switch (proName) {
            case "e_transamount": 
            case "e_transtax": {
                this.getModel().setValue("e_transrecamount", (Object)transrecamount, row);
                this.setLocalAmt(this.getModel(), "e_localamount", transrecamount, row);
                break;
            }
            case "exratetable": 
            case "exratedate": {
                if (newValue != null) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)proName, (Object)oldValue);
                return;
            }
            case "head_exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"TransferOfCreditFormPlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    return;
                }
                int entryCount = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < entryCount; ++i) {
                    BigDecimal transAmount = (BigDecimal)this.getModel().getValue("e_transrecamount", i);
                    this.setLocalAmt(this.getModel(), "e_localamount", transAmount, i);
                }
                break;
            }
            case "payproperty": {
                if (ObjectUtils.isEmpty((Object)newValue)) break;
                DynamicObject payproperty = (DynamicObject)newValue;
                payproperty = BusinessDataServiceHelper.loadSingleFromCache((Object)payproperty.getPkValue(), (String)payproperty.getDynamicObjectType().getName(), (String)"isbasedonamt");
                int entryRowCount = this.getModel().getEntryRowCount("entryentity");
                if (payproperty.getBoolean("isbasedonamt")) {
                    for (int i = 0; i < entryRowCount; ++i) {
                        BigDecimal ePriceTaxTotal = (BigDecimal)this.getModel().getValue("e_pricetaxtotal", i);
                        this.getModel().setValue("e_quantity", (Object)(ePriceTaxTotal.signum() > 0 ? BigDecimal.ONE : BigDecimal.ONE.negate()), i);
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"e_quantity"});
                    }
                } else {
                    for (int i = 0; i < entryRowCount; ++i) {
                        this.getView().setEnable(Boolean.TRUE, i, new String[]{"e_quantity"});
                    }
                }
                break;
            }
            case "asstact": {
                if (newValue == null) {
                    this.getModel().setValue("paycond", null);
                    this.getModel().setValue("settlementtype", null);
                    break;
                }
                DynamicObject asstact = (DynamicObject)newValue;
                String asstactType = (String)this.getModel().getValue("asstacttype");
                long asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"));
                this.getModel().setValue("settlementtype", (Object)asstactSettleTypeId);
                DynamicObject asstactFieldValue = QueryServiceHelper.queryOne((String)"bd_customer", (String)"receivingcondid", (QFilter[])new QFilter[]{new QFilter("id", "=", asstact.getPkValue())});
                if (asstactFieldValue == null) {
                    this.getModel().setValue("paycond", null);
                    return;
                }
                long paycondId = asstactFieldValue.getLong("receivingcondid");
                if (paycondId == 0L) {
                    this.getModel().setValue("paycond", null);
                    return;
                }
                DynamicObject paycondition = QueryServiceHelper.queryOne((String)"bd_reccondition", (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paycondId)});
                if (paycondition == null) {
                    this.getModel().setValue("paycond", null);
                    return;
                }
                if (StringUtils.equals((CharSequence)"1", (CharSequence)((String)paycondition.get("enable")))) {
                    this.getModel().setValue("paycond", (Object)paycondId);
                    break;
                }
                this.getModel().setValue("paycond", null);
                break;
            }
            case "p_transpricetaxtotal": {
                Object pBillId = this.getModel().getValue("p_billid", row);
                this.srcBillId = Long.parseLong(String.valueOf(pBillId));
                this.allocateAmtToDetail();
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object newValue = e.getValue();
        int index = e.getRowIndex();
        if (index == -1) {
            return;
        }
        if (newValue == null && Arrays.asList("e_quantity", "e_transamount", "e_transtax", "p_transpricetaxtotal").contains(key)) {
            newValue = BigDecimal.ZERO;
        }
        String errorMessage = null;
        BigDecimal unSettleAmt = (BigDecimal)this.getModel().getValue("e_recamount", index);
        BigDecimal ePriceTaxTotal = (BigDecimal)this.getModel().getValue("e_pricetaxtotal", index);
        switch (key) {
            case "e_quantity": {
                BigDecimal maxQuantity = (BigDecimal)this.getModel().getValue("e_maxquantity", index);
                if (maxQuantity.abs().compareTo(ArApHelper.getBigDecimal((Object)newValue).abs()) < 0) {
                    this.showErrorMessage(e, key, index, ePriceTaxTotal.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u79fb\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u539f\u5355\u4e0a\u7269\u6599\u7684\u6570\u91cf\u3002", (String)"TransferOfCreditFormPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u79fb\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u539f\u5355\u4e0a\u7269\u6599\u7684\u6570\u91cf\u3002", (String)"TransferOfCreditFormPlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (ArApHelper.getBigDecimal((Object)newValue).signum() == 0) {
                    this.showErrorMessage(e, key, index, ResManager.loadKDString((String)"\u8f6c\u79fb\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a0\u3002", (String)"TransferOfCreditFormPlugin_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                errorMessage = this.validateTransFields(ArApHelper.getBigDecimal((Object)newValue), ePriceTaxTotal);
                if (errorMessage == null) break;
                this.showErrorMessage(e, key, index, errorMessage);
                break;
            }
            case "e_transamount": {
                BigDecimal transTax = (BigDecimal)this.getModel().getValue("e_transtax", index);
                errorMessage = this.validateTransFields(ArApHelper.getBigDecimal((Object)newValue), ePriceTaxTotal);
                if (errorMessage != null) {
                    this.showErrorMessage(e, key, index, errorMessage);
                    break;
                }
                if (transTax.add(ArApHelper.getBigDecimal((Object)newValue)).abs().compareTo(unSettleAmt.abs()) > 0) {
                    this.showErrorMessage(e, key, index, ePriceTaxTotal.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u6536\u4f59\u989d\u3002", (String)"TransferOfCreditFormPlugin_4", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u6536\u4f59\u989d\u3002", (String)"TransferOfCreditFormPlugin_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (transTax.add(ArApHelper.getBigDecimal((Object)newValue)).compareTo(BigDecimal.ZERO) != 0) break;
                this.showErrorMessage(e, key, index, ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u4e0d\u53ef\u4e3a0\u3002", (String)"TransferOfCreditFormPlugin_10", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                break;
            }
            case "e_transtax": {
                BigDecimal transAmount = (BigDecimal)this.getModel().getValue("e_transamount", index);
                errorMessage = this.validateTransFields(ArApHelper.getBigDecimal((Object)newValue), ePriceTaxTotal);
                if (errorMessage != null) {
                    this.showErrorMessage(e, key, index, errorMessage);
                    break;
                }
                if (transAmount.add(ArApHelper.getBigDecimal((Object)newValue)).abs().compareTo(unSettleAmt.abs()) > 0) {
                    this.showErrorMessage(e, key, index, ePriceTaxTotal.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u6536\u4f59\u989d\u3002", (String)"TransferOfCreditFormPlugin_4", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u6536\u4f59\u989d\u3002", (String)"TransferOfCreditFormPlugin_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (transAmount.add(ArApHelper.getBigDecimal((Object)newValue)).compareTo(BigDecimal.ZERO) != 0) break;
                this.showErrorMessage(e, key, index, ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u4e0d\u53ef\u4e3a0\u3002", (String)"TransferOfCreditFormPlugin_10", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                break;
            }
            case "p_transpricetaxtotal": {
                if (ArApHelper.getBigDecimal((Object)newValue).signum() == 0) {
                    this.showErrorMessage(e, key, index, ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u4e0d\u53ef\u4e3a0\u3002", (String)"TransferOfCreditFormPlugin_10", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                BigDecimal pUnPlanLockAmt = (BigDecimal)this.getModel().getValue("unplanlockamt", index);
                if (pUnPlanLockAmt.signum() != ArApHelper.getBigDecimal((Object)newValue).signum()) {
                    this.showErrorMessage(e, key, index, pUnPlanLockAmt.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TransferOfCreditFormPlugin_13", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e0\u3002", (String)"TransferOfCreditFormPlugin_14", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (pUnPlanLockAmt.abs().compareTo(ArApHelper.getBigDecimal((Object)newValue).abs()) >= 0) break;
                this.showErrorMessage(e, key, index, pUnPlanLockAmt.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u6536\u4f59\u989d\u3002", (String)"TransferOfCreditFormPlugin_11", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u884c\u5206\u5f55\u5e94\u6536\u4f59\u989d\u3002", (String)"TransferOfCreditFormPlugin_12", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showErrorMessage(BeforeFieldPostBackEvent e, String key, int index, String massage) {
        this.getView().showErrorNotification(massage);
        e.setCancel(true);
        this.getView().updateView(key, index);
    }

    private String validateTransFields(BigDecimal newValue, BigDecimal ePriceTaxTotal) {
        if (newValue.signum() != 0 && ePriceTaxTotal.signum() != newValue.signum()) {
            return ePriceTaxTotal.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u79fb\u6570\u91cf\u3001\u8f6c\u79fb\u91d1\u989d\u548c\u8f6c\u79fb\u7a0e\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TransferOfCreditFormPlugin_6", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u79fb\u6570\u91cf\u3001\u8f6c\u79fb\u91d1\u989d\u548c\u8f6c\u79fb\u7a0e\u989d\u5fc5\u987b\u5c0f\u4e8e0\u3002", (String)"TransferOfCreditFormPlugin_9", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public void setLocalAmt(IDataModel model, String srcAmountflag, BigDecimal srcAmount, int row) {
        BigDecimal exchangeRate = (BigDecimal)model.getValue("head_exchangerate");
        String quotation = (String)model.getValue("quotation");
        DynamicObject basecurrency = (DynamicObject)model.getValue("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        if ("0".equals(quotation)) {
            model.setValue(srcAmountflag, (Object)srcAmount.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP), row);
        } else {
            model.setValue(srcAmountflag, (Object)srcAmount.divide(exchangeRate, localprecision, RoundingMode.HALF_UP), row);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String deleteEntryName = e.getEntryProp().getName();
        if ("planentity".equals(deleteEntryName)) {
            Object pBillId = this.getModel().getValue("p_billid", e.getRowIndexs()[0]);
            this.srcBillId = Long.parseLong(String.valueOf(pBillId));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String deleteEntryName = e.getEntryProp().getName();
        if ("planentity".equals(deleteEntryName)) {
            this.allocateAmtToDetail();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("transfer".equals(key)) {
            DynamicObjectCollection transferFromInfos = this.getModel().getEntryEntity("entryentity");
            Set transferFromIds = transferFromInfos.stream().map(info -> info.getLong("e_srcfinbillid")).collect(Collectors.toSet());
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0017", null, (Object[])new Object[]{transferFromIds});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm"});
        this.filterTaxRate();
        this.asstactFilter();
        this.filterPayproperty();
    }

    private void asstactFilter() {
        ItemClassEdit asstactF7 = (ItemClassEdit)this.getControl("asstact");
        asstactF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String asstactType = this.getModel().getValue("asstacttype").toString();
            if ("bd_customer".equals(asstactType)) {
                QFilter filter = new QFilter("bizfunction", "ilike", (Object)"%2%");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    private void filterPayproperty() {
        BasedataEdit paypropertyF7 = (BasedataEdit)this.getControl("payproperty");
        paypropertyF7.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity == null || entryEntity.size() < 1) {
                return;
            }
            Long srcId = (Long)this.getModel().getValue("e_srcfinbillid", 0);
            QFilter idFilter = new QFilter("id", "=", (Object)srcId);
            DynamicObject bill = QueryServiceHelper.queryOne((String)"ar_finarbill", (String)"payproperty.isbasedonamt", (QFilter[])idFilter.toArray());
            if (bill == null) {
                return;
            }
            ListFilterParameter lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            lfp.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)bill.getBoolean("payproperty.isbasedonamt")));
        });
    }

    private void filterTaxRate() {
        BasedataEdit taxRateF7 = (BasedataEdit)this.getControl("taxrateid");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        taxRateF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("activedate", "<=", (Object)bizDate);
            filter.and(new QFilter("expdate", ">=", (Object)bizDate).or("expdate", "is null", null));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(filter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("confirm".equals(key)) {
            this.getView().returnDataToParent((Object)Boolean.TRUE);
        }
    }

    private Map<Long, Set<Long>> getPlan2DetailMap() {
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org,settleversion", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.srcBillId)});
        boolean isUseNew = !SettleVersionServiceHelper.isOldVersion((DynamicObject)sourceBills[0]);
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(64);
        DynamicObjectCollection planEntity = this.getModel().getEntryEntity("planentity");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject planRow : planEntity) {
            long billId = planRow.getLong("p_billid");
            int pSplitDimensionId = planRow.getInt("p_splitdimensionid");
            HashSet<Long> detailRowIds = new HashSet<Long>(64);
            for (DynamicObject detailRow : entry) {
                if (billId != detailRow.getLong("e_srcfinbillid")) continue;
                if (isUseNew) {
                    if (pSplitDimensionId != detailRow.getInt("e_splitdimensionid")) continue;
                    detailRowIds.add(detailRow.getLong("e_srcentryid"));
                    continue;
                }
                detailRowIds.add(detailRow.getLong("e_srcentryid"));
            }
            result.put(planRow.getLong("p_entryid"), detailRowIds);
        }
        return result;
    }

    private void allocateAmtToDetail() {
        Map<Long, Set<Long>> plan2DetailMap = this.getPlan2DetailMap();
        HashMap<Long, BigDecimal> allocateAmtMap = new HashMap<Long, BigDecimal>(32);
        DynamicObjectCollection planEntity = this.getModel().getEntryEntity("planentity");
        for (Object planRow : planEntity) {
            if (this.srcBillId != planRow.getLong("p_billid")) continue;
            allocateAmtMap.put(planRow.getLong("p_entryid"), planRow.getBigDecimal("p_transpricetaxtotal"));
        }
        DynamicObjectCollection detailEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject detailRow : detailEntity) {
            if (this.srcBillId != detailRow.getLong("e_srcfinbillid")) continue;
            detailRow.set("e_transamount", (Object)BigDecimal.ZERO);
            detailRow.set("e_transtax", (Object)BigDecimal.ZERO);
            detailRow.set("e_transrecamount", (Object)BigDecimal.ZERO);
            detailRow.set("e_localamount", (Object)BigDecimal.ZERO);
        }
        if (ObjectUtils.isEmpty(plan2DetailMap) || ObjectUtils.isEmpty(allocateAmtMap)) {
            this.getView().updateView("entryentity");
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        for (Map.Entry entrySet : allocateAmtMap.entrySet()) {
            Long planRowId = (Long)entrySet.getKey();
            Set<Long> detailRowIds = plan2DetailMap.get(planRowId);
            BigDecimal allocateAmt = (BigDecimal)allocateAmtMap.get(planRowId);
            if (ObjectUtils.isEmpty(detailRowIds) || BigDecimal.ZERO.compareTo(allocateAmt) == 0) continue;
            BigDecimal totalDetailAmt = BigDecimal.ZERO;
            for (DynamicObject detailRow : entry) {
                long finEntryId = detailRow.getLong("e_srcentryid");
                if (!detailRowIds.contains(finEntryId)) continue;
                totalDetailAmt = totalDetailAmt.add(detailRow.getBigDecimal("e_pricetaxtotal"));
            }
            int needAllocateRowSize = detailRowIds.size();
            BigDecimal remainAmt = allocateAmt;
            for (DynamicObject detailRow : entry) {
                BigDecimal disposeAmt;
                long finEntryId = detailRow.getLong("e_srcentryid");
                if (!detailRowIds.contains(finEntryId)) continue;
                int precision = detailRow.getInt("e_currency.amtprecision");
                if (--needAllocateRowSize == 0) {
                    disposeAmt = remainAmt;
                } else {
                    BigDecimal entryAmt = detailRow.getBigDecimal("e_pricetaxtotal");
                    BigDecimal proportion = entryAmt.divide(totalDetailAmt, 10, RoundingMode.HALF_UP);
                    disposeAmt = allocateAmt.multiply(proportion).setScale(precision, RoundingMode.HALF_UP);
                }
                BigDecimal oldTransTotalAmt = detailRow.getBigDecimal("e_transrecamount");
                BigDecimal newTransTotalAmt = disposeAmt.add(oldTransTotalAmt);
                BigDecimal unSettleAmt = detailRow.getBigDecimal("e_recamount");
                if (newTransTotalAmt.abs().compareTo(unSettleAmt.abs()) > 0) {
                    disposeAmt = unSettleAmt.subtract(oldTransTotalAmt);
                    detailRow.set("e_transrecamount", (Object)unSettleAmt);
                } else {
                    detailRow.set("e_transrecamount", (Object)newTransTotalAmt);
                }
                BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("head_exchangerate");
                String quotation = (String)this.getModel().getValue("quotation");
                DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
                int localprecision = basecurrency.getInt("amtprecision");
                if ("0".equals(quotation)) {
                    detailRow.set("e_localamount", (Object)newTransTotalAmt.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP));
                } else {
                    detailRow.set("e_localamount", (Object)newTransTotalAmt.divide(exchangeRate, localprecision, RoundingMode.HALF_UP));
                }
                remainAmt = remainAmt.subtract(disposeAmt);
            }
        }
        for (DynamicObject detailRow : entry) {
            int precision = detailRow.getInt("e_currency.amtprecision");
            BigDecimal newTransTotalAmt = detailRow.getBigDecimal("e_transrecamount");
            BigDecimal taxRate = detailRow.getBigDecimal("taxrateid.taxrate").divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP);
            BigDecimal tax = newTransTotalAmt.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_UP);
            detailRow.set("e_transtax", (Object)tax);
            detailRow.set("e_transamount", (Object)newTransTotalAmt.subtract(tax));
        }
        this.getView().updateView("entryentity");
    }
}

