/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.baddebtnew;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class AccrualBaseListPlugin
extends AbstractListPlugin {
    private List<Long> orgIds;
    private long orgId = 0L;
    private List<QFilter> qFilters;
    private FilterContainerInitArgs initArgs;
    private boolean isSearchClick;

    public void afterImportData(ImportDataEventArgs e) {
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        List<DynamicObject> orgs = this.getFinishedSettingOrgs();
        List<ComboItem> orgFilterItems = this.getOrgFilterItems(orgs);
        long currentOrg = RequestContext.get().getOrgId();
        this.orgIds = orgs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            CommonFilterColumn filterColumn = (CommonFilterColumn)commonFilterColumn;
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.startsWith("org")) continue;
            filterColumn.setComboItems(orgFilterItems);
            if (EmptyUtils.isEmpty((Object)this.getPageCache().get("isPageOpen"))) {
                this.getPageCache().put("isPageOpen", "true");
                Long defauleOrg = this.getDefaultOrg(currentOrg);
                filterColumn.setDefaultValue(defauleOrg.toString());
                this.orgId = defauleOrg;
            }
            if (!EmptyUtils.isEmpty((Object)this.getPageCache().get("orgForPeriod"))) break;
            this.getPageCache().put("orgForPeriod", String.valueOf(this.orgId));
            break;
        }
        this.initFilterItems(args);
        if (this.isSearchClick) {
            this.initFilterItems(args);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.isSearchClick = true;
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFilterValues = (List)filterValues.get("customfilter");
        if (customFilterValues != null) {
            if (this.qFilters == null) {
                this.qFilters = new ArrayList<QFilter>();
            }
            for (Map map : customFilterValues) {
                Set<Long> longSet;
                List lst;
                if (((List)map.get("FieldName")).get(0).equals("org.id")) {
                    String orgValue = ((List)map.get("Value")).get(0).toString();
                    if (!orgValue.equals("")) {
                        this.getPageCache().put("orgForPeriod", orgValue);
                    } else {
                        this.getPageCache().put("orgForPeriod", "0");
                    }
                    this.orgId = Long.parseLong(orgValue);
                    this.filterContainerInit(this.initArgs);
                    this.qFilters.add(new QFilter("org.id", "=", (Object)this.orgId));
                }
                if (!((List)map.get("FieldName")).get(0).equals("period.id") || (lst = (List)map.get("Value")) == null || lst.size() <= 0 || (longSet = this.convertToLongSet(lst)).isEmpty()) continue;
                this.qFilters.add(new QFilter("period.id", "in", longSet));
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        DynamicObject startPeriod;
        QFilter[] filters;
        DynamicObject finishSettingInitInfo;
        String orgForPeriod;
        super.filterContainerBeforeF7Select(args);
        if ("period.id".equals(args.getFieldName()) && (orgForPeriod = this.getPageCache().get("orgForPeriod")) != null && !orgForPeriod.equals("") && (finishSettingInitInfo = BusinessDataServiceHelper.loadSingle((String)"ar_init", (String)"startperiod", (QFilter[])(filters = new QFilter[]{new QFilter("org", "in", (Object)Long.parseLong(orgForPeriod))}))) != null && (startPeriod = finishSettingInitInfo.getDynamicObject("startperiod")) != null) {
            args.getQfilters().add(new QFilter("periodtype", "=", (Object)startPeriod.getLong("periodtype.id")));
            args.getQfilters().add(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
        }
    }

    private List<ComboItem> getOrgFilterItems(List<DynamicObject> orgs) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        if (orgs != null && orgs.size() > 0) {
            for (DynamicObject org : orgs) {
                orgItems.add(new ComboItem(new LocaleString(org.getString("name")), org.getString("id")));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u5b58\u5728\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u7684\u7ec4\u7ec7", (String)"AccrualBaseListPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return orgItems;
    }

    private Long getDefaultOrg(Long orgId) {
        Long tempOrgId = this.orgIds.get(0);
        if (this.orgIds.contains(orgId)) {
            return orgId;
        }
        return tempOrgId;
    }

    public List<DynamicObject> getFinishedSettingOrgs() {
        DynamicObject[] finishSettingInitInfos;
        LinkedList<DynamicObject> finishedSettingOrgs = new LinkedList<DynamicObject>();
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection orgs = AccrualBaseListPlugin.getAuthorizedBankOrg(userId, "ar_accrualaging", "47156aff000000ac", "fisaccounting", "AR");
        String entityInit = "ar_init";
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", AccrualBaseListPlugin.getIdList((List<DynamicObject>)orgs))};
        for (DynamicObject info : finishSettingInitInfos = BusinessDataServiceHelper.load((String)entityInit, (String)"org", (QFilter[])filters)) {
            finishedSettingOrgs.add(info.getDynamicObject("org"));
        }
        return finishedSettingOrgs;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String entityID, String permissionItem, String attributes, String appID) {
        Map orgMap;
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appID.toLowerCase(), (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(attributes, "=", (Object)Boolean.TRUE);
        if (result.hasAllOrgPerm()) {
            orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = result.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgMap.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static List<Long> getIdList(List<DynamicObject> orgList) {
        ArrayList<Long> idList = new ArrayList<Long>(orgList.size());
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    private void initFilterItems(FilterContainerInitArgs args) {
        DynamicObject[] periods = BaddebtHelper.getPeriods((Object)this.orgId);
        if (periods != null) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (!commonFilter.getFieldName().startsWith("period")) continue;
                commonFilter.getComboItems().clear();
                commonFilter.setComboItems(this.setPeriodComboItems(periods));
                break;
            }
        }
    }

    private List<ComboItem> setPeriodComboItems(DynamicObject[] periods) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(periods.length);
        for (DynamicObject period : periods) {
            comboItems.add(new ComboItem(new LocaleString(period.getString("name")), period.getPkValue().toString()));
        }
        return comboItems;
    }

    private Set<Long> convertToLongSet(Collection<Object> collection) {
        HashSet<Long> hashSet = new HashSet<Long>(collection.size());
        for (Object o : collection) {
            if (EmptyUtils.isEmpty((Object)o)) continue;
            hashSet.add(Long.valueOf(o.toString()));
        }
        return hashSet;
    }
}

