/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.baddebtnew;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DateProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.excel.FormulaException;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ar.helper.BadDebtAccrualHelper;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.AccrualRateRow;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class BadDebtAccrualPlanEdit
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        int ruleentry = this.getModel().getEntryRowCount("ruleentry");
        for (int i = 0; i < ruleentry; ++i) {
            OrmLocaleValue cardName = (OrmLocaleValue)this.getModel().getValue("c_cardname", i);
            this.getModel().setValue("c_titlename", (Object)cardName.getLocaleValue(), i);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
        if ("1".equals(this.getModel().getValue("enable"))) {
            this.getModel().setDataChanged(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"addimg", "deleterule", "modify", "copyrule"});
        CardEntry grid = (CardEntry)this.getView().getControl("ruleentry");
        grid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit accrualObjF7 = (BasedataEdit)this.getControl("accrualobject");
        accrualObjF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String type = (String)this.getModel().getValue("accrualcontext");
            if (EmptyUtils.isNotEmpty((Object)type)) {
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                QFilter entityFilter = null;
                if ("0".equals(type)) {
                    entityFilter = new QFilter("entityobject", "in", (Object)new String[]{"ar_finarbill", "ar_busbill"});
                }
                if ("1".equals(type)) {
                    entityFilter = new QFilter("entityobject", "in", (Object)"ar_revcfmbill");
                }
                if ("2".equals(type)) {
                    entityFilter = new QFilter("entityobject", "in", (Object)new String[]{"cas_paybill", "ap_paidbill"});
                }
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(enableFilter.and(entityFilter));
            }
        });
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter groupTypeFilter = new QFilter("grouptype", "ftlike", (Object)"0");
        DynamicObject useOrg = (DynamicObject)this.getModel().getValue("useorg");
        if (useOrg == null) {
            return;
        }
        DynamicObjectCollection accrualagings = BaseDataServiceHelper.queryBaseData((String)"ar_accrualaging", (Long)useOrg.getLong("id"), (QFilter)enableFilter.and(groupTypeFilter), (String)"id");
        HashSet<Long> agingIds = new HashSet<Long>(8);
        for (DynamicObject aging : accrualagings) {
            agingIds.add(aging.getLong("id"));
        }
        BasedataEdit agingGroupF7 = (BasedataEdit)this.getControl("aginggroup");
        agingGroupF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            this.getPageCache().put("isF7Select", "1");
            QFilter idFilter = new QFilter("id", "in", (Object)agingIds);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(idFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)opStatus)) {
            DynamicObject useOrg = (DynamicObject)this.getModel().getValue("useorg");
            if (useOrg != null) {
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                QFilter defaultFilter = new QFilter("isdefault", "=", (Object)"1");
                QFilter groupFilter = new QFilter("grouptype", "ftlike", (Object)"0");
                DynamicObjectCollection accrualagings = BaseDataServiceHelper.queryBaseData((String)"ar_accrualaging", (Long)useOrg.getLong("id"), (QFilter)filter.and(defaultFilter).and(groupFilter), (String)"id");
                if (accrualagings != null && !accrualagings.isEmpty()) {
                    DynamicObject agingIdDO = (DynamicObject)accrualagings.get(0);
                    DynamicObject aging = BusinessDataServiceHelper.loadSingleFromCache((Object)agingIdDO.getLong("id"), (String)"ar_accrualaging");
                    this.getModel().setValue("aginggroup", (Object)aging.getLong("id"));
                    this.setAccrualAging(aging);
                }
            }
            this.setFieldList("ar_receivedbill", "o_receivedfield");
            this.setFieldList("cas_recbill", "o_recbillfield");
        }
        this.getModel().setValue("c_titlename", (Object)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8ba1\u63d0\u4fe1\u606f\u4e2d\u7684\u540d\u79f0", (String)"BadDebtAccrualPlanEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int entryRowCount = this.getModel().getEntryRowCount("ruleentry");
        if (entryRowCount > 0) {
            EntryGrid grid = (EntryGrid)this.getControl("ruleentry");
            grid.selectRows(0);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("addimg".equals(key)) {
            int cardIndex = this.getModel().getEntryCurrentRowIndex("ruleentry");
            String enable = (String)this.getModel().getValue("enable");
            String status = (String)this.getModel().getValue("status");
            if ("1".equals(enable) && "C".equals(status)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u542f\u7528\u72b6\u6001\u4e0b\u4e0d\u80fd\u65b0\u589e\u8ba1\u63d0\u89c4\u5219\u3002", (String)"BadDebtAccrualPlanEdit_10", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
            this.putRuleRowData(cardIndex);
            this.getModel().createNewEntryRow("ruleentry");
            int entryRowCount = this.getModel().getEntryRowCount("ruleentry");
            if (entryRowCount > 0) {
                EntryGrid grid = (EntryGrid)this.getControl("ruleentry");
                int nextRowIndex = entryRowCount - 1;
                this.getPageCache().put("currentCardRow", String.valueOf(nextRowIndex));
                grid.selectRows(nextRowIndex);
            }
            this.clearRightInfo();
        } else if ("deleterule".equals(key)) {
            String message = ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u6570\u636e\uff1f", (String)"BadDebtAccrualPlanEdit_13", (String)"fi-ar-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
        }
    }

    private void clearRightInfo() {
        this.getModel().setValue("rulenumber", null);
        this.getModel().setValue("rulename", null);
        this.getModel().setValue("accrualobject", null);
        this.getModel().setValue("accrualcontext", null);
        this.getModel().setValue("agingstartdatefield", null);
        this.getModel().setValue("remark", null);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        filterGrid.SetValue(new FilterCondition());
        this.getModel().deleteEntryData("offsetentry");
        this.getModel().setValue("offset", null);
        this.getModel().setValue("offsetobj", null);
        this.getModel().setValue("offsetedobj", null);
        this.getModel().setValue("offsetremark", null);
        this.getModel().setValue("includeperiod", (Object)Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String offset;
        OrmLocaleValue rulename;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int currentCardRow = changeData[0].getRowIndex();
        String currentCardRowString = this.getPageCache().get("currentCardRow");
        if (currentCardRowString != null && !"".equals(currentCardRowString)) {
            currentCardRow = Integer.parseInt(currentCardRowString);
        }
        if ("accrualcontext".equals(key)) {
            String type = (String)newValue;
            DynamicObject accrualobject = (DynamicObject)this.getModel().getValue("accrualobject");
            if (EmptyUtils.isEmpty((Object)type)) {
                this.getModel().setValue("accrualobject", null);
            } else {
                String entityName;
                DynamicObject accrualObj;
                QFilter entityFilter;
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                if ("0".equals(type)) {
                    entityFilter = new QFilter("entityobject", "=", (Object)"ar_finarbill");
                    accrualObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_accrualentityobj", (QFilter[])new QFilter[]{enableFilter, entityFilter});
                    if (accrualobject != null && ((entityName = accrualobject.getString("entityobject")).equals("ar_finarbill") || entityName.equals("ar_busbill"))) {
                        return;
                    }
                    if (accrualObj != null) {
                        this.getModel().setValue("accrualobject", (Object)accrualObj.getLong("id"));
                    } else {
                        this.getModel().setValue("accrualobject", null);
                    }
                }
                if ("1".equals(type)) {
                    entityFilter = new QFilter("entityobject", "=", (Object)"ar_revcfmbill");
                    accrualObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_accrualentityobj", (QFilter[])new QFilter[]{enableFilter, entityFilter});
                    if (accrualobject != null && (entityName = accrualobject.getString("entityobject")).equals("ar_revcfmbill")) {
                        return;
                    }
                    if (accrualObj != null) {
                        this.getModel().setValue("accrualobject", (Object)accrualObj.getLong("id"));
                    } else {
                        this.getModel().setValue("accrualobject", null);
                    }
                }
                if ("2".equals(type)) {
                    entityFilter = new QFilter("entityobject", "=", (Object)"cas_paybill");
                    accrualObj = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_accrualentityobj", (QFilter[])new QFilter[]{enableFilter, entityFilter});
                    if (accrualobject != null && ((entityName = accrualobject.getString("entityobject")).equals("cas_paybill") || entityName.equals("ap_paidbill"))) {
                        return;
                    }
                    if (accrualObj != null) {
                        this.getModel().setValue("accrualobject", (Object)accrualObj.getLong("id"));
                    } else {
                        this.getModel().setValue("accrualobject", null);
                    }
                }
            }
        }
        if ("aginggroup".equals(key)) {
            String isF7Select = this.getPageCache().get("isF7Select");
            if (newValue == null) {
                this.getModel().deleteEntryData("entryentity");
            } else if ("1".equals(isF7Select)) {
                DynamicObject agingIdDO = (DynamicObject)newValue;
                DynamicObject aging = BusinessDataServiceHelper.loadSingleFromCache((Object)agingIdDO.getLong("id"), (String)"ar_accrualaging");
                this.setAccrualAging(aging);
            }
        }
        if ("accrualobject".equals(key)) {
            this.getModel().setValue("c_accrualentityobj", newValue, currentCardRow);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.SetValue(new FilterCondition());
            if (newValue != null) {
                DynamicObject accrualObject = (DynamicObject)newValue;
                String entityName = accrualObject.getString("entityobject");
                this.setFilterGridBasic(entityName);
                this.getView().updateView("filtergrid");
                this.getModel().setValue("agingstartdatefield", (Object)"");
                this.setContrastFieldValues(entityName, true, "agingstartdatefield", false);
                boolean isArBus = "ar_busbill".equals(entityName);
                boolean isArRevcfm = "ar_revcfmbill".equals(entityName);
                if (isArBus) {
                    this.getModel().setValue("offset", (Object)"1");
                    this.getModel().setValue("offsetobj", (Object)"ar_receivedbill,cas_recbill");
                    this.getModel().setValue("offsetedobj", (Object)"ar_busbill");
                    this.getModel().deleteEntryData("offsetentry");
                }
                if (isArRevcfm) {
                    this.getModel().setValue("offset", (Object)"0");
                    this.getModel().setValue("offsetobj", (Object)"ar_receivedbill,cas_recbill");
                    this.getModel().setValue("offsetedobj", (Object)"ar_revcfmbill");
                    this.getModel().deleteEntryData("offsetentry");
                }
                if (!isArBus && !isArRevcfm) {
                    this.getModel().setValue("offset", null);
                    this.getModel().setValue("offsetobj", null);
                    this.getModel().setValue("offsetedobj", null);
                    this.getModel().setValue("offsetremark", null);
                    this.getModel().deleteEntryData("offsetentry");
                }
            } else {
                this.getModel().setValue("offset", null);
                this.getModel().setValue("offsetobj", null);
                this.getModel().setValue("offsetedobj", null);
                this.getModel().setValue("offsetremark", null);
                this.getModel().deleteEntryData("offsetentry");
                ComboEdit fieldCombo = (ComboEdit)this.getControl("agingstartdatefield");
                fieldCombo.setComboItems(new ArrayList(8));
            }
            this.getModel().setValue("includeperiod", (Object)Boolean.TRUE);
        }
        if (newValue != null && "includeperiod".equals(key)) {
            boolean isOffset;
            boolean includePeriod = (Boolean)newValue;
            String offset2 = (String)this.getModel().getValue("offset");
            boolean bl = isOffset = offset2 != null && !"".equals(offset2);
            if (includePeriod) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"o_receivedbill"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"o_receivedfield"});
                if (isOffset) {
                    this.getModel().setValue("offsetobj", (Object)"ar_receivedbill,cas_recbill");
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"o_receivedbill"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"o_receivedfield"});
                if (isOffset) {
                    this.getModel().setValue("offsetobj", (Object)"cas_recbill");
                }
            }
        }
        if ("rulenumber".equals(key)) {
            this.getModel().setValue("c_number", newValue, currentCardRow);
        }
        if ("rulename".equals(key) && (rulename = (OrmLocaleValue)this.getModel().getValue("rulename")) != null) {
            String localeValue = rulename.getLocaleValue();
            if (localeValue != null && !"".equals(localeValue)) {
                this.getModel().setValue("c_cardname", (Object)rulename, currentCardRow);
                this.getModel().setValue("c_titlename", (Object)localeValue, currentCardRow);
            } else {
                this.getModel().setValue("c_titlename", (Object)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8ba1\u63d0\u4fe1\u606f\u4e2d\u7684\u540d\u79f0\u3002", (String)"BadDebtAccrualPlanEdit_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), currentCardRow);
            }
        }
        if ("remark".equals(key)) {
            this.getModel().setValue("c_remark", newValue, currentCardRow);
        }
        if ("agingstartdatefield".equals(key) && !ObjectUtils.isEmpty((Object)newValue)) {
            this.getModel().setValue("c_agingstartdate", newValue, currentCardRow);
        }
        if ("offset".equals(key) && (offset = (String)newValue) != null && !"".equals(offset)) {
            if ("0".equals(offset)) {
                this.setFieldList("ar_revcfmbill", "o_offsetbillfield");
            } else if ("1".equals(offset)) {
                this.setFieldList("ar_busbill", "o_offsetbillfield");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (isOK && "deleterule".equals(callBackID)) {
            CardEntry operEntry = (CardEntry)this.getControl("ruleentry");
            int focusRow = operEntry.getEntryState().getFocusRow();
            int cardCount = this.getModel().getEntryRowCount("ruleentry");
            if (cardCount - 1 > 0) {
                this.getModel().deleteEntryRow("ruleentry", focusRow);
                if (focusRow == cardCount - 1) {
                    operEntry.selectRows(focusRow - 1);
                } else {
                    operEntry.selectRows(focusRow);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u884c\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"BadDebtAccrualPlanEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("save".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("ruleentry");
            this.putRuleRowData(rowIndex);
            DynamicObjectCollection ruleEntries = this.getModel().getEntryEntity("ruleentry");
            StringBuilder errMsg = new StringBuilder();
            boolean isFault = false;
            HashSet<String> numberSet = new HashSet<String>(8);
            for (int i = 0; i < ruleEntries.size(); ++i) {
                DynamicObject ruleEntry = (DynamicObject)ruleEntries.get(i);
                String c_number = ruleEntry.getString("c_number");
                String c_cardname = ruleEntry.getString("c_cardname");
                String c_accrualcontext = ruleEntry.getString("c_accrualcontext");
                DynamicObject c_accrualentityobj = ruleEntry.getDynamicObject("c_accrualentityobj");
                String c_agingstartdate = ruleEntry.getString("c_agingstartdate");
                DynamicObject c_aginggroup = ruleEntry.getDynamicObject("c_aginggroup");
                if (EmptyUtils.isNotEmpty((Object)c_number)) {
                    if (numberSet.contains(c_number)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u4fe1\u606f\u201c\u7f16\u7801\u201d \u503c \u201c%s\u201d \u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BadDebtAccrualPlanEdit_11", (String)"fi-ar-formplugin", (Object[])new Object[]{c_number}));
                    }
                    numberSet.add(c_number);
                }
                if (!EmptyUtils.isEmpty((Object)c_number) && !EmptyUtils.isEmpty((Object)c_cardname) && !EmptyUtils.isEmpty((Object)c_accrualcontext) && !EmptyUtils.isEmpty((Object)c_agingstartdate) && c_accrualentityobj != null && c_aginggroup != null) continue;
                isFault = true;
                if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                    errMsg.append('\u3001');
                }
                errMsg.append(i + 1);
            }
            if (isFault) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u5f20\u5361\u7247\u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BadDebtAccrualPlanEdit_6", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
            }
            StringBuilder accErrMsg = new StringBuilder();
            block1: for (int i = 0; i < ruleEntries.size(); ++i) {
                String jsonAccrualrate = (String)this.getModel().getValue("c_accrualrate_tag", i);
                List accrualRates = SerializationUtils.fromJsonStringToList((String)jsonAccrualrate, AccrualRateRow.class);
                for (AccrualRateRow row : accrualRates) {
                    BigDecimal accrualrate = row.getAccrualrate();
                    if (accrualrate != null && BigDecimal.ZERO.compareTo(accrualrate) != 0) continue;
                    isFault = true;
                    if (accErrMsg.length() > 0 && !"".equals(accErrMsg.toString())) {
                        accErrMsg.append('\u3001');
                    }
                    accErrMsg.append(i + 1);
                    continue block1;
                }
            }
            String saveFaultTitle = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"BadDebtAccrualPlanEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]);
            if (isFault) {
                this.getView().showConfirm(saveFaultTitle, ResManager.loadKDString((String)"\u7b2c%s\u5f20\u5361\u7247:\u201c\u9884\u671f\u635f\u5931\u7387\u201d\u5b58\u5728\u201c\u8ba1\u63d0\u6bd4\u7387\u201d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"BadDebtAccrualPlanEdit_9", (String)"fi-ar-formplugin", (Object[])new Object[]{accErrMsg.toString()}), MessageBoxOptions.OK, ConfirmTypes.Delete, new ConfirmCallBackListener());
                args.setCancel(true);
                return;
            }
            for (int i = 0; i < ruleEntries.size(); ++i) {
                String jsonOffset = (String)this.getModel().getValue("c_offset_tag", i);
                boolean includePeriod = (Boolean)this.getModel().getValue("c_includeperiod", i);
                if (jsonOffset == null || "".equals(jsonOffset)) continue;
                List accrualOffsetVos = SerializationUtils.fromJsonStringToList((String)jsonOffset, AccrualOffsetVo.class);
                for (AccrualOffsetVo accrualOffsetVo : accrualOffsetVos) {
                    String receivedfield = accrualOffsetVo.getReceivedfield();
                    String recbillfield = accrualOffsetVo.getRecbillfield();
                    String matchrelation = accrualOffsetVo.getMatchrelation();
                    String offsetbillfield = accrualOffsetVo.getOffsetbillfield();
                    String offsetedobj = accrualOffsetVo.getOffsetedObj();
                    if (!EmptyUtils.isEmpty((Object)recbillfield) && !EmptyUtils.isEmpty((Object)matchrelation) && !EmptyUtils.isEmpty((Object)offsetbillfield) && !EmptyUtils.isEmpty((Object)offsetedobj) && (!includePeriod || !EmptyUtils.isEmpty((Object)receivedfield))) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u5f20\u5361\u7247\u62b5\u6d88\u8bbe\u7f6e\u5b58\u5728\u5339\u914d\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BadDebtAccrualPlanEdit_7", (String)"fi-ar-formplugin", (Object[])new Object[]{i + 1}));
                }
            }
            MainEntityType entityType = null;
            ArrayList<String> errMsgList = new ArrayList<String>(8);
            for (int i = 0; i < ruleEntries.size(); ++i) {
                boolean isSame;
                DynamicObject ruleEntry = (DynamicObject)ruleEntries.get(i);
                DynamicObject c_accrualEntityObj = ruleEntry.getDynamicObject("c_accrualentityobj");
                String entityName = c_accrualEntityObj.getString("entityobject");
                if (!"ar_finarbill".equals(entityName)) continue;
                if (entityType == null) {
                    entityType = EntityMetadataCache.getDataEntityType((String)entityName);
                }
                if (isSame = BadDebtAccrualHelper.validateFinArBillPlanIsSameEntry((MainEntityType)entityType, (DynamicObject)ruleEntry)) continue;
                isFault = true;
                errMsgList.add(String.valueOf(i + 1));
            }
            if (isFault && !errMsgList.isEmpty()) {
                args.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7b2c%s\u5f20\u5361\u7247\uff0c\u8ba1\u63d0\u5bf9\u8c61\u4e3a\u8d22\u52a1\u5e94\u6536\u5355\u65f6\uff0c\u8d26\u9f84\u8d77\u7b97\u65e5\u548c\u8ba1\u63d0\u6761\u4ef6\u4e2d\u914d\u7f6e\u7684\u5b57\u6bb5\u4ec5\u652f\u6301\u5728\u8d22\u52a1\u5e94\u6536\u5355\u7684\u540c\u4e00\u5206\u5f55\u4e0a\uff08\u660e\u7ec6\u6216\u6536\u6b3e\u8ba1\u5212\uff09\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"BadDebtAccrualPlanEdit_12", (String)"fi-ar-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", errMsgList)}), MessageBoxOptions.OK, ConfirmTypes.Delete, new ConfirmCallBackListener());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if ("newentryforoffset".equals(operateKey)) {
            int offsetEntrySize = this.getModel().getEntryRowCount("offsetentry");
            String offsetedObj = (String)this.getModel().getValue("offsetedobj");
            offsetedObj = offsetedObj.contains("ar_busbill") ? "ar_busbill" : "ar_revcfmbill";
            this.getModel().setValue("o_offsetedobj", (Object)offsetedObj, offsetEntrySize - 1);
        }
        if (operationResult != null && operationResult.isSuccess() && "disable".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
        if (operationResult != null && operationResult.isSuccess() && "save".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("refresh".equals(operateKey)) {
            int ruleEntry = this.getModel().getEntryCurrentRowIndex("ruleentry");
            this.getPageCache().put("currentCardRow", String.valueOf(ruleEntry));
            this.setRightLapInfoFromCard(ruleEntry);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int currentRow;
        boolean isCacheRowNotNull;
        int rowIndex = evt.getRow();
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        String currentCardRow = this.getPageCache().get("currentCardRow");
        boolean bl = isCacheRowNotNull = currentCardRow != null && !"".equals(currentCardRow);
        if (!OperationStatus.VIEW.equals((Object)opStatus) && isCacheRowNotNull) {
            currentRow = Integer.parseInt(currentCardRow);
            int ruleentry = this.getModel().getEntryRowCount("ruleentry");
            if (currentRow != rowIndex && currentRow < ruleentry) {
                this.putRuleRowData(currentRow);
            }
        }
        if (isCacheRowNotNull && (currentRow = Integer.parseInt(currentCardRow)) == rowIndex) {
            return;
        }
        this.getPageCache().put("currentCardRow", String.valueOf(rowIndex));
        this.setRightLapInfoFromCard(rowIndex);
    }

    private void putRuleRowData(int cardIndex) {
        String number = (String)this.getModel().getValue("rulenumber");
        this.getModel().setValue("c_number", (Object)number, cardIndex);
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("rulename");
        this.getModel().setValue("c_cardname", (Object)name, cardIndex);
        String accrualcontext = (String)this.getModel().getValue("accrualcontext");
        this.getModel().setValue("c_accrualcontext", (Object)accrualcontext, cardIndex);
        String agingstartdatefield = (String)this.getModel().getValue("agingstartdatefield");
        this.getModel().setValue("c_agingstartdate", (Object)agingstartdatefield, cardIndex);
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue("accrualobject");
        this.getModel().setValue("c_accrualentityobj", (Object)entityObject, cardIndex);
        String remark = (String)this.getModel().getValue("remark");
        this.getModel().setValue("c_remark", (Object)remark, cardIndex);
        DynamicObject aginggroup = (DynamicObject)this.getModel().getValue("aginggroup");
        this.getModel().setValue("c_aginggroup", (Object)aginggroup, cardIndex);
        String offset = (String)this.getModel().getValue("offset");
        this.getModel().setValue("c_offset", (Object)offset, cardIndex);
        boolean includeperiod = (Boolean)this.getModel().getValue("includeperiod");
        this.getModel().setValue("c_includeperiod", (Object)includeperiod, cardIndex);
        String offsetremark = (String)this.getModel().getValue("offsetremark");
        this.getModel().setValue("c_offsetremark", (Object)offsetremark, cardIndex);
        if (entityObject != null) {
            String entityName = entityObject.getString("entityobject");
            CRCondition conditionObj = new CRCondition();
            Iterator filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            conditionObj.setFilterCondition(filterGridState.getFilterCondition());
            try {
                String tranExpr = this.tranFormula(conditionObj, entityName);
                conditionObj.setExprTran(tranExpr);
            }
            catch (FormulaException exp) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"BadDebtAccrualPlanEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
            }
            catch (Exception exp) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"BadDebtAccrualPlanEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), exp.getMessage()));
            }
            String exprission = SerializationUtils.toJsonString((Object)conditionObj);
            this.getModel().setValue("c_condition_tag", (Object)exprission, cardIndex);
        }
        ArrayList<AccrualOffsetVo> accrualOffsetVos = new ArrayList<AccrualOffsetVo>(8);
        DynamicObjectCollection offsetEntrys = this.getModel().getEntryEntity("offsetentry");
        for (DynamicObject offsetEntry : offsetEntrys) {
            String receivedField = offsetEntry.getString("o_receivedfield");
            String recBillField = offsetEntry.getString("o_recbillfield");
            String matchRelation = offsetEntry.getString("o_matchrelation");
            String offsetBillField = offsetEntry.getString("o_offsetbillfield");
            boolean isNullMatch = offsetEntry.getBoolean("o_isnullmatch");
            AccrualOffsetVo accrualOffsetVo = new AccrualOffsetVo(receivedField, recBillField, matchRelation, offsetBillField, isNullMatch);
            accrualOffsetVo.setReceivedsite(this.getFieldSite(receivedField));
            accrualOffsetVo.setRecbillsite(this.getFieldSite(recBillField));
            accrualOffsetVo.setOffsetbillsite(this.getFieldSite(offsetBillField));
            accrualOffsetVo.setOffsetedObj(offsetEntry.getString("o_offsetedobj"));
            accrualOffsetVos.add(accrualOffsetVo);
        }
        String jsonOffset = SerializationUtils.toJsonString(accrualOffsetVos);
        this.getModel().setValue("c_offset_tag", (Object)jsonOffset, cardIndex);
        ArrayList<AccrualRateRow> accrualRates = new ArrayList<AccrualRateRow>(8);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entrys) {
            String section = entry.getString("e_section");
            boolean isDayMore = entry.getBoolean("e_isdaymore");
            int startDay = entry.getInt("e_startday");
            int endDay = entry.getInt("e_endday");
            int entrySeq = entry.getInt("seq");
            int endYear = entry.getInt("e_endyear");
            BigDecimal accrualRate = entry.getBigDecimal("e_accrualrate");
            AccrualRateRow accrualRateRow = new AccrualRateRow(entrySeq, section, isDayMore, startDay, endDay, accrualRate, endYear);
            accrualRates.add(accrualRateRow);
        }
        String jsonRate = SerializationUtils.toJsonString(accrualRates);
        this.getModel().setValue("c_accrualrate_tag", (Object)jsonRate, cardIndex);
    }

    private String getFieldSite(String field) {
        String temp = field != null && field.contains(".") ? field.split("\\.")[0] : "";
        return temp;
    }

    public String tranFormula(CRCondition formulaObj, String entityNumber) {
        String tranExpr = "";
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return tranExpr;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = formulaObj.getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>(2);
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)"\u4e14", (String)"BadDebtAccrualPlanEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }

    private void setRightLapInfoFromCard(int cardIndex) {
        DynamicObject accualobj;
        boolean isAccrualObjNull;
        String rulenumber = (String)this.getModel().getValue("c_number", cardIndex);
        this.getModel().setValue("rulenumber", (Object)rulenumber);
        OrmLocaleValue rulename = (OrmLocaleValue)this.getModel().getValue("c_cardname", cardIndex);
        this.getModel().setValue("rulename", (Object)rulename);
        String localeValue = rulename.getLocaleValue();
        if (localeValue != null && !"".equals(localeValue)) {
            this.getModel().setValue("c_titlename", (Object)localeValue, cardIndex);
        }
        boolean bl = isAccrualObjNull = (accualobj = (DynamicObject)this.getModel().getValue("c_accrualentityobj", cardIndex)) != null;
        if (isAccrualObjNull) {
            String entityName = accualobj.getString("entityobject");
            this.getModel().setValue("accrualobject", (Object)accualobj);
            String agingstartdatefield = (String)this.getModel().getValue("c_agingstartdate", cardIndex);
            this.setContrastFieldValues(entityName, true, "agingstartdatefield", false);
            this.getModel().setValue("agingstartdatefield", (Object)agingstartdatefield);
        } else {
            this.getModel().setValue("agingstartdatefield", null);
            ComboEdit fieldCombo = (ComboEdit)this.getControl("agingstartdatefield");
            fieldCombo.setComboItems(null);
        }
        String accrualcontext = (String)this.getModel().getValue("c_accrualcontext", cardIndex);
        this.getModel().setValue("accrualcontext", (Object)accrualcontext);
        String remark = (String)this.getModel().getValue("c_remark", cardIndex);
        this.getModel().setValue("remark", (Object)remark);
        String conditionJson = (String)this.getModel().getValue("c_condition_tag", cardIndex);
        if (isAccrualObjNull && conditionJson != null && !"".equals(conditionJson)) {
            String entityName = accualobj.getString("entityobject");
            this.setFilterGrid(entityName, conditionJson);
        } else {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.SetValue(new FilterCondition());
        }
        DynamicObject aginggroup = (DynamicObject)this.getModel().getValue("c_aginggroup", cardIndex);
        if (aginggroup != null) {
            this.getPageCache().put("isF7Select", "0");
            this.getModel().setValue("aginggroup", (Object)aginggroup);
            String jsonRate = (String)this.getModel().getValue("c_accrualrate_tag", cardIndex);
            List accrualRates = SerializationUtils.fromJsonStringToList((String)jsonRate, AccrualRateRow.class);
            int entryentity = this.getModel().getEntryRowCount("entryentity");
            if (entryentity > 0) {
                this.getModel().deleteEntryData("entryentity");
            }
            if ("1".equals(aginggroup.getString("groupbasis"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"e_endyear"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_endyear"});
            }
            for (AccrualRateRow accrualRateRow : accrualRates) {
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("e_section", (Object)accrualRateRow.getSection(), accrualRateRow.getSeq());
                this.getModel().setValue("e_isdaymore", (Object)accrualRateRow.isDaymore(), accrualRateRow.getSeq());
                this.getModel().setValue("e_startday", (Object)accrualRateRow.getStartdays(), accrualRateRow.getSeq());
                this.getModel().setValue("e_endday", (Object)accrualRateRow.getEnddays(), accrualRateRow.getSeq());
                this.getModel().setValue("e_endyear", (Object)accrualRateRow.getEndyear(), accrualRateRow.getSeq());
                this.getModel().setValue("e_accrualrate", (Object)accrualRateRow.getAccrualrate(), accrualRateRow.getSeq());
            }
        }
        this.setAccrualOffset(cardIndex);
    }

    private void setFilterGridBasic(String entityName) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        filterGrid.getFilterGridState().getFilterCondition().getFilterRow().clear();
        filterGrid.setEntityNumber(entityName);
    }

    private void setFilterGridValue(String conditionJson) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
        FilterCondition filterCondition = conditionObj.getFilterCondition();
        filterGrid.SetValue(filterCondition);
    }

    private void setFilterGrid(String entityName, String conditionJson) {
        this.setFilterGridBasic(entityName);
        this.getView().updateView("filtergrid");
        this.setFilterGridValue(conditionJson);
    }

    private void setContrastFieldValues(String entityName, boolean inFieldProp, String field, boolean isOnlyMainEntityField) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        List filterFields = EntityTypeUtil.getInstance().getFilterFields((IDataEntityType)entityType, isOnlyMainEntityField);
        if (inFieldProp) {
            for (FilterField filterField : filterFields) {
                String parentName;
                IDataEntityProperty fieldProp = filterField.getFieldProp();
                if (!(fieldProp instanceof DateProp) || "ar_busbill".equals(entityName) && "planentity".equals(parentName = fieldProp.getParent().getName())) continue;
                LocaleString caption = filterField.getCaption();
                ComboItem item = new ComboItem(caption, filterField.getFullFieldName());
                items.add(item);
            }
        } else {
            for (FilterField filterField : filterFields) {
                LocaleString caption = filterField.getCaption();
                ComboItem item = new ComboItem(caption, filterField.getFieldName());
                items.add(item);
            }
        }
        ComboEdit fieldCombo = (ComboEdit)this.getControl(field);
        fieldCombo.setComboItems(items);
    }

    private void setAccrualAging(DynamicObject aging) {
        if (aging == null) {
            return;
        }
        int entryentity = this.getModel().getEntryRowCount("entryentity");
        if (entryentity > 0) {
            this.getModel().deleteEntryData("entryentity");
        }
        if ("1".equals(aging.getString("groupbasis"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_endyear"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_endyear"});
        }
        DynamicObjectCollection lagings = aging.getDynamicObjectCollection("entry");
        for (DynamicObject laging : lagings) {
            int newrow = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("e_section", (Object)laging.getString("e_section"), newrow);
            this.getModel().setValue("e_isdaymore", (Object)laging.getString("e_isdaymore"), newrow);
            this.getModel().setValue("e_startday", (Object)laging.getString("e_startday"), newrow);
            this.getModel().setValue("e_endday", (Object)laging.getString("e_endday"), newrow);
            this.getModel().setValue("e_endyear", (Object)laging.getString("e_endyear"), newrow);
        }
    }

    private void setAccrualOffset(int cardIndex) {
        this.getModel().deleteEntryData("offsetentry");
        String offset = (String)this.getModel().getValue("c_offset", cardIndex);
        String offsetremark = (String)this.getModel().getValue("c_offsetremark", cardIndex);
        boolean includePeriod = (Boolean)this.getModel().getValue("c_includeperiod", cardIndex);
        this.setFieldList("ar_receivedbill", "o_receivedfield");
        this.setFieldList("cas_recbill", "o_recbillfield");
        if ("0".equals(offset)) {
            this.setFieldList("ar_revcfmbill", "o_offsetbillfield");
        } else if ("1".equals(offset)) {
            this.setFieldList("ar_busbill", "o_offsetbillfield");
        }
        this.getModel().setValue("offset", (Object)offset);
        this.getModel().setValue("offsetremark", (Object)offsetremark);
        this.getModel().setValue("includeperiod", (Object)includePeriod);
        String jsonOffset = (String)this.getModel().getValue("c_offset_tag", cardIndex);
        if (jsonOffset != null && !"".equals(jsonOffset)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            List accrualOffsetVos = SerializationUtils.fromJsonStringToList((String)jsonOffset, AccrualOffsetVo.class);
            TableValueSetter vs = new TableValueSetter(new String[]{"o_receivedfield", "o_recbillfield", "o_matchrelation", "o_offsetbillfield", "o_isnullmatch", "o_offsetedobj"});
            for (AccrualOffsetVo accrualOffsetVo : accrualOffsetVos) {
                String receivedfield = accrualOffsetVo.getReceivedfield();
                String recbillfield = accrualOffsetVo.getRecbillfield();
                String matchrelation = accrualOffsetVo.getMatchrelation();
                String offsetbillfield = accrualOffsetVo.getOffsetbillfield();
                boolean isnullmatch = accrualOffsetVo.isNullmatch();
                String offsetedobj = accrualOffsetVo.getOffsetedObj();
                vs.addRow(new Object[]{receivedfield, recbillfield, matchrelation, offsetbillfield, isnullmatch, offsetedobj});
            }
            model.batchCreateNewEntryRow("offsetentry", vs);
        }
    }

    private List<String> getRuleNumber(String operation) {
        DynamicObjectCollection ruleentry = this.getModel().getEntryEntity("ruleentry");
        ArrayList<String> ruleNumbers = new ArrayList<String>(ruleentry.size());
        for (DynamicObject row : ruleentry) {
            ruleNumbers.add(row.getString("c_number"));
        }
        if ("modify".equals(operation)) {
            int selectRowIndex = this.getModel().getEntryCurrentRowIndex("ruleentry");
            ruleNumbers.remove(this.getModel().getValue("c_number", selectRowIndex));
        }
        return ruleNumbers;
    }

    private void setFieldList(String entityKey, String field) {
        List properties = EntityMetadataUtils.getProperties((String)entityKey);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(properties.size());
        for (IDataEntityProperty prop : properties) {
            String alias;
            LocaleString displayName = prop.getDisplayName();
            if (displayName == null || EmptyUtils.isEmpty((Object)prop.getParent()) || EmptyUtils.isEmpty((Object)(alias = prop.getAlias()))) continue;
            String parentName = prop.getParent().getName();
            String fieldName = prop.getName();
            if (!entityKey.equals(parentName)) {
                StringBuilder temp = new StringBuilder();
                temp.append(parentName);
                temp.append('.');
                temp.append(fieldName);
                LocaleString dis = new LocaleString(displayName.getLocaleValue() + "(" + temp + ")");
                items.add(new ComboItem(dis, temp.toString()));
                continue;
            }
            LocaleString dis = new LocaleString(displayName.getLocaleValue() + "(" + fieldName + ")");
            items.add(new ComboItem(dis, prop.getName()));
        }
        ComboEdit edit = (ComboEdit)this.getControl(field);
        edit.setComboItems(items.stream().distinct().collect(Collectors.toList()));
    }
}

