/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.baddebtnew;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.business.service.baddebtnew.BadDebtAccrualService;
import kd.fi.ar.helper.BadDebtAccrualHelper;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.AccrualRateRow;
import kd.fi.ar.vo.baddebtnew.AccrualResult;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class BadDebtAccrueEdit
extends AbstractFormPlugin {
    protected static final Log logger = LogFactory.getLog(BadDebtAccrueEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "e_extfilterdes"});
        BasedataEdit accrualSchemeF7 = (BasedataEdit)this.getControl("p_accrualscheme");
        accrualSchemeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int row = this.getModel().getEntryCurrentRowIndex("planentry");
            DynamicObject org = (DynamicObject)this.getModel().getValue("p_org", row);
            ArrayList param = new ArrayList(8);
            Map pageCacheAll = this.getPageCache().getAll();
            if (org == null) {
                for (Long orgId : this.getOrgIds()) {
                    param.addAll(SerializationUtils.fromJsonStringToList((String)((String)pageCacheAll.get(orgId.toString() + "planIds")), Long.class));
                }
            } else {
                param.addAll(SerializationUtils.fromJsonStringToList((String)((String)pageCacheAll.get(org.getString("id") + "planIds")), Long.class));
            }
            QFilter idFilter = new QFilter("id", "in", param);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(idFilter);
        });
        BasedataEdit agingGroupF7 = (BasedataEdit)this.getControl("aginggroup");
        agingGroupF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Set<Long> orgIds = this.getOrgIds();
            HashSet param = new HashSet(8);
            HashMap<String, String> agingIdsCacheMap = new HashMap<String, String>(8);
            for (Long orgId : orgIds) {
                DynamicObjectCollection accrualAgings = BaseDataServiceHelper.queryBaseData((String)"ar_accrualaging", (Long)orgId, (QFilter)new QFilter("enable", "=", (Object)"1").and(new QFilter("grouptype", "ftlike", (Object)"0")), (String)"id");
                List agingIds = accrualAgings.stream().map(aging -> aging.getLong("id")).collect(Collectors.toList());
                param.addAll(agingIds);
                agingIdsCacheMap.put(orgId.toString() + "agingIds", SerializationUtils.toJsonString(agingIds));
            }
            this.getPageCache().put(agingIdsCacheMap);
            QFilter idFilter = new QFilter("id", "in", param);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(idFilter);
        });
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("p_org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Set<Long> param = this.getOrgIds();
            int row = this.getModel().getEntryCurrentRowIndex("planentry");
            DynamicObject accrualScheme = (DynamicObject)this.getModel().getValue("p_accrualscheme", row);
            if (accrualScheme != null) {
                Long schemeId = accrualScheme.getLong("id");
                Iterator<Long> iterator = param.iterator();
                Map pageCacheAll = this.getPageCache().getAll();
                while (iterator.hasNext()) {
                    Long orgId = iterator.next();
                    List schemeIds = SerializationUtils.fromJsonStringToList((String)((String)pageCacheAll.get(orgId.toString() + "planIds")), Long.class);
                    if (schemeIds != null) {
                        if (schemeIds.contains(schemeId)) continue;
                        iterator.remove();
                        continue;
                    }
                    iterator.remove();
                }
            }
            QFilter idFilter = new QFilter("id", "in", param);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(idFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.activeTab("tabpageap4");
        if (OperationStatus.EDIT.equals((Object)status)) {
            DynamicObjectCollection accrualagings;
            List multyorg = (List)formShowParameter.getCustomParam("multyorg");
            if (ObjectUtils.isEmpty((Object)multyorg)) {
                return;
            }
            Object period = formShowParameter.getCustomParam("period");
            String periodName = ResManager.loadKDString((String)"\u671f\u521d", (String)"BadDebtAccrueEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]);
            if (EmptyUtils.isNotEmpty((Object)period)) {
                periodName = (String)formShowParameter.getCustomParam("periodname");
            }
            Boolean isPeriod = (Boolean)formShowParameter.getCustomParam("isperiod");
            Object exratetable = formShowParameter.getCustomParam("exratetable");
            this.getModel().setValue("multyorg", (Object)multyorg.toArray());
            this.getModel().setValue("period", period);
            this.getModel().setValue("isperiod", (Object)isPeriod);
            this.getModel().setValue("listperiod", (Object)periodName);
            this.getModel().setValue("exratetable", exratetable);
            this.getModel().setValue("exratedate", (Object)this.getPeriodEndDate());
            long currentOrg = RequestContext.get().getOrgId();
            DynamicObject accrualaging = null;
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            QFilter defaultFilter = new QFilter("isdefault", "=", (Object)"1");
            QFilter groupFilter = new QFilter("grouptype", "ftlike", (Object)"0");
            if (multyorg.contains(currentOrg)) {
                accrualagings = BaseDataServiceHelper.queryBaseData((String)"ar_accrualaging", (Long)currentOrg, (QFilter)filter.and(defaultFilter).and(groupFilter), (String)"id");
                if (accrualagings != null && !accrualagings.isEmpty()) {
                    accrualaging = (DynamicObject)accrualagings.get(0);
                }
            } else {
                accrualagings = BaseDataServiceHelper.queryBaseData((String)"ar_accrualaging", (Long)Long.parseLong(multyorg.get(0).toString()), (QFilter)filter.and(defaultFilter).and(groupFilter), (String)"id");
                if (accrualagings != null && !accrualagings.isEmpty()) {
                    accrualaging = (DynamicObject)accrualagings.get(0);
                }
            }
            if (accrualaging != null) {
                DynamicObject aging = BusinessDataServiceHelper.loadSingleFromCache((Object)accrualaging.getLong("id"), (String)"ar_accrualaging");
                this.getModel().setValue("aginggroup", (Object)aging.getLong("id"));
                this.setAccrualAging(aging);
            }
            HashMap<String, String> planIdsCacheMap = new HashMap<String, String>(8);
            for (Object orgId : multyorg) {
                Long id = Long.parseLong(orgId.toString());
                DynamicObjectCollection baddebtAccrualPlans = BaseDataServiceHelper.queryBaseData((String)"ar_baddebtaccrualplan", (Long)id, (QFilter)new QFilter("enable", "=", (Object)"1"), (String)"id,accrualmethod,accrualfrequency");
                for (DynamicObject plan : baddebtAccrualPlans) {
                    long planId = plan.getLong("id");
                    int newrow = this.getModel().createNewEntryRow("planentry");
                    this.getModel().setValue("p_org", (Object)id, newrow);
                    this.getModel().setValue("p_accrualscheme", (Object)planId, newrow);
                    this.getModel().setValue("p_accrualmethod", (Object)plan.getString("accrualmethod"), newrow);
                    this.getModel().setValue("p_accrualfrequency", (Object)plan.getString("accrualfrequency"), newrow);
                }
                ArrayList<Long> planIds = new ArrayList<Long>(8);
                for (DynamicObject plan : baddebtAccrualPlans) {
                    planIds.add(plan.getLong("id"));
                }
                planIdsCacheMap.put(id.toString() + "planIds", SerializationUtils.toJsonString(planIds));
            }
            this.getPageCache().put(planIdsCacheMap);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("e_extfilterdes".equals(key)) {
            int rowCount = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject accrualObj = (DynamicObject)this.getModel().getValue("e_accrualobj", rowCount);
            if (accrualObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u672c\u884c\u7684\u201c\u8ba1\u63d0\u5bf9\u8c61\u201d\u3002", (String)"BadDebtAccrueEdit_17", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityName = accrualObj.getString("entityobject");
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
            String fldNodes = SerializationUtils.toJsonString((Object)srcBillNode);
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("e_extfilter");
            String conditionJson = (String)this.getModel().getValue(largeTextEdit.getTagFieldKey());
            this.showConditionForm(conditionJson, mainType.getName(), false, fldNodes, key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("e_extfilterdes".equals(actionId)) {
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("e_extfilter");
            if (StringUtils.isNotBlank((CharSequence)returnData)) {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
                this.getModel().setValue(largeTextEdit.getTagFieldKey(), (Object)returnData);
                if (condition.getExprDesc().length() > 255) {
                    this.getModel().setValue(actionId, (Object)condition.getExprDesc().substring(0, 255));
                } else {
                    this.getModel().setValue(actionId, (Object)condition.getExprDesc());
                }
            }
        }
    }

    private void setAccrualAging(DynamicObject aging) {
        if (aging == null) {
            return;
        }
        int entryentity = this.getModel().getEntryRowCount("agingentry");
        if (entryentity > 0) {
            this.getModel().deleteEntryData("agingentry");
        }
        if ("1".equals(aging.getString("groupbasis"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"a_endyear"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"a_endyear"});
        }
        DynamicObjectCollection lagings = aging.getDynamicObjectCollection("entry");
        for (DynamicObject laging : lagings) {
            int newrow = this.getModel().createNewEntryRow("agingentry");
            this.getModel().setValue("a_section", (Object)laging.getString("e_section"), newrow);
            this.getModel().setValue("a_isdaymore", (Object)laging.getString("e_isdaymore"), newrow);
            this.getModel().setValue("a_startday", (Object)laging.getString("e_startday"), newrow);
            this.getModel().setValue("a_endday", (Object)laging.getString("e_endday"), newrow);
            this.getModel().setValue("a_endyear", (Object)laging.getString("e_endyear"), newrow);
        }
    }

    private Date getPeriodEndDate() {
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (EmptyUtils.isNotEmpty((Object)period)) {
            return period.getDate("enddate");
        }
        return new Date();
    }

    private Set<Long> getOrgIds() {
        DynamicObjectCollection multyOrg = (DynamicObjectCollection)this.getModel().getValue("multyorg");
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject org : multyOrg) {
            orgIds.add((Long)org.getDynamicObject("fbasedataid").getPkValue());
        }
        return orgIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("aginggroup".equals(key)) {
            DynamicObject aginggroup = (DynamicObject)this.getModel().getValue("aginggroup");
            if (aginggroup != null) {
                DynamicObjectCollection multyOrg = (DynamicObjectCollection)this.getModel().getValue("multyorg");
                StringBuilder errMsg = new StringBuilder();
                Map pageCacheAll = this.getPageCache().getAll();
                for (DynamicObject org : multyOrg) {
                    Long orgId = (Long)org.getDynamicObject("fbasedataid").getPkValue();
                    List agingIds = SerializationUtils.fromJsonStringToList((String)((String)pageCacheAll.get(orgId.toString() + "agingIds")), Long.class);
                    if (agingIds.contains(aginggroup.getLong("id"))) continue;
                    if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                        errMsg.append('\u3001');
                    }
                    errMsg.append(org.getDynamicObject("fbasedataid").getString("name"));
                }
                if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u9f84\u5206\u7ec4\u5728%s\u4e0b\u65e0\u4f7f\u7528\u6743\uff0c\u8bf7\u4fee\u6539\u8d26\u9f84\u5206\u7ec4\u6216\u91cd\u65b0\u8bbe\u7f6e\u8d26\u9f84\u5206\u7ec4\u7684\u5206\u914d\u6743\u9650\u3002", (String)"BadDebtAccrueEdit_14", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
                    this.getModel().setValue("aginggroup", null);
                    return;
                }
            }
            if (newValue != null) {
                DynamicObject agingIdDO = (DynamicObject)newValue;
                DynamicObject aging = BusinessDataServiceHelper.loadSingleFromCache((Object)agingIdDO.getLong("id"), (String)"ar_accrualaging");
                this.setAccrualAging(aging);
            } else {
                this.getModel().deleteEntryData("agingentry");
            }
        }
        if ("p_accrualscheme".equals(key)) {
            if (newValue != null) {
                DynamicObject schemeDO = (DynamicObject)newValue;
                this.getModel().setValue("p_accrualmethod", (Object)schemeDO.getString("accrualmethod"));
                this.getModel().setValue("p_accrualfrequency", (Object)schemeDO.getString("accrualfrequency"));
            } else {
                this.getModel().setValue("p_accrualmethod", null);
                this.getModel().setValue("p_accrualfrequency", null);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        String key = op.getOperateKey();
        if ("btn_ok".equals(key)) {
            DynamicObject accrualScheme;
            DynamicObject accrualScheme2;
            this.validateField();
            Set<Long> orgIds = this.getOrgIds();
            Map<Long, String> orgNameMap = this.getOrgNameMap();
            Long periodId = 0L;
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            if (period != null) {
                periodId = period.getLong("id");
            }
            Map orgAndPreperiodMap = (Map)this.getView().getFormShowParameter().getCustomParam("preperiodId");
            boolean isPeriod = (Boolean)this.getModel().getValue("isperiod");
            DynamicObject exrateTable = (DynamicObject)this.getModel().getValue("exratetable");
            Date exrateDate = (Date)this.getModel().getValue("exratedate");
            Long exrateTableId = exrateTable.getLong("id");
            Map settleModelMap = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, new ArrayList<Long>(orgIds), (String)"ar_003");
            ArrayList<DynamicObject> individualSchemes = new ArrayList<DynamicObject>(8);
            int rowCount = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < rowCount; ++i) {
                Object tempObject = this.getModel().getValue("e_accrualobj", i);
                if (tempObject == null) continue;
                DynamicObject accrualObject = (DynamicObject)tempObject;
                String entityObject = accrualObject.getString("entityobject");
                Object accrualFilter = this.getIndividualFilter(i);
                QFilter extFilter = this.getExtFilter(entityObject, i, settleModelMap, orgNameMap);
                if (accrualFilter == null) {
                    accrualFilter = extFilter;
                } else if (extFilter != null) {
                    accrualFilter.and(extFilter);
                }
                if (accrualFilter == null) continue;
                accrualScheme2 = new AccrualScheme();
                accrualScheme2.setAccrualType("1");
                accrualScheme2.setEntityKey(entityObject);
                accrualScheme2.setAccrualObjId(Long.valueOf(accrualObject.getLong("id")));
                accrualScheme2.setIndividualReason((String)this.getModel().getValue("e_individualreason", i));
                accrualScheme2.setCondition((QFilter)accrualFilter);
                accrualScheme2.setIndividual(true);
                accrualScheme2.setAccrualPercentForIndividual((BigDecimal)this.getModel().getValue("e_accrualrate", i));
                accrualScheme2.setOffset(false);
                individualSchemes.add(accrualScheme2);
            }
            HashMap orgIdAndSchemesMap = new HashMap(8);
            HashMap<Long, String> orgIdAndFrequencyMap = new HashMap<Long, String>(8);
            DynamicObjectCollection planEntries = (DynamicObjectCollection)this.getModel().getValue("planentry");
            HashSet<Long> schemeIds = new HashSet<Long>(8);
            for (DynamicObject entry : planEntries) {
                accrualScheme2 = entry.getDynamicObject("p_accrualscheme");
                schemeIds.add(accrualScheme2.getLong("id"));
            }
            Map schemeIdAndDOMap = BusinessDataServiceHelper.loadFromCache((Object[])schemeIds.toArray(), (String)"ar_baddebtaccrualplan");
            MainEntityType entityType = null;
            HashSet<String> errorPlanRow = new HashSet<String>(8);
            int planRowCount = 0;
            for (DynamicObject entry : planEntries) {
                ++planRowCount;
                DynamicObject org = entry.getDynamicObject("p_org");
                Long orgId = org.getLong("id");
                Object accrualSchemeId = entry.get("p_accrualscheme.id");
                accrualScheme = (DynamicObject)schemeIdAndDOMap.get(accrualSchemeId);
                boolean isMaterialSettle = "1".equals(settleModelMap.get(orgId));
                DynamicObjectCollection ruleEntries = accrualScheme.getDynamicObjectCollection("ruleentry");
                for (int i = 0; i < ruleEntries.size(); ++i) {
                    boolean isMatch;
                    DynamicObject ruleEntry = (DynamicObject)ruleEntries.get(i);
                    DynamicObject c_accrualEntityObj = ruleEntry.getDynamicObject("c_accrualentityobj");
                    String entityName = c_accrualEntityObj.getString("entityobject");
                    if (!"ar_finarbill".equals(entityName)) continue;
                    if (entityType == null) {
                        entityType = EntityMetadataCache.getDataEntityType((String)entityName);
                    }
                    if (isMatch = BadDebtAccrualHelper.validateSchemeFieldIsMatchOrgSettleModel((MainEntityType)entityType, (DynamicObject)ruleEntry, (boolean)isMaterialSettle)) continue;
                    errorPlanRow.add(String.valueOf(planRowCount));
                    break;
                }
                List<AccrualScheme> schemesParam = this.convertSchemeParam(accrualScheme);
                ArrayList<AccrualScheme> schemes = (ArrayList<AccrualScheme>)orgIdAndSchemesMap.get(orgId);
                String accrualFrequency = accrualScheme.getString("accrualfrequency");
                if (schemes == null) {
                    schemes = new ArrayList<AccrualScheme>(8);
                    schemes.addAll(schemesParam);
                    orgIdAndSchemesMap.put(orgId, schemes);
                    orgIdAndFrequencyMap.put(orgId, accrualFrequency);
                    continue;
                }
                if (accrualFrequency.equals(orgIdAndFrequencyMap.get(orgId))) {
                    schemes.addAll(schemesParam);
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\uff0c\u5206\u7ec4\u8ba4\u5b9a\u9875\u7b7e\u4e2d\u5b58\u5728\u8ba1\u63d0\u9891\u7387\u4e0d\u540c\u7684\u8ba1\u63d0\u65b9\u6848\uff0c\u65e0\u6cd5\u540c\u65f6\u8ba1\u63d0\u3002", (String)"BadDebtAccrueEdit_11", (String)"fi-ar-formplugin", (Object[])new Object[]{org.getString("name")}));
            }
            if (!errorPlanRow.isEmpty()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u7ec4\u8ba4\u5b9a\u7b2c%s\u884c\uff1a\u8ba1\u63d0\u65b9\u6848\u4e2d\uff0c\u8ba1\u63d0\u5bf9\u8c61\u4e3a\u8d22\u52a1\u5e94\u6536\u5355\u7684\u89c4\u5219\uff0c\u8d26\u9f84\u8d77\u7b97\u65e5\u548c\u8ba1\u63d0\u6761\u4ef6\u4e2d\u914d\u7f6e\u7684\u5206\u5f55\u5b57\u6bb5\uff08\u660e\u7ec6\u6216\u6536\u6b3e\u8ba1\u5212\uff09\u9700\u8981\u4e0e\u7ec4\u7ec7\u7684\u7ed3\u7b97\u6a21\u578b\u5bf9\u5e94\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BadDebtAccrueEdit_15", (String)"fi-ar-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", errorPlanRow)}), MessageBoxOptions.OK, ConfirmTypes.Delete, new ConfirmCallBackListener());
                return;
            }
            ArrayList<DynamicObject> expectSchemes = new ArrayList<DynamicObject>(8);
            DynamicObjectCollection accrualObjs = (DynamicObjectCollection)this.getModel().getValue("accrualobject");
            if (accrualObjs != null && accrualObjs.size() > 0) {
                for (DynamicObject obj : accrualObjs) {
                    DynamicObject acccrualObj = obj.getDynamicObject("fbasedataid");
                    accrualScheme = new AccrualScheme();
                    accrualScheme.setAccrualType("3");
                    accrualScheme.setEntityKey(acccrualObj.getString("entityobject"));
                    accrualScheme.setAccrualObjId(Long.valueOf(acccrualObj.getLong("id")));
                    accrualScheme.setOffset(false);
                    HashMap<Integer, String> agingRange = new HashMap<Integer, String>(8);
                    HashMap<Integer, BigDecimal> accrualPercentForScheme = new HashMap<Integer, BigDecimal>(8);
                    int agingEntryRow = this.getModel().getEntryRowCount("agingentry");
                    int agingStartDay = Integer.MAX_VALUE;
                    for (int i = 0; i < agingEntryRow; ++i) {
                        Integer aEndDay = (Integer)this.getModel().getValue("a_endday", i);
                        BigDecimal aPercent = (BigDecimal)this.getModel().getValue("a_percent", i);
                        boolean isDayMore = (Boolean)this.getModel().getValue("a_isdaymore", i);
                        String aSection = (String)this.getModel().getValue("a_section", i);
                        int startDays = (Integer)this.getModel().getValue("a_startday", i);
                        if (startDays < agingStartDay) {
                            agingStartDay = startDays;
                        }
                        if (isDayMore) {
                            agingRange.put(Integer.MAX_VALUE, aSection);
                            accrualPercentForScheme.put(Integer.MAX_VALUE, aPercent);
                            break;
                        }
                        agingRange.put(aEndDay, aSection);
                        accrualPercentForScheme.put(aEndDay, aPercent);
                    }
                    accrualScheme.setAgingRange(agingRange);
                    accrualScheme.setAccrualPercentForScheme(accrualPercentForScheme);
                    accrualScheme.setAgingStartDay(agingStartDay);
                    expectSchemes.add(accrualScheme);
                }
            }
            ArrayList<AccrualResult> results = new ArrayList<AccrualResult>(8);
            try {
                for (Long orgId : orgIds) {
                    ArrayList<DynamicObject> schemeList = new ArrayList<DynamicObject>(16);
                    Long nextPeriodId = 0L;
                    String nextPeriodName = null;
                    List schemeObjects = (List)orgIdAndSchemesMap.get(orgId);
                    if (!isPeriod) {
                        DynamicObject nextPeriod = schemeObjects == null || schemeObjects.size() == 0 ? BadDebtAccrualHelper.getNextAccrualPeriod((Long)periodId, (String)"month") : BadDebtAccrualHelper.getNextAccrualPeriod((Long)periodId, (String)((AccrualScheme)schemeObjects.get(0)).getAccrualFrequency());
                        if (nextPeriod == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u574f\u8d26\u8ba1\u63d0\uff1a\u4e0b\u4e00\u671f\u95f4\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u671f\u95f4\u914d\u7f6e\u3002", (String)"BadDebtAccrueEdit_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                        }
                        nextPeriodId = nextPeriod.getLong("id");
                        nextPeriodName = nextPeriod.getString("name");
                    }
                    schemeList.addAll(individualSchemes);
                    if (schemeObjects != null) {
                        schemeList.addAll(schemeObjects);
                    }
                    schemeList.addAll(expectSchemes);
                    BadDebtAccrualService badDebtAccrualService = new BadDebtAccrualService(orgId, periodId);
                    String prePeriodString = isPeriod ? "" : (String)orgAndPreperiodMap.get(orgId);
                    Long prePeriodId = prePeriodString == null || "".equals(prePeriodString) ? 0L : Long.parseLong(prePeriodString);
                    AccrualResult accrualResult = badDebtAccrualService.badDebtAccrual(prePeriodId, schemeList, isPeriod, exrateTableId, exrateDate);
                    results.add(accrualResult);
                    logger.info(String.format("BadDebtAccrueEdit-result:orgId:%s,periodId:%s,sucess:%s,preperiodId:%s,errorMsg:%s", orgId, periodId, accrualResult.isSuccess(), prePeriodId, accrualResult.getErrorMsg()));
                    if (!accrualResult.isSuccess()) continue;
                    this.updateAccrualRecord(orgId, periodId, isPeriod);
                    if (isPeriod) continue;
                    BadDebtAccrualHelper.insertNextPeriodBadDebtAccrue((Long)orgId, (Long)nextPeriodId, (Long)periodId, (Long)0L, (Boolean)Boolean.FALSE, (String)nextPeriodName, (Long)exrateTableId);
                }
                StringBuilder successMsg = new StringBuilder();
                StringBuilder errMsg = new StringBuilder();
                if (results.size() > 0) {
                    for (AccrualResult re : results) {
                        Long idKey = re.getOrgId();
                        if (re.isSuccess()) {
                            if (successMsg.length() > 0 && !"".equals(successMsg.toString())) {
                                successMsg.append('\u3001');
                            }
                            successMsg.append(orgNameMap.get(idKey));
                            continue;
                        }
                        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                            errMsg.append('\n');
                        }
                        errMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c%2$s", (String)"BadDebtAccrueEdit_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), orgNameMap.get(idKey), re.getErrorMsg()));
                    }
                }
                if (successMsg.length() > 0 && !"".equals(successMsg.toString())) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\uff0c\u8ba1\u63d0\u6210\u529f\u3002", (String)"BadDebtAccrueEdit_13", (String)"fi-ar-formplugin", (Object[])new Object[]{successMsg}));
                }
                if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                    this.getView().getParentView().showErrorNotification(errMsg.toString());
                }
                this.getView().invokeOperation("close");
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private List<AccrualScheme> convertSchemeParam(DynamicObject accrualScheme) {
        ArrayList<AccrualScheme> schemeList = new ArrayList<AccrualScheme>(8);
        if (accrualScheme == null) {
            return schemeList;
        }
        DynamicObjectCollection cardEntries = accrualScheme.getDynamicObjectCollection("ruleentry");
        for (DynamicObject cardEntry : cardEntries) {
            DynamicObject accrualObject;
            boolean isOffset;
            AccrualScheme groupScheme = new AccrualScheme();
            HashMap<Integer, String> agingRange = new HashMap<Integer, String>(8);
            HashMap<Integer, BigDecimal> accrualPercentForScheme = new HashMap<Integer, BigDecimal>(8);
            String offsetRule = cardEntry.getString("c_offset");
            boolean bl = isOffset = !"".equals(offsetRule);
            if (isOffset) {
                String offsetRuleJson = cardEntry.getString("c_offset_tag");
                List accrualOffsetVos = SerializationUtils.fromJsonStringToList((String)offsetRuleJson, AccrualOffsetVo.class);
                if (accrualOffsetVos == null || accrualOffsetVos.size() == 0) {
                    isOffset = false;
                } else {
                    ArrayList<String> offsetFieldForReceivedBill = new ArrayList<String>(8);
                    ArrayList offsetFieldForRecBill = new ArrayList(8);
                    ArrayList<String> offsetedField = new ArrayList<String>(8);
                    boolean includePeriod = cardEntry.getBoolean("c_includeperiod");
                    for (AccrualOffsetVo vo : accrualOffsetVos) {
                        if (includePeriod) {
                            offsetFieldForReceivedBill.add(vo.getReceivedfield());
                        }
                        offsetFieldForRecBill.add(vo.getRecbillfield());
                        offsetedField.add(vo.getOffsetbillfield());
                    }
                    String offsetedBillEntity = "ar_revcfmbill";
                    if ("1".equals(offsetRule)) {
                        offsetedBillEntity = "ar_busbill";
                    }
                    groupScheme.setOffsetVoList(accrualOffsetVos);
                    groupScheme.setOffsetFieldForReceivedBill(offsetFieldForReceivedBill);
                    groupScheme.setOffsetFieldForRecBill(offsetFieldForRecBill);
                    groupScheme.setOffsetedField(offsetedField);
                    groupScheme.setIncludePeriod(includePeriod);
                    groupScheme.setOffsetBillEntity(offsetedBillEntity);
                }
            }
            int agingStartDay = Integer.MAX_VALUE;
            String accrualRateJson = cardEntry.getString("c_accrualrate_tag");
            List accrualRateRows = SerializationUtils.fromJsonStringToList((String)accrualRateJson, AccrualRateRow.class);
            for (AccrualRateRow row : accrualRateRows) {
                int startdays = row.getStartdays();
                if (startdays < agingStartDay) {
                    agingStartDay = startdays;
                }
                if (row.isDaymore()) {
                    agingRange.put(Integer.MAX_VALUE, row.getSection());
                    accrualPercentForScheme.put(Integer.MAX_VALUE, row.getAccrualrate());
                    break;
                }
                agingRange.put(row.getEnddays(), row.getSection());
                accrualPercentForScheme.put(row.getEnddays(), row.getAccrualrate());
            }
            if ((accrualObject = cardEntry.getDynamicObject("c_accrualentityobj")) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u65b9\u6848\u4e2d\u5b58\u5728\u8ba1\u63d0\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8ba1\u63d0\u65b9\u6848\u3002", (String)"BadDebtAccrueEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
            String accrualObjectName = accrualObject.getString("entityobject");
            String condition = cardEntry.getString("c_condition_tag");
            CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
            FilterCondition filterCondition = formula.getFilterCondition();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)accrualObjectName);
            FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
            filterBuilder.buildFilter(false);
            QFilter accrualFilter = filterBuilder.getQFilter();
            groupScheme.setEntityKey(accrualObjectName);
            groupScheme.setAccrualObjId(Long.valueOf(accrualObject.getLong("id")));
            groupScheme.setAccrualType("2");
            groupScheme.setCondition(accrualFilter);
            groupScheme.setIndividual(false);
            groupScheme.setAccrualPercentForScheme(accrualPercentForScheme);
            groupScheme.setAccrualSchemeId(Long.valueOf(accrualScheme.getLong("id")));
            groupScheme.setAccrualFrequency(accrualScheme.getString("accrualfrequency"));
            groupScheme.setAgingRange(agingRange);
            groupScheme.setAgingStartDay(agingStartDay);
            groupScheme.setOffset(isOffset);
            groupScheme.setAgingDateEntity(cardEntry.getString("c_agingstartdate"));
            schemeList.add(groupScheme);
        }
        return schemeList;
    }

    private void validateField() {
        Object exrateDate;
        StringBuilder errMsg = new StringBuilder();
        boolean isFault = false;
        Object exrateTable = this.getModel().getValue("exratetable");
        if (exrateTable == null) {
            isFault = true;
            String fieldName = this.getModel().getProperty("exratetable").getDisplayName().getLocaleValue();
            if (errMsg.length() > 0) {
                errMsg.append(',');
            }
            errMsg.append(fieldName);
        }
        if ((exrateDate = this.getModel().getValue("exratedate")) == null) {
            isFault = true;
            String fieldName = this.getModel().getProperty("exratedate").getDisplayName().getLocaleValue();
            if (errMsg.length() > 0) {
                errMsg.append(',');
            }
            errMsg.append(fieldName);
        }
        if (isFault) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ee5\u4e0b\u5b57\u6bb5\uff1a%s\u3002", (String)"BadDebtAccrueEdit_6", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg}));
        }
        HashMap<String, Set> objAndCustoms = new HashMap<String, Set>(8);
        DynamicObjectCollection entries = (DynamicObjectCollection)this.getModel().getValue("entry");
        for (DynamicObject entry : entries) {
            DynamicObject accrualObj = entry.getDynamicObject("e_accrualobj");
            DynamicObjectCollection customer = entry.getDynamicObjectCollection("e_customer");
            BigDecimal accrualRate = entry.getBigDecimal("e_accrualrate");
            if (accrualObj == null || accrualRate == null || accrualRate.compareTo(BigDecimal.ZERO) == 0) {
                LocaleString objName = this.getModel().getProperty("e_accrualobj").getDisplayName();
                LocaleString rateName = this.getModel().getProperty("e_accrualrate").getDisplayName();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e2a\u522b\u8ba4\u5b9a\u9875\u7b7e\u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u4ee5\u4e0b\u5b57\u6bb5\uff1a%1$s\u3001%2$s\u3002", (String)"BadDebtAccrueEdit_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), objName, rateName));
            }
            String entityObject = accrualObj.getString("entityobject");
            Set customs = objAndCustoms.getOrDefault(entityObject, new HashSet(8));
            for (DynamicObject cus : customer) {
                long masterId = (Long)cus.getDynamicObject("fbasedataid").getPkValue();
                if (customs.contains(masterId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e2a\u522b\u8ba4\u5b9a\u9875\u7b7e\u76f8\u540c\u8ba1\u63d0\u5bf9\u8c61\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BadDebtAccrueEdit_16", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]));
                }
                customs.add(masterId);
            }
            objAndCustoms.put(entityObject, customs);
        }
        HashMap orgIdAndSchemeIdsMap = new HashMap(8);
        DynamicObjectCollection planEntries = (DynamicObjectCollection)this.getModel().getValue("planentry");
        if (planEntries != null && planEntries.size() > 0) {
            for (int i = 0; i < planEntries.size(); ++i) {
                DynamicObject entry = (DynamicObject)planEntries.get(i);
                DynamicObject org = entry.getDynamicObject("p_org");
                DynamicObject scheme = entry.getDynamicObject("p_accrualscheme");
                if (org == null || scheme == null) {
                    LocaleString orgName = this.getModel().getProperty("p_org").getDisplayName();
                    LocaleString schemeName = this.getModel().getProperty("p_accrualscheme").getDisplayName();
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u8ba4\u5b9a\u9875\u7b7e\u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u4ee5\u4e0b\u5b57\u6bb5\uff1a%1$s\u3001%2$s\u3002", (String)"BadDebtAccrueEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), orgName, schemeName));
                }
                Long orgId = org.getLong("id");
                Long schemeId = scheme.getLong("id");
                ArrayList<Long> schemeIds = (ArrayList<Long>)orgIdAndSchemeIdsMap.get(orgId);
                if (schemeIds == null) {
                    schemeIds = new ArrayList<Long>(8);
                    schemeIds.add(schemeId);
                    orgIdAndSchemeIdsMap.put(orgId, schemeIds);
                    continue;
                }
                if (schemeIds.contains(schemeId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u8ba4\u5b9a\u9875\u7b7e\u7b2c%s\u884c\uff0c\u76f8\u540c\u7ec4\u7ec7\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u8ba1\u63d0\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BadDebtAccrueEdit_12", (String)"fi-ar-formplugin", (Object[])new Object[0]), i + 1));
                }
                schemeIds.add(schemeId);
            }
        }
        DynamicObject aginggroup = (DynamicObject)this.getModel().getValue("aginggroup");
        DynamicObjectCollection accrualobject = (DynamicObjectCollection)this.getModel().getValue("accrualobject");
        DynamicObjectCollection agingEntries = (DynamicObjectCollection)this.getModel().getValue("agingentry");
        if (aginggroup != null && (accrualobject == null || accrualobject.size() == 0) || accrualobject != null && accrualobject.size() > 0 && aginggroup == null) {
            LocaleString groupName = this.getModel().getProperty("aginggroup").getDisplayName();
            LocaleString objsName = this.getModel().getProperty("accrualobject").getDisplayName();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u671f\u635f\u5931\u9875\u7b7e\u5b58\u5728\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u65e0\u9700\u9884\u671f\u635f\u5931\u8bf7\u6e05\u7a7a\u5b57\u6bb5\uff0c\u68c0\u67e5\u4ee5\u4e0b\u5b57\u6bb5\uff1a%1$s\u3001%2$s\u3002", (String)"BadDebtAccrueEdit_9", (String)"fi-ar-formplugin", (Object[])new Object[0]), groupName, objsName));
        }
        for (DynamicObject entry : agingEntries) {
            BigDecimal rate = entry.getBigDecimal("a_percent");
            if (rate != null && rate.compareTo(BigDecimal.ZERO) != 0) continue;
            LocaleString percentName = this.getModel().getProperty("a_percent").getDisplayName();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u671f\u635f\u5931\u9875\u7b7e\u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u4ee5\u4e0b\u5b57\u6bb5\uff1a%s\u3002", (String)"BadDebtAccrueEdit_10", (String)"fi-ar-formplugin", (Object[])new Object[0]), percentName));
        }
    }

    private void updateAccrualRecord(Long orgId, Long periodId, boolean isPeriod) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("period", "=", (Object)periodId));
        if (isPeriod) {
            filter.and(new QFilter("isperiod", "=", (Object)isPeriod));
        }
        DynamicObject accrualRecord = BusinessDataServiceHelper.loadSingle((String)"ar_baddebtaccrue", (String)"id,accrualstatus,accrualscheme", (QFilter[])filter.toArray());
        accrualRecord.set("accrualstatus", (Object)"1");
        OperationServiceHelper.executeOperate((String)"save", (String)"ar_baddebtaccrue", (DynamicObject[])new DynamicObject[]{accrualRecord}, (OperateOption)OperateOption.create());
    }

    private QFilter getIndividualFilter(int i) {
        DynamicObjectCollection asstacts = (DynamicObjectCollection)this.getModel().getValue("e_customer", i);
        if (asstacts == null || asstacts.isEmpty()) {
            return null;
        }
        HashSet<Long> asstactIds = new HashSet<Long>(asstacts.size());
        for (DynamicObject asstact : asstacts) {
            DynamicObject fbasedataid = asstact.getDynamicObject("fbasedataid");
            if (fbasedataid != null) {
                asstactIds.add(fbasedataid.getLong("masterid"));
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba2\u6237\u67e5\u8be2\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BadDebtAccrueEdit_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        DynamicObject accrualObj = (DynamicObject)this.getModel().getValue("e_accrualobj", i);
        String asstactNameInSourceBill = this.getAsstactNameInSourceBill(accrualObj.getString("entityobject"));
        return new QFilter(asstactNameInSourceBill, "in", asstactIds);
    }

    private String getAsstactNameInSourceBill(String accrualObject) {
        String result = "asstact";
        switch (accrualObject) {
            case "ap_paidbill": {
                result = "payee";
                break;
            }
            case "cas_paybill": {
                result = "itempayee";
            }
        }
        return result;
    }

    private QFilter getExtFilter(String entityObject, int entryCount, Map<Long, Object> settleModelMap, Map<Long, String> orgNameMap) {
        String conditionJson = (String)this.getModel().getValue("e_extfilter_tag", entryCount);
        if (conditionJson == null || "".equals(conditionJson)) {
            return null;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        if (filterCondition == null) {
            return null;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityObject);
        if ("ar_finarbill".equals(entityObject)) {
            this.extFilterValidator(entityObject, dataEntityType, filterCondition, settleModelMap, orgNameMap, entryCount);
        }
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    private void extFilterValidator(String entityObject, MainEntityType dataEntityType, FilterCondition filterCondition, Map<Long, Object> settleModelMap, Map<Long, String> orgNameMap, int entryCount) {
        List filterRow = filterCondition.getFilterRow();
        boolean existMaterial = false;
        boolean existPlan = false;
        if (EmptyUtils.isNotEmpty((Object)filterRow)) {
            for (Object simpleFilterRow : filterRow) {
                String string = simpleFilterRow.getFieldName();
                String[] sp = string.split("\\.");
                IDataEntityProperty property = dataEntityType.findProperty(sp[0]);
                if (property == null) continue;
                String parentName = property.getParent().getName();
                if ("entry".equals(parentName)) {
                    existMaterial = true;
                    continue;
                }
                if (!"planentity".equals(parentName)) continue;
                existPlan = true;
            }
            ArrayList<String> errorOrgName = new ArrayList<String>(8);
            for (Map.Entry entry : settleModelMap.entrySet()) {
                Long key = (Long)entry.getKey();
                Object value = entry.getValue();
                boolean isMaterialSettle = "1".equals(value);
                if ((!isMaterialSettle || !existPlan) && (isMaterialSettle || !existMaterial)) continue;
                errorOrgName.add(orgNameMap.get(key));
            }
            if (!errorOrgName.isEmpty()) {
                String errorOrg = String.join((CharSequence)"\u3001", errorOrgName);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e2a\u522b\u8ba4\u5b9a\u7b2c%1$s\u884c\uff0c\u6269\u5c55\u6761\u4ef6\u4e2d\u7684\u5b57\u6bb5\u4e0e\u7ec4\u7ec7\uff1a%2$s\u7684\u7ed3\u7b97\u6a21\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"BadDebtAccrueEdit_18", (String)"fi-ar-formplugin", (Object[])new Object[0]), entryCount + 1, errorOrg));
            }
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private Map<Long, String> getOrgNameMap() {
        DynamicObjectCollection multyOrg = (DynamicObjectCollection)this.getModel().getValue("multyorg");
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(8);
        for (DynamicObject org : multyOrg) {
            DynamicObject data = org.getDynamicObject("fbasedataid");
            orgNameMap.put(data.getLong("id"), data.getString("name"));
        }
        return orgNameMap;
    }
}

