/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.base;

import java.math.BigDecimal;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class ArBaseBillPlugin
extends AbstractBillPlugIn {
    protected PriceLocalCalculator buildCalculator(IDataModel m, int index) {
        return this.buildCalculatorByPresent(m, index, false);
    }

    protected PriceLocalCalculator buildCalculatorByPresent(IDataModel m, int index, boolean isPresent) {
        isPresent = !isPresent ? (Boolean)m.getValue("e_ispresent", index) : isPresent;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        boolean isPriceTotal = (Boolean)m.getValue("ispricetotal");
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
        BigDecimal discountAmt = (BigDecimal)m.getValue("e_discountamount", index);
        boolean existProperty = EntityMetadataUtils.isExistProperty((DynamicObject)m.getDataEntity(), (String)"adjustamount");
        BigDecimal adjustamount = BigDecimal.ZERO;
        if (existProperty) {
            adjustamount = (BigDecimal)m.getValue("e_adjustamount", index);
        }
        int precision = 2;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        int localPrecision = this.getLocalPrecision();
        TaxUnitPriceCalculator calculator = null;
        if (includeTax) {
            if (isPriceTotal && !isPresent) {
                BigDecimal recamount = (BigDecimal)m.getValue("e_recamount", index);
                calculator = new PriceTaxTotalCalculator(qty, recamount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            } else {
                BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            }
        } else if (isPriceTotal && !isPresent) {
            BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        } else {
            BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        }
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, localPrecision, quotation);
        localCalculator.calculate();
        return localCalculator;
    }

    protected void setRowValue(IDataModel m, PriceLocalCalculator calculator, int index) {
        m.beginInit();
        m.setValue("e_unitprice", (Object)calculator.getUnitprice(), index);
        m.setValue("e_taxunitprice", (Object)calculator.getTaxunitprice(), index);
        m.setValue("e_tax", (Object)calculator.getTax(), index);
        m.setValue("e_discountamount", (Object)calculator.getDiscountamount(), index);
        m.endInit();
        this.getView().updateView("e_unitprice", index);
        this.getView().updateView("e_taxunitprice", index);
        this.getView().updateView("e_tax", index);
        this.getView().updateView("e_discountamount", index);
        m.setValue("e_actunitprice", (Object)calculator.getActunitprice(), index);
        m.setValue("e_acttaxunitprice", (Object)calculator.getActtaxunitprice(), index);
        m.setValue("e_taxlocalamt", (Object)calculator.getTaxlocal(), index);
        m.setValue("e_discountlocalamt", (Object)calculator.getDiscountamountlocal(), index);
        boolean existProperty = EntityMetadataUtils.isExistProperty((DynamicObject)m.getDataEntity(), (String)"adjustamount");
        if (existProperty) {
            m.setValue("e_adjustlocalamt", (Object)calculator.getAdjustamtlocal(), index);
        }
        this.assigendEntryAmount(m, index, calculator.getAmount(), calculator.getAmountlocal(), calculator.getPricetaxtotal(), calculator.getPricetaxtotallocal());
    }

    protected void assigendEntryAmount(IDataModel m, int index, BigDecimal amount, BigDecimal amountlocal, BigDecimal pricetaxtotal, BigDecimal pricetaxtotallocal) {
        m.beginInit();
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_recamount", (Object)pricetaxtotal, index);
        m.endInit();
        this.getView().updateView("e_amount", index);
        this.getView().updateView("e_recamount", index);
        m.setValue("e_unconfirmamt", (Object)amount, index);
        m.setValue("e_localamt", (Object)amountlocal, index);
        m.setValue("e_uninvoicedamt", (Object)pricetaxtotal, index);
        m.setValue("e_reclocalamt", (Object)pricetaxtotallocal, index);
    }

    protected int getLocalPrecision() {
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        return localPrecision;
    }
}

