/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.botp.cv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.formplugin.botp.cv.ArBill2OriginalBillCommonUtil;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.util.UUID;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class ArBill2OriginalBillPlugin
extends AbstractConvertPlugIn {
    private static final Log LOGGER = LogFactory.getLog(ArBill2OriginalBillPlugin.class);
    private static final String RMB = "cny";
    private static final int IMC_AMT_PRECISION = 2;
    private static final int IMC_NUM_PRECISION = 8;
    public static final String NULL = "NULL";
    public static final String PERCENT = "PERCENT";
    public static final String TOTAL = "TOTAL";
    public static final String GIFT = "GIFT";

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        Date start = new Date();
        List selectedRows = e.getSelectedRows();
        HashMap<Long, String> idAndBillNoMap = new HashMap<Long, String>(selectedRows.size());
        HashSet<Long> pks = new HashSet<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long pk = (Long)row.getPrimaryKeyValue();
            pks.add(pk);
            idAndBillNoMap.put(pk, row.getBillNo());
        }
        int limit = this.queryBatchBillLimit();
        if (pks.size() > limit) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u6bcf\u6b21\u4e0b\u63a8\u5355\u636e\u6570\u91cf\u9700\u5c0f\u4e8e\u201c%s\u201d\u3002", (String)"BusArBill2OriginalBillPlugin_3", (String)"fi-ar-formplugin", (Object[])new Object[]{limit}));
        }
        String srcBillextendName = this.getSrcMainType().getExtendName();
        Map existTargetBillMap = ArApHelper.isHasSameTarBill((String)srcBillextendName, (Long[])pks.toArray(new Long[0]), (String)"ar_invoice");
        StringBuilder errMsg = new StringBuilder();
        for (Map.Entry nextEntry : existTargetBillMap.entrySet()) {
            if (!Boolean.TRUE.equals(nextEntry.getValue())) continue;
            if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                errMsg.append('\u3001');
            }
            errMsg.append(idAndBillNoMap.get(nextEntry.getKey()));
        }
        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u5df2\u901a\u8fc7\u5f00\u7968\u5355\u8fdb\u884c\u5f00\u7968\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusArBill2OriginalBillPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
        }
        this.checkSrcIsOriginalBill(idAndBillNoMap);
        if (!VerifyServiceHelper.enablePreOriginalWfConfig((boolean)true)) {
            this.pushCheck(idAndBillNoMap);
        }
        Date end = new Date();
        LOGGER.info(String.format("ArBill2OriginalBillPluginTimeLog:business[%s],time:[%s]", "beforeBuildRowCondition", ArBill2OriginalBillPlugin.timeDifferenceSecond(end, start)));
    }

    private void checkSrcIsOriginalBill(Map<Long, String> idAndBillNoMap) {
        Set<Long> pks = idAndBillNoMap.keySet();
        StringBuilder errMsg = new StringBuilder();
        Map srcIdMap = BOTPHelper.loadNearUpBillIds((String)"ar_finarbill", (String)"sim_original_bill", (Long[])pks.toArray(new Long[0]));
        if (!srcIdMap.isEmpty()) {
            for (Map.Entry entry : srcIdMap.entrySet()) {
                Long key = (Long)entry.getKey();
                String billNo = idAndBillNoMap.get(key);
                if (StringUtils.isEmpty((CharSequence)billNo)) continue;
                if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                    errMsg.append('\u3001');
                }
                errMsg.append(billNo);
            }
        }
        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u636e\uff1a%s\uff0c\u4e0a\u6e38\u5df2\u5b58\u5728\u5f00\u7968\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u4e0b\u63a8\u3002", (String)"ArBill2OriginalBillPlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
        }
    }

    private void pushCheck(HashMap<Long, String> idAndBillNoMap) {
        Set<Long> finArBillIds = idAndBillNoMap.keySet();
        StringBuilder errMsg = new StringBuilder();
        Map srcIdMap = BOTPHelper.loadNearUpBillIds((String)"ar_finarbill", (String)"ar_busbill", (Long[])finArBillIds.toArray(new Long[0]));
        if (!srcIdMap.isEmpty()) {
            ArrayList srcBusArIds = new ArrayList(8);
            for (Map.Entry entry : srcIdMap.entrySet()) {
                List list = (List)entry.getValue();
                srcBusArIds.addAll(list);
            }
            Map dirtTargetBillIdMap = BOTPHelper.findDirtTargetBillIds((String)"ar_busbill", (Long[])srcBusArIds.toArray(new Long[0]), (String)"sim_original_bill", (String)"sim_original_bill");
            if (!dirtTargetBillIdMap.isEmpty()) {
                for (Map.Entry entry : srcIdMap.entrySet()) {
                    Long key = (Long)entry.getKey();
                    List value = (List)entry.getValue();
                    for (Map.Entry entryMap : dirtTargetBillIdMap.entrySet()) {
                        Long entryKey = (Long)entryMap.getKey();
                        Set entryMapValue = (Set)entryMap.getValue();
                        if (entryMapValue.isEmpty() || !value.contains(entryKey)) continue;
                        String finArBillNo = idAndBillNoMap.get(key);
                        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                            errMsg.append('\u3001');
                        }
                        errMsg.append(finArBillNo);
                    }
                }
            }
        }
        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u636e\uff1a%s\uff0c\u4e0a\u6e38\u6682\u4f30\u5e94\u6536\u5355\u5df2\u5f00\u7968\uff0c\u8d22\u52a1\u5e94\u6536\u5355\u4e0d\u5141\u8bb8\u518d\u4e0b\u63a8\u5f00\u7968\u3002", (String)"ArBill2OriginalBillPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
        }
        errMsg = new StringBuilder();
        DynamicObjectCollection finArCol = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,org,billno,sourcebilltype,sourcebillno", (QFilter[])new QFilter[]{new QFilter("id", "in", idAndBillNoMap.keySet())});
        HashSet<Long> orgIds = new HashSet<Long>(8);
        HashSet<String> hashSet = new HashSet<String>(8);
        HashSet<String> hashSet2 = new HashSet<String>(8);
        HashMap<String, String> srcBillNoNoMap = new HashMap<String, String>(8);
        for (DynamicObject finArInfo : finArCol) {
            String sourceBillNo;
            orgIds.add(finArInfo.getLong("org"));
            String sourceBillType = finArInfo.getString("sourcebilltype");
            if (!StringUtils.isEmpty((CharSequence)sourceBillType)) {
                hashSet.add(sourceBillType);
            }
            if (!StringUtils.isEmpty((CharSequence)(sourceBillNo = finArInfo.getString("sourcebillno")))) {
                hashSet2.add(sourceBillNo);
            }
            String billNo = finArInfo.getString("billno");
            srcBillNoNoMap.put(sourceBillNo, billNo);
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and(new QFilter("sourcebilltype", "in", hashSet));
        filter.and(new QFilter("sourcebillno", "in", hashSet2));
        DynamicObjectCollection busArBillCol = QueryServiceHelper.query((String)"ar_busbill", (String)"id,sourcebillno,entry.id", (QFilter[])new QFilter[]{filter});
        if (!busArBillCol.isEmpty()) {
            HashSet<Long> busArBillIdSet = new HashSet<Long>(busArBillCol.size());
            HashSet<Long> busArBillEntryIdSet = new HashSet<Long>(busArBillCol.size());
            for (DynamicObject busArBill : busArBillCol) {
                busArBillIdSet.add(busArBill.getLong("id"));
                busArBillEntryIdSet.add(busArBill.getLong("entry.id"));
            }
            Map TargetBillIdMap = BOTPHelper.loadNearTarBillIds((String)"ar_busbill", (String)"entry", (Long[])busArBillIdSet.toArray(new Long[0]), (Long[])busArBillEntryIdSet.toArray(new Long[0]), (String)"sim_original_bill");
            if (!TargetBillIdMap.isEmpty()) {
                for (DynamicObject busArBillInfo : busArBillCol) {
                    String sourceBillNo;
                    String finArBillNo;
                    Long busArBillId = busArBillInfo.getLong("id");
                    if (!TargetBillIdMap.containsKey(busArBillId) || StringUtils.isEmpty((CharSequence)(finArBillNo = (String)srcBillNoNoMap.get(sourceBillNo = busArBillInfo.getString("sourcebillno"))))) continue;
                    if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                        errMsg.append('\u3001');
                    }
                    errMsg.append(finArBillNo);
                }
            }
        }
        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u636e\uff1a%s\uff0c\u5b58\u5728\u540c\u6e90\u4e14\u5df2\u5f00\u7968\u7684\u6682\u4f30\u5e94\u6536\u5355\uff0c\u8d22\u52a1\u5e94\u6536\u5355\u4e0d\u5141\u8bb8\u518d\u4e0b\u63a8\u5f00\u7968\u3002", (String)"ArBill2OriginalBillPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
        }
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
    }

    public void afterConvert(AfterConvertEventArgs e) {
        Date date0 = new Date();
        ArBill2OriginalBillCommonUtil handler = this.getArBill2OriginalBillUtil();
        ExtendedDataEntity[] billExtendDataEntityArr = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().getName());
        Map srcfldPro = e.getFldProperties();
        HashMap<Object, DynamicObject> sourceMap = new HashMap<Object, DynamicObject>(srcfldPro.size());
        handler.fillSourceMap2(billExtendDataEntityArr, srcfldPro, sourceMap, this.getSrcMainType().getName());
        String batchNumber = "100_" + UUID.getBatchNumber() + '_';
        int serialNo = 0;
        ArrayList<DynamicObject> entitys = new ArrayList<DynamicObject>(billExtendDataEntityArr.length);
        Date date1 = new Date();
        LOGGER.info(String.format("ArBill2OriginalBillPluginTimeLog:business[%s],time:[%s]", "fillSourceMap", ArBill2OriginalBillPlugin.timeDifferenceSecond(date0, date1)));
        for (ExtendedDataEntity entity : billExtendDataEntityArr) {
            DynamicObjectCollection items;
            DynamicObject bill;
            DynamicObject dataEntity = entity.getDataEntity();
            List sourceBillRows = (List)entity.getValue("ConvertSource");
            DynamicObject sourceObj = sourceMap.get(((DynamicProperty)srcfldPro.get("id")).getValue(sourceBillRows.get(0)));
            handler.setRemark(dataEntity);
            handler.setBillNoByDB(dataEntity);
            boolean isFrom = !RMB.equalsIgnoreCase(dataEntity.getDynamicObject("fromcurr").getString("number"));
            handler.setBuyerAndSallerInfo(entity, sourceObj);
            handler.setConstantData(dataEntity, null);
            dataEntity.set("originbillseq", (Object)(batchNumber + serialNo));
            ++serialNo;
            BigDecimal recAmount = sourceObj.getBigDecimal("recamount");
            BigDecimal invoiceAmount = BigDecimal.ZERO;
            BigDecimal totalTax = BigDecimal.ZERO;
            BigDecimal totalFromAmount = BigDecimal.ZERO;
            BigDecimal totalFromTax = BigDecimal.ZERO;
            if (dataEntity.getDataEntityState().getFromDatabase() && (bill = QueryServiceHelper.queryOne((String)"sim_original_bill", (String)String.join((CharSequence)",", "invoiceamount", "totaltax", "totalamount", "foreigninvoiceamount", "foreigntax"), (QFilter[])new QFilter("id", "=", dataEntity.getPkValue()).toArray())) != null) {
                invoiceAmount = bill.getBigDecimal("invoiceamount");
                totalTax = bill.getBigDecimal("totaltax");
                totalFromAmount = bill.getBigDecimal("foreigninvoiceamount");
                totalFromTax = bill.getBigDecimal("foreigntax");
            }
            if ((items = dataEntity.getDynamicObjectCollection("sim_original_bill_item")).size() > 0) {
                int seqIncrement = 0;
                for (int i = 0; i < items.size(); ++i) {
                    BigDecimal discountAmtWithTax;
                    DynamicObject tgtEntryRow = (DynamicObject)items.get(i);
                    tgtEntryRow.set("seq", (Object)(++seqIncrement));
                    this.setNameAndSpbm(handler, dataEntity, tgtEntryRow);
                    BigDecimal rateValue = handler.execTaxRate(new BigDecimal(tgtEntryRow.getString("taxrate")).divide(new BigDecimal("100"), 5, RoundingMode.HALF_UP).toPlainString());
                    tgtEntryRow.set("taxrate", (Object)rateValue.toPlainString());
                    String discountMode = tgtEntryRow.getString("discountmode");
                    DynamicObject fromCurrency = (DynamicObject)dataEntity.get("fromcurr");
                    String quotation = (String)entity.getValue("quotation");
                    if (isFrom) {
                        BigDecimal exrate = (BigDecimal)entity.getValue("exrate");
                        discountAmtWithTax = handler.calToAmount(quotation, exrate, tgtEntryRow.getBigDecimal("fromdiscountamount"), fromCurrency);
                    } else {
                        discountAmtWithTax = tgtEntryRow.getBigDecimal("discountamount");
                    }
                    boolean hsbzFlag = "1".equals(dataEntity.getString("hsbz"));
                    if (recAmount.compareTo(BigDecimal.ZERO) < 0 || StringUtils.isBlank((CharSequence)discountMode) || BigDecimal.ZERO.compareTo(discountAmtWithTax) == 0) {
                        invoiceAmount = invoiceAmount.add(tgtEntryRow.getBigDecimal("amount"));
                        totalTax = totalTax.add(tgtEntryRow.getBigDecimal("tax"));
                        totalFromAmount = totalFromAmount.add(tgtEntryRow.getBigDecimal("fromamount"));
                        totalFromTax = totalFromTax.add(tgtEntryRow.getBigDecimal("fromtax"));
                    } else {
                        DynamicObject discountItemNew;
                        boolean isAllDiscount;
                        boolean isPresent = GIFT.equals(discountMode);
                        BigDecimal itemRmbDiscountAmount = tgtEntryRow.getBigDecimal("discountamount");
                        BigDecimal itemTaxAmount = tgtEntryRow.getBigDecimal("taxamount");
                        boolean bl = isAllDiscount = BigDecimal.ZERO.compareTo(itemTaxAmount.subtract(itemRmbDiscountAmount)) == 0;
                        if (isPresent || isAllDiscount) {
                            discountItemNew = handler.dealPresentItem(handler, isFrom, ++seqIncrement, tgtEntryRow, hsbzFlag);
                        } else {
                            tgtEntryRow.set("discountamount", null);
                            tgtEntryRow.set("discountrate", null);
                            BigDecimal discountAmount = discountAmtWithTax.divide(BigDecimal.ONE.add(rateValue), 2, RoundingMode.HALF_UP);
                            BigDecimal discountTax = discountAmtWithTax.subtract(discountAmount);
                            discountItemNew = handler.createNewRow(++seqIncrement, tgtEntryRow, discountAmtWithTax, discountAmount, discountTax, null, hsbzFlag);
                            totalTax = totalTax.add(discountItemNew.getBigDecimal("tax"));
                            totalTax = totalTax.add(tgtEntryRow.getBigDecimal("tax"));
                            invoiceAmount = invoiceAmount.add(discountItemNew.getBigDecimal("amount"));
                            invoiceAmount = invoiceAmount.add(tgtEntryRow.getBigDecimal("amount"));
                            if (isFrom) {
                                handler.dealItemFromInfo(discountItemNew, rateValue, tgtEntryRow, fromCurrency);
                            }
                            totalFromAmount = totalFromAmount.add(discountItemNew.getBigDecimal("fromamount"));
                            totalFromTax = totalFromTax.add(discountItemNew.getBigDecimal("fromtax"));
                            totalFromAmount = totalFromAmount.add(tgtEntryRow.getBigDecimal("fromamount"));
                            totalFromTax = totalFromTax.add(tgtEntryRow.getBigDecimal("fromtax"));
                        }
                        items.add(++i, discountItemNew);
                    }
                    if (hsbzFlag) {
                        tgtEntryRow.set("remainvalidamount", tgtEntryRow.get("taxamount"));
                    } else {
                        tgtEntryRow.set("remainvalidamount", tgtEntryRow.get("amount"));
                    }
                    tgtEntryRow.set("orifromtaxamount", (Object)tgtEntryRow.getBigDecimal("fromtaxamount"));
                    tgtEntryRow.set("oritaxamount", (Object)tgtEntryRow.getBigDecimal("taxamount"));
                    tgtEntryRow.set("remainvalidnum", tgtEntryRow.get("num"));
                    tgtEntryRow.set("remainvalidtax", tgtEntryRow.get("tax"));
                    tgtEntryRow.set("discountamount", (Object)0);
                    tgtEntryRow.set("fromdiscountamount", (Object)0);
                }
            }
            handler.setCurrencyAndAmount(entity, invoiceAmount, totalTax);
            entity.setValue("foreigninvoiceamount", (Object)totalFromAmount);
            entity.setValue("foreigntax", (Object)totalFromTax);
            entity.setValue("foreigntotalamount", (Object)totalFromAmount.add(totalFromTax));
            entitys.add(dataEntity);
        }
        handler.clear();
        Date date2 = new Date();
        LOGGER.info(String.format("ArBill2OriginalBillPluginTimeLog:business[%s],time:[%s]", "dealItem", ArBill2OriginalBillPlugin.timeDifferenceSecond(date1, date2)));
        this.setOriginalBillValueByInvoke(entitys, handler);
        Date date3 = new Date();
        LOGGER.info(String.format("ArBill2OriginalBillPluginTimeLog:business[%s],time:[%s]", "matchInterface", ArBill2OriginalBillPlugin.timeDifferenceSecond(date2, date3)));
    }

    private void setNameAndSpbm(ArBill2OriginalBillCommonUtil handler, DynamicObject dataEntity, DynamicObject tgtEntryRow) {
        String name;
        DynamicObject itemExpense;
        String expenseItemName = null;
        String materialName = null;
        String materialNumber = null;
        String expenseNumber = null;
        DynamicObject itemMaterial = tgtEntryRow.getDynamicObject("materielfield");
        if (null != itemMaterial) {
            materialName = itemMaterial.getString("name");
            materialNumber = itemMaterial.getString("number");
        }
        if (null != (itemExpense = tgtEntryRow.getDynamicObject("expenseitem"))) {
            expenseItemName = itemExpense.getString("name");
            expenseNumber = itemExpense.getString("number");
        }
        if (StringUtils.isNotBlank((CharSequence)materialName) && StringUtils.isNotBlank((CharSequence)expenseItemName)) {
            boolean isChooseMaterial = handler.bothItemExistChooseMaterial(dataEntity);
            String string = name = isChooseMaterial ? materialName : expenseItemName;
            if (isChooseMaterial) {
                tgtEntryRow.set("expenseitem", null);
                tgtEntryRow.set("spbm", (Object)materialNumber);
            } else {
                tgtEntryRow.set("materielfield", null);
                tgtEntryRow.set("spbm", (Object)expenseNumber);
            }
        } else {
            String string = name = StringUtils.isBlank((CharSequence)materialName) ? expenseItemName : materialName;
            if (null != itemMaterial) {
                tgtEntryRow.set("spbm", (Object)itemMaterial.getString("number"));
            }
            if (null != itemExpense) {
                tgtEntryRow.set("spbm", (Object)itemExpense.getString("number"));
            }
        }
        tgtEntryRow.set("origoodsname", (Object)name);
        if (StringUtils.isBlank((CharSequence)tgtEntryRow.getString("goodsname"))) {
            tgtEntryRow.set("goodsname", (Object)name);
        }
    }

    public void setOriginalBillValueByInvoke(List<DynamicObject> entitys, ArBill2OriginalBillCommonUtil handler) {
        ArrayList<DynamicObject> partList = new ArrayList<DynamicObject>(1000);
        for (DynamicObject bill : entitys) {
            partList.add(bill);
            if (partList.size() != 500) continue;
            handler.setOriginalBillValueByInvoke(partList);
            partList.clear();
        }
        if (partList.size() > 0) {
            handler.setOriginalBillValueByInvoke(partList);
        }
    }

    public ArBill2OriginalBillCommonUtil getArBill2OriginalBillUtil() {
        return new ArBill2OriginalBillCommonUtil();
    }

    private int queryBatchBillLimit() {
        QFilter filter = new QFilter("config_key", "=", (Object)"ArBillPushLimit");
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"invsm_param_configuration", (String)"config_type,config_key,config_value", (QFilter[])new QFilter[]{filter});
        if (collection.length == 0) {
            return 1000;
        }
        try {
            String limit = collection[0].getString("config_value");
            return Integer.parseInt(limit);
        }
        catch (Exception exception) {
            return 1000;
        }
    }

    public static int timeDifferenceSecond(Date date1, Date date2) {
        return (int)((date2.getTime() - date1.getTime()) / 1000L);
    }
}

