/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.botp.cv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ar.formplugin.botp.cv.ArBill2OriginalBillCommonUtil;
import kd.fi.ar.util.UUID;
import kd.fi.arapcommon.helper.ArApHelper;

public class ArBillMerge2OriginalBillPlugin
extends AbstractConvertPlugIn {
    private static final Log LOGGER = LogFactory.getLog(ArBillMerge2OriginalBillPlugin.class);
    private static final String RMB = "cny";

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        HashMap<Long, String> idAndBillNoMap = new HashMap<Long, String>(selectedRows.size());
        ArrayList<Long> pks = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long pk = (Long)row.getPrimaryKeyValue();
            pks.add(pk);
            idAndBillNoMap.put(pk, row.getBillNo());
        }
        String srcBillextendName = this.getSrcMainType().getExtendName();
        Map existTargetBillMap = ArApHelper.isHasSameTarBill((String)srcBillextendName, (Long[])pks.toArray(new Long[0]), (String)"ar_invoice");
        StringBuilder errMsg = new StringBuilder();
        for (Map.Entry nextEntry : existTargetBillMap.entrySet()) {
            if (!Boolean.TRUE.equals(nextEntry.getValue())) continue;
            if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                errMsg.append('\u3001');
            }
            errMsg.append((String)idAndBillNoMap.get(nextEntry.getKey()));
        }
        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u5df2\u901a\u8fc7\u5f00\u7968\u5355\u8fdb\u884c\u5f00\u7968\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusArBill2OriginalBillPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
        }
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        ArBill2OriginalBillCommonUtil.addFilterAndQueryFields(e);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ArBill2OriginalBillCommonUtil handler = this.getArBill2OriginalBillUtil();
        long startTime = System.currentTimeMillis();
        String tgtName = this.getTgtMainType().getName();
        ExtendedDataEntity[] extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(tgtName);
        Map srcfldPro = e.getFldProperties();
        String batchNumber = "100_" + UUID.getBatchNumber() + '_';
        int serialNo = 0;
        ArrayList<DynamicObject> entitys = new ArrayList<DynamicObject>();
        HashMap<Object, DynamicObject> sourceMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, Map<Object, DynamicObject>> sourceItemMap = new HashMap<Object, Map<Object, DynamicObject>>();
        String srcBillName = this.getSrcMainType().getName();
        handler.fillSourceMap(extendedDataEntities, srcfldPro, sourceMap, sourceItemMap, srcBillName);
        int itemEntitySeq = 0;
        for (ExtendedDataEntity entity : extendedDataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            List sourceBillRows = (List)entity.getValue("ConvertSource");
            handler.setRemark(dataEntity);
            handler.setBillNoByDB(dataEntity);
            DynamicObjectCollection items = dataEntity.getDynamicObjectCollection("sim_original_bill_item");
            DynamicObjectCollection itemsNews = new DynamicObjectCollection();
            DynamicObject sourceRow = (DynamicObject)sourceBillRows.get(0);
            Object sourceId = ((DynamicProperty)srcfldPro.get("id")).getValue((Object)sourceRow);
            DynamicObject sourceObj = sourceMap.get(sourceId);
            boolean isFrom = !RMB.equalsIgnoreCase(dataEntity.getDynamicObject("fromcurr").getString("number"));
            handler.setHSBZ(entity, sourceObj);
            handler.setBuyerAndSallerInfo(entity, sourceObj);
            handler.setConstantData(dataEntity, null);
            dataEntity.set("originbillseq", (Object)(batchNumber + serialNo));
            BigDecimal recAmount = sourceObj.getBigDecimal("recamount");
            ++serialNo;
            ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
            ExtendedDataEntity[] sim_original_bill_items = targetExtDataEntitySet.FindByEntityKey("sim_original_bill_item");
            int length = items.size();
            int seqIncrement = 0;
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTax = BigDecimal.ZERO;
            BigDecimal totalFromAmount = BigDecimal.ZERO;
            BigDecimal totalFromTax = BigDecimal.ZERO;
            for (int i = 0; i < length; ++i) {
                BigDecimal discountAmtWithTax;
                ++seqIncrement;
                ExtendedDataEntity itemConstruct = sim_original_bill_items[itemEntitySeq];
                ++itemEntitySeq;
                DynamicObject source = (DynamicObject)((List)itemConstruct.getValue("ConvertSource")).get(0);
                DynamicObject billTypeDO = sourceObj.getDynamicObject("billtype");
                String entryItemType = handler.getEntryItemType(billTypeDO);
                Object sourceBillId = ((DynamicProperty)srcfldPro.get("id")).getValue((Object)source);
                Object sourceEntryId = ((DynamicProperty)srcfldPro.get("entry.id")).getValue((Object)source);
                Map<Object, DynamicObject> currentSourceItemMap = sourceItemMap.get(sourceBillId);
                DynamicObject sourceItem = currentSourceItemMap.get(sourceEntryId);
                DynamicObject tgtEntryRow = (DynamicObject)items.get(i);
                String expenseItemName = String.valueOf(((DynamicProperty)srcfldPro.get("e_expenseitem.name")).getValue((Object)source));
                String materialName = String.valueOf(((DynamicProperty)srcfldPro.get("e_material.name")).getValue((Object)source));
                String name = "NULL".equalsIgnoreCase(expenseItemName) ? materialName : expenseItemName;
                tgtEntryRow.set("origoodsname", (Object)name);
                if (StringUtils.isBlank((CharSequence)tgtEntryRow.getString("goodsname"))) {
                    tgtEntryRow.set("goodsname", (Object)name);
                }
                BigDecimal itemAmount = tgtEntryRow.getBigDecimal("amount");
                BigDecimal itemTax = tgtEntryRow.getBigDecimal("tax");
                totalAmount = totalAmount.add(itemAmount);
                totalTax = totalTax.add(itemTax);
                BigDecimal bigTaxRate = (BigDecimal)((DynamicProperty)srcfldPro.get("e_taxrate")).getValue((Object)source);
                BigDecimal rateValue = handler.execTaxRate(bigTaxRate.divide(new BigDecimal("100"), 5, RoundingMode.HALF_UP).toPlainString());
                tgtEntryRow.set("taxrate", (Object)rateValue.toPlainString());
                handler.setItemTaxClass(entryItemType, sourceItem, tgtEntryRow);
                String e_discountmode = String.valueOf(((DynamicProperty)srcfldPro.get("e_discountmode")).getValue((Object)source));
                DynamicObject fromCurrency = (DynamicObject)dataEntity.get("fromcurr");
                String quotation = (String)entity.getValue("quotation");
                if (isFrom) {
                    BigDecimal exrate = (BigDecimal)entity.getValue("exrate");
                    discountAmtWithTax = handler.calToAmount(quotation, exrate, sourceItem.getBigDecimal("e_discountamount"), fromCurrency);
                } else {
                    discountAmtWithTax = sourceItem.getBigDecimal("e_discountamount");
                }
                boolean hsbzFlag = sourceObj.getBoolean("isincludetax");
                BigDecimal fromAmount = tgtEntryRow.getBigDecimal("fromamount");
                BigDecimal fromTax = tgtEntryRow.getBigDecimal("fromtax");
                totalFromAmount = totalFromAmount.add(fromAmount);
                totalFromTax = totalFromTax.add(fromTax);
                tgtEntryRow.set("seq", (Object)seqIncrement);
                if (recAmount.compareTo(BigDecimal.ZERO) < 0 || "NULL".equals(e_discountmode) || BigDecimal.ZERO.compareTo(discountAmtWithTax) == 0) {
                    itemsNews.add((Object)tgtEntryRow);
                } else {
                    BigDecimal unitPrice = tgtEntryRow.getBigDecimal("unitprice");
                    BigDecimal num = tgtEntryRow.getBigDecimal("num");
                    Object isPresent = sourceItem.get("e_ispresent");
                    BigDecimal itemTaxRate = sourceItem.getBigDecimal("e_taxrate").divide(new BigDecimal("100"));
                    if (this.isPresentItem(isPresent)) {
                        handler.dealPresentItem(handler, isFrom, entity, itemsNews, seqIncrement, tgtEntryRow, fromCurrency, quotation, hsbzFlag, unitPrice, num, itemTaxRate);
                        totalTax = totalTax.subtract(itemTax);
                        totalFromAmount = totalFromAmount.subtract(fromAmount);
                        totalFromTax = totalFromTax.subtract(fromTax);
                        totalAmount = totalAmount.subtract(itemAmount);
                    } else {
                        BigDecimal arAmountWithTax = sourceItem.getBigDecimal("e_recamount");
                        BigDecimal amountWithTax = sourceItem.getBigDecimal("e_uninvoicedamt");
                        if (amountWithTax.compareTo(arAmountWithTax) < 0) {
                            discountAmtWithTax = discountAmtWithTax.multiply(amountWithTax.divide(arAmountWithTax, 8, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
                        }
                        BigDecimal oriAmount = tgtEntryRow.getBigDecimal("amount");
                        amountWithTax = amountWithTax.add(discountAmtWithTax);
                        BigDecimal amount = unitPrice.multiply(num).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal tgtItemTax = amountWithTax.subtract(amount);
                        if (isFrom) {
                            amountWithTax = sourceItem.getBigDecimal("e_uninvoicedlocalamt").add(sourceItem.getBigDecimal("e_discountlocalamt"));
                            tgtItemTax = amountWithTax.subtract(amount);
                        }
                        tgtEntryRow.set("tax", (Object)handler.getRealValue(tgtItemTax, 2));
                        tgtEntryRow.set("amount", (Object)handler.getRealValue(amount, 2));
                        tgtEntryRow.set("taxamount", (Object)handler.getRealValue(amountWithTax, 2));
                        tgtEntryRow.set("discountamount", (Object)"");
                        tgtEntryRow.set("discountrate", (Object)"");
                        itemsNews.add((Object)tgtEntryRow);
                        BigDecimal discountAmount = amount.subtract(oriAmount);
                        BigDecimal discountTax = discountAmtWithTax.subtract(discountAmount);
                        DynamicObject newRow = handler.createNewRow(++seqIncrement, tgtEntryRow, discountAmtWithTax, discountAmount, discountTax, itemsNews, hsbzFlag);
                        if (isFrom) {
                            handler.dealItemFromInfo(sourceItem, newRow, itemTaxRate, tgtEntryRow, fromCurrency);
                        }
                        totalFromAmount = totalFromAmount.add(newRow.getBigDecimal("fromamount"));
                        totalFromTax = totalFromTax.add(newRow.getBigDecimal("fromtax"));
                    }
                }
                if (hsbzFlag) {
                    tgtEntryRow.set("remainvalidamount", tgtEntryRow.get("taxamount"));
                } else {
                    tgtEntryRow.set("remainvalidamount", tgtEntryRow.get("amount"));
                }
                tgtEntryRow.set("remainvalidnum", tgtEntryRow.get("num"));
                tgtEntryRow.set("remainvalidtax", tgtEntryRow.get("tax"));
            }
            handler.setCurrencyAndAmount(entity, sourceObj, totalAmount, totalTax);
            entity.setValue("foreigninvoiceamount", (Object)totalFromAmount);
            entity.setValue("foreigntax", (Object)totalFromTax);
            entity.setValue("foreigntotalamount", (Object)totalFromAmount.add(totalFromTax));
            dataEntity.set("sim_original_bill_item", (Object)itemsNews);
            long endTime = System.currentTimeMillis();
            LOGGER.info("ArBill2OriginalBillBotpTimeMerge:" + (endTime - startTime));
            entitys.add(dataEntity);
        }
        this.setOriginalBillValueByInvoke(entitys, handler);
    }

    public void setOriginalBillValueByInvoke(List<DynamicObject> entitys, ArBill2OriginalBillCommonUtil handler) {
        handler.setOriginalBillValueByInvoke(entitys);
    }

    public ArBill2OriginalBillCommonUtil getArBill2OriginalBillUtil() {
        return new ArBill2OriginalBillCommonUtil();
    }

    private boolean isPresentItem(Object isPresent) {
        return null != isPresent && (Boolean)isPresent != false;
    }
}

