/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.botp.cv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.invoice.TaxClassMatcher;
import kd.fi.ar.formplugin.formservice.InvoiceBizService;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.invoice.FillIssueInfoHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ArFinPushInvoiceConverter
extends AbstractConvertPlugIn {
    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        HashMap<Long, String> idAndBillNoMap = new HashMap<Long, String>(selectedRows.size());
        ArrayList<Long> pks = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long pk = (Long)row.getPrimaryKeyValue();
            pks.add(pk);
            idAndBillNoMap.put(pk, row.getBillNo());
        }
        String srcBillextendName = this.getSrcMainType().getExtendName();
        Map existTargetBillMap = ArApHelper.isHasSameTarBill((String)srcBillextendName, (Long[])pks.toArray(new Long[0]), (String)"sim_original_bill");
        StringBuilder errMsg = new StringBuilder();
        for (Map.Entry nextEntry : existTargetBillMap.entrySet()) {
            if (!Boolean.TRUE.equals(nextEntry.getValue())) continue;
            if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                errMsg.append('\u3001');
            }
            errMsg.append((String)idAndBillNoMap.get(nextEntry.getKey()));
        }
        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u5df2\u901a\u8fc7\u5f00\u7968\u7533\u8bf7\u8fdb\u884c\u5f00\u7968\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvoiceConvertPlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntity[] targetDataEntity = e.getTargetExtDataEntitySet().FindByEntityKey("ar_invoice");
        InvoiceBizService service = new InvoiceBizService();
        HashMap<Long, DynamicObject> orgIdAndConfigMap = new HashMap<Long, DynamicObject>(8);
        this.setTaxClass(targetDataEntity);
        Map invoiceTypePKMap = InvoiceTypeHelper.getInvoiceTypePKMap();
        for (ExtendedDataEntity invoiceEntity : targetDataEntity) {
            String drawer;
            DynamicObject org;
            String firmName;
            DynamicObject invoice = invoiceEntity.getDataEntity();
            DynamicObject invoicetypef7 = invoice.getDynamicObject("invoicetypef7");
            String invoicetype = invoice.getString("invoicetype");
            if (invoicetypef7 == null) {
                Long pk = invoiceTypePKMap.computeIfAbsent(InvoiceType.getTypeNo((String)invoicetype), v -> 0L);
                invoice.set("invoicetypef7", (Object)pk);
            } else {
                String number = invoicetypef7.getString("number");
                String value = InvoiceType.getValue((String)number);
                if (value == null) {
                    value = number;
                }
                invoice.set("invoicetype", (Object)value);
            }
            Date date = invoice.getDate("bizdate");
            if (ObjectUtils.isEmpty((Object)date)) {
                invoice.set("bizdate", (Object)new Date());
            }
            if (StringUtils.isEmpty((String)(firmName = (org = invoice.getDynamicObject("org")).getString("ffirmname")))) {
                invoice.set("sellername", (Object)org.getLocaleString("name"));
            } else {
                invoice.set("sellername", (Object)firmName);
            }
            DynamicObject asstact = invoice.getDynamicObject("asstact");
            String buyerName = invoice.getString("buyername");
            if (EmptyUtils.isEmpty((Object)buyerName) && asstact != null) {
                invoice.set("buyername", (Object)asstact.getString("name"));
            }
            FillIssueInfoHelper.fillInfo((DynamicObject)invoice);
            if (EmptyUtils.isNotEmpty((Object)org)) {
                Long orgId = org.getLong("id");
                DynamicObject config = (DynamicObject)orgIdAndConfigMap.get(orgId);
                if (EmptyUtils.isEmpty((Object)config)) {
                    config = service.getStaffCfg(org);
                    orgIdAndConfigMap.put(orgId, config);
                }
                if (EmptyUtils.isNotEmpty((Object)config)) {
                    if (ObjectUtils.isEmpty((Object)invoice.get("payer"))) {
                        invoice.set("payer", config.get("payer"));
                    }
                    if (ObjectUtils.isEmpty((Object)invoice.get("checker"))) {
                        invoice.set("checker", config.get("checker"));
                    }
                    if (ObjectUtils.isEmpty((Object)invoice.get("drawer"))) {
                        invoice.set("drawer", config.get("drawer"));
                    }
                }
            }
            if (ObjectUtils.isEmpty((Object)(drawer = invoice.getString("drawer")))) {
                invoice.set("drawer", (Object)RequestContext.get().getUserName());
            }
            this.setItemName(invoice);
            DynamicObjectCollection entrys = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                entry.set("e_unverifiedwriteoffamt", (Object)entry.getBigDecimal("e_recamount"));
                entry.set("e_unverifiedwriteoffqty", (Object)entry.getBigDecimal("e_quantity"));
                BigDecimal quantity = entry.getBigDecimal("e_quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
                DynamicObject material = entry.getDynamicObject("e_material");
                DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = null;
                if (!ObjectUtils.isEmpty((Object)material)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                        covertRate = UnitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)measureUnit.getLong("id"), (Long)baseUnit.getLong("id"));
                        covertRate = covertRate == null ? BigDecimal.ONE : covertRate;
                    }
                } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                    covertRate = BigDecimal.ONE;
                }
                if (EmptyUtils.isEmpty((Object)entry.getBigDecimal("e_unitcoefficient"))) {
                    entry.set("e_unitcoefficient", (Object)covertRate);
                }
                if (!EmptyUtils.isEmpty((Object)entry.getBigDecimal("e_baseunitqty"))) continue;
                entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit));
            }
            invoice.set("redinvoice", (Object)(BigDecimal.ZERO.compareTo(invoice.getBigDecimal("recamount")) > 0 ? 1 : 0));
        }
        this.setEntryAmt(targetDataEntity);
        this.setHeadAmt(targetDataEntity);
    }

    private void setEntryAmt(ExtendedDataEntity[] targetDataEntity) {
        HashSet<Long> sourceBillEntryIds = new HashSet<Long>(16);
        HashMap<Long, Tuple> sourceBillEntryQtyOrAmt = new HashMap<Long, Tuple>(16);
        for (ExtendedDataEntity invoiceEntity : targetDataEntity) {
            DynamicObject invoice = invoiceEntity.getDataEntity();
            DynamicObjectCollection entry = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Long sourceBillEntryId = row.getLong("e_sourcebillentryid");
                if (sourceBillEntryId == null || sourceBillEntryId == 0L) continue;
                sourceBillEntryIds.add(sourceBillEntryId);
            }
        }
        DynamicObjectCollection sourceArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"entry.id,entry.e_quantity,entry.e_recamount", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", sourceBillEntryIds)});
        for (DynamicObject sourceBill : sourceArBills) {
            Long sourceEntryId = sourceBill.getLong("entry.id");
            Tuple tuple = Tuple.create((Object)sourceBill.getBigDecimal("entry.e_quantity"), (Object)sourceBill.getBigDecimal("entry.e_recamount"));
            sourceBillEntryQtyOrAmt.put(sourceEntryId, tuple);
        }
        for (ExtendedDataEntity invoiceEntity : targetDataEntity) {
            DynamicObject invoice = invoiceEntity.getDataEntity();
            boolean includeTax = invoice.getBoolean("isincludetax");
            DynamicObjectCollection entry = invoice.getDynamicObjectCollection("entry");
            boolean isAmount = invoice.getBoolean("isamount");
            for (DynamicObject row : entry) {
                BigDecimal invQty = row.getBigDecimal("e_quantity");
                BigDecimal invAmt = row.getBigDecimal("e_recamount");
                Long sourceBillEntryId = row.getLong("e_sourcebillentryid");
                Tuple tuple = (Tuple)sourceBillEntryQtyOrAmt.get(sourceBillEntryId);
                if (tuple == null) continue;
                if (isAmount) {
                    BigDecimal srcAmt = (BigDecimal)tuple.item2;
                    if (invAmt.abs().compareTo(srcAmt.abs()) >= 0) continue;
                    this.calculatorEntryAmt(includeTax, invoice, row);
                    continue;
                }
                BigDecimal srcQty = (BigDecimal)tuple.item1;
                if (invQty.abs().compareTo(srcQty.abs()) >= 0) continue;
                this.calculatorEntryAmt(includeTax, invoice, row);
            }
        }
    }

    private void calculatorEntryAmt(boolean includeTax, DynamicObject invoice, DynamicObject row) {
        UnitPriceCalculator calculator;
        BigDecimal discountAmt;
        DynamicObject basecurrency;
        DynamicObject currency = invoice.getDynamicObject("currency");
        int precision = ObjectUtils.isEmpty((Object)currency) ? 2 : currency.getInt("amtprecision");
        BigDecimal rate = invoice.getBigDecimal("exchangerate");
        String quotation = invoice.getString("quotation");
        if (quotation == null || rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int localprecision = ObjectUtils.isEmpty((Object)(basecurrency = invoice.getDynamicObject("basecurrency"))) ? 2 : basecurrency.getInt("amtprecision");
        BigDecimal qty = row.getBigDecimal("e_quantity");
        BigDecimal taxRate = row.getBigDecimal("e_taxrate");
        String discountMode = row.getString("e_discountmode");
        BigDecimal discountRate = row.getBigDecimal("e_discountrate");
        BigDecimal taxUnitPrice = row.getBigDecimal("e_taxunitprice");
        BigDecimal unitPrice = row.getBigDecimal("e_unitprice");
        if (includeTax) {
            if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                row.set("e_discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
            }
            discountAmt = row.getBigDecimal("e_discountamount");
            BigDecimal pricetaxtotal = row.getBigDecimal("e_recamount");
            calculator = new PriceTaxTotalCalculator(true, unitPrice, taxUnitPrice, qty, pricetaxtotal, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else {
            if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                row.set("e_discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
            }
            discountAmt = row.getBigDecimal("e_discountamount");
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, quotation);
        localCalculator.calculate();
        this.resetEntryProp(row, localCalculator);
    }

    private void resetEntryProp(DynamicObject row, PriceLocalCalculator localCalculator) {
        row.set("e_unitprice", (Object)localCalculator.getUnitprice());
        row.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
        row.set("e_actunitprice", (Object)localCalculator.getActunitprice());
        row.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
        row.set("e_tax", (Object)localCalculator.getTax());
        row.set("e_amount", (Object)localCalculator.getAmount());
        row.set("e_localamt", (Object)localCalculator.getAmountlocal());
        row.set("e_recamount", (Object)localCalculator.getPricetaxtotal());
        row.set("e_reclocalamt", (Object)localCalculator.getPricetaxtotallocal());
        row.set("e_unverifiedwriteoffamt", (Object)localCalculator.getPricetaxtotal());
        row.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
    }

    private void setHeadAmt(ExtendedDataEntity[] targetDataEntity) {
        for (ExtendedDataEntity invoiceEntity : targetDataEntity) {
            DynamicObject invoice = invoiceEntity.getDataEntity();
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal recamount = BigDecimal.ZERO;
            BigDecimal reclocalamt = BigDecimal.ZERO;
            BigDecimal localamt = BigDecimal.ZERO;
            DynamicObjectCollection entry = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                amount = amount.add(row.getBigDecimal("e_amount"));
                localamt = localamt.add(row.getBigDecimal("e_localamt"));
                tax = tax.add(row.getBigDecimal("e_tax"));
                recamount = recamount.add(row.getBigDecimal("e_recamount"));
                reclocalamt = reclocalamt.add(row.getBigDecimal("e_reclocalamt"));
            }
            invoice.set("amount", (Object)amount);
            invoice.set("localamt", (Object)localamt);
            invoice.set("tax", (Object)tax);
            invoice.set("recamount", (Object)recamount);
            invoice.set("reclocalamt", (Object)reclocalamt);
        }
    }

    private void setItemName(DynamicObject invoice) {
        DynamicObjectCollection entry = invoice.getDynamicObjectCollection("entry");
        boolean isSal = "SAL".equals(invoice.getString("biztype"));
        for (DynamicObject row : entry) {
            DynamicObject item;
            if (!EmptyUtils.isEmpty((Object)row.getString("e_itemname")) || (item = isSal ? row.getDynamicObject("e_material") : row.getDynamicObject("e_expenseitem")) == null) continue;
            row.set("e_itemname", (Object)item.getString("name"));
        }
    }

    private void setTaxClass(ExtendedDataEntity[] targetDataEntity) {
        ArrayList<DynamicObject> materialInvoices = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> expenseInvoices = new ArrayList<DynamicObject>(8);
        HashMap<Long, List<DynamicObject>> asstactAndMaterialEntryMap = new HashMap<Long, List<DynamicObject>>(8);
        HashMap<Long, List<DynamicObject>> asstactAndExpenseEntryMap = new HashMap<Long, List<DynamicObject>>(8);
        for (ExtendedDataEntity data : targetDataEntity) {
            ArrayList tempList;
            List entries;
            DynamicObject invoice = data.getDataEntity();
            Long asstactId = invoice.getLong("asstact.id");
            if ("SAL".equals(invoice.getString("biztype"))) {
                materialInvoices.add(invoice);
                entries = (List)asstactAndMaterialEntryMap.get(asstactId);
                if (entries != null) {
                    entries.addAll(invoice.getDynamicObjectCollection("entry"));
                    continue;
                }
                tempList = new ArrayList(10);
                tempList.addAll(invoice.getDynamicObjectCollection("entry"));
                asstactAndMaterialEntryMap.put(asstactId, tempList);
                continue;
            }
            expenseInvoices.add(invoice);
            entries = (List)asstactAndExpenseEntryMap.get(asstactId);
            if (entries != null) {
                entries.addAll(invoice.getDynamicObjectCollection("entry"));
                continue;
            }
            tempList = new ArrayList(10);
            tempList.addAll(invoice.getDynamicObjectCollection("entry"));
            asstactAndExpenseEntryMap.put(asstactId, tempList);
        }
        List<DynamicObject> materialEntryItem = this.getEntryItemMap(materialInvoices, "e_material");
        List<DynamicObject> expenseEntryItem = this.getEntryItemMap(expenseInvoices, "e_expenseitem");
        if (!materialEntryItem.isEmpty()) {
            this.setTaxField(asstactAndMaterialEntryMap, materialEntryItem, "e_material");
        }
        if (!expenseEntryItem.isEmpty()) {
            this.setTaxField(asstactAndExpenseEntryMap, expenseEntryItem, "e_expenseitem");
        }
    }

    private void setTaxField(Map<Long, List<DynamicObject>> entryMap, List<DynamicObject> entryItems, String entryItemType) {
        TaxClassMatcher taxClassMatcher = new TaxClassMatcher(null, entryItems);
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : entryMap.entrySet()) {
            Long asstactId = mapEntry.getKey();
            List<DynamicObject> entries = mapEntry.getValue();
            for (DynamicObject entry : entries) {
                DynamicObject taxClassMappingInfo;
                DynamicObject entryItem = entry.getDynamicObject(entryItemType);
                if (entryItem == null || entry.getDynamicObject("e_taxclass") != null || (taxClassMappingInfo = taxClassMatcher.getTaxClassMappingInfo(asstactId, entryItem)) == null) continue;
                DynamicObject taxsupertypenum = taxClassMappingInfo.getDynamicObject("taxsupertypenum");
                entry.set("e_taxclass", (Object)taxsupertypenum);
                if (EmptyUtils.isEmpty((Object)entry.getString("e_invspectype"))) {
                    entry.set("e_invspectype", (Object)taxClassMappingInfo.getString("spectype"));
                }
                if (EmptyUtils.isEmpty((Object)entry.getString("e_itemname"))) {
                    entry.set("e_itemname", (Object)taxClassMappingInfo.getString("invname"));
                }
                if (!EmptyUtils.isEmpty((Object)entry.getDynamicObject("taxrateid"))) continue;
                entry.set("taxrateid", (Object)taxClassMappingInfo.getDynamicObject("taxratef7"));
                entry.set("e_taxrate", (Object)taxClassMappingInfo.getBigDecimal("taxrate").multiply(new BigDecimal(100)));
            }
        }
    }

    private List<DynamicObject> getEntryItemMap(List<DynamicObject> invoices, String entryItemType) {
        ArrayList<DynamicObject> asstactAndEntryItems = new ArrayList<DynamicObject>(8);
        for (DynamicObject invoice : invoices) {
            DynamicObjectCollection entries = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                DynamicObject entryItem = entry.getDynamicObject(entryItemType);
                if (entryItem == null || entry.getDynamicObject("e_taxclass") != null) continue;
                asstactAndEntryItems.add(entryItem);
            }
        }
        return asstactAndEntryItems;
    }
}

