/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.botp.cv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.ar.formplugin.botp.cv.BusArBill2OriginalBillCommonUtil;
import kd.fi.ar.util.UUID;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.model.BusArBillModel;
import kd.fi.arapcommon.util.EmptyUtils;

public class BusArBill2OriginalBillPlugin
extends AbstractConvertPlugIn {
    private static final Log LOGGER = LogFactory.getLog(BusArBill2OriginalBillPlugin.class);
    private static final String RMB = "cny";
    private static int IMC_AMT_PRECISION = 2;
    private static int IMC_NUM_PRECISION = 8;

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        Map existOriginalBillMap;
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        HashMap<Long, String> idAndBillNoMap = new HashMap<Long, String>(selectedRows.size());
        ArrayList<Long> pks = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long pk = (Long)row.getPrimaryKeyValue();
            pks.add(pk);
            idAndBillNoMap.put(pk, row.getBillNo());
        }
        String srcBillextendName = this.getSrcMainType().getExtendName();
        Map existTargetBillMap = ArApHelper.isHasSameTarBill((String)srcBillextendName, (Long[])pks.toArray(new Long[0]), (String)"ar_invoice");
        StringBuilder errMsg = new StringBuilder();
        for (Map.Entry nextEntry : existTargetBillMap.entrySet()) {
            if (!Boolean.TRUE.equals(nextEntry.getValue())) continue;
            if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                errMsg.append('\u3001');
            }
            errMsg.append((String)idAndBillNoMap.get(nextEntry.getKey()));
        }
        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u5df2\u901a\u8fc7\u5f00\u7968\u5355\u8fdb\u884c\u5f00\u7968\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusArBill2OriginalBillPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
        }
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)"ar_busbill", (Long[])pks.toArray(new Long[0]), null);
        if (bfRowLinkDownNodes != null && bfRowLinkDownNodes.size() > 0) {
            TableDefine finArTableDefine = EntityMetadataCache.loadTableDefine((String)"ar_finarbill", (String)"ar_finarbill");
            Long finArTableId = finArTableDefine.getTableId();
            ArrayList finArNodes = new ArrayList(8);
            for (BFRowLinkDownNode node : bfRowLinkDownNodes) {
                BOTPHelper.findTargetNodes((BFRowLinkDownNode)node, (Long)finArTableId, finArNodes);
            }
            TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)"sim_original_bill", (String)"sim_original_bill");
            DynamicObject[] tableId = tableDefine.getTableId();
            ArrayList originalNodes = new ArrayList(8);
            for (BFRowLinkDownNode node : finArNodes) {
                BOTPHelper.findTargetNodes((BFRowLinkDownNode)node, (Long)tableId, originalNodes);
            }
            if (originalNodes.size() > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u6e38\u7684\u8d22\u52a1\u5e94\u6536\u5355\u5df2\u5f00\u7968\uff0c\u6682\u4f30\u5e94\u6536\u5355\u4e0d\u5141\u8bb8\u518d\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u8fdb\u884c\u5f00\u7968\u3002", (String)"BusArBill2OriginalBillPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        }
        DynamicObject[] busBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id,sourcebillno,sourcebilltype,org", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        HashSet<Long> orgIds = new HashSet<Long>(8);
        HashSet<String> srcBillNos = new HashSet<String>(8);
        HashSet<String> srcBillTypes = new HashSet<String>(8);
        for (DynamicObject bill : busBills) {
            orgIds.add(bill.getLong("org.id"));
            if (EmptyUtils.isNotEmpty((Object)bill.getString("sourcebillno"))) {
                srcBillNos.add(bill.getString("sourcebillno"));
            }
            if (!EmptyUtils.isNotEmpty((Object)bill.getString("sourcebilltype"))) continue;
            srcBillTypes.add(bill.getString("sourcebilltype"));
        }
        QFilter finArFilter = new QFilter("org", "in", orgIds);
        finArFilter.and(new QFilter("sourcebillno", "in", srcBillNos));
        finArFilter.and(new QFilter("sourcebilltype", "in", srcBillTypes));
        finArFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{finArFilter});
        List<Long> finArIds = Arrays.stream(finArBills).map(finArBill -> finArBill.getLong("id")).collect(Collectors.toList());
        if (finArIds.size() > 0 && (existOriginalBillMap = ArApHelper.isHasSameTarBill((String)"ar_finarbill", (Long[])finArIds.toArray(new Long[0]), (String)"sim_original_bill")).containsValue(Boolean.TRUE)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\u540c\u6e90\u7684\u8d22\u52a1\u5e94\u6536\u5355\u5df2\u5f00\u7968\uff0c\u6682\u4f30\u5e94\u6536\u5355\u4e0d\u5141\u8bb8\u518d\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u3002", (String)"BusArBill2OriginalBillPlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        List<Long> partPushAndhaveDisCountAmtBusEntryIds = this.getPartPushBusEntryIds(pks);
        if (partPushAndhaveDisCountAmtBusEntryIds.size() > 0) {
            List custQFilters = e.getCustQFilters();
            QFilter filter = new QFilter("entry.id", "not in", partPushAndhaveDisCountAmtBusEntryIds);
            e.setCustFilterExpression(filter.toString());
            custQFilters.add(filter);
            String desc = ResManager.loadKDString((String)"\u6298\u6263\u989d\u4e0d\u4e3a0\u65f6\uff0c\u672a\u51b2\u56de\u6216\u672a\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u7684\u6682\u4f30\u5e94\u6536\u5355\u624d\u5141\u8bb8\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u3002", (String)"BusArBill2OriginalBillPlugin_5", (String)"fi-arapcommon", (Object[])new Object[0]);
            e.setCustFilterDesc(desc);
        }
    }

    private List<Long> getPartPushBusEntryIds(List<Long> pks) {
        ArrayList<Long> entryIds = new ArrayList<Long>(16);
        DataSet busBills = QueryServiceHelper.queryDataSet((String)"partpush", (String)"ar_busbill", (String)"entry.id,entry.e_quantity,entry.e_amount,entry.e_unwoffqty,entry.e_unwoffnotaxamt,entry.e_uninvoicedqty,entry.e_uninvnotaxamt", (QFilter[])new QFilter[]{new QFilter("id", "in", pks), new QFilter("isadjust", "=", (Object)Boolean.FALSE), new QFilter("entry.e_unitprice", "!=", (Object)BigDecimal.ZERO), new QFilter("entry.e_discountamount", "!=", (Object)BigDecimal.ZERO)}, null);
        for (Row row : busBills) {
            BigDecimal qty = row.getBigDecimal("entry.e_quantity");
            BigDecimal amount = row.getBigDecimal("entry.e_amount");
            BigDecimal unWoffQty = row.getBigDecimal("entry.e_unwoffqty");
            BigDecimal unWoffAmt = row.getBigDecimal("entry.e_unwoffnotaxamt");
            BigDecimal unInvQty = row.getBigDecimal("entry.e_uninvoicedqty");
            BigDecimal unInvAmt = row.getBigDecimal("entry.e_uninvnotaxamt");
            if (qty.compareTo(unWoffQty) == 0 && qty.compareTo(unInvQty) == 0 && amount.compareTo(unWoffAmt) == 0 && amount.compareTo(unInvAmt) == 0) continue;
            entryIds.add(row.getLong("entry.id"));
        }
        return entryIds;
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        BusArBill2OriginalBillCommonUtil.addFilterAndQueryFields(e);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        BusArBillModel busArBillModel = new BusArBillModel();
        BusArBill2OriginalBillCommonUtil handler = this.getArBill2OriginalBillUtil();
        long startTime = System.currentTimeMillis();
        String tgtName = this.getTgtMainType().getName();
        ExtendedDataEntity[] extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(tgtName);
        Map srcfldPro = e.getFldProperties();
        String batchNumber = "100_" + UUID.getBatchNumber() + '_';
        int serialNo = 0;
        ArrayList<DynamicObject> entitys = new ArrayList<DynamicObject>();
        HashMap<Object, DynamicObject> sourceMap = new HashMap<Object, DynamicObject>();
        HashMap<Object, Map<Object, DynamicObject>> sourceItemMap = new HashMap<Object, Map<Object, DynamicObject>>();
        String srcBillName = this.getSrcMainType().getName();
        handler.fillSourceMap(extendedDataEntities, srcfldPro, sourceMap, sourceItemMap, srcBillName);
        int itemEntitySeq = 0;
        for (ExtendedDataEntity entity : extendedDataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            List sourceBillRows = (List)entity.getValue("ConvertSource");
            handler.setRemark(dataEntity);
            handler.setBillNoByDB(dataEntity);
            DynamicObject sourceRow = (DynamicObject)sourceBillRows.get(0);
            Object sourceId = ((DynamicProperty)srcfldPro.get("id")).getValue((Object)sourceRow);
            DynamicObject sourceObj = sourceMap.get(sourceId);
            handler.setHSBZ(entity, sourceObj);
            handler.setBuyerAndSallerInfo(entity, sourceObj);
            handler.setConstantData(dataEntity, null);
            dataEntity.set("originbillseq", (Object)(batchNumber + serialNo));
            ++serialNo;
            DynamicObjectCollection items = dataEntity.getDynamicObjectCollection("sim_original_bill_item");
            DynamicObjectCollection itemsNews = new DynamicObjectCollection();
            ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
            ExtendedDataEntity[] sim_original_bill_items = targetExtDataEntitySet.FindByEntityKey("sim_original_bill_item");
            int length = items.size();
            int seqIncrement = 0;
            boolean isFrom = !RMB.equalsIgnoreCase(dataEntity.getDynamicObject("fromcurr").getString("number"));
            BigDecimal invoiceAmount = sourceObj.getBigDecimal(busArBillModel.HEAD_PRICETAXTOTAL);
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalTax = BigDecimal.ZERO;
            BigDecimal totalFromAmount = BigDecimal.ZERO;
            BigDecimal totalFromTax = BigDecimal.ZERO;
            for (int i = 0; i < length; ++i) {
                BigDecimal discountAmtWithTax;
                ++seqIncrement;
                ExtendedDataEntity itemConstruct = sim_original_bill_items[itemEntitySeq];
                ++itemEntitySeq;
                DynamicObject source = (DynamicObject)((List)itemConstruct.getValue("ConvertSource")).get(0);
                DynamicObject billTypeDO = sourceObj.getDynamicObject(busArBillModel.HEAD_BILLTYPE);
                String entryItemType = handler.getEntryItemType(billTypeDO);
                Object sourceBillId = ((DynamicProperty)srcfldPro.get(busArBillModel.HEAD_PK)).getValue((Object)source);
                Object sourceEntryId = ((DynamicProperty)srcfldPro.get(busArBillModel.ENTRY_PK)).getValue((Object)source);
                Map<Object, DynamicObject> currentSourceItemMap = sourceItemMap.get(sourceBillId);
                DynamicObject sourceEntryRow = currentSourceItemMap.get(sourceEntryId);
                DynamicObject tgtEntryRow = (DynamicObject)items.get(i);
                String expenseItemName = String.valueOf(((DynamicProperty)srcfldPro.get("e_expenseitem.name")).getValue((Object)source));
                String materialName = String.valueOf(((DynamicProperty)srcfldPro.get("e_material.name")).getValue((Object)source));
                String name = "NULL".equalsIgnoreCase(expenseItemName) ? materialName : expenseItemName;
                tgtEntryRow.set("origoodsname", (Object)name);
                if (StringUtils.isBlank((CharSequence)tgtEntryRow.getString("goodsname"))) {
                    tgtEntryRow.set("goodsname", (Object)name);
                }
                BigDecimal bigTaxRate = (BigDecimal)((DynamicProperty)srcfldPro.get(busArBillModel.E_TAXRATE)).getValue((Object)source);
                BigDecimal rateValue = handler.execTaxRate(bigTaxRate.divide(new BigDecimal("100"), 5, RoundingMode.HALF_UP).toPlainString());
                tgtEntryRow.set("taxrate", (Object)rateValue.toPlainString());
                handler.setItemTaxClass(entryItemType, sourceEntryRow, tgtEntryRow);
                String e_discountmode = String.valueOf(((DynamicProperty)srcfldPro.get(busArBillModel.E_DISCOUNTMODE)).getValue((Object)source));
                DynamicObject fromCurrency = (DynamicObject)dataEntity.get("fromcurr");
                String quotation = (String)entity.getValue("quotation");
                if (isFrom) {
                    BigDecimal exrate = (BigDecimal)entity.getValue("exrate");
                    discountAmtWithTax = handler.calToAmount(quotation, exrate, sourceEntryRow.getBigDecimal(busArBillModel.E_DISCOUNTAMOUNT), fromCurrency);
                } else {
                    discountAmtWithTax = sourceEntryRow.getBigDecimal(busArBillModel.E_DISCOUNTAMOUNT);
                }
                boolean hsbzFlag = sourceObj.getBoolean(busArBillModel.HEAD_ISINCLUDETAX);
                tgtEntryRow.set("seq", (Object)seqIncrement);
                if (invoiceAmount.compareTo(BigDecimal.ZERO) < 0 || "NULL".equals(e_discountmode) || BigDecimal.ZERO.compareTo(discountAmtWithTax) == 0) {
                    itemsNews.add((Object)tgtEntryRow);
                    totalAmount = totalAmount.add(tgtEntryRow.getBigDecimal("amount"));
                    totalTax = totalTax.add(tgtEntryRow.getBigDecimal("tax"));
                    totalFromAmount = totalFromAmount.add(tgtEntryRow.getBigDecimal("fromamount"));
                    totalFromTax = totalFromTax.add(tgtEntryRow.getBigDecimal("fromtax"));
                } else {
                    BigDecimal unitPrice = tgtEntryRow.getBigDecimal("unitprice");
                    BigDecimal num = tgtEntryRow.getBigDecimal("num");
                    Object isPresent = sourceEntryRow.get(busArBillModel.E_ISPRESENT);
                    BigDecimal e_recAmount = sourceEntryRow.getBigDecimal(busArBillModel.E_PRICETAXTOTAL);
                    BigDecimal e_discountAmount = sourceEntryRow.getBigDecimal(busArBillModel.E_DISCOUNTAMOUNT);
                    boolean isAllDiscount = e_recAmount.compareTo(BigDecimal.ZERO) == 0 && e_discountAmount.compareTo(BigDecimal.ZERO) != 0;
                    BigDecimal itemTaxRate = sourceEntryRow.getBigDecimal(busArBillModel.E_TAXRATE).divide(new BigDecimal("100"));
                    if (null != isPresent && ((Boolean)isPresent).booleanValue() || isAllDiscount) {
                        handler.dealPresentItem(handler, isFrom, entity, itemsNews, seqIncrement, tgtEntryRow, fromCurrency, quotation, hsbzFlag, unitPrice, num, itemTaxRate);
                    } else {
                        tgtEntryRow.set("discountamount", null);
                        tgtEntryRow.set("discountrate", null);
                        itemsNews.add((Object)tgtEntryRow);
                        BigDecimal discountAmount = discountAmtWithTax.divide(BigDecimal.ONE.add(rateValue), IMC_AMT_PRECISION, RoundingMode.HALF_UP);
                        BigDecimal discountTax = discountAmtWithTax.subtract(discountAmount);
                        DynamicObject newRow = handler.createNewRow(++seqIncrement, tgtEntryRow, discountAmtWithTax, discountAmount, discountTax, itemsNews, hsbzFlag);
                        totalTax = totalTax.add(newRow.getBigDecimal("tax"));
                        totalTax = totalTax.add(tgtEntryRow.getBigDecimal("tax"));
                        totalAmount = totalAmount.add(newRow.getBigDecimal("amount"));
                        totalAmount = totalAmount.add(tgtEntryRow.getBigDecimal("amount"));
                        if (isFrom) {
                            handler.dealItemFromInfo(sourceEntryRow, newRow, itemTaxRate, tgtEntryRow, fromCurrency);
                        }
                        totalFromAmount = totalFromAmount.add(newRow.getBigDecimal("fromamount"));
                        totalFromTax = totalFromTax.add(newRow.getBigDecimal("fromtax"));
                        totalFromAmount = totalFromAmount.add(tgtEntryRow.getBigDecimal("fromamount"));
                        totalFromTax = totalFromTax.add(tgtEntryRow.getBigDecimal("fromtax"));
                    }
                }
                if (hsbzFlag) {
                    tgtEntryRow.set("remainvalidamount", tgtEntryRow.get("taxamount"));
                } else {
                    tgtEntryRow.set("remainvalidamount", tgtEntryRow.get("amount"));
                }
                tgtEntryRow.set("orifromtaxamount", (Object)tgtEntryRow.getBigDecimal("fromtaxamount"));
                tgtEntryRow.set("oritaxamount", (Object)tgtEntryRow.getBigDecimal("taxamount"));
                tgtEntryRow.set("remainvalidnum", tgtEntryRow.get("num"));
                tgtEntryRow.set("remainvalidtax", tgtEntryRow.get("tax"));
            }
            handler.setCurrencyAndAmount(entity, sourceObj, totalAmount, totalTax);
            entity.setValue("foreigninvoiceamount", (Object)totalFromAmount);
            entity.setValue("foreigntax", (Object)totalFromTax);
            entity.setValue("foreigntotalamount", (Object)totalFromAmount.add(totalFromTax));
            dataEntity.set("sim_original_bill_item", (Object)itemsNews);
            long endTime = System.currentTimeMillis();
            LOGGER.info("BusArBill2OriginalBillPlugin:" + (endTime - startTime));
            entitys.add(dataEntity);
        }
        handler.setOriginalBillValueByInvoke(entitys);
    }

    public BusArBill2OriginalBillCommonUtil getArBill2OriginalBillUtil() {
        return new BusArBill2OriginalBillCommonUtil();
    }
}

