/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.botp.cv;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.fi.arapcommon.util.DateUtils;

public class FinArToDcmRecordPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entities;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entities = entitySet.FindByEntityKey("dcm_collrecord")) {
            DynamicObject collRecord = entity.getDataEntity();
            this.entrySummary(collRecord);
        }
    }

    private void entrySummary(DynamicObject record) {
        DynamicObjectCollection srcentry = record.getDynamicObjectCollection("srcentry");
        if (srcentry == null || srcentry.size() == 0) {
            return;
        }
        Date earlistDate = null;
        Date latestDate = null;
        int overDueDay = 0;
        BigDecimal overDueAmt = BigDecimal.ZERO;
        for (DynamicObject row : srcentry) {
            Date e_srcduedate;
            boolean isClose = row.getBoolean("e_isclose");
            BigDecimal eSrcOverAmount = row.getBigDecimal("e_srcoveramount");
            if (!isClose) {
                overDueAmt = overDueAmt.add(eSrcOverAmount);
            }
            if ((e_srcduedate = row.getDate("e_srcduedate")) == null) continue;
            if (earlistDate == null) {
                earlistDate = e_srcduedate;
            } else if (e_srcduedate.before(earlistDate)) {
                earlistDate = e_srcduedate;
            }
            if (latestDate == null) {
                latestDate = e_srcduedate;
                continue;
            }
            if (!e_srcduedate.after(latestDate)) continue;
            latestDate = e_srcduedate;
        }
        if (earlistDate != null) {
            overDueDay = DateUtils.getDiffDays(earlistDate, (Date)new Date()) - 1;
        }
        record.set("earlistdate", earlistDate);
        record.set("lastestdate", latestDate);
        record.set("overdueday", (Object)overDueDay);
        record.set("overdueamt", (Object)overDueAmt);
    }
}

