/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.botp.cv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.fi.ar.business.invoice.TaxClassMatcher;
import kd.fi.ar.formplugin.formservice.InvoiceBizService;
import kd.fi.arapcommon.convert.InitConvertHelper;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.invoice.FillIssueInfoHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceConvertPlugin
extends AbstractConvertPlugIn {
    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        HashMap<Long, String> idAndBillNoMap = new HashMap<Long, String>(selectedRows.size());
        ArrayList<Long> pks = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long pk = (Long)row.getPrimaryKeyValue();
            pks.add(pk);
            idAndBillNoMap.put(pk, row.getBillNo());
        }
        String srcBillextendName = this.getSrcMainType().getExtendName();
        Map existTargetBillMap = ArApHelper.isHasSameTarBill((String)srcBillextendName, (Long[])pks.toArray(new Long[0]), (String)"sim_original_bill");
        StringBuilder errMsg = new StringBuilder();
        for (Map.Entry nextEntry : existTargetBillMap.entrySet()) {
            if (!Boolean.TRUE.equals(nextEntry.getValue())) continue;
            if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
                errMsg.append('\u3001');
            }
            errMsg.append((String)idAndBillNoMap.get(nextEntry.getKey()));
        }
        if (errMsg.length() > 0 && !"".equals(errMsg.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u5df2\u901a\u8fc7\u5f00\u7968\u7533\u8bf7\u8fdb\u884c\u5f00\u7968\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvoiceConvertPlugin_2", (String)"fi-ar-formplugin", (Object[])new Object[]{errMsg.toString()}));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("ar_invoice");
        InvoiceBizService service = new InvoiceBizService();
        HashMap<Long, DynamicObject> orgIdAndConfigMap = new HashMap<Long, DynamicObject>(8);
        HashMap<Long, List> billByOrgId = new HashMap<Long, List>(4);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            Long orgId = bill.getLong("org.id");
            if (ObjectUtils.isEmpty((Object)orgId)) {
                return;
            }
            List bills = billByOrgId.computeIfAbsent(orgId, a -> new ArrayList(64));
            bills.add(bill);
        }
        new InitConvertHelper("ar_init", this.getRule(), billByOrgId);
        this.setTaxClass(entitys);
        FillIssueInfoHelper.fillInfo((boolean)false, (ExtendedDataEntity[])entitys);
        Map invoiceTypePKMap = InvoiceTypeHelper.getInvoiceTypePKMap();
        QueryUtil queryUtil = new QueryUtil();
        for (ExtendedDataEntity entity : entitys) {
            Date date;
            DynamicObject asstact;
            String buyerName;
            String firmName;
            DynamicObject config;
            DynamicObject invoice = entity.getDataEntity();
            DynamicObject invoicetypef7 = invoice.getDynamicObject("invoicetypef7");
            String invoicetype = invoice.getString("invoicetype");
            if (invoicetypef7 == null) {
                Long pk = invoiceTypePKMap.computeIfAbsent(InvoiceType.getTypeNo((String)invoicetype), v -> 0L);
                invoice.set("invoicetypef7", (Object)pk);
            } else {
                String number = invoicetypef7.getString("number");
                String value = InvoiceType.getValue((String)number);
                if (value == null) {
                    value = number;
                }
                invoice.set("invoicetype", (Object)value);
            }
            DynamicObject org = invoice.getDynamicObject("org");
            long orgId = invoice.getLong("org.id");
            if (invoice.get("salesorg") == null && org.getBoolean("fissale")) {
                invoice.set("salesorg", (Object)org);
            }
            if (EmptyUtils.isEmpty((Object)(config = (DynamicObject)orgIdAndConfigMap.get(orgId)))) {
                config = service.getStaffCfg(org);
                orgIdAndConfigMap.put(orgId, config);
            }
            if (EmptyUtils.isNotEmpty((Object)config)) {
                if (ObjectUtils.isEmpty((Object)invoice.get("payer"))) {
                    invoice.set("payer", config.get("payer"));
                }
                if (ObjectUtils.isEmpty((Object)invoice.get("checker"))) {
                    invoice.set("checker", config.get("checker"));
                }
                if (ObjectUtils.isEmpty((Object)invoice.get("drawer"))) {
                    invoice.set("drawer", config.get("drawer"));
                }
            }
            if (StringUtils.isNotEmpty((String)(firmName = org.getString("ffirmname")))) {
                invoice.set("sellername", (Object)firmName);
            }
            if (EmptyUtils.isEmpty((Object)(buyerName = invoice.getString("buyername"))) && (asstact = invoice.getDynamicObject("asstact")) != null) {
                buyerName = asstact.getString("name");
                invoice.set("buyername", (Object)buyerName);
            }
            if (ObjectUtils.isEmpty((Object)(date = invoice.getDate("bizdate")))) {
                invoice.set("bizdate", (Object)new Date());
            }
            BigDecimal exchangeRate = invoice.getBigDecimal("exchangerate");
            String quotation = invoice.getString("quotation");
            DynamicObjectCollection entrys = invoice.getDynamicObjectCollection("entry");
            int baseprecision = invoice.getInt("basecurrency.amtprecision");
            for (DynamicObject entry : entrys) {
                entry.set("e_unverifiedwriteoffamt", (Object)entry.getBigDecimal("e_recamount"));
                entry.set("e_unverifiedwriteoffqty", (Object)entry.getBigDecimal("e_quantity"));
                this.calculatorRows(exchangeRate, quotation, baseprecision, entry);
                BigDecimal quantity = entry.getBigDecimal("e_quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
                DynamicObject material = entry.getDynamicObject("e_material");
                DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                        covertRate = queryUtil.getConvertRate(Long.valueOf(material.getLong("id")), Long.valueOf(measureUnit.getLong("id")), Long.valueOf(baseUnit.getLong("id")));
                    }
                } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                    covertRate = BigDecimal.ONE;
                }
                if (EmptyUtils.isEmpty((Object)entry.getBigDecimal("e_unitcoefficient"))) {
                    entry.set("e_unitcoefficient", (Object)covertRate);
                }
                if (EmptyUtils.isEmpty((Object)entry.getBigDecimal("e_baseunitqty"))) {
                    entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit));
                }
                String discountMode = entry.getString("e_discountmode");
                int precision = invoice.getInt("currency.amtprecision");
                BigDecimal disCountRate = entry.getBigDecimal("e_discountrate");
                if (!"TOTAL".equals(discountMode) || disCountRate.compareTo(BigDecimal.ZERO) == 0) continue;
                Boolean isIncludetax = invoice.getBoolean("isincludetax");
                BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
                if (isIncludetax.booleanValue()) {
                    entry.set("e_discountamount", (Object)disCountRate.multiply(quantity).setScale(precision, RoundingMode.HALF_UP));
                    continue;
                }
                entry.set("e_discountamount", (Object)disCountRate.multiply(quantity).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
            }
            this.calculateHeadAmt(invoice);
            this.setItemName(invoice);
        }
    }

    public static BigDecimal getConvertExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        return InitConvertHelper.getConvertExchangeRate((Long)exratetableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
    }

    private void setItemName(DynamicObject invoice) {
        DynamicObjectCollection entry = invoice.getDynamicObjectCollection("entry");
        boolean isSal = "SAL".equals(invoice.getString("biztype"));
        for (DynamicObject row : entry) {
            DynamicObject item;
            if (!EmptyUtils.isEmpty((Object)row.getString("e_itemname")) || (item = isSal ? row.getDynamicObject("e_material") : row.getDynamicObject("e_expenseitem")) == null || !row.getString("e_itemname").isEmpty()) continue;
            row.set("e_itemname", (Object)item.getString("name"));
        }
    }

    private void calculatorRows(BigDecimal exchangeRate, String quotation, int baseprecision, DynamicObject entry) {
        BigDecimal reclocalamt;
        BigDecimal discountlocalamt;
        BigDecimal localamt;
        BigDecimal amount = entry.getBigDecimal("e_amount");
        BigDecimal discountamount = entry.getBigDecimal("e_discountamount");
        BigDecimal recamount = entry.getBigDecimal("e_recamount");
        if ("1".equals(quotation)) {
            localamt = amount.divide(exchangeRate, baseprecision, RoundingMode.HALF_UP);
            discountlocalamt = discountamount.divide(exchangeRate, baseprecision, RoundingMode.HALF_UP);
            reclocalamt = recamount.divide(exchangeRate, baseprecision, RoundingMode.HALF_UP);
        } else {
            localamt = amount.multiply(exchangeRate).setScale(baseprecision, RoundingMode.HALF_UP);
            discountlocalamt = discountamount.multiply(exchangeRate).setScale(baseprecision, RoundingMode.HALF_UP);
            reclocalamt = recamount.multiply(exchangeRate).setScale(baseprecision, RoundingMode.HALF_UP);
        }
        entry.set("e_localamt", (Object)localamt);
        entry.set("e_discountlocalamt", (Object)discountlocalamt);
        entry.set("e_reclocalamt", (Object)reclocalamt);
    }

    private void calculateHeadAmt(DynamicObject invoice) {
        DynamicObjectCollection entrys = invoice.getDynamicObjectCollection("entry");
        int count = entrys.size();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal reclocalamt = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            amount = amount.add((BigDecimal)((DynamicObject)entrys.get(i)).get("e_amount"));
            tax = tax.add((BigDecimal)((DynamicObject)entrys.get(i)).get("e_tax"));
            recamount = recamount.add((BigDecimal)((DynamicObject)entrys.get(i)).get("e_recamount"));
            reclocalamt = reclocalamt.add((BigDecimal)((DynamicObject)entrys.get(i)).get("e_reclocalamt"));
            localamt = localamt.add((BigDecimal)((DynamicObject)entrys.get(i)).get("e_localamt"));
        }
        invoice.set("amount", (Object)amount);
        invoice.set("tax", (Object)tax);
        invoice.set("recamount", (Object)recamount);
        invoice.set("reclocalamt", (Object)reclocalamt);
        invoice.set("localamt", (Object)localamt);
    }

    private void setTaxClass(ExtendedDataEntity[] targetDataEntity) {
        ArrayList<DynamicObject> materialInvoices = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> expenseInvoices = new ArrayList<DynamicObject>(8);
        HashMap<Long, List<DynamicObject>> asstactAndMaterialEntryMap = new HashMap<Long, List<DynamicObject>>(8);
        HashMap<Long, List<DynamicObject>> asstactAndExpenseEntryMap = new HashMap<Long, List<DynamicObject>>(8);
        for (ExtendedDataEntity data : targetDataEntity) {
            ArrayList tempList;
            List entries;
            DynamicObject invoice = data.getDataEntity();
            Long asstactId = invoice.getLong("asstact.id");
            if ("SAL".equals(invoice.getString("biztype"))) {
                materialInvoices.add(invoice);
                entries = (List)asstactAndMaterialEntryMap.get(asstactId);
                if (entries != null) {
                    entries.addAll(invoice.getDynamicObjectCollection("entry"));
                    continue;
                }
                tempList = new ArrayList(10);
                tempList.addAll(invoice.getDynamicObjectCollection("entry"));
                asstactAndMaterialEntryMap.put(asstactId, tempList);
                continue;
            }
            expenseInvoices.add(invoice);
            entries = (List)asstactAndExpenseEntryMap.get(asstactId);
            if (entries != null) {
                entries.addAll(invoice.getDynamicObjectCollection("entry"));
                continue;
            }
            tempList = new ArrayList(10);
            tempList.addAll(invoice.getDynamicObjectCollection("entry"));
            asstactAndExpenseEntryMap.put(asstactId, tempList);
        }
        List<DynamicObject> materialEntryItem = this.getEntryItemMap(materialInvoices, "e_material");
        List<DynamicObject> expenseEntryItem = this.getEntryItemMap(expenseInvoices, "e_expenseitem");
        if (!materialEntryItem.isEmpty()) {
            this.setTaxField(asstactAndMaterialEntryMap, materialEntryItem, "e_material");
        }
        if (!expenseEntryItem.isEmpty()) {
            this.setTaxField(asstactAndExpenseEntryMap, expenseEntryItem, "e_expenseitem");
        }
    }

    private void setTaxField(Map<Long, List<DynamicObject>> entryMap, List<DynamicObject> entryItems, String entryItemType) {
        TaxClassMatcher taxClassMatcher = new TaxClassMatcher(null, entryItems);
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : entryMap.entrySet()) {
            Long asstactId = mapEntry.getKey();
            List<DynamicObject> entries = mapEntry.getValue();
            for (DynamicObject entry : entries) {
                DynamicObject taxClassMappingInfo;
                DynamicObject entryItem = entry.getDynamicObject(entryItemType);
                if (entryItem == null || entry.getDynamicObject("e_taxclass") != null || (taxClassMappingInfo = taxClassMatcher.getTaxClassMappingInfo(asstactId, entryItem)) == null) continue;
                DynamicObject taxsupertypenum = taxClassMappingInfo.getDynamicObject("taxsupertypenum");
                entry.set("e_taxclass", (Object)taxsupertypenum);
                if (EmptyUtils.isEmpty((Object)entry.getString("e_invspectype"))) {
                    entry.set("e_invspectype", (Object)taxClassMappingInfo.getString("spectype"));
                }
                if (EmptyUtils.isEmpty((Object)entry.getString("e_itemname"))) {
                    entry.set("e_itemname", (Object)taxClassMappingInfo.getString("invname"));
                }
                if (!EmptyUtils.isEmpty((Object)entry.getDynamicObject("taxrateid"))) continue;
                entry.set("taxrateid", (Object)taxClassMappingInfo.getDynamicObject("taxratef7"));
                entry.set("e_taxrate", (Object)taxClassMappingInfo.getBigDecimal("taxrate").multiply(new BigDecimal(100)));
            }
        }
    }

    private List<DynamicObject> getEntryItemMap(List<DynamicObject> invoices, String entryItemType) {
        ArrayList<DynamicObject> asstactAndEntryItems = new ArrayList<DynamicObject>(8);
        for (DynamicObject invoice : invoices) {
            DynamicObjectCollection entries = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                DynamicObject entryItem = entry.getDynamicObject(entryItemType);
                if (entryItem == null || entry.getDynamicObject("e_taxclass") != null) continue;
                asstactAndEntryItems.add(entryItem);
            }
        }
        return asstactAndEntryItems;
    }
}

