/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArRevCfmSalOutVerifyDataCheck
extends AbstractDataCheck {
    private String getSourceBillEntityName() {
        return "im_saloutbill";
    }

    public String getEntityName() {
        return "ar_revcfmbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("sourcebilltype");
        selector.add("entry.id");
        selector.add("entry.seq");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    public boolean isBatch() {
        return true;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(16);
        Map sourceBillIdMap = BOTPHelper.loadNearUpBillIds((String)this.getEntityName(), (String)this.getSourceBillEntityName(), (Long[])((Long[])billList.stream().map(entity -> entity.getLong("id")).toArray(Long[]::new)));
        HashSet sourceBillIds = new HashSet();
        for (List value : sourceBillIdMap.values()) {
            sourceBillIds.addAll(value);
        }
        if (EmptyUtils.isEmpty(sourceBillIds)) {
            billList.forEach(bill -> results.add(new DataCheckResult()));
            return results;
        }
        DynamicObjectCollection sourceBillList = QueryServiceHelper.query((String)this.getSourceBillEntityName(), (String)"id,billentry.id,billentry.logisticsbill", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)});
        Map<Long, Set<Long>> verifyMainEntryIdToAsstEntryIdMap = this.getVerifyMainEntryIdToAsstEntryIdMap(sourceBillList, billList);
        Map<Long, Boolean> sourceEntryIdToIsTicMap = sourceBillList.stream().collect(Collectors.toMap(entity -> entity.getLong("billentry.id"), entity -> entity.getBoolean("billentry.logisticsbill")));
        Map<Long, Set<Long>> finEntryIdToSourceEntryIds = this.getFinEntryIdToSourceEntryIdsMap(billList, this.getSourceBillEntityName());
        for (DynamicObject bill2 : billList) {
            boolean normal = true;
            for (DynamicObject row : bill2.getDynamicObjectCollection("entry")) {
                long entryId = row.getLong("id");
                int seq = row.getInt("seq");
                long sourceEntryId = this.getSourceEntryId(entryId, finEntryIdToSourceEntryIds);
                Boolean ticEntry = null;
                if (sourceEntryIdToIsTicMap.get(sourceEntryId) != null) {
                    ticEntry = sourceEntryIdToIsTicMap.get(sourceEntryId);
                }
                Set<Long> verityEntryIds = verifyMainEntryIdToAsstEntryIdMap.get(sourceEntryId);
                if (ticEntry == null || !ticEntry.booleanValue() && verityEntryIds != null && verityEntryIds.contains(entryId)) continue;
                normal = false;
                results.add(new DataCheckResult(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u5206\u5f55\u7b2c%s\u884c,\u7269\u6d41\u5355\u636e\u884c\u5b58\u5728\u6838\u9500\u8bb0\u5f55\u6216\u975e\u7269\u6d41\u5355\u636e\u884c\u672a\u627e\u5230\u6838\u9500\u8bb0\u5f55", (String)"ArRevCfmSalOutVerifyDataCheck_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), seq)));
                break;
            }
            if (!normal) continue;
            results.add(new DataCheckResult());
        }
        return results;
    }

    private long getSourceEntryId(long entryId, Map<Long, Set<Long>> finEntryIdToSourceEntryIds) {
        return ((Set)finEntryIdToSourceEntryIds.getOrDefault(entryId, new HashSet())).stream().findAny().orElse(0L);
    }

    private List<DynamicObject> listVerifyRecord(List<Long> mainBillEntryIds, List<Long> asstBillEntryIds) {
        return QueryServiceHelper.query((String)"ar_verifyrecord", (String)"billentryid,entry.e_billentryid", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)this.getSourceBillEntityName()), new QFilter("entry.e_billtype", "=", (Object)this.getEntityName()), new QFilter("billentryid", "in", mainBillEntryIds), new QFilter("entry.e_billentryid", "in", asstBillEntryIds)});
    }

    private Map<Long, Set<Long>> getVerifyMainEntryIdToAsstEntryIdMap(DynamicObjectCollection sourceBillList, List<DynamicObject> billList) {
        List<Long> sourceBillEntryIds = sourceBillList.stream().map(entity -> entity.getLong("billentry.id")).collect(Collectors.toList());
        ArrayList<Long> finBillEntryIds = new ArrayList<Long>(16);
        for (DynamicObject bill : billList) {
            DynamicObjectCollection entryCollection = bill.getDynamicObjectCollection("entry");
            entryCollection.forEach(row -> finBillEntryIds.add(row.getLong("id")));
        }
        List<DynamicObject> verifyList = this.listVerifyRecord(sourceBillEntryIds, finBillEntryIds);
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        verifyList.forEach(entity -> {
            Set value = result.getOrDefault(entity.getLong("billentryid"), new HashSet(16));
            value.add(entity.getLong("entry.e_billentryid"));
            result.put(entity.getLong("billentryid"), value);
        });
        return result;
    }

    private Map<Long, Set<Long>> getFinEntryIdToSourceEntryIdsMap(List<DynamicObject> billList, String sourceEntityName) {
        HashSet finEntryIds = new HashSet(16);
        for (DynamicObject bill : billList) {
            finEntryIds.addAll(bill.getDynamicObjectCollection("entry").stream().map(row -> row.getLong("id")).collect(Collectors.toSet()));
        }
        return BOTPHelper.loadSourceRowIdsMap((String)this.getEntityName(), (String)"entry", (Long[])finEntryIds.toArray(new Long[0]), (String)sourceEntityName);
    }
}

