/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArInvoiceAmountDataCheck
extends AbstractDataCheck {
    public String getEntityName() {
        return "ar_finarbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("amount");
        selector.add("tax");
        selector.add("recamount");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    public boolean isBatch() {
        return true;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> result = new ArrayList<DataCheckResult>(16);
        List<Long> billIds = billList.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
        HashSet<Long> invoiceBillIds = this.listTargetBillId(this.getEntityName(), "ar_invoice", billIds);
        HashSet<Long> finArBillIds = this.listSourceBillId(this.getEntityName(), "ar_invoice", new ArrayList<Long>(invoiceBillIds));
        Map finArBillIdToInvoiceBillIdsMap = BOTPHelper.loadDirtTargetBillIds((String)this.getEntityName(), (String)"ar_invoice", new ArrayList<Long>(finArBillIds));
        DynamicObjectCollection invoiceBillList = QueryServiceHelper.query((String)"ar_invoice", (String)"id,amount,tax,recamount", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceBillIds)});
        Map<Long, DynamicObject> invoiceIdMap = invoiceBillList.stream().collect(Collectors.toMap(entity -> entity.getLong("id"), Function.identity()));
        for (DynamicObject bill : billList) {
            long id = bill.getLong("id");
            if (!finArBillIds.contains(id)) {
                result.add(new DataCheckResult());
                continue;
            }
            List<DynamicObject> invoiceBills = this.getInvoiceBillList(new ArrayList<Long>((Collection)finArBillIdToInvoiceBillIdsMap.get(id)), invoiceIdMap);
            boolean amountEquals = this.isAmountEquals(bill.getBigDecimal("amount"), invoiceBills, "amount");
            if (!amountEquals) {
                result.add(new DataCheckResult(ResManager.loadKDString((String)"\u4e0b\u6e38\u5f00\u7968\u5355\u91d1\u989d\u6c47\u603b\u4e0e\u8d22\u52a1\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"FinArInvoiceAmountDataCheck_0", (String)"fi-ar-formplugin", (Object[])new Object[0])));
                continue;
            }
            boolean taxEquals = this.isAmountEquals(bill.getBigDecimal("tax"), invoiceBills, "tax");
            if (!taxEquals) {
                result.add(new DataCheckResult(ResManager.loadKDString((String)"\u4e0b\u6e38\u5f00\u7968\u5355\u7a0e\u989d\u6c47\u603b\u4e0d\u7b49\u4e8e\u8d22\u52a1\u5355\u7a0e\u989d\u3002", (String)"FinArInvoiceAmountDataCheck_1", (String)"fi-ar-formplugin", (Object[])new Object[0])));
                continue;
            }
            boolean recAmountEquals = this.isAmountEquals(bill.getBigDecimal("recamount"), invoiceBills, "recamount");
            if (!recAmountEquals) {
                result.add(new DataCheckResult(ResManager.loadKDString((String)"\u4e0b\u6e38\u5f00\u7968\u5355\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u4e0d\u7b49\u4e8e\u8d22\u52a1\u5355\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"FinArInvoiceAmountDataCheck_2", (String)"fi-ar-formplugin", (Object[])new Object[0])));
                continue;
            }
            result.add(new DataCheckResult());
        }
        return result;
    }

    private List<DynamicObject> getInvoiceBillList(List<Long> invoiceIds, Map<Long, DynamicObject> invoiceIdMap) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        invoiceIds.forEach(id -> {
            if (invoiceIdMap.get(id) != null) {
                result.add((DynamicObject)invoiceIdMap.get(id));
            }
        });
        return result;
    }

    private boolean isAmountEquals(BigDecimal sourceAmount, List<DynamicObject> targetsBills, String propertyName) {
        BigDecimal targetAmount = targetsBills.stream().map(entity -> entity.getBigDecimal(propertyName)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        return sourceAmount.compareTo(targetAmount) == 0;
    }

    private HashSet<Long> listTargetBillId(String sourceEntityName, String targetEntityName, List<Long> billIds) {
        Map targetBillIdsMap = BOTPHelper.findTargetBills((String)sourceEntityName, (Long[])billIds.toArray(new Long[0]));
        if (EmptyUtils.isEmpty(targetBillIdsMap.get(targetEntityName))) {
            return new HashSet<Long>(16);
        }
        return (HashSet)targetBillIdsMap.get(targetEntityName);
    }

    private HashSet<Long> listSourceBillId(String sourceEntityName, String targetEntityName, List<Long> billIds) {
        Map targetBillIdsMap = BOTPHelper.findSourceBills((String)targetEntityName, (Long[])billIds.toArray(new Long[0]));
        if (EmptyUtils.isEmpty(targetBillIdsMap.get(sourceEntityName))) {
            return new HashSet<Long>(16);
        }
        return (HashSet)targetBillIdsMap.get(sourceEntityName);
    }
}

