/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.check;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.util.AmountUtils;

public class FinArQtyAndAmtDataCheck {
    public DataCheckResult billHeaderAmount(DynamicObject bill, DataCheckResult result) {
        boolean priceLimtZero;
        BigDecimal priceTaxTotal = bill.getBigDecimal("recamount");
        BigDecimal settAmount = bill.getBigDecimal("settleamount");
        BigDecimal unSettAmount = bill.getBigDecimal("unsettleamount");
        boolean subTax = priceTaxTotal.subtract(settAmount).compareTo(unSettAmount) == 0;
        boolean priceOverZero = subTax && priceTaxTotal.compareTo(BigDecimal.ZERO) > 0 && settAmount.compareTo(priceTaxTotal) <= 0;
        boolean bl = priceLimtZero = subTax && priceTaxTotal.compareTo(BigDecimal.ZERO) <= 0 && settAmount.compareTo(priceTaxTotal) >= 0;
        if (!priceOverZero && !priceLimtZero) {
            result.setSuccess(false);
            String msg = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u8d85\u989d\u7ed3\u7b97\u6216\u672a\u7ed3\u7b97\u8d85\u6709\u6548\u8303\u56f4,\u8bf7\u68c0\u67e5\u3002", (String)"FinArQtyAndAmtDataCheck_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
            result.setErrorMessage(msg);
            return result;
        }
        if ((result = this.sumEntryAmt(bill, result)).isSuccess()) {
            return this.sumPlanEntryAmt(bill, result);
        }
        return result;
    }

    public DataCheckResult sumPlanEntryAmt(DynamicObject bill, DataCheckResult result) {
        String billName = (String)bill.getDynamicObjectType().getDisplayName().get((Object)"zh_CN");
        BigDecimal settAmount = bill.getBigDecimal("settleamount");
        BigDecimal unSettAmount = bill.getBigDecimal("unsettleamount");
        BigDecimal sumPlanSettAmt = BigDecimal.ZERO;
        BigDecimal sumPlaUnSettAmt = BigDecimal.ZERO;
        DynamicObjectCollection entryColls = bill.getDynamicObjectCollection("planentity");
        if (entryColls != null && entryColls.size() > 0) {
            for (DynamicObject entry : entryColls) {
                sumPlanSettAmt = sumPlanSettAmt.add(entry.getBigDecimal("plansettledamt"));
                sumPlaUnSettAmt = sumPlaUnSettAmt.add(entry.getBigDecimal("unplansettleamt"));
            }
        }
        if (sumPlanSettAmt.compareTo(settAmount) == 0 && sumPlaUnSettAmt.compareTo(unSettAmount) == 0) {
            result.setSuccess(true);
        } else {
            result.setSuccess(false);
            String msg = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u8868\u5934\u7ed3\u7b97\u91d1\u989d\u53cd\u5199\u4e0e\u8ba1\u5212\u884c\u6c47\u603b\u4e0d\u4e00\u81f4,\u8bf7\u68c0\u67e5\u3002", (String)"FinArQtyAndAmtDataCheck_1", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]);
            result.setErrorMessage(msg);
        }
        return result;
    }

    public DataCheckResult sumEntryAmt(DynamicObject bill, DataCheckResult result) {
        BigDecimal settAmount = bill.getBigDecimal("settleamount");
        BigDecimal unSettAmount = bill.getBigDecimal("unsettleamount");
        BigDecimal sumEntrySettAmt = BigDecimal.ZERO;
        BigDecimal sumEntryUnSettAmt = BigDecimal.ZERO;
        DynamicObjectCollection entryColls = bill.getDynamicObjectCollection("entry");
        if (entryColls != null && entryColls.size() > 0) {
            for (DynamicObject entry : entryColls) {
                sumEntrySettAmt = sumEntrySettAmt.add(entry.getBigDecimal("e_settledamt"));
                sumEntryUnSettAmt = sumEntryUnSettAmt.add(entry.getBigDecimal("e_unsettleamt"));
            }
        }
        if (sumEntrySettAmt.compareTo(settAmount) != 0 || sumEntryUnSettAmt.compareTo(unSettAmount) != 0) {
            result.setSuccess(false);
            String msg = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u8868\u5934\u7ed3\u7b97\u91d1\u989d\u4e0e\u660e\u7ec6\u884c\u6c47\u603b\u4e0d\u4e00\u81f4,\u8bf7\u68c0\u67e5\u3002", (String)"FinArQtyAndAmtDataCheck_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
            result.setErrorMessage(msg);
            return result;
        }
        return result;
    }

    public DataCheckResult billDetailentry(DynamicObjectCollection entryColls, DataCheckResult result) {
        if (entryColls != null && entryColls.size() > 0) {
            for (DynamicObject entry : entryColls) {
                boolean priceLimtZero;
                BigDecimal settAmount = entry.getBigDecimal("e_settledamt");
                BigDecimal priceTax = entry.getBigDecimal("e_recamount");
                BigDecimal unSettAmount = entry.getBigDecimal("e_unsettleamt");
                boolean subTax = priceTax.subtract(settAmount).compareTo(unSettAmount) == 0;
                boolean priceOverZero = subTax && priceTax.compareTo(BigDecimal.ZERO) > 0 && settAmount.compareTo(priceTax) <= 0;
                boolean bl = priceLimtZero = subTax && priceTax.compareTo(BigDecimal.ZERO) <= 0 && settAmount.compareTo(priceTax) >= 0;
                if (!priceOverZero && !priceLimtZero) {
                    result.setSuccess(false);
                    String msg = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u8d85\u989d\u7ed3\u7b97\u6216\u672a\u7ed3\u7b97\u8d85\u6709\u6548\u8303\u56f4,\u8bf7\u68c0\u67e5\u3002", (String)"FinArQtyAndAmtDataCheck_3", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                    result.setErrorMessage(msg);
                    return result;
                }
                boolean verifyQtyNormal = AmountUtils.absLessThanEquals((BigDecimal)entry.getBigDecimal("e_verifiedqty"), (BigDecimal)entry.getBigDecimal("e_quantity"));
                boolean verifyAmtNormal = AmountUtils.absLessThanEquals((BigDecimal)entry.getBigDecimal("e_verifiedamt"), (BigDecimal)entry.getBigDecimal("e_amount"));
                if (verifyQtyNormal && verifyAmtNormal) continue;
                result.setSuccess(false);
                String msg = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u8d85\u989d\u6838\u9500,\u8bf7\u68c0\u67e5\u3002", (String)"FinArQtyAndAmtDataCheck_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                result.setErrorMessage(msg);
                return result;
            }
        }
        return result;
    }

    public DataCheckResult planEntryAmount(DynamicObjectCollection planColls, DataCheckResult result) {
        if (planColls != null && planColls.size() > 0) {
            for (DynamicObject planEntry : planColls) {
                boolean limtPriceZero;
                BigDecimal settAmount = planEntry.getBigDecimal("plansettledamt");
                BigDecimal planPriceTax = planEntry.getBigDecimal("planpricetax");
                BigDecimal unPlanSettAmount = planEntry.getBigDecimal("unplansettleamt");
                boolean subTax = planPriceTax.subtract(settAmount).compareTo(unPlanSettAmount) == 0;
                boolean overPriceZero = subTax && planPriceTax.compareTo(BigDecimal.ZERO) > 0 && settAmount.compareTo(planPriceTax) <= 0;
                boolean bl = limtPriceZero = subTax && planPriceTax.compareTo(BigDecimal.ZERO) <= 0 && settAmount.compareTo(planPriceTax) >= 0;
                if (overPriceZero || limtPriceZero) continue;
                result.setSuccess(false);
                String msg = String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u8d85\u989d\u7ed3\u7b97\u6216\u672a\u7ed3\u7b97\u8d85\u6709\u6548\u8303\u56f4,\u8bf7\u68c0\u67e5\u3002", (String)"FinArQtyAndAmtDataCheck_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]);
                result.setErrorMessage(msg);
                return result;
            }
        }
        return result;
    }

    public DataCheckResult returnResult(DynamicObject bill) {
        DataCheckResult result = new DataCheckResult();
        result.setSuccess(true);
        DataCheckResult headerIsPass = this.billHeaderAmount(bill, result);
        if (headerIsPass.isSuccess()) {
            DataCheckResult entryIsPass = this.billDetailentry(bill.getDynamicObjectCollection("entry"), result);
            if (entryIsPass.isSuccess()) {
                DataCheckResult planIsPass = this.planEntryAmount(bill.getDynamicObjectCollection("planentity"), result);
                return planIsPass;
            }
            return entryIsPass;
        }
        return headerIsPass;
    }
}

