/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.util.AmountUtils;

public class FinArRecfVerifyDataCheck
extends AbstractDataCheck {
    public String getEntityName() {
        return "ar_revcfmbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("entry.id");
        selector.add("entry.e_quantity");
        selector.add("entry.e_verifiedqty");
        selector.add("entry.e_amount");
        selector.add("entry.e_verifiedamt");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    public boolean isBatch() {
        return false;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        DataCheckResult result = new DataCheckResult();
        result.setSuccess(true);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            boolean verifyQtyNormal = AmountUtils.absLessThanEquals((BigDecimal)entry.getBigDecimal("e_verifiedqty"), (BigDecimal)entry.getBigDecimal("e_quantity"));
            boolean verifyAmtNormal = AmountUtils.absLessThanEquals((BigDecimal)entry.getBigDecimal("e_verifiedamt"), (BigDecimal)entry.getBigDecimal("e_amount"));
            if (verifyQtyNormal && verifyAmtNormal) continue;
            result.setSuccess(false);
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s,\u7684\u6536\u5165\u786e\u8ba4\u5355\u8d85\u989d\u6838\u9500,\u8bf7\u68c0\u67e5\u3002", (String)"FinArRecfVerifyDataCheck_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), bill.getString("billno"));
            result.setErrorMessage(msg);
            break;
        }
        return result;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> result = new ArrayList<DataCheckResult>(16);
        for (DynamicObject bill : billList) {
            result.add(this.dataCheck(bill));
        }
        return result;
    }
}

