/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.ArApXDBHelper;

public class FinArRecfWriteDataCheck
extends AbstractDataCheck {
    public String getEntityName() {
        return "ar_revcfmbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("entry.id");
        selector.add("entry.e_verifiedqty");
        selector.add("entry.e_verifiedamt");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    public boolean isBatch() {
        return true;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(billList.size());
        billList.forEach(t -> {
            DataCheckResult result = new DataCheckResult();
            result.setSuccess(true);
            results.add(result);
        });
        Set pks = billList.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ar_revcfmbill", (Object[])pks.toArray(), (boolean)true);
        QFilter headerFilter = new QFilter("billid", "in", pks).and("billtype", "=", (Object)"ar_revcfmbill");
        QFilter entryFilter = new QFilter("entry.e_billid", "in", pks).and("entry.e_billtype", "=", (Object)"ar_revcfmbill");
        entryFilter.and(commonFilter);
        Object[] HeaderVerifyRecords = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)"id,billentryid,verifyqty,verifyamount,entry.e_verifyqty,entry.e_verifyamount,entry.e_billentryid", (QFilter[])new QFilter[]{headerFilter});
        Object[] entryVerifyRecords = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)"id,billentryid,verifyqty,verifyamount,entry.e_verifyqty,entry.e_verifyamount,entry.e_billentryid", (QFilter[])new QFilter[]{entryFilter});
        DynamicObject[] verifyRecords = (DynamicObject[])ArrayUtils.addAll((Object[])HeaderVerifyRecords, (Object[])entryVerifyRecords);
        Map<String, Map<String, BigDecimal>> sumMap = this.returnSumMap(verifyRecords);
        for (int i = 0; i < billList.size(); ++i) {
            DataCheckResult result = (DataCheckResult)results.get(i);
            DynamicObject bill = billList.get(i);
            DynamicObjectCollection entryColls = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColls) {
                BigDecimal entryVerAmt = entry.getBigDecimal("e_verifiedamt");
                BigDecimal entryVerQut = entry.getBigDecimal("e_verifiedqty");
                String entryId = entry.getString("id");
                boolean flag = entryVerAmt.compareTo(BigDecimal.ZERO) != 0 || entryVerQut.compareTo(BigDecimal.ZERO) != 0;
                Map<String, BigDecimal> getDataMap = sumMap.get(entryId);
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s,\u7684\u6536\u5165\u786e\u8ba4\u6838\u9500\u8bb0\u5f55\u4fe1\u606f\u4e0e\u5b9e\u9645\u6838\u9500\u60c5\u51b5\u4e0d\u4e00\u81f4\u3002", (String)"FinArRecfWriteDataCheck_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), bill.getString("billno"));
                if (getDataMap != null) {
                    BigDecimal sumQty = getDataMap.get("sumQty");
                    BigDecimal sumAmt = getDataMap.get("sumAmt");
                    if (entryVerAmt.compareTo(sumAmt) == 0 && entryVerQut.compareTo(sumQty) == 0) continue;
                    result.setSuccess(false);
                    result.setErrorMessage(msg);
                    break;
                }
                if (getDataMap != null || !flag) continue;
                result.setSuccess(false);
                result.setErrorMessage(msg);
                break;
            }
            results.add(result);
        }
        return results;
    }

    public Map<String, Map<String, BigDecimal>> returnSumMap(DynamicObject[] verifyRecords) {
        Map<String, Map<String, BigDecimal>> sumMap = new HashMap<String, Map<String, BigDecimal>>();
        for (int i = 0; i < verifyRecords.length; ++i) {
            String headerEntryId = verifyRecords[i].getString("billentryid");
            BigDecimal headerQty = verifyRecords[i].getBigDecimal("verifyqty");
            BigDecimal headerAmt = verifyRecords[i].getBigDecimal("verifyamount");
            sumMap = this.addHeaderAndEntry(headerEntryId, sumMap, headerQty, headerAmt);
            DynamicObjectCollection entryColls = verifyRecords[i].getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColls) {
                String entryId = entry.getString("e_billentryid");
                BigDecimal entryQty = entry.getBigDecimal("e_verifyqty");
                BigDecimal entryAmt = entry.getBigDecimal("e_verifyamount");
                sumMap = this.addHeaderAndEntry(entryId, sumMap, entryQty, entryAmt);
            }
        }
        return sumMap;
    }

    public Map<String, Map<String, BigDecimal>> addHeaderAndEntry(String entryId, Map<String, Map<String, BigDecimal>> sumMap, BigDecimal qty, BigDecimal amt) {
        Map<String, BigDecimal> addMap = sumMap.get(entryId);
        if (addMap != null) {
            addMap.put("sumQty", addMap.get("sumQty").add(qty));
            addMap.put("sumAmt", addMap.get("sumAmt").add(amt));
        } else {
            addMap = new HashMap<String, BigDecimal>();
            addMap.put("sumQty", qty);
            addMap.put("sumAmt", amt);
            sumMap.put(entryId, addMap);
        }
        return sumMap;
    }
}

