/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.BOTPHelper;

public class FinArRevCfmVerifyDataCheck
extends AbstractDataCheck {
    public String getEntityName() {
        return "ar_finarbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("entry.id");
        selector.add("entry.e_verifiedqty");
        selector.add("entry.e_verifiedamt");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    public boolean isBatch() {
        return true;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        List billIds = billList.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
        Map billIdToRevCfmBillIdsMap = BOTPHelper.loadDirtTargetBillIds((String)"ar_finarbill", (String)"ar_revcfmbill", billIds);
        ArrayList revBillIds = new ArrayList(16);
        billIdToRevCfmBillIdsMap.values().forEach(revBillIds::addAll);
        DynamicObjectCollection revCfmBillList = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,entry.id,entry.e_verifiedqty,entry.e_verifiedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", revBillIds)});
        Map<Long, Set<Long>> revCfmEntryIdToFinEntryIdsMap = this.getRevCfmEntryIdToFinEntryIdsMap(revCfmBillList);
        Map<Long, BigDecimal> sourceRowIdToAmtSummaryMap = this.getSourceRowSummaryMap((List<DynamicObject>)revCfmBillList, revCfmEntryIdToFinEntryIdsMap, "entry.e_verifiedamt");
        Map<Long, BigDecimal> sourceRowIdToQtySummaryMap = this.getSourceRowSummaryMap((List<DynamicObject>)revCfmBillList, revCfmEntryIdToFinEntryIdsMap, "entry.e_verifiedqty");
        ArrayList<DataCheckResult> result = new ArrayList<DataCheckResult>(16);
        for (DynamicObject bill : billList) {
            if (!billIdToRevCfmBillIdsMap.containsKey(bill.getLong("id"))) {
                result.add(new DataCheckResult());
                continue;
            }
            DataCheckResult summaryEquals = this.getSummaryEqualsResult(bill, sourceRowIdToAmtSummaryMap, sourceRowIdToQtySummaryMap);
            result.add(summaryEquals);
        }
        return result;
    }

    private DataCheckResult getSummaryEqualsResult(DynamicObject bill, Map<Long, BigDecimal> sourceRowIdToAmtSummaryMap, Map<Long, BigDecimal> sourceRowIdToQtySummaryMap) {
        for (DynamicObject entryRow : bill.getDynamicObjectCollection("entry")) {
            long entryId = entryRow.getLong("id");
            BigDecimal verifiedQty = entryRow.getBigDecimal("e_verifiedqty");
            BigDecimal verifiedAmt = entryRow.getBigDecimal("e_verifiedamt");
            if (verifiedQty.compareTo(sourceRowIdToQtySummaryMap.getOrDefault(entryId, BigDecimal.ZERO)) != 0) {
                return new DataCheckResult(ResManager.loadKDString((String)"\u5df2\u6838\u9500\u6570\u91cf\u6c47\u603b\u4e0d\u7b49\u4e8e\u6536\u5165\u786e\u8ba4\u5355\u5df2\u6838\u9500\u6570\u91cf\u3002", (String)"FinArRevCfmVerifyDataCheck_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
            if (verifiedAmt.compareTo(sourceRowIdToAmtSummaryMap.getOrDefault(entryId, BigDecimal.ZERO)) == 0) continue;
            return new DataCheckResult(ResManager.loadKDString((String)"\u5df2\u6838\u9500\u91d1\u989d\u6c47\u603b\u4e0d\u7b49\u4e8e\u6536\u5165\u786e\u8ba4\u5355\u5df2\u6838\u9500\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArRevCfmVerifyDataCheck_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        return new DataCheckResult();
    }

    private Map<Long, BigDecimal> getSourceRowSummaryMap(List<DynamicObject> revCfmBillList, Map<Long, Set<Long>> revCfmEntryIdToFinEntryIdsMap, String propertyName) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject bill : revCfmBillList) {
            long entryId = bill.getLong("entry.id");
            Set sourceFinEntryIds = revCfmEntryIdToFinEntryIdsMap.getOrDefault(entryId, new HashSet(16));
            Iterator iterator = sourceFinEntryIds.iterator();
            while (iterator.hasNext()) {
                long sourceFinEntryId = (Long)iterator.next();
                BigDecimal propertyValue = bill.getBigDecimal(propertyName);
                BigDecimal summary = result.getOrDefault(sourceFinEntryId, BigDecimal.ZERO);
                summary = summary.add(propertyValue);
                result.put(sourceFinEntryId, summary);
            }
        }
        return result;
    }

    private Map<Long, Set<Long>> getRevCfmEntryIdToFinEntryIdsMap(DynamicObjectCollection revCfmBillList) {
        Long[] revCfmEntryIds = (Long[])revCfmBillList.stream().map(entity -> entity.getLong("entry.id")).distinct().toArray(Long[]::new);
        return BOTPHelper.loadSourceRowIdsMap((String)"ar_revcfmbill", (String)"entry", (Long[])revCfmEntryIds, (String)this.getEntityName());
    }
}

