/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.formplugin.check.FinArCheckSumAmtUtil;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.BOTPHelper;

public class FinArSalQtyDataCheck
extends AbstractDataCheck {
    public String getEntityName() {
        return "im_saloutbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("billentry.id");
        selector.add("billentry.qty");
        selector.add("billentry.joinpriceqty");
        selector.add("billentry.seq");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    public boolean isBatch() {
        return true;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(billList.size());
        return this.dataCheckApBills(billList, results, "ar_finarbill");
    }

    public List<DataCheckResult> dataCheckApBills(List<DynamicObject> billList, List<DataCheckResult> results, String billFormId) {
        Long entryId;
        billList.forEach(t -> {
            DataCheckResult result = new DataCheckResult();
            result.setSuccess(true);
            results.add(result);
        });
        DynamicObjectCollection allEntryColls = new DynamicObjectCollection();
        for (DynamicObject bill : billList) {
            DynamicObjectCollection entryColls = bill.getDynamicObjectCollection("billentry");
            allEntryColls.addAll((Collection)entryColls);
        }
        List<Long> allEntryIds = allEntryColls.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
        Map targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap((String)"im_saloutbill", (String)"billentry", (Long[])allEntryIds.toArray(new Long[0]), (String)billFormId);
        ArrayList allTarEntryIds = new ArrayList();
        for (Map.Entry it : targetRowIdsMap.entrySet()) {
            Set tarIds = (Set)it.getValue();
            if (tarIds == null) continue;
            allTarEntryIds.addAll(tarIds);
        }
        QFilter filter = new QFilter("entry.id", "in", allTarEntryIds);
        QFilter[] filters = new QFilter[]{filter.and("billstatus", "=", (Object)"C")};
        DynamicObjectCollection apBills = QueryServiceHelper.query((String)billFormId, (String)"id,entry.e_quantity,entry.seq,entry.id", (QFilter[])filters);
        HashMap<Long, BigDecimal> compareMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry it : targetRowIdsMap.entrySet()) {
            Long sourEntryId = (Long)it.getKey();
            Set tarIds = (Set)it.getValue();
            ArrayList<DynamicObject> tarBills = new ArrayList<DynamicObject>();
            for (int i = 0; i < apBills.size(); ++i) {
                entryId = ((DynamicObject)apBills.get(i)).getLong("entry.id");
                if (!tarIds.contains(entryId)) continue;
                tarBills.add((DynamicObject)apBills.get(i));
            }
            if (tarBills == null || tarBills.size() <= 0) continue;
            BigDecimal allQty = FinArCheckSumAmtUtil.sumAmt(tarBills, "entry.e_quantity");
            compareMap.put(sourEntryId, allQty);
        }
        block4: for (int i = 0; i < billList.size(); ++i) {
            DynamicObject bill = billList.get(i);
            DataCheckResult result = results.get(i);
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntrys) {
                String msg;
                entryId = entry.getLong("id");
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal joinpriceQty = entry.getBigDecimal("joinpriceqty");
                if (compareMap.get(entryId) == null) continue;
                BigDecimal allQty = (BigDecimal)compareMap.get(entryId);
                if (allQty.compareTo(qty) > 0) {
                    result.setSuccess(false);
                    msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s,\u7684\u9500\u552e\u51fa\u5e93\u5355\u8d85\u6570\u91cf\u6682\u4f30\u5e94\u6536\u6216\u8d22\u52a1\u5e94\u6536,\u8bf7\u68c0\u67e5\u3002", (String)"FinArSalQtyDataCheck_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), bill.getString("billno"));
                    result.setErrorMessage(msg);
                    continue block4;
                }
                if (allQty.compareTo(joinpriceQty) == 0) continue;
                result.setSuccess(false);
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s,\u7684\u9500\u552e\u51fa\u5e93\u5355\u7d2f\u8ba1\u5e94\u6536\u6570\u91cf\u4e0e\u4e0b\u6e38\u6682\u4f30\u5e94\u6536\u6216\u8d22\u52a1\u5e94\u6536\u6570\u91cf\u4e0d\u7b49,\u8bf7\u68c0\u67e5\u3002", (String)"FinArSalQtyDataCheck_1", (String)"fi-ap-formplugin", (Object[])new Object[0]), bill.getString("billno"));
                result.setErrorMessage(msg);
                continue block4;
            }
        }
        return results;
    }
}

