/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.check;

import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.base.CheckResult;
import kd.fi.arapcommon.check.base.DataCheckService;
import kd.fi.arapcommon.check.base.HealthCheckFilter;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class FinArSettleDataCheck
implements DataCheckService {
    private HealthCheckFilter healthCheckFilter = new HealthCheckFilter();

    public CheckResult getCheckResult() {
        CheckResult result = new CheckResult();
        List orgIds = this.healthCheckFilter.getOrgIds();
        if (ObjectUtils.isEmpty((Object)orgIds)) {
            result.setMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinArSettleDataCheck_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return result;
        }
        Date startDate = this.healthCheckFilter.getStartDate();
        Date endDate = this.healthCheckFilter.getEndDate();
        if (ObjectUtils.isEmpty((Object)startDate) || ObjectUtils.isEmpty((Object)endDate)) {
            result.setMessage(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinArSettleDataCheck_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            return result;
        }
        int errorCount = 0;
        List bills = result.getBills();
        for (Long orgId : orgIds) {
            AbnormalBillInfo billInfo;
            String msg;
            long id;
            String billno;
            DataSet checkDataSet;
            String sql;
            int settleParam = ArApHelper.getArSettleParam((Object)orgId);
            if (1 == settleParam) {
                sql = "select distinct id,billno from (select h.fid id,h.fbillno billno,e.fsettledamt amt1,case when vmain.famt is null then 0 else vmain.famt end amt2,case when vsub.famt is null then 0 else vsub.famt end amt3 from t_ar_finarbill h inner join t_ar_finarbillentry e on h.fid=e.fid left join (select fmainbillentryid,sum(ftotalsettleamt) famt from t_ap_settlerecord where forgid=? group by fmainbillentryid) vmain on vmain.fmainbillentryid=e.fentryid left join (select fbillentryid,sum(fsettleamt) famt from t_ap_settlerecordentry group by fbillentryid) vsub on vsub.fbillentryid=e.fentryid where h.forgid=? and h.fcreatetime>? and h.fcreatetime<?) f where amt1<>amt2+amt3";
                checkDataSet = this.getFinArSettleDataCheck(startDate, endDate, orgId, sql);
                for (Row row : checkDataSet) {
                    ++errorCount;
                    billno = row.getString("billno");
                    id = row.getLong("id");
                    msg = ResManager.loadKDString((String)"\u5355\u636e\u7ed3\u7b97\u6570\u636e\u5f02\u5e38\uff08\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u4e0d\u5339\u914d\uff09\uff0c\u8bf7\u68c0\u67e5", (String)"FinArSettleDataCheck_2", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                    billInfo = new AbnormalBillInfo(id, billno, "ar_finarbill", msg);
                    bills.add(billInfo);
                }
                continue;
            }
            sql = "select distinct id,billno from (select h.fid id,h.fbillno billno,e.fplansettledamt amt1,case when vmain.famt is null then 0 else vmain.famt end amt2,case when vsub.famt is null then 0 else vsub.famt end amt3 from t_ar_finarbill h inner join t_ar_finarplanentry e on h.fid=e.fid left join (select fmainbillentryid,sum(ftotalsettleamt) famt from t_ap_settlerecord where forgid=? group by fmainbillentryid) vmain on vmain.fmainbillentryid=e.fentryid left join (select fbillentryid,sum(fsettleamt) famt from t_ap_settlerecordentry group by fbillentryid) vsub on vsub.fbillentryid=e.fentryid where h.forgid=? and h.fcreatetime>? and h.fcreatetime<?) f where amt1<>amt2+amt3";
            checkDataSet = this.getFinArSettleDataCheck(startDate, endDate, orgId, sql);
            for (Row row : checkDataSet) {
                ++errorCount;
                billno = row.getString("billno");
                id = row.getLong("id");
                msg = ResManager.loadKDString((String)"\u5355\u636e\u7ed3\u7b97\u6570\u636e\u5f02\u5e38\uff08\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u4e0d\u5339\u914d\uff09\uff0c\u8bf7\u68c0\u67e5", (String)"FinArSettleDataCheck_2", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                billInfo = new AbnormalBillInfo(id, billno, "ar_finarbill", msg);
                bills.add(billInfo);
            }
        }
        result.setTotal(errorCount);
        return result;
    }

    private DataSet getFinArSettleDataCheck(Date startDate, Date endDate, Long orgId, String sql) {
        return DB.queryDataSet((String)"FinArSettleDataCheck", (DBRoute)DBRouteConst.AR, (String)sql, (Object[])new Object[]{orgId, orgId, startDate, endDate});
    }

    public void setQFilter(QFilter filter) {
        String property = filter.getProperty();
        if ("org".equals(property)) {
            this.healthCheckFilter.setOrgIds((List)filter.getValue());
        }
        List nests = filter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            String nestProperty = nest.getFilter().getProperty();
            String tag = nest.getFilter().getCP();
            if ("createtime".equals(nestProperty) && ">=".equals(tag)) {
                this.healthCheckFilter.setStartDate((Date)nest.getFilter().getValue());
                continue;
            }
            if (!"createtime".equals(nestProperty) || !"<=".equals(tag)) continue;
            this.healthCheckFilter.setEndDate((Date)nest.getFilter().getValue());
        }
    }
}

