/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice.Invoice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.InstantUtils;

public class ArInvoiceBillImportHelper
extends AbstractBillImport {
    private Map<String, BigDecimal> convertRateMap = new HashMap<String, BigDecimal>(8);
    private QuotationHelper quotationHelper;
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private static final String[] ENTRY = new String[]{"e_unitprice", "e_amount", "e_localamt", "e_taxunitprice", "e_tax", "e_discountamount", "e_discountlocalamt", "e_recamount", "e_reclocalamt", "e_unverifiedwriteoffamt"};
    private static final String[] HEAD = new String[]{"recamount", "reclocalamt", "amount", "localamt", "tax", "redinvoice"};
    Map<Long, DynamicObject> taxsupertypenumMap = new HashMap<Long, DynamicObject>();

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    public ArInvoiceBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public ArInvoiceBillImportHelper(IFormView view, IPageCache pageCache) {
        this.view = view;
        this.model = view.getModel();
        this.pageCache = pageCache;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        boolean isRedInvoice;
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        boolean isIncludeTax = sourceData.get("isincludetax") == null ? false : (Boolean)sourceData.get("isincludetax");
        this.checkInvoiceStatus(sourceData);
        this.validateInvoiceType(sourceData);
        String importtype = (String)e.getOption().get("importtype");
        boolean bl = isRedInvoice = sourceData.get("redinvoice") == null ? false : (Boolean)sourceData.get("redinvoice");
        if (!isRedInvoice) {
            sourceData.remove("blueinvoicecode");
            sourceData.remove("blueinvoiceno");
        }
        this.checkNull("currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"ArInvoiceBillImportHelper_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), sourceData);
        this.removeNoAssignField(sourceData, this.headFields);
        List entryList = null;
        if (sourceData.get("entry") != null) {
            entryList = (List)sourceData.get("entry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                Map entry = (Map)entryList.get(i);
                this.removeNoAssignField(entry, this.entryFields);
                this.checkIncludeTax(entry, isIncludeTax);
                this.checkDiscountMode(entry, i);
            }
        }
    }

    private void validateInvoiceType(Map<String, Object> data) {
        Object invoicetypef7 = data.get("invoicetypef7");
        Object invoicetype = data.get("invoicetype");
        if (ObjectUtils.isEmpty((Object)invoicetype) && ObjectUtils.isEmpty((Object)invoicetypef7)) {
            throw new KDBizException(InvoiceTypeHelper.getValidateInfo());
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        Long orgPk = (Long)org.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ar_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"ArInvoiceBillImportHelper_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        this.init.checkInit();
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArInvoiceBillImportHelper_8", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        this.createByInit(sourceData);
        this.setDefaultSourceValue(sourceData);
        this.setBuyer();
        this.setSeller();
        this.setMaterialandExpenseAbout();
        this.setTaxRate();
        this.setIsPresent();
        this.calculatePrice(sourceData);
    }

    private void checkIncludeTax(Map entry, Boolean isIncludeTax) {
        boolean isPresent;
        boolean bl = isPresent = entry.get("e_ispresent") != null ? (Boolean)entry.get("e_ispresent") : false;
        if (isPresent) {
            return;
        }
        if (isIncludeTax.booleanValue()) {
            Object recAmount = entry.get("e_recamount");
            if (!ObjectUtils.isEmpty(recAmount)) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u5f55\u5165\u4ef7\u7a0e\u5408\u8ba1\uff0c\u5f55\u5165\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArInvoiceBillImportHelper_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        Object recAmount = entry.get("e_unitprice");
        if (!ObjectUtils.isEmpty(recAmount)) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5f55\u5165\u4ef7\u7a0e\u5408\u8ba1,\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ArInvoiceBillImportHelper_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
    }

    private void checkDiscountMode(Map entry, int index) {
        String discountMode = (String)entry.get("e_discountmode");
        if (DiscountModeEnum.PERCENT.getValue().equals(discountMode)) {
            Object rate = entry.get("e_discountrate");
            if (EmptyUtils.isEmpty(rate)) {
                return;
            }
            BigDecimal discountRate = new BigDecimal(rate.toString());
            if (discountRate.compareTo(new BigDecimal(100)) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u6298\u6263\u7387\u4e0b\u5355\u4f4d\u6298\u6263\u7387\u503c\u4e0d\u80fd\u5927\u4e8e100", (String)"ArInvoiceBillImportHelper_3", (String)"fi-ar-formplugin", (Object[])new Object[]{index + 1}));
            }
        } else if (DiscountModeEnum.NULL.getValue().equals(discountMode) || DiscountModeEnum.TOTAL.getValue().equals(discountMode)) {
            entry.remove("e_discountrate");
        }
    }

    private void checkInvoiceStatus(Map data) {
        Object isOffline = data.get("isoffline");
        boolean offline = EmptyUtils.isEmpty(isOffline) ? false : isOffline.equals(Boolean.TRUE);
        String invoicestatus = (String)data.get("invoicestatus");
        if (!offline && "1".equals(invoicestatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u7ebf\u4e0b\u5f00\u7968\u6570\u636e\uff0c\u5f00\u7968\u72b6\u6001\u4e0d\u80fd\u4e3a\u5df2\u5f00\u7968\u3002", (String)"ArInvoiceBillImportHelper_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private void createByInit(Map sourceData) {
        boolean isBankOrg;
        DynamicObject headOrg = this.model.getDataEntity().getDynamicObject("org");
        boolean isPurOrg = headOrg.getBoolean("fissale");
        if (isPurOrg && EmptyUtils.isEmpty(sourceData.get("salesorg"))) {
            this.model.setValue("salesorg", (Object)headOrg.getLong("id"));
        }
        if ((isBankOrg = headOrg.getBoolean("fisbankroll")) && EmptyUtils.isEmpty(sourceData.get("recorg"))) {
            this.model.setValue("recorg", (Object)headOrg.getLong("id"));
        }
        DynamicObject cur = this.init.getStandardCurrency();
        this.model.setValue("basecurrency", cur.getPkValue());
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exchangerate")) || BigDecimal.ZERO.compareTo((BigDecimal)this.model.getValue("exchangerate")) == 0) {
            this.model.setValue("exchangerate", (Object)1);
        }
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        FormServiceHelper.checkMeasureUnitRange((IDataModel)this.model, (String)"entry", (String)"e_material", (String)"e_measureunit");
        DynamicObject srcCurrency = (DynamicObject)this.model.getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)srcCurrency) && !ObjectUtils.isEmpty((Object)destCurrency) && srcCurrency.getPkValue().equals(destCurrency.getPkValue())) {
            this.model.setValue("exchangerate", (Object)BigDecimal.ONE);
            this.model.setValue("quotation", (Object)"0");
        } else {
            this.getQuotationHelper().getExchangeRate4Import(this.model);
        }
    }

    private void setDefaultSourceValue(Map<String, Object> sourceData) {
        DynamicObject invoicetype;
        if (EmptyUtils.isEmpty((Object)this.model.getValue("paymode"))) {
            this.model.setValue("paymode", (Object)"CREDIT");
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("asstacttype"))) {
            this.model.setValue("asstacttype", (Object)"bd_customer");
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("applydate"))) {
            this.model.setValue("applydate", (Object)InstantUtils.getInstantString((Instant)Instant.now(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("bizdate"))) {
            this.model.setValue("bizdate", (Object)InstantUtils.getInstantString((Instant)Instant.now(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("exratedate"))) {
            this.model.setValue("exratedate", (Object)InstantUtils.getInstantString((Instant)Instant.now(), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("redinvoice"))) {
            this.model.setValue("redinvoice", (Object)Boolean.FALSE);
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("redflushblue"))) {
            this.model.setValue("redflushblue", (Object)Boolean.FALSE);
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("invoicestatus"))) {
            this.model.setValue("invoicestatus", (Object)"0");
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("redflushblue"))) {
            this.model.setValue("redflushblue", (Object)Boolean.FALSE);
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("isoffline"))) {
            this.model.setValue("isoffline", (Object)Boolean.FALSE);
        }
        if ((invoicetype = (DynamicObject)this.model.getValue("invoicetypef7")) != null) {
            String number = invoicetype.getString("number");
            String value = InvoiceType.getValue((String)number);
            if (value == null) {
                value = number;
            }
            this.model.setValue("invoicetype", (Object)value);
        }
        DynamicObjectCollection entries = this.model.getEntryEntity("entry");
        for (DynamicObject entry : entries) {
            entry.set("e_unverifiedwriteoffqty", entry.get("e_quantity"));
        }
    }

    protected void setBuyer() {
        DynamicObject buyter = this.model.getDataEntity().getDynamicObject("buyer");
        if (Objects.isNull(buyter)) {
            return;
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("buyername"))) {
            this.model.setValue("buyername", (Object)buyter.getString("name"));
        }
    }

    protected void setSeller() {
        DynamicObject seller = this.model.getDataEntity().getDynamicObject("seller");
        if (Objects.isNull(seller)) {
            return;
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("sellername"))) {
            this.model.setValue("sellername", (Object)seller.getString("name"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("sellertin"))) {
            this.model.setValue("sellertin", (Object)seller.getString("ftaxregnum"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("selleraddr"))) {
            this.model.setValue("selleraddr", (Object)seller.getString("faddress"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("sellertel"))) {
            this.model.setValue("sellertel", (Object)seller.getString("phone"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("sellerbank"))) {
            this.model.setValue("sellerbank", (Object)seller.getString("depositbank"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("selleracct"))) {
            this.model.setValue("selleracct", (Object)seller.getString("bankaccount"));
        }
    }

    private void setMaterialandExpenseAbout() {
        DynamicObjectCollection entries = this.model.getEntryEntity("entry");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject expense;
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject material = entry.getDynamicObject("e_material");
            String billtype = (String)this.model.getValue("biztype");
            if (!EmptyUtils.isEmpty((Object)material) && "SAL".equals(billtype)) {
                DynamicObject productline;
                if (EmptyUtils.isEmpty((Object)entry.getString("e_itemname"))) {
                    this.model.setValue("e_itemname", (Object)material.getString("name"), i);
                }
                this.model.setValue("e_baseunit", (Object)material.getDynamicObject("baseunit"), i);
                if (EmptyUtils.isEmpty((Object)entry.getString("e_spectype"))) {
                    this.model.setValue("e_spectype", material.get("modelnum"), i);
                }
                if (EmptyUtils.isEmpty((Object)entry.get("e_measureunit"))) {
                    this.model.setValue("e_measureunit", material.get("baseunit"), i);
                }
                if ((productline = material.getDynamicObject("productline")) != null && ObjectUtils.isEmpty((Object)this.model.getValue("e_productline", i))) {
                    this.model.setValue("e_productline", productline.getPkValue(), i);
                }
                DynamicObject measureUnit = (DynamicObject)this.model.getValue("e_measureunit", i);
                long materialID = (Long)material.getPkValue();
                long measureUnitID = (Long)measureUnit.getPkValue();
                DynamicObject baseunit = material.getDynamicObject("baseunit");
                if (ObjectUtils.isEmpty((Object)baseunit)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"ArInvoiceBillImportHelper_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), material.getString("name")));
                }
                long baseUnitID = (Long)baseunit.getPkValue();
                BigDecimal convertRate = BigDecimal.ONE;
                if (measureUnitID != baseUnitID) {
                    convertRate = this.getConvertRate(materialID, measureUnitID, baseUnitID);
                }
                this.model.setValue("e_unitcoefficient", (Object)convertRate, i);
                BigDecimal quantity = (BigDecimal)this.model.getValue("e_quantity", i);
                this.model.setValue("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)convertRate, (DynamicObject)baseunit), i);
                Object taxclass = this.model.getValue("e_taxclass", i);
                if (ObjectUtils.isEmpty((Object)taxclass)) {
                    Long materialId = (Long)material.getPkValue();
                    DynamicObject taxsupertypenum = this.taxsupertypenumMap.get(materialId);
                    if (ObjectUtils.isEmpty((Object)taxsupertypenum)) {
                        taxsupertypenum = BusinessDataServiceHelper.loadSingle((String)"ar_goodslinktaxtype", (String)"taxsupertypenum.id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("materiel", "=", material.getPkValue())});
                        this.taxsupertypenumMap.put(materialId, taxsupertypenum);
                    }
                    if (!ObjectUtils.isEmpty((Object)taxsupertypenum)) {
                        this.model.setValue("e_taxclass", (Object)taxsupertypenum.getLong("taxsupertypenum.id"), i);
                    }
                }
            }
            if (EmptyUtils.isEmpty((Object)(expense = entry.getDynamicObject("e_expenseitem"))) || !"EXP".equals(billtype) || !EmptyUtils.isEmpty((Object)entry.getString("e_itemname")) || EmptyUtils.isEmpty((Object)expense.getString("name"))) continue;
            this.model.setValue("e_itemname", (Object)expense.getString("name"), i);
            Object taxclass = this.model.getValue("e_taxclass", i);
            if (!ObjectUtils.isEmpty((Object)taxclass)) continue;
            Long expenseitemId = (Long)expense.getPkValue();
            DynamicObject taxsupertypenum = this.taxsupertypenumMap.get(expenseitemId);
            if (ObjectUtils.isEmpty((Object)taxsupertypenum)) {
                taxsupertypenum = BusinessDataServiceHelper.loadSingle((String)"ar_goodslinktaxtype", (String)"taxsupertypenum.id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("expenseitem", "=", expense.getPkValue())});
                this.taxsupertypenumMap.put(expenseitemId, taxsupertypenum);
            }
            if (ObjectUtils.isEmpty((Object)taxsupertypenum)) continue;
            this.model.setValue("e_taxclass", (Object)taxsupertypenum.getLong("taxsupertypenum.id"), i);
        }
    }

    private BigDecimal getConvertRate(Long materialId, Long srcUnitId, Long desUnitId) {
        String key = materialId + "_" + srcUnitId + "_" + desUnitId;
        BigDecimal value = this.convertRateMap.get(key);
        if (value != null) {
            return value;
        }
        BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        this.convertRateMap.put(key, unitRateConv);
        return unitRateConv;
    }

    private void calculatePrice(Map sourceData) {
        DynamicObjectCollection entries = this.model.getEntryEntity("entry");
        int count = entries.size();
        boolean isFx = sourceData.get("isfx") != null && (Boolean)sourceData.get("isfx") != false;
        for (int i = 0; i < count; ++i) {
            this.calculateAmt(this.model, i, isFx);
        }
    }

    private void calculateAmt(IDataModel m, int index, boolean isFx) {
        m.beginInit();
        if (index != -1) {
            this.calculatorEntryAmt(m, index, isFx);
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                this.calculatorEntryAmt(m, i, isFx);
            }
        }
        this.calculateHeadAmt();
        m.endInit();
        IFormView v = this.view;
        if (index != -1) {
            for (String e : ENTRY) {
                v.updateView(e, index);
            }
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                String[] stringArray = ENTRY;
                int n = stringArray.length;
                for (int e = 0; e < n; ++e) {
                    String e2 = stringArray[e];
                    v.updateView(e2, i);
                }
            }
        }
        for (String h : HEAD) {
            v.updateView(h);
        }
    }

    private void calculateHeadAmt() {
        IDataModel m = this.model;
        int count = m.getEntryRowCount("entry");
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal reclocalamt = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            amount = amount.add((BigDecimal)m.getValue("e_amount", i));
            tax = tax.add((BigDecimal)m.getValue("e_tax", i));
            recamount = recamount.add((BigDecimal)m.getValue("e_recamount", i));
            reclocalamt = reclocalamt.add((BigDecimal)m.getValue("e_reclocalamt", i));
            localamt = localamt.add((BigDecimal)m.getValue("e_localamt", i));
        }
        m.setValue("amount", (Object)amount);
        m.setValue("tax", (Object)tax);
        m.setValue("recamount", (Object)recamount);
        m.setValue("reclocalamt", (Object)reclocalamt);
        m.setValue("localamt", (Object)localamt);
    }

    private void calculatorEntryAmt(IDataModel m, int index, boolean isFx) {
        UnitPriceCalculator calculator;
        DynamicObject basecurrency;
        boolean isPresent = (Boolean)m.getValue("e_ispresent", index);
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = ObjectUtils.isEmpty((Object)currency) ? 2 : currency.getInt("amtprecision");
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int localprecision = ObjectUtils.isEmpty((Object)(basecurrency = (DynamicObject)m.getValue("basecurrency"))) ? 2 : basecurrency.getInt("amtprecision");
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        BigDecimal discountAmt = (BigDecimal)m.getValue("e_discountamount", index);
        BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
        BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
        if (includeTax && isPresent) {
            this.resetEntryPropForPresent(m, rate, precision, localprecision, index, quotation);
            return;
        }
        if (includeTax) {
            BigDecimal pricetaxtotal = (BigDecimal)m.getValue("e_recamount", index);
            calculator = new PriceTaxTotalCalculator(false, unitPrice, taxUnitPrice, qty, pricetaxtotal, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else {
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        }
        boolean isCalculate = true;
        if (isFx) {
            BigDecimal recamount;
            BigDecimal calAmount;
            BigDecimal tax = (BigDecimal)m.getValue("e_tax", index);
            BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
            if (amount.compareTo(calAmount = (recamount = (BigDecimal)m.getValue("e_recamount", index)).subtract(tax)) == 0) {
                calculator.calculate();
                calculator.setTax(tax);
                calculator.setPricetaxtotal(recamount);
                calculator.setAmount(calAmount);
                isCalculate = false;
            }
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, isCalculate, quotation);
        localCalculator.calculate();
        this.resetEntryProp(m, localCalculator, index);
    }

    private void resetEntryPropForPresent(IDataModel m, BigDecimal rate, int precision, int localprecision, int index, String quotation) {
        BigDecimal price = (BigDecimal)m.getValue("e_unitprice", index);
        m.setValue("e_taxunitprice", (Object)price, index);
        m.setValue("e_actunitprice", (Object)price, index);
        m.setValue("e_acttaxunitprice", (Object)price, index);
        m.setValue("e_tax", (Object)BigDecimal.ZERO, index);
        m.setValue("e_amount", (Object)BigDecimal.ZERO, index);
        m.setValue("e_localamt", (Object)BigDecimal.ZERO, index);
        m.setValue("e_recamount", (Object)BigDecimal.ZERO, index);
        m.setValue("e_reclocalamt", (Object)BigDecimal.ZERO, index);
        m.setValue("e_unverifiedwriteoffamt", (Object)BigDecimal.ZERO, index);
        BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal discountAmout = price.multiply(quantity).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal discountLocalAmt = "0".equals(quotation) ? discountAmout.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP) : discountAmout.divide(rate, localprecision, RoundingMode.HALF_UP);
        m.setValue("e_discountamount", (Object)discountAmout, index);
        m.setValue("e_discountlocalamt", (Object)discountLocalAmt, index);
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
        m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("e_actunitprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice(), index);
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
        m.setValue("e_amount", (Object)localCalculator.getAmount(), index);
        m.setValue("e_localamt", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_recamount", (Object)localCalculator.getPricetaxtotal(), index);
        m.setValue("e_reclocalamt", (Object)localCalculator.getPricetaxtotallocal(), index);
        m.setValue("e_unverifiedwriteoffamt", (Object)localCalculator.getPricetaxtotal(), index);
        m.setValue("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
    }

    private void setTaxRate() {
        DynamicObjectCollection entries = this.model.getEntryEntity("entry");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
            if (EmptyUtils.isEmpty((Object)taxRateId)) {
                this.model.setValue("taxrateid", null, i);
                continue;
            }
            if (taxRateId.get("taxrate") == entry.get("e_taxrate") || EmptyUtils.isEmpty((Object)taxRateId.get("taxrate"))) continue;
            this.model.setValue("e_taxrate", taxRateId.get("taxrate"));
        }
    }

    private void setIsPresent() {
        DynamicObjectCollection entries = this.model.getEntryEntity("entry");
        for (int i = 0; i < entries.size(); ++i) {
            Boolean isPresent = (Boolean)this.model.getValue("e_ispresent", i);
            if (isPresent == null || !isPresent.booleanValue()) continue;
            BigDecimal rice = (BigDecimal)this.model.getValue("e_unitprice", i);
            BigDecimal priceTax = (BigDecimal)this.model.getValue("e_taxunitprice", i);
            if (BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) {
                this.model.setValue("e_discountmode", (Object)"PERCENT", i);
                this.model.setValue("e_discountrate", (Object)new BigDecimal(100), i);
                continue;
            }
            this.model.setValue("e_discountmode", (Object)"NULL", i);
            this.model.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
        }
    }

    private void checkTaxClassNull(Map entry) {
        if (EmptyUtils.isEmpty(entry.get("e_taxclass"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u7a0e\u6536\u5206\u7c7b\u3002", (String)"ArInvoiceBillImportHelper_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        Map taxClass = (Map)entry.get("e_taxclass");
        if (taxClass.get("number") == null && taxClass.get("name") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u7a0e\u6536\u5206\u7c7b\u3002", (String)"ArInvoiceBillImportHelper_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(7);
        headFields.add("recamount");
        headFields.add("amount");
        headFields.add("tax");
        headFields.add("reclocalamt");
        headFields.add("localamt");
        headFields.add("associatedamt");
        headFields.add("quotation");
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(6);
        entryFields.add("e_verifiedwriteoffamt");
        entryFields.add("e_unverifiedwriteoffamt");
        entryFields.add("e_verifiedwriteoffqty");
        entryFields.add("e_unverifiedwriteoffqty");
        entryFields.add("e_actunitprice");
        entryFields.add("e_acttaxunitprice");
        entryFields.add("e_associatedamt");
        return entryFields;
    }
}

