/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceCardService {
    public static void fillSellerInfo(IDataModel m, DynamicObject org) {
        m.setValue("seller", org.getPkValue());
        if (StringUtils.isEmpty((String)org.getString("ffirmname"))) {
            m.setValue("sellername", (Object)org.getString("name"));
        } else {
            m.setValue("sellername", (Object)org.getString("ffirmname"));
        }
        m.setValue("sellertin", org.get("ftaxregnum"));
        m.setValue("selleraddr", (Object)org.getString("faddress"));
        m.setValue("sellertel", org.get("phone"));
        m.setValue("sellerbank", (Object)org.getString("depositbank"));
        m.setValue("selleracct", org.get("bankaccount"));
    }

    public static Map<String, Object> initSellerParamMap(IDataModel m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object seller = m.getValue("seller");
        if (seller != null) {
            DynamicObject obj = (DynamicObject)seller;
            seller = obj.getPkValue();
        }
        map.put("seller", seller);
        map.put("sellername", m.getValue("sellername"));
        map.put("sellertin", m.getValue("sellertin"));
        map.put("selleraddr", m.getValue("selleraddr"));
        map.put("sellertel", m.getValue("sellertel"));
        map.put("sellerbank", m.getValue("sellerbank"));
        map.put("selleracct", m.getValue("selleracct"));
        return map;
    }

    public static void setSellerInfo(AbstractBillPlugIn form, Map<String, Object> map) {
        IDataModel model = form.getView().getModel();
        model.setValue("seller", map.get("seller"));
        model.setValue("sellername", map.get("sellername"));
        model.setValue("sellertin", map.get("sellertin"));
        model.setValue("selleraddr", map.get("selleraddr"));
        model.setValue("sellertel", map.get("sellertel"));
        model.setValue("sellerbank", map.get("sellerbank"));
        model.setValue("selleracct", map.get("selleracct"));
        InvoiceCardService.setSellerLabel(form);
    }

    public static void setSellerLabel(AbstractBillPlugIn form) {
        IDataModel model = form.getView().getModel();
        if (model.getValue("sellername") == null || "".equals(model.getValue("sellername").toString().trim())) {
            form.getView().setVisible(Boolean.TRUE, new String[]{"flex_addseller"});
            form.getView().setVisible(Boolean.FALSE, new String[]{"flex_sellerinfo"});
        } else {
            ((Label)form.getControl("sname")).setText(model.getValue("sellername").toString());
            ((Label)form.getControl("stin")).setText(model.getValue("sellertin").toString());
            ((Label)form.getControl("saddr")).setText(model.getValue("selleraddr").toString());
            ((Label)form.getControl("stel")).setText(model.getValue("sellertel").toString());
            ((Label)form.getControl("sbank")).setText(model.getValue("sellerbank").toString());
            ((Label)form.getControl("sacct")).setText(model.getValue("selleracct").toString());
            form.getView().setVisible(Boolean.FALSE, new String[]{"flex_addseller"});
            form.getView().setVisible(Boolean.TRUE, new String[]{"flex_sellerinfo"});
        }
    }

    public static Map<String, Object> initBuyerParamMap(IDataModel m) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object buyer = m.getValue("buyer");
        if (buyer != null) {
            DynamicObject obj = (DynamicObject)buyer;
            buyer = obj.getPkValue();
        }
        map.put("buyer", buyer);
        map.put("buyername", m.getValue("buyername"));
        map.put("asstacttype", m.getValue("asstacttype"));
        map.put("buyertin", m.getValue("buyertin"));
        map.put("buyeraddr", m.getValue("buyeraddr"));
        map.put("buyertel", m.getValue("buyertel"));
        map.put("buyerbank", m.getValue("buyerbank"));
        map.put("buyeracct", m.getValue("buyeracct"));
        return map;
    }

    public static void setBuyerInfo(AbstractBillPlugIn form, Map<String, Object> map) {
        IDataModel model = form.getView().getModel();
        model.setValue("buyer", map.get("buyer"));
        model.setValue("buyername", map.get("buyername"));
        model.setValue("buyertin", map.get("buyertin"));
        model.setValue("buyeraddr", map.get("buyeraddr"));
        model.setValue("buyertel", map.get("buyertel"));
        model.setValue("buyerbank", map.get("buyerbank"));
        model.setValue("buyeracct", map.get("buyeracct"));
        InvoiceCardService.setBuyerLabel(form);
    }

    public static void setBuyerLabel(AbstractBillPlugIn form) {
        IDataModel model = form.getView().getModel();
        if (model.getValue("buyer") == null && EmptyUtils.isEmpty((Object)model.getValue("buyername"))) {
            form.getView().setVisible(Boolean.TRUE, new String[]{"flex_addbuyer"});
            form.getView().setVisible(Boolean.FALSE, new String[]{"flex_buyerinfo"});
        } else {
            ((Label)form.getControl("bname")).setText((String)model.getValue("buyername"));
            ((Label)form.getControl("btin")).setText(model.getValue("buyertin").toString());
            ((Label)form.getControl("baddr")).setText(model.getValue("buyeraddr").toString());
            ((Label)form.getControl("btel")).setText(model.getValue("buyertel").toString());
            ((Label)form.getControl("bbank")).setText(model.getValue("buyerbank").toString());
            ((Label)form.getControl("bacct")).setText(model.getValue("buyeracct").toString());
            form.getView().setVisible(Boolean.FALSE, new String[]{"flex_addbuyer"});
            form.getView().setVisible(Boolean.TRUE, new String[]{"flex_buyerinfo"});
        }
    }
}

