/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SalesLayoutPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addSalesmanListener();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("ar_transferofcredit".equals(this.getModel().getDataEntityType().getName())) {
            return;
        }
        Object org = this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org) && ((DynamicObject)org).getBoolean("fissale")) {
            this.getModel().setValue("salesorg", org);
        } else {
            this.getModel().setValue("salesorg", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newVal = changeData[0].getNewValue();
        if ("salesorg".equals(key)) {
            this.salesOrgChanged();
        } else if ("salesman".equals(key)) {
            this.salesmanChanged(newVal);
        }
    }

    private void salesmanChanged(Object newVal) {
        Long saleGroupId = newVal == null ? null : Long.valueOf(((DynamicObject)newVal).getLong("operatorgrpid"));
        this.getModel().setValue("salesgroup", (Object)saleGroupId);
    }

    private void salesOrgChanged() {
        this.getModel().setValue("salesman", null);
        this.getModel().setValue("salesgroup", null);
    }

    private void addSalesmanListener() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("salesman");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter filter = new QFilter("opergrptype", "=", (Object)"XSZ");
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("salesorg"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesLayoutPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("salesorg");
            Long id = org.getLong("id");
            Map operatorgroupMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("operatorgrouptype", "=", (Object)"XSZ"), new QFilter("ctrlstrategy", "!=", (Object)"7").or("createorg", "=", (Object)id)});
            ArrayList<String> groupNos = new ArrayList<String>(operatorgroupMap.size());
            for (Map.Entry keySet : operatorgroupMap.entrySet()) {
                DynamicObject operatorgroup = (DynamicObject)keySet.getValue();
                groupNos.add(operatorgroup.getString("number"));
            }
            if (groupNos.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u9500\u552e\u7ec4\u3002", (String)"SalesLayoutPlugin_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            filter = filter.and(new QFilter("opergrpnumber", "in", groupNos));
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }
}

