/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApTransferHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.EmptyUtils;

@KSObject
public class TransferEditController {
    private Map<String, Set<String>> extendFieldMap = new HashMap<String, Set<String>>(2);

    public void fillModel(IDataModel model, IFormView view) {
        List billIds = (List)view.getFormShowParameter().getCustomParam("billIds");
        this.extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"ar_transferofcredit");
        String sourceBillSelectors = String.join((CharSequence)",", this.getSourceBillSelectors());
        QFilter[] sourceBillFilters = new QFilter[]{new QFilter("id", "in", (Object)billIds)};
        DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)sourceBillSelectors, (QFilter[])sourceBillFilters);
        this.fillHead(model, view, finBills);
        for (DynamicObject finBill : finBills) {
            DynamicObjectCollection srcDetailEntry = finBill.getDynamicObjectCollection("entry");
            for (DynamicObject srcDetailRow : srcDetailEntry) {
                if (srcDetailRow.getBigDecimal("e_unlockamt").signum() == 0) continue;
                int entryIndex = model.createNewEntryRow("entryentity");
                this.fillEntry(srcDetailRow, model, entryIndex);
            }
            DynamicObjectCollection srcPlanEntity = finBill.getDynamicObjectCollection("planentity");
            for (DynamicObject srcPlanRow : srcPlanEntity) {
                if (srcPlanRow.getBigDecimal("unplanlockamt").signum() == 0) continue;
                int entryIndex = model.createNewEntryRow("planentity");
                this.fillPlanEntry(srcPlanRow, model, entryIndex);
            }
        }
    }

    protected void fillHead(IDataModel model, IFormView view, DynamicObject[] finBills) {
        Date bizDate;
        DynamicObject finBill = finBills[0];
        DynamicObject org = finBill.getDynamicObject("org");
        Set salesorgs = Arrays.stream(finBills).map(e -> e.getDynamicObject("salesorg")).collect(Collectors.toSet());
        Set salesmans = Arrays.stream(finBills).map(e -> e.getDynamicObject("salesman")).collect(Collectors.toSet());
        if (salesorgs.size() == 1) {
            model.setValue("salesorg", (Object)finBill.getDynamicObject("salesorg"));
            if (salesmans.size() == 1) {
                model.setValue("salesman", (Object)finBill.getDynamicObject("salesman"));
                model.setValue("salesgroup", (Object)finBill.getDynamicObject("salesgroup"));
            }
        }
        InitHelper init = new InitHelper(org.getLong("id"), "ar_init");
        HashSet<Date> dates = new HashSet<Date>(2);
        for (DynamicObject fin : finBills) {
            dates.add(fin.getDate("exratedate"));
            if (dates.size() > 1) break;
        }
        if (dates.size() == 1) {
            model.setValue("exratedate", (Object)finBill.getDate("exratedate"));
        } else {
            model.setValue("exratedate", (Object)new Date());
        }
        HashSet<Long> exratetableIds = new HashSet<Long>(2);
        for (DynamicObject fin : finBills) {
            DynamicObject exratetable = fin.getDynamicObject("exratetable");
            exratetableIds.add(exratetable.getLong("id"));
            if (exratetableIds.size() > 1) break;
        }
        if (exratetableIds.size() == 1) {
            model.setValue("exratetable", finBill.get("exratetable"));
        } else {
            model.setValue("exratetable", (Object)init.getExrateTable());
        }
        DynamicObject currency = finBill.getDynamicObject("currency");
        DynamicObject basecurrency = finBill.getDynamicObject("basecurrency");
        Long currencyId = currency.getLong("id");
        Long basecurrencyId = basecurrency.getLong("id");
        model.setValue("currency", (Object)currencyId);
        model.setValue("basecurrency", (Object)basecurrencyId);
        if (finBill.getLong("currency.id") == finBill.getLong("basecurrency.id")) {
            view.setVisible(Boolean.FALSE, new String[]{"head_exchangerate"});
            view.setVisible(Boolean.FALSE, new String[]{"e_localamount"});
            model.setValue("head_exchangerate", (Object)1);
            model.setValue("quotation", (Object)"0");
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"head_exchangerate"});
            view.setEnable(Boolean.TRUE, new String[]{"head_exchangerate"});
            view.setVisible(Boolean.TRUE, new String[]{"e_localamount"});
            this.getExchangeRate(model, view);
        }
        ArApHelper.setValue((IDataModel)model, (String)"billtype", (Object)finBills[0].getDynamicObject("billtype"));
        ArApHelper.setValue((IDataModel)model, (String)"asstacttype", (Object)finBills[0].getString("asstacttype"));
        ArApHelper.setValue((IDataModel)model, (String)"org", (Object)org);
        ArApHelper.setValue((IDataModel)model, (String)"recorg", (Object)finBills[0].getDynamicObject("recorg"));
        ArApHelper.setValue((IDataModel)model, (String)"currency", (Object)finBills[0].getDynamicObject("currency"));
        Date currentDate = init.getCurrentDate();
        if (currentDate == null) {
            currentDate = init.getStartDate();
        }
        if (currentDate.after(bizDate = new Date())) {
            model.setValue("bizdate", (Object)currentDate);
            model.setValue("duedate", (Object)currentDate);
        }
        DateEdit transDate = (DateEdit)view.getControl("bizdate");
        transDate.setMinDate(currentDate);
        Set<String> headExtendFields = this.extendFieldMap.get("head");
        for (String headExtendField : headExtendFields) {
            HashSet<Object> sameValues = new HashSet<Object>(64);
            for (DynamicObject fin : finBills) {
                sameValues.add(fin.get(headExtendField));
            }
            if (sameValues.size() != 1) continue;
            model.setValue(headExtendField, finBills[0].get(headExtendField));
        }
    }

    private void getExchangeRate(IDataModel model, IFormView view) {
        DynamicObject srcCurrency = (DynamicObject)model.getValue("currency");
        DynamicObject destCurrency = (DynamicObject)model.getValue("basecurrency");
        DynamicObject exrateTable = (DynamicObject)model.getValue("exratetable");
        long srcCurrencyId = srcCurrency.getLong("id");
        long destCurrencyId = destCurrency.getLong("id");
        long exrateTableId = exrateTable.getLong("id");
        Date exrateDate = (Date)model.getValue("exratedate");
        Map exrateMap = BaseDataHelper.getExchangeRateMap((Long)exrateTableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        if (exrateMap != null) {
            boolean quoteType = (Boolean)exrateMap.get("quoteType");
            String quotation = quoteType ? "1" : "0";
            model.setValue("quotation", (Object)quotation);
            Object exchangeRate = exrateMap.get("exchangeRate");
            if (EmptyUtils.isEmpty(exchangeRate)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"TransferEditController_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            model.setValue("head_exchangerate", (Object)((BigDecimal)exchangeRate));
        }
    }

    protected void fillEntry(DynamicObject row, IDataModel model, int index) {
        DynamicObject info = (DynamicObject)row.getParent();
        BigDecimal unLockAmt = row.getBigDecimal("e_unlockamt");
        ArApHelper.setValue((IDataModel)model, (String)"e_srcfinbillid", (Object)info.getLong("id"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_asstacttype", (Object)info.getString("asstacttype"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_asstact", (Object)info.getDynamicObject("asstact"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_billno", (Object)info.getString("billno"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_bizdate", (Object)info.getDate("bizdate"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_currency", (Object)info.getDynamicObject("currency"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_trate", (Object)info.getBigDecimal("exchangerate"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_srcentryid", (Object)row.getLong("id"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_material", (Object)row.getDynamicObject("e_material"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_spectype", (Object)row.getString("e_spectype"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_assistantattr", (Object)row.get("e_assistantattr"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_expenseitem", (Object)row.getDynamicObject("e_expenseitem"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_recamount", (Object)unLockAmt, (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_pricetaxtotal", (Object)row.getBigDecimal("e_recamount"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_measureunit", (Object)row.getDynamicObject("e_measureunit"), (int)index);
        BigDecimal quantity = row.getBigDecimal("e_quantity");
        ArApHelper.setValue((IDataModel)model, (String)"e_maxquantity", (Object)quantity, (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_quantity", (Object)quantity, (int)index);
        BigDecimal taxrate = row.getBigDecimal("e_taxrate").divide(BigDecimal.valueOf(100L));
        ArApHelper.setValue((IDataModel)model, (String)"e_taxrate", (Object)taxrate, (int)index);
        int precision = info.getInt("currency.amtprecision");
        BigDecimal taxRate = row.getBigDecimal("taxrateid.taxrate").divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP);
        BigDecimal tax = unLockAmt.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_UP);
        ArApHelper.setValue((IDataModel)model, (String)"e_transtax", (Object)tax, (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_transamount", (Object)unLockAmt.subtract(tax), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_transrecamount", (Object)unLockAmt, (int)index);
        BigDecimal exchangeRate = (BigDecimal)model.getValue("head_exchangerate");
        String quotation = (String)model.getValue("quotation");
        DynamicObject currency = (DynamicObject)model.getValue("basecurrency");
        int localprecision = currency.getInt("amtprecision");
        if (!EmptyUtils.isEmpty((Object)exchangeRate)) {
            if ("0".equals(quotation)) {
                ArApHelper.setValue((IDataModel)model, (String)"e_localamount", (Object)unLockAmt.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP), (int)index);
            } else {
                ArApHelper.setValue((IDataModel)model, (String)"e_localamount", (Object)unLockAmt.divide(exchangeRate, localprecision, RoundingMode.HALF_UP), (int)index);
            }
        }
        ArApHelper.setValue((IDataModel)model, (String)"taxrateid", (Object)row.getDynamicObject("taxrateid"), (int)index);
        ArApHelper.setValue((IDataModel)model, (String)"e_splitdimensionid", (Object)row.get("e_splitdimensionid"), (int)index);
        Set<String> materialExtendFields = this.extendFieldMap.get("entry");
        for (String materialExtendField : materialExtendFields) {
            ArApHelper.setValue((IDataModel)model, (String)materialExtendField, (Object)row.get(materialExtendField), (int)index);
        }
    }

    private void fillPlanEntry(DynamicObject srcPlanRow, IDataModel model, int index) {
        DynamicObject finBill = (DynamicObject)srcPlanRow.getParent();
        model.setValue("p_billno", finBill.get("billno"), index);
        model.setValue("p_billid", finBill.get("id"), index);
        model.setValue("p_entryid", srcPlanRow.get("id"), index);
        model.setValue("p_transpricetaxtotal", srcPlanRow.get("unplanlockamt"), index);
        model.setValue("p_splitdimensionid", srcPlanRow.get("p_splitdimensionid"), index);
        model.setValue("p_recrate", srcPlanRow.get("p_recrate"), index);
        Set<String> planEntryFieldNames = this.extendFieldMap.get("planentity");
        for (String fieldName : planEntryFieldNames) {
            model.setValue(fieldName, srcPlanRow.get(fieldName), index);
        }
    }

    protected List<String> getSourceBillSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("org");
        selectors.add("recorg");
        selectors.add("billtype");
        selectors.add("salesorg");
        selectors.add("salesman");
        selectors.add("salesgroup");
        selectors.add("currency");
        selectors.add("basecurrency");
        selectors.add("exchangerate");
        selectors.add("billno");
        selectors.add("exratedate");
        selectors.add("bizdate");
        selectors.add("duedate");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("exratetable");
        selectors.add("e_material");
        selectors.add("e_assistantattr");
        selectors.add("e_spectype");
        selectors.add("e_expenseitem");
        selectors.add("e_measureunit");
        selectors.add("e_quantity");
        selectors.add("e_taxrate");
        selectors.add("taxrateid");
        selectors.add("e_recamount");
        selectors.add("e_unlockamt");
        selectors.add("e_splitdimensionid");
        selectors.add("p_splitdimensionid");
        selectors.add("p_recrate");
        selectors.addAll((Collection)this.extendFieldMap.get("head"));
        selectors.addAll((Collection)this.extendFieldMap.get("entry"));
        selectors.addAll((Collection)this.extendFieldMap.get("planentity"));
        return selectors;
    }
}

