/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice.bus;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.MaterialRow;

public class BusArBillImportHelper
extends AbstractBillImport {
    private Map<String, BigDecimal> convertRateMap = new HashMap<String, BigDecimal>(8);
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private final List<String> headUpdFields = this.headRemoveUpFields();
    private final List<String> entryUpdFields = this.entryRemoveUpFields();
    private QuotationHelper quotationHelper;

    public BusArBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map sourceData = e.getSourceData();
        boolean includeTax = sourceData.containsKey("isincludetax") ? ((Boolean)sourceData.get("isincludetax")).booleanValue() : ((Boolean)this.model.getValue("isincludetax")).booleanValue();
        boolean ispricetotal = sourceData.containsKey("ispricetotal") ? ((Boolean)sourceData.get("ispricetotal")).booleanValue() : ((Boolean)this.model.getValue("ispricetotal")).booleanValue();
        boolean isNew = false;
        String importType = (String)e.getOption().get("importtype");
        if ("overridenew".equals(importType) || importType == null) {
            isNew = ObjectUtils.isEmpty(sourceData.get("_pkid_"));
        } else if ("new".equals(importType)) {
            isNew = true;
        }
        if (!isNew && !EmptyUtils.isEmpty(sourceData.get("sourcebillid"))) {
            this.removeNoAssignField(sourceData, this.headUpdFields);
        } else {
            this.checkNull("currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"BusArBillImportHelper_12", (String)"fi-ar-formplugin", (Object[])new Object[0]), sourceData);
            this.removeNoAssignField(sourceData, this.headFields);
        }
        this.removeNoAssignField(sourceData, new String[]{"planentity"});
        List entryList = null;
        if (sourceData.get("entry") != null) {
            entryList = (List)sourceData.get("entry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                boolean ispresent;
                Map entry = (Map)entryList.get(i);
                boolean bl = ispresent = entry.get("e_ispresent") != null ? (Boolean)entry.get("e_ispresent") : false;
                if (!isNew && !EmptyUtils.isEmpty(sourceData.get("sourcebillid"))) {
                    this.removeNoAssignField(entry, this.entryUpdFields);
                } else {
                    this.removeNoAssignField(entry, this.entryFields);
                }
                this.checkPriceandAmount(ispresent, includeTax, ispricetotal, entry, i);
                this.removeNoAssignField(entry, new String[]{"subentryentity"});
                this.checkCoreBillEntrySeq(entry, i);
                this.checkDiscountMode(includeTax, entry, i);
            }
        }
        if (!isNew && !EmptyUtils.isEmpty(sourceData.get("sourcebillid"))) {
            this.removeNoAssignField(sourceData, new String[]{"isincludetax"});
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject org;
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        if (BillSrcTypeEnum.MANUAL.getValue().equals(this.model.getValue("billsrctype"))) {
            this.model.setValue("billsrctype", (Object)BillSrcTypeEnum.IMPORT.getValue());
        }
        if (ObjectUtils.isEmpty((Object)(org = (DynamicObject)this.model.getValue("org")))) {
            return;
        }
        Long orgPk = (Long)org.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ar_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"BusArBillImportHelper_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        this.init.checkInit();
        BookDateHelper.checkBookDate((IDataModel)this.model, (boolean)true, (Map)this.cacheDateMap, (InitHelper)this.init);
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusArBillImportHelper_13", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        this.createByInit(sourceData);
        this.setCalculatorAmt((IBillModel)this.model);
    }

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    private void setCalculatorAmt(IBillModel m) {
        int count = m.getEntryEntity("entry").size();
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal reclocalamt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        BigDecimal invoicedamt = BigDecimal.ZERO;
        BigDecimal invoicedlocamt = BigDecimal.ZERO;
        BigDecimal uninvoicedamt = BigDecimal.ZERO;
        BigDecimal uninvoicedlocamt = BigDecimal.ZERO;
        BigDecimal unwoffamt = BigDecimal.ZERO;
        BigDecimal unwofflocamt = BigDecimal.ZERO;
        BigDecimal unrelateinvamt = BigDecimal.ZERO;
        BigDecimal unrelateinvlocamt = BigDecimal.ZERO;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        boolean ispricetotal = (Boolean)m.getValue("ispricetotal");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = currency.getInt("amtprecision");
        int localprecision = this.getLocalPrecision();
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        HashMap<String, MaterialRow> rowMap = new HashMap<String, MaterialRow>(8);
        for (int i = 0; i < count; ++i) {
            DynamicObject taxrateid;
            Boolean isPresent;
            DynamicObject material = (DynamicObject)m.getValue("e_material", i);
            if (!ObjectUtils.isEmpty((Object)material)) {
                m.setValue("e_spectype", (Object)material.getString("modelnum"), i);
                DynamicObject baseunit = material.getDynamicObject("baseunit");
                if (baseunit != null) {
                    Object baseunitPk = baseunit.getPkValue();
                    m.setValue("e_baseunit", baseunitPk, i);
                    if (ObjectUtils.isEmpty((Object)m.getValue("e_measureunit", i))) {
                        m.setValue("e_measureunit", baseunitPk, i);
                    }
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7269\u6599\u201c%s\u201d\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"BusArBillImportHelper_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), material.getString("name")));
                }
                DynamicObject productline = material.getDynamicObject("productline");
                if (productline != null && ObjectUtils.isEmpty((Object)m.getValue("e_productline", i))) {
                    m.setValue("e_productline", productline.getPkValue(), i);
                }
                DynamicObject measureUnit = (DynamicObject)m.getValue("e_measureunit", i);
                long materialID = (Long)material.getPkValue();
                long measureUnitID = (Long)measureUnit.getPkValue();
                String key = materialID + "-" + measureUnitID;
                MaterialRow row = null;
                if (!rowMap.containsKey(key)) {
                    row = this.buildMaterialRow(material, baseunit, measureUnitID);
                    rowMap.put(key, row);
                } else {
                    row = (MaterialRow)rowMap.get(key);
                }
                this.setMaterialRow(m, row, i);
                BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", i);
                m.setValue("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)row.getUnitCoefficient(), (DynamicObject)baseunit), i);
                if (ObjectUtils.isEmpty((Object)m.getValue("taxrateid", i)) && material.getDynamicObject("taxrate") != null) {
                    Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                    m.setValue("taxrateid", taxrateId, i);
                }
            }
            if ((isPresent = (Boolean)this.model.getValue("e_ispresent", i)).booleanValue()) {
                BigDecimal rice = (BigDecimal)m.getValue("e_unitprice", i);
                BigDecimal priceTax = (BigDecimal)m.getValue("e_taxunitprice", i);
                if (BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) {
                    m.setValue("e_discountmode", (Object)"PERCENT", i);
                    m.setValue("e_discountrate", (Object)new BigDecimal(100), i);
                } else {
                    m.setValue("e_discountmode", (Object)"NULL", i);
                    m.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
                }
            }
            if (!ObjectUtils.isEmpty((Object)(taxrateid = (DynamicObject)m.getValue("taxrateid", i))) && EmptyUtils.isEmpty((Object)m.getValue("e_taxrate", i))) {
                m.setValue("e_taxrate", (Object)taxrateid.getBigDecimal("taxrate"), i);
            }
            Object disCountType = m.getValue("e_discountmode", i);
            BigDecimal disCountAmt = (BigDecimal)m.getValue("e_discountamount", i);
            BigDecimal qty = (BigDecimal)m.getValue("e_quantity", i);
            int pricePrecision = 4;
            if (DiscountModeEnum.NULL.getValue().equals(m.getValue("e_discountmode", i)) || DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) == 0) {
                m.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
            } else if (DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) != 0) {
                pricePrecision = currency.getInt("priceprecision");
                BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", i);
                taxRate = taxRate.divide(BigDecimal.valueOf(100L));
                BigDecimal discountRate = includeTax ? disCountAmt.divide(qty, pricePrecision, RoundingMode.HALF_UP) : disCountAmt.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.add(taxRate), pricePrecision, RoundingMode.HALF_UP);
                m.setValue("e_discountrate", (Object)discountRate, i);
            }
            if (ispricetotal && isPresent.booleanValue()) {
                this.resetEntryPropForPresent(m, includeTax, rate, precision, localprecision, i, quotation);
            } else {
                this.calculatorEntryAmt((IDataModel)m, includeTax, ispricetotal, quotation, rate, precision, localprecision, i);
            }
            recamount = recamount.add((BigDecimal)m.getValue("e_recamount", i));
            reclocalamt = reclocalamt.add((BigDecimal)m.getValue("e_reclocalamt", i));
            amount = amount.add((BigDecimal)m.getValue("e_amount", i));
            localamt = localamt.add((BigDecimal)m.getValue("e_localamt", i));
            tax = tax.add((BigDecimal)m.getValue("e_tax", i));
            taxlocamt = taxlocamt.add((BigDecimal)m.getValue("e_taxlocalamt", i));
            invoicedamt = invoicedamt.add((BigDecimal)m.getValue("e_invoicedamt", i));
            invoicedlocamt = invoicedlocamt.add((BigDecimal)m.getValue("e_invoicedlocamt", i));
            uninvoicedamt = uninvoicedamt.add((BigDecimal)m.getValue("e_uninvoicedamt", i));
            uninvoicedlocamt = uninvoicedlocamt.add((BigDecimal)m.getValue("e_uninvoicedlocamt", i));
            unwoffamt = unwoffamt.add((BigDecimal)m.getValue("e_unwoffamt", i));
            unwofflocamt = unwofflocamt.add((BigDecimal)m.getValue("e_unwofflocamt", i));
            unrelateinvamt = unrelateinvamt.add((BigDecimal)m.getValue("e_unrelateinvamt", i));
            unrelateinvlocamt = unrelateinvlocamt.add((BigDecimal)m.getValue("e_unrelateinvlocamt", i));
        }
        m.setValue("recamount", (Object)recamount);
        m.setValue("reclocalamt", (Object)reclocalamt);
        m.setValue("amount", (Object)amount);
        m.setValue("localamt", (Object)localamt);
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxlocamt);
        m.setValue("invoicedamt", (Object)invoicedamt);
        m.setValue("invoicedlocamt", (Object)invoicedlocamt);
        m.setValue("uninvoicedamt", (Object)uninvoicedamt);
        m.setValue("uninvoicedlocamt", (Object)uninvoicedlocamt);
        m.setValue("unwoffamt", (Object)unwoffamt);
        m.setValue("unwofflocamt", (Object)unwofflocamt);
        m.setValue("unwoffnotaxamt", (Object)amount);
        m.setValue("unwoffnotaxlocamt", (Object)localamt);
        m.setValue("unwofftax", (Object)tax);
        m.setValue("unwofftaxlocal", (Object)taxlocamt);
        m.setValue("unrelateinvamt", (Object)unrelateinvamt);
        m.setValue("unrelateinvlocamt", (Object)unrelateinvlocamt);
    }

    private void resetEntryPropForPresent(IBillModel m, boolean includeTax, BigDecimal rate, int precision, int localprecision, int i, String quotation) {
        BigDecimal price;
        BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", i);
        m.setValue("e_uninvoicedqty", (Object)quantity, i);
        m.setValue("e_unconfirmqty", (Object)quantity, i);
        m.setValue("e_unwoffqty", (Object)quantity, i);
        if (includeTax) {
            price = (BigDecimal)m.getValue("e_taxunitprice", i);
            m.setValue("e_unitprice", (Object)price, i);
        } else {
            price = (BigDecimal)m.getValue("e_unitprice", i);
            m.setValue("e_taxunitprice", (Object)price, i);
        }
        m.setValue("e_actunitprice", (Object)price, i);
        m.setValue("e_acttaxunitprice", (Object)price, i);
        m.setValue("e_tax", (Object)BigDecimal.ZERO, i);
        m.setValue("e_taxlocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_amount", (Object)BigDecimal.ZERO, i);
        m.setValue("e_localamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_recamount", (Object)BigDecimal.ZERO, i);
        m.setValue("e_reclocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvoicedamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvoicedlocamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unconfirmamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwoffamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwofflocamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwoffnotaxamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwoffnotaxlocamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwofftax", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwofftaxlocal", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvnotaxamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvnotaxlocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unrelateinvamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unrelateinvlocamt", (Object)BigDecimal.ZERO, i);
        BigDecimal discountAmout = price.multiply(quantity).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal discountLocalAmt = "0".equals(quotation) ? discountAmout.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP) : discountAmout.divide(rate, localprecision, RoundingMode.HALF_UP);
        m.setValue("e_discountamount", (Object)discountAmout, i);
        m.setValue("e_discountlocalamt", (Object)discountLocalAmt, i);
    }

    private void setMaterialRow(IBillModel m, MaterialRow row, int iRow) {
        m.setValue("e_spectype", (Object)row.getSpecType(), iRow);
        m.setValue("e_baseunit", (Object)row.getBaseUnitPk(), iRow);
        m.setValue("e_measureunit", (Object)row.getMeasureUnitPk(), iRow);
        m.setValue("e_unitcoefficient", (Object)row.getUnitCoefficient(), iRow);
        if (EmptyUtils.isNotEmpty((Object)row.getTaxRatePk()) && EmptyUtils.isEmpty((Object)m.getValue("taxrateid", iRow))) {
            m.setValue("taxrateid", (Object)row.getTaxRatePk(), iRow);
        }
    }

    private MaterialRow buildMaterialRow(DynamicObject material, DynamicObject baseunit, long measureUnitID) {
        MaterialRow row = new MaterialRow();
        row.setMaterialPk(((Long)material.getPkValue()).longValue());
        row.setSpecType(material.getString("modelnum"));
        row.setBaseUnitPk(baseunit != null ? (Long)baseunit.getPkValue() : measureUnitID);
        row.setMeasureUnitPk(measureUnitID);
        BigDecimal convertRate = this.getConvertRate(row.getMaterialPk(), row.getMeasureUnitPk(), row.getBaseUnitPk());
        row.setUnitCoefficient(convertRate != null ? convertRate : BigDecimal.ONE);
        DynamicObject taxrate = material.getDynamicObject("taxrate");
        if (!ObjectUtils.isEmpty((Object)taxrate)) {
            row.setTaxRatePk(((Long)taxrate.getPkValue()).longValue());
        }
        return row;
    }

    protected void calculatorEntryAmt(IDataModel m, boolean includeTax, boolean ispricetotal, String quotation, BigDecimal rate, int precision, int localprecision, int index) {
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        BigDecimal discountAmt = (BigDecimal)m.getValue("e_discountamount", index);
        TaxUnitPriceCalculator calculator = null;
        if (includeTax && !ispricetotal) {
            BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
            calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else if (!includeTax && !ispricetotal) {
            BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else if (!includeTax && ispricetotal) {
            BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else if (includeTax && ispricetotal) {
            BigDecimal recamount = (BigDecimal)m.getValue("e_recamount", index);
            calculator = new PriceTaxTotalCalculator(qty, recamount, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, rate, localprecision, quotation);
        localCalculator.calculate();
        this.resetEntryProp(m, localCalculator, index);
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
        m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("e_actunitprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice(), index);
        BigDecimal amount = localCalculator.getAmount();
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("e_taxlocalamt", (Object)localCalculator.getTaxlocal(), index);
        m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
        m.setValue("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_localamt", (Object)localCalculator.getAmountlocal(), index);
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        m.setValue("e_recamount", (Object)recamount, index);
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        m.setValue("e_reclocalamt", (Object)reclocalamt, index);
        m.setValue("e_uninvoicedamt", (Object)recamount, index);
        m.setValue("e_uninvoicedlocamt", (Object)reclocalamt, index);
        m.setValue("e_unconfirmamt", (Object)amount, index);
        BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", index);
        m.setValue("e_uninvoicedqty", (Object)quantity, index);
        m.setValue("e_unconfirmqty", (Object)quantity, index);
        m.setValue("e_unwoffqty", (Object)quantity, index);
        m.setValue("e_unwoffamt", (Object)recamount, index);
        m.setValue("e_unwofflocamt", (Object)reclocalamt, index);
        m.setValue("e_unwoffnotaxamt", (Object)amount, index);
        m.setValue("e_unwoffnotaxlocamt", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_unwofftax", (Object)localCalculator.getTax(), index);
        m.setValue("e_unwofftaxlocal", (Object)localCalculator.getTaxlocal(), index);
        m.setValue("e_uninvnotaxamt", (Object)amount, index);
        m.setValue("e_uninvnotaxlocalamt", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_unrelateinvqty", (Object)quantity, index);
        m.setValue("e_unrelateinvamt", (Object)recamount, index);
        m.setValue("e_unrelateinvlocamt", (Object)reclocalamt, index);
    }

    protected int getLocalPrecision() {
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        return localPrecision;
    }

    private BigDecimal getConvertRate(Long materialId, Long srcUnitId, Long desUnitId) {
        String key = materialId + "_" + srcUnitId + "_" + desUnitId;
        BigDecimal value = this.convertRateMap.get(key);
        if (value != null) {
            return value;
        }
        BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        this.convertRateMap.put(key, unitRateConv);
        return unitRateConv;
    }

    private void checkPriceandAmount(boolean ispresent, boolean includetax, boolean ispricetotal, Map entry, int index) {
        if (!ispresent) {
            if (includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("e_taxunitprice"), ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"BusArBillImportHelper_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("e_unitprice"), ResManager.loadKDString((String)"\u5355\u4ef7", (String)"BusArBillImportHelper_3", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_amount"), ResManager.loadKDString((String)"\u91d1\u989d", (String)"BusArBillImportHelper_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            } else if (includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_recamount"), ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"BusArBillImportHelper_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            }
        }
    }

    private void checkEntryNull(Object value, String title, int index) {
        if (!this.isNull(value)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%1$s\u884c\uff0c\u8bf7\u8865\u5145\u201c%2$s\u201d\u3002", (String)"BusArBillImportHelper_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), index, title));
        }
    }

    private boolean isNull(Object value) {
        boolean notNull = false;
        if (!ObjectUtils.isEmpty((Object)value)) {
            if (value instanceof Map) {
                Map vData = (Map)value;
                String importprop = (String)vData.get("importprop");
                if (StringUtils.isNotEmpty((String)importprop) && StringUtils.isNotEmpty((String)((String)vData.get(importprop)))) {
                    notNull = true;
                } else {
                    String vNum = (String)vData.get("number");
                    String vName = (String)vData.get("name");
                    if (!StringUtils.isEmpty((String)vNum) || !StringUtils.isEmpty((String)vName)) {
                        notNull = true;
                    }
                }
            }
            if (value instanceof String) {
                notNull = true;
            }
            if (value instanceof BigDecimal) {
                notNull = true;
            }
            if (value instanceof Double) {
                notNull = true;
            }
            if (value instanceof Integer) {
                notNull = true;
            }
        }
        return notNull;
    }

    private void checkCoreBillEntrySeq(Map entry, int index) {
        if (EmptyUtils.isNotEmpty(entry.get("e_corebillentryseq"))) {
            String coreBillEntrySeq = String.valueOf(entry.get("e_corebillentryseq"));
            if (coreBillEntrySeq.contains(".")) {
                int end = coreBillEntrySeq.length();
                if ((coreBillEntrySeq = coreBillEntrySeq.substring(coreBillEntrySeq.lastIndexOf(46) + 1, end)) != null && Integer.parseInt(coreBillEntrySeq) != 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$d\u884c\uff0c\u6570\u503c\u5b57\u6bb5\u6838\u5fc3\u5355\u636e\u884c\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a%2$s\uff0c\u8bf7\u4fee\u6539", (String)"BusArBillImportHelper_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1, entry.get("e_corebillentryseq")));
                }
            }
            if (Integer.parseInt(coreBillEntrySeq = String.valueOf(entry.get("e_corebillentryseq"))) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%d\u884c\uff0c\u201c\u6838\u5fc3\u5355\u636e\u884c\u53f7\u201d\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusArBillImportHelper_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1));
            }
        }
    }

    private void checkDiscountMode(Boolean includetax, Map entry, int index) {
        boolean ispresent;
        boolean bl = ispresent = entry.get("e_ispresent") != null ? (Boolean)entry.get("e_ispresent") : false;
        if (ispresent) {
            return;
        }
        String discountMode = (String)entry.get("e_discountmode");
        BigDecimal discountRate = BusArBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_discountrate");
        if (discountMode != null && discountRate != null) {
            if ("PERCENT".equals(discountMode) && (discountRate.compareTo(BigDecimal.ZERO) < 0 || discountRate.compareTo(new BigDecimal(100)) > 0)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%d\u884c\uff0c\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387\u201d\uff0c\u6298\u6263\u7387\u8303\u56f4\u4e3a0\u81f3100\u3002", (String)"BusArBillImportHelper_9", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1));
            }
            if ("PERUNIT".equals(discountMode)) {
                if (includetax.booleanValue() && (discountRate.compareTo(BigDecimal.ZERO) < 0 || discountRate.compareTo(BusArBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_taxunitprice")) > 0)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u4e3a\u662f\u65f6\uff0c\u987b\u7b26\u5408\u89c4\u5219\uff1a0\u2264\u5355\u4f4d\u6298\u6263\u989d\u2264\u542b\u7a0e\u5355\u4ef7\u3002", (String)"BusArBillImportHelper_10", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]));
                }
                if (!(includetax.booleanValue() || discountRate.compareTo(BigDecimal.ZERO) >= 0 && discountRate.compareTo(BusArBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_unitprice")) <= 0)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u4e3a\u5426\u65f6\uff0c\u987b\u7b26\u5408\u89c4\u5219\uff1a0\u2264\u5355\u4f4d\u6298\u6263\u989d\u2264\u5355\u4ef7\u3002", (String)"BusArBillImportHelper_11", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
        }
    }

    private void createByInit(Map sourceData) {
        Date bizDate;
        Date currentDate;
        DynamicObject headOrg = this.model.getDataEntity().getDynamicObject("org");
        boolean isBankOrg = headOrg.getBoolean("fisbankroll");
        if (isBankOrg && EmptyUtils.isEmpty(sourceData.get("recorg"))) {
            this.model.setValue("recorg", (Object)headOrg.getLong("id"));
        }
        DynamicObject currency = this.init.getStandardCurrency();
        this.model.setValue("basecurrency", currency.getPkValue());
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exchangerate"))) {
            this.model.setValue("exchangerate", (Object)1);
        }
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        FormServiceHelper.checkMeasureUnitRange((IDataModel)this.model, (String)"entry", (String)"e_material", (String)"e_measureunit");
        DynamicObject srcCurrency = (DynamicObject)this.model.getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)srcCurrency) && !ObjectUtils.isEmpty((Object)destCurrency) && srcCurrency.getPkValue().equals(destCurrency.getPkValue())) {
            this.model.setValue("exchangerate", (Object)BigDecimal.ONE);
            this.model.setValue("quotation", (Object)"0");
        } else {
            this.getQuotationHelper().getExchangeRate4Import(this.model);
        }
        if (!"true".equals(this.pageCache.get("isWebApi")) && (currentDate = ObjectUtils.isEmpty((Object)this.init.getCurrentDate()) ? this.init.getStartDate() : this.init.getCurrentDate()).after(bizDate = (Date)this.model.getValue("bizdate"))) {
            this.model.setValue("bizdate", (Object)currentDate);
            if (ObjectUtils.isEmpty((Object)"duedate")) {
                this.model.setValue("duedate", (Object)currentDate);
            }
        }
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(21);
        headFields.add("recamount");
        headFields.add("reclocalamt");
        headFields.add("amount");
        headFields.add("localamt");
        headFields.add("tax");
        headFields.add("taxlocamt");
        headFields.add("uninvoicedamt");
        headFields.add("uninvoicedlocamt");
        headFields.add("invoicedamt");
        headFields.add("invoicedlocamt");
        headFields.add("invamt");
        headFields.add("invlocamt");
        headFields.add("unwoffamt");
        headFields.add("unwofflocamt");
        headFields.add("unwoffnotaxamt");
        headFields.add("unwoffnotaxlocamt");
        headFields.add("unwofftax");
        headFields.add("unwofftaxlocal");
        headFields.add("unrelateinvamt");
        headFields.add("unrelateinvlocamt");
        headFields.add("relateinvamt");
        headFields.add("relateinvlocamt");
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(30);
        entryFields.add("e_actunitprice");
        entryFields.add("e_acttaxunitprice");
        entryFields.add("e_invoicedamt");
        entryFields.add("e_uninvoicedamt");
        entryFields.add("e_unconfirmamt");
        entryFields.add("e_invoicedqty");
        entryFields.add("e_uninvoicedqty");
        entryFields.add("e_invnotaxamt");
        entryFields.add("e_unconfirmqty");
        entryFields.add("e_relateinvlocamt");
        entryFields.add("e_unrelateinvlocamt");
        entryFields.add("e_invnotaxlocamt");
        entryFields.add("e_invoicedloctax");
        entryFields.add("e_invlocamt");
        entryFields.add("e_unwoffqty");
        entryFields.add("e_unwoffamt");
        entryFields.add("e_unwofflocamt");
        entryFields.add("e_unwoffnotaxamt");
        entryFields.add("e_unwoffnotaxlocamt");
        entryFields.add("e_unwofftax");
        entryFields.add("e_unwofftaxlocal");
        entryFields.add("e_invoicednotaxamt");
        entryFields.add("e_invnotaxlocalamt");
        entryFields.add("e_uninvnotaxamt");
        entryFields.add("e_uninvnotaxlocalamt");
        entryFields.add("e_uninvoicedlocamt");
        entryFields.add("e_unrelateinvqty");
        entryFields.add("e_relateinvqty");
        entryFields.add("e_unrelateinvamt");
        entryFields.add("e_relateinvamt");
        entryFields.add("subentryentity");
        return entryFields;
    }

    private final List<String> headRemoveUpFields() {
        ArrayList<String> headUpdFields = new ArrayList<String>(24);
        headUpdFields.add("org");
        headUpdFields.add("billtype");
        headUpdFields.add("asstacttype");
        headUpdFields.add("asstact");
        headUpdFields.add("isadjust");
        headUpdFields.add("writeoffbusiness");
        headUpdFields.add("isvoucher");
        headUpdFields.add("isintertax");
        headUpdFields.add("imageno");
        headUpdFields.add("isarchive");
        headUpdFields.add("currency");
        headUpdFields.add("recamount");
        headUpdFields.add("reclocalamt");
        headUpdFields.add("amount");
        headUpdFields.add("localamt");
        headUpdFields.add("tax");
        headUpdFields.add("taxlocamt");
        headUpdFields.add("unwoffamt");
        headUpdFields.add("unwofflocamt");
        headUpdFields.add("invoicedamt");
        headUpdFields.add("invoicedlocamt");
        headUpdFields.add("uninvoicedamt");
        headUpdFields.add("uninvoicedlocamt");
        headUpdFields.add("billstatus");
        headUpdFields.addAll(this.headFields);
        return headUpdFields;
    }

    private final List<String> entryRemoveUpFields() {
        ArrayList<String> entryUpdFields = new ArrayList<String>(24);
        entryUpdFields.add("e_material");
        entryUpdFields.add("e_measureunit");
        entryUpdFields.add("e_expenseitem");
        entryUpdFields.add("e_corebilltype");
        entryUpdFields.add("e_corebillno");
        entryUpdFields.add("e_corebillentryseq");
        entryUpdFields.add("e_localamt");
        entryUpdFields.add("e_reclocalamt");
        entryUpdFields.add("e_tax");
        entryUpdFields.add("e_taxlocalamt");
        entryUpdFields.add("e_uninvoicedamt");
        entryUpdFields.add("e_uninvoicedlocamt");
        entryUpdFields.add("e_invoicedamt");
        entryUpdFields.add("e_invoicedlocamt");
        entryUpdFields.add("e_invoicedqty");
        entryUpdFields.add("e_uninvoicedqty");
        entryUpdFields.add("e_unwoffamt");
        entryUpdFields.add("e_unwofflocamt");
        entryUpdFields.add("e_unwoffqty");
        entryUpdFields.add("e_confirmedamt");
        entryUpdFields.add("e_unconfirmamt");
        entryUpdFields.add("e_iswriteoff");
        entryUpdFields.addAll(this.entryFields);
        return entryUpdFields;
    }
}

