/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice.fin;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.business.price.FxCalculator;
import kd.fi.arapcommon.business.price.FxLocalCalculator;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.model.FinArBillModel;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class FinArBillAmtCalculateHandler {
    private final IFormView view;
    private final IBillModel model;
    private final FinArBillModel billModel;

    public FinArBillAmtCalculateHandler(IFormView view) {
        this.view = view;
        this.model = (IBillModel)view.getModel();
        this.billModel = (FinArBillModel)BillModelFactory.getModel((String)"ar_finarbill");
    }

    public void calculateAllAmtByDetailEntry(int entryIndex, String changeKey, Object oldValue) {
        this.calculateAllAmtByDetailEntry(entryIndex, changeKey, oldValue, false);
    }

    public void calculateAllAmtByDetailEntryPresent(int entryIndex, String changeKey, Object oldValue) {
        PriceLocalCalculator calculator = this.buildCalculator(entryIndex, true);
        this.calculateAllAmtByDetailEntryCalculator(entryIndex, changeKey, oldValue, false, calculator);
    }

    public void calculateAllAmtByDetailEntry(int entryIndex, String changeKey, Object oldValue, boolean isCopyEntryRow) {
        PriceLocalCalculator calculator = this.buildCalculator(entryIndex, false);
        this.calculateAllAmtByDetailEntryCalculator(entryIndex, changeKey, oldValue, isCopyEntryRow, calculator);
    }

    private void calculateAllAmtByDetailEntryCalculator(int entryIndex, String changeKey, Object oldValue, boolean isCopyEntryRow, PriceLocalCalculator calculator) {
        BigDecimal oldEntryAdjustAmountLocal;
        BigDecimal oldEntryTax = isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)this.model.getValue("e_tax", entryIndex);
        BigDecimal oldEntryTaxLocal = isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)this.model.getValue("e_taxlocalamt", entryIndex);
        BigDecimal oldEntryAmount = isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)this.model.getValue("e_amount", entryIndex);
        BigDecimal oldEntryAmountLocal = isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)this.model.getValue("e_localamt", entryIndex);
        BigDecimal oldEntryPriceTaxTotal = isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)this.model.getValue("e_recamount", entryIndex);
        BigDecimal oldEntryPriceTaxTotalLocal = isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)this.model.getValue("e_reclocalamt", entryIndex);
        BigDecimal oldEntryAdjustAmount = isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)this.model.getValue("e_adjustamount", entryIndex);
        BigDecimal bigDecimal = oldEntryAdjustAmountLocal = isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)this.model.getValue("e_adjustlocalamt", entryIndex);
        if ("e_amount".equals(changeKey)) {
            oldEntryAmount = (BigDecimal)oldValue;
        }
        if ("e_recamount".equals(changeKey)) {
            oldEntryPriceTaxTotal = (BigDecimal)oldValue;
        }
        this.setDetailEntryValue(calculator, entryIndex);
        this.model.setValue("tax", (Object)((BigDecimal)this.model.getValue("tax")).subtract(oldEntryTax).add(calculator.getTax()));
        this.model.setValue("taxlocamt", (Object)((BigDecimal)this.model.getValue("taxlocamt")).subtract(oldEntryTaxLocal).add(calculator.getTaxlocal()));
        BigDecimal amount = ((BigDecimal)this.model.getValue("amount")).subtract(oldEntryAmount).add(calculator.getAmount());
        this.model.setValue("amount", (Object)amount);
        this.model.setValue("unverifyamount", (Object)amount);
        this.model.setValue("localamt", (Object)((BigDecimal)this.model.getValue("localamt")).subtract(oldEntryAmountLocal).add(calculator.getAmountlocal()));
        BigDecimal priceTaxTotal = ((BigDecimal)this.model.getValue("recamount")).subtract(oldEntryPriceTaxTotal).add(calculator.getPricetaxtotal());
        this.model.setValue("unsettleamount", (Object)priceTaxTotal);
        this.model.setValue("uninvoicedamt", (Object)priceTaxTotal);
        BigDecimal priceTaxTotalLocal = ((BigDecimal)this.model.getValue("reclocalamt")).subtract(oldEntryPriceTaxTotalLocal).add(calculator.getPricetaxtotallocal());
        this.model.setValue("uninvoicedlocalamt", (Object)priceTaxTotalLocal);
        this.model.setValue("reclocalamt", (Object)priceTaxTotalLocal);
        this.model.setValue("unsettlelocalamt", (Object)priceTaxTotalLocal);
        this.model.setValue("adjustamount", (Object)((BigDecimal)this.model.getValue("adjustamount")).subtract(oldEntryAdjustAmount).add(calculator.getAdjustamt()));
        this.model.setValue("adjustlocalamt", (Object)((BigDecimal)this.model.getValue("adjustlocalamt")).subtract(oldEntryAdjustAmountLocal).add(calculator.getAdjustamtlocal()));
        this.model.setValue("recamount", (Object)priceTaxTotal);
    }

    public void calculateAllAmtByHead() {
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotallocal = BigDecimal.ZERO;
        BigDecimal adjustamountTotal = BigDecimal.ZERO;
        BigDecimal adjustlocalamtTotal = BigDecimal.ZERO;
        int entryRowCount = this.model.getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            boolean isPresent = (Boolean)this.model.getValue("e_ispresent", i);
            PriceLocalCalculator calculator = this.buildCalculator(i, isPresent);
            this.setDetailEntryValue(calculator, i);
            tax = tax.add(calculator.getTax());
            taxLocAmt = taxLocAmt.add(calculator.getTaxlocal());
            amount = amount.add(calculator.getAmount());
            localAmt = localAmt.add(calculator.getAmountlocal());
            priceTaxTotal = priceTaxTotal.add(calculator.getPricetaxtotal());
            priceTaxTotallocal = priceTaxTotallocal.add(calculator.getPricetaxtotallocal());
            adjustamountTotal = adjustamountTotal.add(calculator.getAdjustamt());
            adjustlocalamtTotal = adjustlocalamtTotal.add(calculator.getAdjustamtlocal());
        }
        this.model.setValue("tax", (Object)tax);
        this.model.setValue("taxlocamt", (Object)taxLocAmt);
        this.model.setValue("amount", (Object)amount);
        this.model.setValue("unverifyamount", (Object)amount);
        this.model.setValue("localamt", (Object)localAmt);
        this.model.setValue("unsettleamount", (Object)priceTaxTotal);
        this.model.setValue("uninvoicedamt", (Object)priceTaxTotal);
        this.model.setValue("uninvoicedlocalamt", (Object)priceTaxTotallocal);
        this.model.setValue("reclocalamt", (Object)priceTaxTotallocal);
        this.model.setValue("unsettlelocalamt", (Object)priceTaxTotallocal);
        this.model.setValue("adjustamount", (Object)adjustamountTotal);
        this.model.setValue("adjustlocalamt", (Object)adjustlocalamtTotal);
        this.model.setValue("recamount", (Object)priceTaxTotal);
    }

    public void ifFxCalculate(int detailIndex, String key, BigDecimal oldValue, BeforeFieldPostBackEvent e) {
        this.ifFxCalculate(detailIndex, key, oldValue, e, false);
    }

    public void ifFxCalculate(int detailIndex, String key, BigDecimal oldValue, BeforeFieldPostBackEvent e, boolean isCopyEntryRow) {
        if (EmptyUtils.isEmpty((Object)oldValue)) {
            oldValue = BigDecimal.ZERO;
        }
        boolean flag = e != null && EmptyUtils.isNotEmpty((Object)e.getValue());
        BigDecimal e_tax = flag && "e_tax".equals(key) ? new BigDecimal(e.getValue().toString()) : (BigDecimal)this.model.getValue("e_tax", detailIndex);
        BigDecimal e_amount = flag && "e_amount".equals(key) ? new BigDecimal(e.getValue().toString()) : (BigDecimal)this.model.getValue("e_amount", detailIndex);
        BigDecimal e_priceTaxTotal = flag && "e_recamount".equals(key) ? new BigDecimal(e.getValue().toString()) : (BigDecimal)this.model.getValue("e_recamount", detailIndex);
        BigDecimal e_adjustamount = (BigDecimal)this.model.getValue("e_adjustamount", detailIndex);
        BigDecimal oldEntryTax = "e_tax".equals(key) ? oldValue : e_tax;
        BigDecimal oldEntryTaxLocal = isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)this.model.getValue("e_taxlocalamt", detailIndex);
        BigDecimal oldEntryAmount = "e_amount".equals(key) ? oldValue : e_amount;
        BigDecimal oldEntryPriceTaxTotal = "e_recamount".equals(key) ? oldValue : e_priceTaxTotal;
        BigDecimal oldEntryAdjustamount = "e_adjustamount".equals(key) ? oldValue : e_adjustamount;
        BigDecimal oldEntryAmountLocal = (BigDecimal)this.model.getValue("e_localamt", detailIndex);
        BigDecimal oldEntryPriceTaxTotalLocal = (BigDecimal)this.model.getValue("e_reclocalamt", detailIndex);
        BigDecimal oldEntryAdjustlocalamt = (BigDecimal)this.model.getValue("e_adjustlocalamt");
        BigDecimal exchangeRate = (BigDecimal)this.model.getValue("exchangerate");
        int localCurrencyPrecison = 2;
        DynamicObject baseCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localCurrencyPrecison = baseCurrency.getInt("amtprecision");
        }
        String billTypeNo = ((DynamicObject)this.model.getValue("billtype")).getString("number");
        String srcBillType = (String)this.model.getValue("sourcebilltype");
        FxCalculator fxCalculator = "arfin_borrowar_BT_S".equals(billTypeNo) && EmptyUtils.isNotEmpty((Object)srcBillType) ? new FxCalculator(e_tax, e_amount, e_priceTaxTotal, e_adjustamount, ((Boolean)this.model.getValue("isfx")).booleanValue(), ((Boolean)this.model.getValue("isfxpricetaxtotal")).booleanValue(), false, false, false, true) : new FxCalculator(e_tax, e_amount, e_priceTaxTotal, e_adjustamount, ((Boolean)this.model.getValue("isfx")).booleanValue(), ((Boolean)this.model.getValue("isfxpricetaxtotal")).booleanValue(), "e_tax".equals(key), "e_amount".equals(key), "e_recamount".equals(key), "e_adjustamount".equals(key));
        String quotation = (String)this.model.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        FXPriceLocalCalculator calculator = new FXPriceLocalCalculator(fxCalculator, exchangeRate, localCurrencyPrecison, quotation);
        calculator.calculate();
        if (!("arfin_borrowar_BT_S".equals(billTypeNo) && EmptyUtils.isNotEmpty((Object)srcBillType) || this.checkAmountRange(calculator, detailIndex))) {
            if (EmptyUtils.isNotEmpty((Object)e)) {
                e.setCancel(true);
            }
            this.view.updateView(key, detailIndex);
            this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff08\u7f16\u53f7\uff1a%1$s\uff09\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u8c03\u6574\u91d1\u989d\u8d85\u51fa\u5fae\u8c03\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u8c03\u6574\u91d1\u989d\u6216\u524d\u5f80\u201c\u7cfb\u7edf\u53c2\u6570>\u5e94\u6536\u201d\u8bbe\u7f6e\u201c\u5fae\u8c03\u5bb9\u5dee\u8303\u56f4\u201d\u3002", (String)"FinArBillEdit_20", (String)"fi-ar-formplugin", (Object[])new Object[0]), this.model.getValue("billno"), detailIndex + 1));
            return;
        }
        this.model.beginInit();
        this.model.setValue("e_tax", (Object)calculator.getTax(), detailIndex);
        this.model.setValue("e_taxlocalamt", (Object)calculator.getTaxLocal(), detailIndex);
        this.model.endInit();
        this.view.updateView("e_tax", detailIndex);
        this.view.updateView("e_taxlocalamt", detailIndex);
        this.model.setValue("e_adjustlocalamt", (Object)calculator.getAdjustamtlocal(), detailIndex);
        this.assigendEntryAmount(detailIndex, calculator.getAmount(), calculator.getAmountLocal(), calculator.getPricetaxtotal(), calculator.getPriceTaxTotalLocal());
        BigDecimal newEntryTax = (BigDecimal)this.model.getValue("e_tax", detailIndex);
        BigDecimal newEntryTaxLoc = (BigDecimal)this.model.getValue("e_taxlocalamt", detailIndex);
        BigDecimal newEntryAmount = (BigDecimal)this.model.getValue("e_amount", detailIndex);
        BigDecimal totalTax = ((BigDecimal)this.model.getValue("tax")).subtract(oldEntryTax).add(newEntryTax);
        this.model.setValue("tax", (Object)totalTax);
        BigDecimal taxLocAmt = ((BigDecimal)this.model.getValue("taxlocamt")).subtract(oldEntryTaxLocal).add(newEntryTaxLoc);
        this.model.setValue("taxlocamt", (Object)taxLocAmt);
        BigDecimal totalAmount = ((BigDecimal)this.model.getValue("amount")).subtract(oldEntryAmount).add(newEntryAmount);
        this.model.setValue("amount", (Object)totalAmount);
        this.model.setValue("unverifyamount", (Object)totalAmount);
        this.model.setValue("localamt", (Object)((BigDecimal)this.model.getValue("localamt")).subtract(oldEntryAmountLocal).add(calculator.getAmountLocal()));
        BigDecimal priceTaxTotal = ((BigDecimal)this.model.getValue("recamount")).subtract(oldEntryPriceTaxTotal).add(calculator.getPricetaxtotal());
        this.model.setValue("unsettleamount", (Object)priceTaxTotal);
        BigDecimal priceTaxTotalLocal = ((BigDecimal)this.model.getValue("reclocalamt")).subtract(oldEntryPriceTaxTotalLocal).add(calculator.getPriceTaxTotalLocal());
        if (!"ar_invoice".equals(this.model.getValue("sourcebilltype"))) {
            this.model.setValue("uninvoicedamt", (Object)priceTaxTotal);
            this.model.setValue("uninvoicedlocalamt", (Object)priceTaxTotalLocal);
        } else {
            this.model.setValue("invoicedamt", (Object)priceTaxTotal);
        }
        this.model.setValue("reclocalamt", (Object)priceTaxTotalLocal);
        this.model.setValue("unsettlelocalamt", (Object)priceTaxTotalLocal);
        this.model.setValue("adjustamount", (Object)((BigDecimal)this.model.getValue("adjustamount")).subtract(oldEntryAdjustamount).add(calculator.getAdjustamt()));
        this.model.setValue("adjustlocalamt", (Object)((BigDecimal)this.model.getValue("adjustlocalamt")).subtract(oldEntryAdjustlocalamt).add(calculator.getAdjustamtlocal()));
        this.model.setValue("recamount", (Object)priceTaxTotal);
    }

    public void ifFxLocalCalculate(int detailIndex, String key, BigDecimal newValue) {
        boolean inputTax = this.billModel.E_TAXLOCALAMT.equals(key);
        boolean inputAmount = this.billModel.E_LOCALAMT.equals(key);
        boolean inputPriceTax = this.billModel.E_PRICETAXTOTALLOC.equals(key);
        BigDecimal entryTaxLocal = inputTax ? newValue : (BigDecimal)this.model.getValue(this.billModel.E_TAXLOCALAMT, detailIndex);
        BigDecimal entryAmountLocal = inputAmount ? newValue : (BigDecimal)this.model.getValue(this.billModel.E_LOCALAMT, detailIndex);
        BigDecimal entryPriceTaxLocal = inputPriceTax ? newValue : (BigDecimal)this.model.getValue(this.billModel.E_PRICETAXTOTALLOC, detailIndex);
        BigDecimal entryAdjustlocalamt = (BigDecimal)this.model.getValue(this.billModel.E_ADJUSTLOCALAMT, detailIndex);
        boolean isFX = (Boolean)this.model.getValue(this.billModel.HEAD_ISFX);
        boolean isFXLocal = (Boolean)this.model.getValue(this.billModel.HEAD_ISFXLOCAL);
        boolean isFXPriceTaxTotal = (Boolean)this.model.getValue(this.billModel.HEAD_ISFXPRICETAXTOTAL);
        FxLocalCalculator calculator = new FxLocalCalculator(entryTaxLocal, entryAmountLocal, entryPriceTaxLocal, entryAdjustlocalamt, isFX, isFXPriceTaxTotal, isFXLocal, inputTax, inputAmount);
        calculator.calculate();
        this.model.beginInit();
        this.model.setValue(this.billModel.E_TAXLOCALAMT, (Object)calculator.getTaxLocal(), detailIndex);
        this.model.setValue(this.billModel.E_LOCALAMT, (Object)calculator.getAmountLocal(), detailIndex);
        this.model.setValue(this.billModel.E_PRICETAXTOTALLOC, (Object)calculator.getPriceTaxTotalLocal(), detailIndex);
        this.model.setValue(this.billModel.E_UNSETTLELOCALAMT, (Object)calculator.getPriceTaxTotalLocal().subtract((BigDecimal)this.model.getValue(this.billModel.E_SETTLEDLOCALAMT)), detailIndex);
        this.model.setValue(this.billModel.E_UNINVOICEDLOCAMT, (Object)calculator.getPriceTaxTotalLocal().subtract((BigDecimal)this.model.getValue(this.billModel.E_INVOICEDLOCAMT)), detailIndex);
        this.model.endInit();
    }

    public void ifFxLocalCalculateToSpecialType(int detailIndex, String key, BigDecimal newValue) {
        boolean inputTax = this.billModel.E_TAXLOCALAMT.equals(key);
        boolean inputAmount = this.billModel.E_LOCALAMT.equals(key);
        BigDecimal entryTaxLocal = inputTax ? newValue : (BigDecimal)this.model.getValue(this.billModel.E_TAXLOCALAMT, detailIndex);
        BigDecimal entryAmountLocal = inputAmount ? newValue : (BigDecimal)this.model.getValue(this.billModel.E_LOCALAMT, detailIndex);
        BigDecimal entryAdjustlocalamt = (BigDecimal)this.model.getValue(this.billModel.E_ADJUSTLOCALAMT, detailIndex);
        this.model.beginInit();
        this.model.setValue(this.billModel.E_TAXLOCALAMT, (Object)entryTaxLocal, detailIndex);
        this.model.setValue(this.billModel.E_LOCALAMT, (Object)entryAmountLocal, detailIndex);
        BigDecimal priceTaxLocal = entryAmountLocal.add(entryTaxLocal).add(entryAdjustlocalamt);
        this.model.setValue(this.billModel.E_PRICETAXTOTALLOC, (Object)priceTaxLocal, detailIndex);
        this.model.setValue(this.billModel.E_UNSETTLELOCALAMT, (Object)priceTaxLocal.subtract((BigDecimal)this.model.getValue(this.billModel.E_SETTLEDLOCALAMT)), detailIndex);
        this.model.setValue(this.billModel.E_UNINVOICEDLOCAMT, (Object)priceTaxLocal.subtract((BigDecimal)this.model.getValue(this.billModel.E_INVOICEDLOCAMT)), detailIndex);
        this.model.endInit();
    }

    public void updateHeadValue(int detailIndex, Map<String, BigDecimal> amountMap) {
        BigDecimal oldEntryTaxLocal = amountMap.get("oldTaxLocal");
        BigDecimal oldEntryAmountLocal = amountMap.get("oldAmountLocal");
        BigDecimal oldEntryPriceTaxLocal = amountMap.get("oldPriceTaxLocal");
        BigDecimal oldUnSettleAmountLocal = amountMap.get("oldUnSettleAmountLocal");
        BigDecimal oldUnInvoiceAmountLocal = amountMap.get("oldUnInvoiceAmountLocal");
        BigDecimal newEntryTaxLocal = (BigDecimal)this.model.getValue(this.billModel.E_TAXLOCALAMT, detailIndex);
        BigDecimal newEntryAmountLocal = (BigDecimal)this.model.getValue(this.billModel.E_LOCALAMT, detailIndex);
        BigDecimal newEntryPriceTaxLocal = (BigDecimal)this.model.getValue(this.billModel.E_PRICETAXTOTALLOC, detailIndex);
        BigDecimal newEntryUnSettleAmountLocal = (BigDecimal)this.model.getValue(this.billModel.E_UNSETTLELOCALAMT, detailIndex);
        BigDecimal newEntryUnInvoiceAmountLocal = (BigDecimal)this.model.getValue(this.billModel.E_UNINVOICEDLOCAMT, detailIndex);
        BigDecimal totalTaxLocal = ((BigDecimal)this.model.getValue(this.billModel.HEAD_TAXLOCAMT)).subtract(oldEntryTaxLocal).add(newEntryTaxLocal);
        BigDecimal totalAmountLocal = ((BigDecimal)this.model.getValue(this.billModel.HEAD_LOCALAMT)).subtract(oldEntryAmountLocal).add(newEntryAmountLocal);
        BigDecimal totalPriceTaxLocal = ((BigDecimal)this.model.getValue(this.billModel.HEAD_PRICETAXTOTALLOC)).subtract(oldEntryPriceTaxLocal).add(newEntryPriceTaxLocal);
        BigDecimal totalUnSettleAmountLocal = ((BigDecimal)this.model.getValue(this.billModel.HEAD_UNSETTLELOCALAMT)).subtract(oldUnSettleAmountLocal).add(newEntryUnSettleAmountLocal);
        BigDecimal totalUnInvoiceAmountLocal = ((BigDecimal)this.model.getValue(this.billModel.HEAD_UNINVOICEDLOCALAMT)).subtract(oldUnInvoiceAmountLocal).add(newEntryUnInvoiceAmountLocal);
        this.model.setValue(this.billModel.HEAD_TAXLOCAMT, (Object)totalTaxLocal);
        this.model.setValue(this.billModel.HEAD_LOCALAMT, (Object)totalAmountLocal);
        this.model.setValue(this.billModel.HEAD_PRICETAXTOTALLOC, (Object)totalPriceTaxLocal);
        this.model.setValue(this.billModel.HEAD_UNSETTLELOCALAMT, (Object)totalUnSettleAmountLocal);
        this.model.setValue(this.billModel.HEAD_UNINVOICEDLOCALAMT, (Object)totalUnInvoiceAmountLocal);
    }

    private PriceLocalCalculator buildCalculator(int detailIndex, boolean isPresent) {
        TaxUnitPriceCalculator calculator;
        isPresent = !isPresent ? (Boolean)this.model.getValue("e_ispresent", detailIndex) : isPresent;
        boolean includeTax = (Boolean)this.model.getValue("isincludetax");
        boolean isPriceTotal = (Boolean)this.model.getValue("ispricetotal");
        BigDecimal qty = (BigDecimal)this.model.getValue("e_quantity", detailIndex);
        BigDecimal taxRate = (BigDecimal)this.model.getValue("e_taxrate", detailIndex);
        String discountMode = (String)this.model.getValue("e_discountmode", detailIndex);
        BigDecimal discountRate = (BigDecimal)this.model.getValue("e_discountrate", detailIndex);
        BigDecimal exchangeRate = (BigDecimal)this.model.getValue("exchangerate");
        BigDecimal discountAmt = (BigDecimal)this.model.getValue("e_discountamount", detailIndex);
        boolean existProperty = EntityMetadataUtils.isExistProperty((DynamicObject)this.model.getDataEntity(), (String)"adjustamount");
        BigDecimal adjustamount = BigDecimal.ZERO;
        if (existProperty) {
            adjustamount = (BigDecimal)this.model.getValue("e_adjustamount", detailIndex);
        }
        int precision = 2;
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        if (includeTax) {
            if (isPriceTotal && !isPresent) {
                BigDecimal recamount = (BigDecimal)this.model.getValue("e_recamount", detailIndex);
                calculator = new PriceTaxTotalCalculator(qty, recamount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            } else {
                BigDecimal taxUnitPrice = (BigDecimal)this.model.getValue("e_taxunitprice", detailIndex);
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            }
        } else if (isPriceTotal && !isPresent) {
            BigDecimal amount = (BigDecimal)this.model.getValue("e_amount", detailIndex);
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        } else {
            BigDecimal unitPrice = (BigDecimal)this.model.getValue("e_unitprice", detailIndex);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        }
        String quotation = (String)this.model.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, localPrecision, quotation);
        localCalculator.calculate();
        return localCalculator;
    }

    private void setDetailEntryValue(PriceLocalCalculator calculator, int index) {
        this.model.beginInit();
        this.model.setValue("e_unitprice", (Object)calculator.getUnitprice(), index);
        this.model.setValue("e_taxunitprice", (Object)calculator.getTaxunitprice(), index);
        this.model.setValue("e_tax", (Object)calculator.getTax(), index);
        this.model.setValue("e_taxlocalamt", (Object)calculator.getTaxlocal(), index);
        this.model.setValue("e_discountamount", (Object)calculator.getDiscountamount(), index);
        this.model.endInit();
        this.view.updateView("e_unitprice", index);
        this.view.updateView("e_taxunitprice", index);
        this.view.updateView("e_tax", index);
        this.view.updateView("e_discountamount", index);
        this.view.updateView("e_taxlocalamt", index);
        this.model.setValue("e_actunitprice", (Object)calculator.getActunitprice(), index);
        this.model.setValue("e_acttaxunitprice", (Object)calculator.getActtaxunitprice(), index);
        this.model.setValue("e_discountlocalamt", (Object)calculator.getDiscountamountlocal(), index);
        boolean existProperty = EntityMetadataUtils.isExistProperty((DynamicObject)this.model.getDataEntity(), (String)"adjustamount");
        if (existProperty) {
            this.model.setValue("e_adjustlocalamt", (Object)calculator.getAdjustamtlocal(), index);
        }
        this.assigendEntryAmount(index, calculator.getAmount(), calculator.getAmountlocal(), calculator.getPricetaxtotal(), calculator.getPricetaxtotallocal());
    }

    private void assigendEntryAmount(int index, BigDecimal amount, BigDecimal amountlocal, BigDecimal pricetaxtotal, BigDecimal pricetaxtotallocal) {
        this.model.beginInit();
        this.model.setValue("e_amount", (Object)amount, index);
        this.model.setValue("e_recamount", (Object)pricetaxtotal, index);
        this.model.setValue("e_localamt", (Object)amountlocal, index);
        this.model.endInit();
        this.view.updateView("e_amount", index);
        this.view.updateView("e_recamount", index);
        this.view.updateView("e_localamt", index);
        this.model.setValue("e_unconfirmamt", (Object)amount.subtract((BigDecimal)this.model.getValue("e_confirmedamt", index)), index);
        this.model.setValue("e_uninvoicedamt", (Object)pricetaxtotal, index);
        this.model.setValue("e_reclocalamt", (Object)pricetaxtotallocal, index);
        this.model.setValue("e_unverifyamt", (Object)amount, index);
        this.model.setValue("e_unsettleamt", (Object)pricetaxtotal, index);
        this.model.setValue("e_unlockamt", (Object)pricetaxtotal, index);
        this.model.setValue("e_unsettlelocalamt", (Object)pricetaxtotallocal, index);
        if (!"ar_invoice".equals(this.model.getValue("sourcebilltype"))) {
            this.model.setValue("e_uninvoicedamt", (Object)pricetaxtotal, index);
            this.model.setValue("e_uninvoicedlocalamt", (Object)pricetaxtotallocal, index);
        } else {
            this.model.setValue("e_uninvoicedamt", (Object)BigDecimal.ZERO, index);
            this.model.setValue("e_uninvoicedlocalamt", (Object)BigDecimal.ZERO, index);
            this.model.setValue("e_invoicedamt", (Object)pricetaxtotal, index);
        }
    }

    private boolean checkAmountRange(FXPriceLocalCalculator fxCalculator, int index) {
        boolean result = true;
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        boolean isCheck = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"ar_022");
        if (!isCheck) {
            return result;
        }
        BigDecimal fxRange = (BigDecimal)kd.fi.arapcommon.helper.SystemParameterHelper.getARAppParameter((Long)org.getLong("id"), (String)"ar022_condition");
        if (fxRange == null) {
            fxRange = BigDecimal.ZERO;
        }
        PriceLocalCalculator priceCalculator = this.buildCalculator(index, false);
        BigDecimal fxTax = fxCalculator.getTax();
        BigDecimal tax = priceCalculator.getTax();
        BigDecimal taxRange = fxTax.subtract(tax).abs();
        BigDecimal fxAmount = fxCalculator.getAmount();
        BigDecimal amount = priceCalculator.getAmount();
        BigDecimal amtRange = fxAmount.subtract(amount).abs();
        BigDecimal fxPriceTaxTotal = fxCalculator.getPricetaxtotal();
        BigDecimal priceTaxTotal = priceCalculator.getPricetaxtotal();
        BigDecimal priceTaxTotalRange = fxPriceTaxTotal.subtract(priceTaxTotal).abs();
        if (fxRange.compareTo(taxRange) < 0 || fxRange.compareTo(amtRange) < 0 || fxRange.compareTo(priceTaxTotalRange) < 0) {
            result = false;
        }
        return result;
    }
}

