/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice.fin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ar.helper.FinarPremHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.helper.ViewsettleHelper;
import kd.fi.ar.helper.ViewverHelper;
import kd.fi.ar.helper.WriteoffVerify;
import kd.fi.ar.vo.CheckResult;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.form.AbstractBillEditHandler;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApLicenseServiceHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.EditInBulkService;
import kd.fi.arapcommon.service.writeoff.WriteOffHelper;
import kd.fi.arapcommon.util.StdConfig;

public class FinArBillClickHandler
extends AbstractBillEditHandler {
    public FinArBillClickHandler(AbstractBillPlugIn billPlugIn) {
        super(billPlugIn);
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "e_corebillno": {
                this.corebillShowF7();
                break;
            }
            case "settleinfo_view": {
                this.showSettleView(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{"settleinfoflex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"presettleinfoflex"});
                break;
            }
            case "presettleinfo_view": {
                this.showSettleView(true);
                this.getView().setVisible(Boolean.FALSE, new String[]{"presettleinfoflex"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"settleinfo_ignore"});
                break;
            }
            case "settleinfo_ignore": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"settleinfoflex"});
                break;
            }
            case "presettleinfo_ignore": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"settleinfoflex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"presettleinfoflex"});
                break;
            }
            case "sameinfo_view": {
                Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0071", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
                if (sameBillInfo != null && !sameBillInfo.isEmpty()) {
                    ArrayList sameBillNos = new ArrayList(sameBillInfo.values());
                    ListShowParameter parameter = new ListShowParameter();
                    parameter.setBillFormId("ar_finarbill");
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    QFilter qFilter = new QFilter("billno", "in", sameBillNos.get(0));
                    parameter.getListFilterParameter().setFilter(qFilter);
                    parameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
                    this.getView().showForm((FormShowParameter)parameter);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
                    break;
                }
            }
            case "sameinfo_ignore": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
            }
        }
    }

    private void showSettleView(boolean isPre) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        boolean hiddenManualSettle = "true".equals(StdConfig.get((String)"isHiddenManualSettle"));
        String entityName = hiddenManualSettle ? "ar_settleconsole" : "ar_handsettle";
        ArrayList<String> selectPks = new ArrayList<String>(100);
        selectPks.add(this.getModel().getValue("id").toString());
        FormShowParameter formShowParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        formShowParameter.setFormId(entityName);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(hiddenManualSettle ? ResManager.loadKDString((String)"\u5e94\u6536\u7ed3\u7b97\u5de5\u4f5c\u53f0", (String)"FinArBillClickHandler_11", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u624b\u5de5\u7ed3\u7b97", (String)"FinArBillClickHandler_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        customParams.put("finarbills", selectPks);
        customParams.put("submitsettle", SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"ar_016"));
        customParams.put("billstatus", this.getModel().getValue("billstatus"));
        if (isPre) {
            customParams.put("datascope", "prebill");
        }
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm(formShowParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        boolean includeTax;
        String key = evt.getItemKey();
        DynamicObject finArBill = this.getModel().getDataEntity();
        Object finPk = finArBill.getPkValue();
        if ("tblloss".equals(key)) {
            BigDecimal sumAmt = BigDecimal.ZERO;
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
            for (DynamicObject entry : entrys) {
                sumAmt = sumAmt.add(entry.getBigDecimal("e_unlockamt"));
            }
            if (sumAmt.compareTo(BigDecimal.ZERO) > 0) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("ar_baddebtconfirm");
                ArrayList<Object> pkList = new ArrayList<Object>(8);
                pkList.add(this.getModel().getDataEntity().getPkValue());
                parameter.getCustomParams().put("pks", pkList);
                this.getView().showForm(parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u9501\u5b9a\u91d1\u989d\u5927\u4e8e0\uff0c\u624d\u5141\u8bb8\u574f\u8d26\u635f\u5931\u3002", (String)"FinArBillEdit_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        }
        if ("tblwriteoff".equals(key)) {
            CheckResult result;
            String appId = this.getView().getFormShowParameter().getAppId();
            if ("dhc".equalsIgnoreCase(appId)) {
                String mainAppId = "/BBRH+122=39";
                String formId = this.getView().getFormShowParameter().getFormId();
                String entityName = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
                LicenseCheckResult checkResult = ArApLicenseServiceHelper.check((String)mainAppId, (String)entityName);
                if (!checkResult.getHasLicense().booleanValue()) {
                    this.getView().showErrorNotification(checkResult.getMsg());
                    return;
                }
                Long orgPk = (Long)this.getModel().getDataEntity().getDynamicObject("org").getPkValue();
                if (!BaseDataHelper.checkCurrentUserPermission((long)orgPk, (String)"ar", (String)"ar_finarbill", (String)"/NCNJ/321ENR")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u8d22\u52a1\u5e94\u6536\u5355\u7684\u201c\u51b2\u9500\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WriteoffVerify_01", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!(result = WriteoffVerify.check((Object[])new Object[]{finPk}, (boolean)true)).isIspass()) {
                this.getView().showErrorNotification(result.getMessage());
                return;
            }
            Map settleBillNumberMap = WriteOffHelper.getSettleBillNumberMap((Object[])new Object[]{finPk});
            boolean isPushPrem = FinarPremHelper.isPushPremiumBill((Object[])new Object[]{finPk});
            if (settleBillNumberMap.size() > 0 || isPushPrem) {
                StringBuilder title = new StringBuilder();
                Object title1 = "";
                int i = 1;
                if (isPushPrem) {
                    String warnPrem = ResManager.loadKDString((String)"%s\u3001\u56e0\u8be5\u5355\u636e\u5df2\u8f6c\u51fa\u8d28\u4fdd\u91d1\uff0c\u51b2\u9500\u540e\u4f1a\u540c\u65f6\u51b2\u9500\u8d28\u4fdd\u91d1\u3002", (String)"FinArBillClickHandler_7", (String)"fi-ar-formplugin", (Object[])new Object[]{i});
                    title.append(warnPrem);
                    ++i;
                }
                if (settleBillNumberMap.size() > 0) {
                    String warnTitle = String.format(ResManager.loadKDString((String)"%1$s\u3001\u5355\u636e\u7f16\u53f7%2$s\u4e0e\u4ee5\u4e0b\u5355\u636e\u8fdb\u884c\u8fc7\u7ed3\u7b97\uff0c\u51b2\u9500\u4f1a\u91ca\u653e\u53cc\u65b9\u7684\u53ef\u7ed3\u7b97\u989d\u5ea6\uff0c\u4e14\u91cd\u65b0\u5165\u8d26\u7cfb\u7edf\u4e0d\u4f1a\u5bf9\u5176\u81ea\u52a8\u7ed3\u7b97", (String)"FinArBillClickHandler_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), i, finArBill.getString("billno"));
                    title1 = ResManager.loadKDString((String)"\u8bf7\u52a1\u5fc5\u5173\u6ce8\u88ab\u91ca\u653e\u7684\u5355\u636e\uff0c\u5e76\u53ca\u65f6\u5bf9\u91cd\u65b0\u5165\u8d26\u7684\u5e94\u6536\u5355\u8fdb\u884c\u7ed3\u7b97\uff0c\u907f\u514d\u91cd\u590d\u6536\u6b3e\u3002", (String)"FinArBillClickHandler_9", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                    title.append('\n').append(warnTitle);
                    ++i;
                }
                String warn = title.toString();
                if (i == 2) {
                    warn = warn.replace("1.", "");
                }
                List msgs = WriteOffHelper.getOperationConfirmMessage((Map)settleBillNumberMap, (boolean)true);
                OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.getView(), (IFormPlugin)this.getBillPlugIn());
                String warnTitle = ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u51b2\u9500\uff1f", (String)"FinArBillClickHandler_10", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                operationConfirmHelper.openOperationConfirm(warn, (String)title1, warnTitle, msgs, false);
            } else if (finArBill.getBoolean("istransfer")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u503a\u6743\u8f6c\u79fb\u4e1a\u52a1\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u51b2\u9500\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FinArBillEdit_35", (String)"fi-ar-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("writeoff"));
            } else {
                this.getView().invokeOperation("writeoff");
            }
        }
        if ("viewver".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        }
        if ("viewver_arrev".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        }
        if ("viewsettle".equals(key)) {
            ViewsettleHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        }
        if ("viewvr_oriwf".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        }
        if ("viewvr_saloutwf".equals(key)) {
            ViewverHelper.itemClick((ItemClickEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        }
        if ("editsettingsinbulk".equals(key)) {
            EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getBillPlugIn().getPluginName());
            editInBulkService.showEditSettingsInBulk();
        }
        if ("editinbulk".equals(key) && (includeTax = ((Boolean)this.getModel().getValue("isincludetax")).booleanValue())) {
            EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getBillPlugIn().getPluginName());
            editInBulkService.showEditInBulk();
        }
        if ("handsettle".equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            boolean submitSettle = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"ar_016");
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (submitSettle) {
                if (!"B".equals(billStatus) && !"C".equals(billStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u6001\u7684\u5355\u636e\u5141\u8bb8\u8fdb\u884c\u624b\u5de5\u7ed3\u7b97\u3002", (String)"FinArBillClickHandler_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (!"C".equals(billStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u6001\u7684\u5355\u636e\u5141\u8bb8\u8fdb\u884c\u624b\u5de5\u7ed3\u7b97\u3002", (String)"FinArBillClickHandler_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal unlockamtTotal = BigDecimal.ZERO;
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entry");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                unlockamtTotal = unlockamtTotal.add(dynamicObject.getBigDecimal("e_unlockamt"));
            }
            if (!"settled".equals(this.getModel().getValue("settlestatus")) && unlockamtTotal.compareTo(BigDecimal.ZERO) != 0) {
                String entityName;
                ArrayList<String> selectPks = new ArrayList<String>(64);
                selectPks.add(this.getModel().getValue("id").toString());
                boolean hiddenManualSettle = "true".equals(StdConfig.get((String)"isHiddenManualSettle"));
                String string = entityName = hiddenManualSettle ? "ar_settleconsole" : "ar_handsettle";
                if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)"ar", (String)entityName, (String)"47150e89000000ac")) {
                    String entityDisplayName = MetadataServiceHelper.getDataEntityType((String)entityName).getDisplayName().getLocaleValue();
                    String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s%2$s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"FinArBillClickHandler_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue(), entityDisplayName);
                    this.getView().showErrorNotification(message);
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                formShowParameter.setFormId(entityName);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCaption(hiddenManualSettle ? ResManager.loadKDString((String)"\u5e94\u6536\u7ed3\u7b97\u5de5\u4f5c\u53f0", (String)"FinArBillClickHandler_11", (String)"fi-ar-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u624b\u5de5\u7ed3\u7b97", (String)"FinArBillClickHandler_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                customParams.put("finarbills", selectPks);
                customParams.put("submitsettle", submitSettle);
                customParams.put("billstatus", billStatus);
                formShowParameter.setCustomParams(customParams);
                this.getView().showForm(formShowParameter);
            } else if (submitSettle) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\u6001\u4e14\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u7b49\u4e8e0\u7684\u5355\u636e\u5141\u8bb8\u624b\u5de5\u7ed3\u7b97\u3002", (String)"FinArBillClickHandler_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(18000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u6001\u4e14\u672a\u9501\u5b9a\u91d1\u989d\u4e0d\u7b49\u4e8e0\u7684\u5355\u636e\u5141\u8bb8\u624b\u5de5\u7ed3\u7b97\u3002", (String)"FinArBillClickHandler_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), Integer.valueOf(18000));
            }
        }
        if ("buckle".equals(key) || "rebate".equals(key) || "adjustinv".equals(key) || "overdue".equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (!BaseDataHelper.checkCurrentUserPermission((long)org.getLong("id"), (String)"ar", (String)"ar_finarbill", (String)"0A3J+YT5CUD4")) {
                String message = ResManager.loadKDString((String)"\u65e0\u201c\u8d22\u52a1\u5e94\u6536\u5355\u201d\u7684\u201c\u501f\u8d37\u9879\u8c03\u6574\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FinArBillEdit_34", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return;
            }
            this.adiustShowForm(key);
        }
        if ("buckleentry".equals(key) || "rebateentry".equals(key) || "adjustinventry".equals(key) || "overdueentry".equals(key)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("adjusttype", key.replace("entry", ""));
            this.getView().invokeOperation("billmodify", option);
        }
        if ("totaldiscount".equals(key)) {
            DiscountAmtHelper totalService = new DiscountAmtHelper();
            totalService.discountShowForm(this.getView(), this.getBillPlugIn(), BillModelFactory.getModel((String)"ar_finarbill"));
        }
        if ("splitplanrow".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("planentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"FinArBillClickHandler_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            IBillModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("planentity");
            int i = model.insertEntryRow("planentity", rowIndex + 1);
            MainEntityType entityType = model.getDataEntityType();
            EntityType type = (EntityType)entityType.getAllEntities().get("planentity");
            Set planEntryFields = type.getFields().keySet();
            model.beginInit();
            for (String field : planEntryFields) {
                model.setValue(field, model.getValue(field, rowIndex), i);
            }
            this.getView().updateView("planentity");
        }
    }

    private void corebillShowF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("entry");
        String coreBillType = (String)this.getModel().getValue("e_corebilltype", currrow);
        ArApCorebillHelper.showCoreBillF7((String)coreBillType, (IFormView)this.getView(), (String)this.getBillPlugIn().getPluginName());
    }

    private void adiustShowForm(String key) {
        FormShowParameter formShowParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        formShowParameter.setFormId("ap_totaladjust");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        customParams.put("currency", currency.getPkValue());
        customParams.put("adjusttype", key);
        customParams.put("pkValue", this.getModel().getValue("id"));
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.getBillPlugIn(), "ap_totaladjust"));
        this.getView().showForm(formShowParameter);
    }
}

