/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.service.plan.FinPlanRowService;
import kd.fi.arapcommon.service.plan.PlanRow;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArBillFormHelper {
    public static void createByInit(IBillModel model, IPageCache pageCache, InitHelper init) {
        Date bizDate;
        Date currentDate;
        DynamicObject currency = init.getStandardCurrency();
        if (ObjectUtils.isEmpty((Object)model.getValue("currency"))) {
            model.setValue("currency", currency.getPkValue());
        }
        model.setValue("basecurrency", currency.getPkValue());
        if (ObjectUtils.isEmpty((Object)model.getValue("exchangerate"))) {
            model.setValue("exchangerate", (Object)1);
        }
        if (ObjectUtils.isEmpty((Object)model.getValue("exratetable"))) {
            model.setValue("exratetable", init.getExrateTable().getPkValue());
        }
        if (!"true".equals(pageCache.get("isWebApi")) && (currentDate = ObjectUtils.isEmpty((Object)init.getCurrentDate()) ? init.getStartDate() : init.getCurrentDate()).after(bizDate = (Date)model.getValue("bizdate"))) {
            model.setValue("bizdate", (Object)currentDate);
            if (ObjectUtils.isEmpty((Object)"duedate")) {
                model.setValue("duedate", (Object)currentDate);
            }
        }
    }

    public static void calculatePlan4Copy(IDataModel model) {
        int currentRowCount = model.getEntryRowCount("planentity");
        BigDecimal reclocalamt = (BigDecimal)model.getValue("reclocalamt");
        DynamicObject baseCurrency = (DynamicObject)model.getValue("basecurrency");
        int localpecision = baseCurrency.getInt("amtprecision");
        String quotation = (String)model.getValue("quotation");
        BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal planpricetaxloc = BigDecimal.ZERO;
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        for (int i = 0; i < currentRowCount; ++i) {
            if (i == currentRowCount - 1) {
                BigDecimal lastRowlocAmt = reclocalamt.subtract(planpricetaxloc);
                model.setValue("planpricetaxloc", (Object)lastRowlocAmt, i);
                model.setValue("unplansettlelocamt", (Object)lastRowlocAmt, i);
                continue;
            }
            BigDecimal planpricetax = (BigDecimal)model.getValue("planpricetax", i);
            BigDecimal rowlocpricetax = "1".equals(quotation) ? planpricetax.divide(exchangeRate, localpecision, RoundingMode.HALF_UP) : planpricetax.multiply(exchangeRate).setScale(localpecision, RoundingMode.HALF_UP);
            model.setValue("planpricetaxloc", (Object)rowlocpricetax, i);
            model.setValue("unplansettlelocamt", (Object)rowlocpricetax, i);
            planpricetaxloc = planpricetaxloc.add(rowlocpricetax);
        }
    }

    public static void calculateAllPlanRow(IBillModel model) {
        if (((Boolean)model.getValue("iswrittenoff")).booleanValue()) {
            return;
        }
        List<PlanRow> planRows = FinArBillFormHelper.calculatePlanRow(model);
        int currentRowCount = model.getEntryRowCount("planentity");
        int diffRowCount = planRows.size() - currentRowCount;
        if (diffRowCount > 0) {
            model.batchCreateNewEntryRow("planentity", diffRowCount);
        } else if (diffRowCount < 0) {
            int[] deleteRowIndexs = new int[Math.abs(diffRowCount)];
            for (int i = 0; i < Math.abs(diffRowCount); ++i) {
                deleteRowIndexs[i] = currentRowCount - i - 1;
            }
            model.deleteEntryRows("planentity", deleteRowIndexs);
        }
        FinArBillFormHelper.updateByPlanList(model, planRows);
    }

    public static List<PlanRow> calculatePlanRow(IBillModel model) {
        FinPlanRowService planRowService = (FinPlanRowService)BeanFactory.getBean(FinPlanRowService.class, (Object[])new Object[0]);
        DynamicObject bill = model.getDataEntity(true);
        return planRowService.calculatePlanRows(bill, planRowService.getTermsDate(bill));
    }

    private static void updateByPlanList(IBillModel model, List<PlanRow> planRows) {
        Date planMaxDuedate = null;
        Object settlementType = model.getValue("settlementtype");
        if (settlementType instanceof DynamicObject) {
            DynamicObject obj = (DynamicObject)settlementType;
            settlementType = obj.getPkValue();
        }
        BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
        String quotation = (String)model.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int localPrecision = FinArBillFormHelper.getLocalPrecision(model);
        BigDecimal pricetaxtotal = (BigDecimal)model.getValue("recamount");
        BigDecimal pricetaxtotallocal = (BigDecimal)model.getValue("reclocalamt");
        for (int i = 0; i < planRows.size(); ++i) {
            PlanRow planRow = planRows.get(i);
            Date palnDuedate = planRow.getDueDate();
            BigDecimal planAmt = planRow.getPlanAmt();
            BigDecimal planAmtLocal = BigDecimal.ZERO;
            if (i == planRows.size() - 1) {
                planAmt = pricetaxtotal;
                planAmtLocal = pricetaxtotallocal;
            } else {
                planAmtLocal = "1".equals(quotation) ? planAmt.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP) : planAmt.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                pricetaxtotal = pricetaxtotal.subtract(planAmt);
                pricetaxtotallocal = pricetaxtotallocal.subtract(planAmtLocal);
            }
            model.setValue("planpricetax", (Object)planAmt, i);
            model.setValue("unplanlockamt", (Object)planAmt, i);
            model.setValue("unplansettleamt", (Object)planAmt, i);
            model.setValue("planpricetaxloc", (Object)planAmtLocal, i);
            model.setValue("unplansettlelocamt", (Object)planAmtLocal, i);
            model.setValue("planduedate", (Object)palnDuedate, i);
            if (EmptyUtils.isEmpty((Object)model.getValue("plansettletype", i))) {
                model.setValue("plansettletype", settlementType, i);
            }
            if (planMaxDuedate == null) {
                planMaxDuedate = palnDuedate;
                continue;
            }
            if (palnDuedate == null) continue;
            planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
        }
        if (planMaxDuedate != null) {
            model.setValue("duedate", planMaxDuedate);
        }
    }

    public static int getLocalPrecision(IBillModel model) {
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        return localPrecision;
    }

    public static void setDefaultValue(IBillModel model, DynamicObject org, long orgId) {
        if (ObjectUtils.isEmpty((Object)model.getValue("recorg")) && org.getBoolean("fisbankroll")) {
            model.setValue("recorg", (Object)orgId);
        }
        if (ObjectUtils.isEmpty((Object)model.getValue("salesorg")) && org.getBoolean("fissale")) {
            model.setValue("salesorg", (Object)orgId);
        }
    }

    public static BigDecimal getExchangeRate(IBillModel m) {
        return FormServiceHelper.getExchangeRate((IBillModel)m);
    }
}

