/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.ar.formplugin.formservice.fin.FinArBillFormHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.business.price.FxCalculator;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.form.FxLocalAmtHandler;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.MaterialRow;
import kd.sdk.fi.ap.extpoint.importext.IAfterImportDataExt;

public class FinArBillImportHelper
extends AbstractBillImport
implements IAfterImportDataExt {
    private Map<String, BigDecimal> convertRateMap = new HashMap<String, BigDecimal>(8);
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private final List<String> headUpdFields = this.headRemoveUpFields();
    private final List<String> entryUpdFields = this.entryRemoveUpFields();
    private final List<String> planEntryFields = this.planEntryRemoveFields();
    private FxLocalAmtHandler fxLocalAmtHandler;
    private boolean hasConfirmQty = false;
    private boolean hasConfirmAmt = false;
    private QuotationHelper quotationHelper;
    private Map<Long, Boolean> isFxCheckMap = new HashMap<Long, Boolean>(8);
    private Map<Long, BigDecimal> fxRangeMap = new HashMap<Long, BigDecimal>(8);

    public FinArBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map sourceData = e.getSourceData();
        boolean isNew = false;
        String importType = (String)e.getOption().get("importtype");
        if ("overridenew".equals(importType) || importType == null) {
            isNew = ObjectUtils.isEmpty(sourceData.get("_pkid_"));
        } else if ("new".equals(importType)) {
            isNew = true;
        }
        boolean includetax = sourceData.containsKey("isincludetax") ? ((Boolean)sourceData.get("isincludetax")).booleanValue() : ((Boolean)this.model.getValue("isincludetax")).booleanValue();
        boolean ispricetotal = sourceData.containsKey("ispricetotal") ? ((Boolean)sourceData.get("ispricetotal")).booleanValue() : ((Boolean)this.model.getValue("ispricetotal")).booleanValue();
        boolean isPeriod = sourceData.get("isperiod") != null ? (Boolean)sourceData.get("isperiod") : false;
        this.checkIsFx(sourceData);
        if (isNew) {
            this.checkNull("currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"FinArBillImportHelper_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), sourceData);
            this.removeNoAssignField(sourceData, this.headFields);
        } else {
            this.removeNoAssignField(sourceData, this.headUpdFields);
        }
        List entryList = null;
        if (sourceData.get("entry") != null) {
            entryList = (List)sourceData.get("entry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                Map entry = (Map)entryList.get(i);
                boolean ispresent = entry.get("e_ispresent") != null ? (Boolean)entry.get("e_ispresent") : false;
                this.checkPriceandAmount(ispresent, includetax, ispricetotal, entry, i);
                if (!isPeriod && isNew) {
                    this.removeNoAssignField(entry, new String[]{"e_invoicedamt"});
                }
                if (isNew) {
                    this.removeNoAssignField(entry, this.entryFields);
                    continue;
                }
                String entry_id = (String)entry.get("id");
                String e_srcid = (String)entry.get("e_srcid");
                String e_srcentryid = (String)entry.get("e_srcentryid");
                if (!kd.bos.util.StringUtils.isEmpty((String)e_srcid) || !kd.bos.util.StringUtils.isEmpty((String)e_srcentryid)) {
                    if (kd.bos.util.StringUtils.isEmpty((String)entry_id)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5bfc\u5165\u65b0\u589e\u5206\u5f55\u65f6\uff0c\u6e90\u5355id\u3001\u6e90\u5355\u5206\u5f55id\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"FinArBillImportHelper_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]));
                    }
                    this.removeNoAssignField(entry, this.entryUpdFields);
                    continue;
                }
                this.removeNoAssignField(entry, this.entryFields);
            }
        }
        List planEntryList = null;
        if (sourceData.get("planentity") != null) {
            planEntryList = (List)sourceData.get("planentity");
        }
        if (planEntryList != null) {
            for (int i = 0; i < planEntryList.size(); ++i) {
                Map entry = (Map)planEntryList.get(i);
                this.removeNoAssignField(entry, this.planEntryFields);
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e, IDataModel m) {
        DynamicObject org;
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        String url = RequestContext.get().getClientUrl();
        String param = sourceData.toString();
        this.hasConfirmQty = param.contains("e_confirmedqty");
        this.hasConfirmAmt = param.contains("e_confirmedamt");
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map opMap = e.getOption();
        String type = (String)opMap.get("importtype");
        boolean isNew = false;
        String importType = (String)e.getOption().get("importtype");
        if ("overridenew".equals(importType) || importType == null) {
            isNew = ObjectUtils.isEmpty(sourceData.get("_pkid_"));
        } else if ("new".equals(importType)) {
            isNew = true;
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("billsrctype")) || BillSrcTypeEnum.MANUAL.getValue().equals(this.model.getValue("billsrctype"))) {
            this.model.setValue("billsrctype", (Object)BillSrcTypeEnum.IMPORT.getValue());
        }
        if (ObjectUtils.isEmpty((Object)(org = (DynamicObject)this.model.getValue("org")))) {
            return;
        }
        Long orgPk = (Long)org.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ar_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"FinArBillImportHelper_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        this.init.checkInit();
        BookDateHelper.checkBookDate((IDataModel)this.model, (boolean)true, (Map)this.cacheDateMap, (InitHelper)this.init);
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinArBillImportHelper_11", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        this.createByInit(sourceData);
        this.createDefaultField((IBillModel)this.model);
        this.setCalculatorAmt((IBillModel)this.model, type);
        this.calPlanEntity(isNew);
    }

    private void createDefaultField(IBillModel model) {
        Object dueDate = model.getValue("duedate");
        if (ObjectUtils.isEmpty((Object)dueDate)) {
            model.setValue("duedate", (Object)new Date());
        }
        DynamicObject asstact = (DynamicObject)model.getValue("asstact");
        model.setValue("relationpay", (Object)this.isBizPartner(asstact));
    }

    private boolean isBizPartner(DynamicObject custsupper) {
        DynamicObject asstact;
        DynamicObject intercompany;
        boolean isBizPartner = false;
        if (custsupper != null && (custsupper.getDataEntityType().getName().equals("bd_supplier") || custsupper.getDataEntityType().getName().equals("bd_customer")) && (intercompany = (asstact = BusinessDataServiceHelper.loadSingle((Object)custsupper.getPkValue(), (String)custsupper.getDynamicObjectType().getName(), (String)"internal_company")).getDynamicObject("internal_company")) != null) {
            isBizPartner = true;
        }
        return isBizPartner;
    }

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    private void setCalculatorAmt(IBillModel m, String type) {
        int iCount = m.getEntryEntity("entry").size();
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal reclocalamt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        BigDecimal uninvoicedamt = BigDecimal.ZERO;
        BigDecimal uninvoiceLocaldamt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        boolean ispricetotal = (Boolean)m.getValue("ispricetotal");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = currency.getInt("amtprecision");
        int localprecision = FinArBillFormHelper.getLocalPrecision(m);
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        HashMap<String, MaterialRow> rowMap = new HashMap<String, MaterialRow>(8);
        for (int i = 0; i < iCount; ++i) {
            DynamicObject taxrateid;
            Boolean isPresent;
            DynamicObject material = (DynamicObject)m.getValue("e_material", i);
            if (!ObjectUtils.isEmpty((Object)material)) {
                DynamicObject baseunit = material.getDynamicObject("baseunit");
                if (!ObjectUtils.isEmpty((Object)baseunit)) {
                    Object baseunitPk = baseunit.getPkValue();
                    m.setValue("e_baseunit", baseunitPk, i);
                    if (ObjectUtils.isEmpty((Object)m.getValue("e_measureunit", i))) {
                        m.setValue("e_measureunit", baseunitPk, i);
                    }
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"FinArBillImportHelper_9", (String)"fi-ar-formplugin", (Object[])new Object[0]), material.getString("name")));
                }
                DynamicObject productline = material.getDynamicObject("productline");
                if (productline != null && ObjectUtils.isEmpty((Object)m.getValue("e_productline", i))) {
                    m.setValue("e_productline", productline.getPkValue(), i);
                }
                DynamicObject measureUnit = (DynamicObject)m.getValue("e_measureunit", i);
                long materialID = (Long)material.getPkValue();
                long measureUnitID = (Long)measureUnit.getPkValue();
                String key = materialID + "-" + measureUnitID;
                MaterialRow row = null;
                if (!rowMap.containsKey(key)) {
                    row = this.buildMaterialRow(material, baseunit, measureUnitID);
                    rowMap.put(key, row);
                } else {
                    row = (MaterialRow)rowMap.get(key);
                }
                this.setMaterialRow(m, row, i);
                BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", i);
                m.setValue("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)row.getUnitCoefficient(), (DynamicObject)baseunit), i);
            }
            if ((isPresent = (Boolean)this.model.getValue("e_ispresent", i)).booleanValue()) {
                BigDecimal rice = (BigDecimal)m.getValue("e_unitprice", i);
                BigDecimal priceTax = (BigDecimal)m.getValue("e_taxunitprice", i);
                if (BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) {
                    m.setValue("e_discountmode", (Object)"PERCENT", i);
                    m.setValue("e_discountrate", (Object)new BigDecimal(100), i);
                } else {
                    m.setValue("e_discountmode", (Object)"NULL", i);
                    m.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
                }
            }
            if (!ObjectUtils.isEmpty((Object)(taxrateid = (DynamicObject)m.getValue("taxrateid", i))) && EmptyUtils.isEmpty((Object)m.getValue("e_taxrate", i))) {
                m.setValue("e_taxrate", (Object)taxrateid.getBigDecimal("taxrate"), i);
            }
            Object disCountType = m.getValue("e_discountmode", i);
            BigDecimal disCountAmt = (BigDecimal)m.getValue("e_discountamount", i);
            BigDecimal qty = (BigDecimal)m.getValue("e_quantity", i);
            int pricePrecision = 4;
            if (DiscountModeEnum.NULL.getValue().equals(m.getValue("e_discountmode", i)) || DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) == 0) {
                m.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
            } else if (DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) != 0) {
                pricePrecision = currency.getInt("priceprecision");
                BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", i);
                taxRate = taxRate.divide(BigDecimal.valueOf(100L));
                BigDecimal discountRate = includeTax ? disCountAmt.divide(qty, pricePrecision, RoundingMode.HALF_UP) : disCountAmt.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.add(taxRate), pricePrecision, RoundingMode.HALF_UP);
                m.setValue("e_discountrate", (Object)discountRate, i);
            }
            if (ispricetotal && isPresent.booleanValue()) {
                this.resetEntryPropForPresent((IDataModel)m, i, includeTax, precision, localprecision, rate);
            } else {
                this.calculatorEntryAmt((IDataModel)m, includeTax, ispricetotal, rate, precision, localprecision, i, type);
            }
            amount = amount.add((BigDecimal)m.getValue("e_amount", i));
            localamt = localamt.add((BigDecimal)m.getValue("e_localamt", i));
            tax = tax.add((BigDecimal)m.getValue("e_tax", i));
            taxlocamt = taxlocamt.add((BigDecimal)m.getValue("e_taxlocalamt", i));
            recamount = recamount.add((BigDecimal)m.getValue("e_recamount", i));
            reclocalamt = reclocalamt.add((BigDecimal)m.getValue("e_reclocalamt", i));
            uninvoicedamt = uninvoicedamt.add((BigDecimal)m.getValue("e_uninvoicedamt", i));
            uninvoiceLocaldamt = uninvoiceLocaldamt.add((BigDecimal)m.getValue("e_uninvoicedlocalamt", i));
            adjustamt = adjustamt.add((BigDecimal)m.getValue("e_adjustamount", i));
            adjustamtlocal = adjustamtlocal.add((BigDecimal)m.getValue("e_adjustlocalamt", i));
        }
        m.setValue("amount", (Object)amount);
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxlocamt);
        m.setValue("localamt", (Object)localamt);
        m.setValue("recamount", (Object)recamount);
        m.setValue("reclocalamt", (Object)reclocalamt);
        m.setValue("unsettleamount", (Object)recamount);
        m.setValue("unsettlelocalamt", (Object)reclocalamt);
        m.setValue("unverifyamount", (Object)amount);
        m.setValue("uninvoicedamt", (Object)uninvoicedamt);
        m.setValue("uninvoicedlocalamt", (Object)uninvoiceLocaldamt);
        m.setValue("invoicedamt", (Object)recamount.subtract(uninvoicedamt));
        m.setValue("invoicedlocalamt", (Object)reclocalamt.subtract(uninvoiceLocaldamt));
        m.setValue("adjustamount", (Object)adjustamt);
        m.setValue("adjustlocalamt", (Object)adjustamtlocal);
    }

    private void resetEntryPropForPresent(IDataModel m, int i, boolean includeTax, int precision, int localprecision, BigDecimal rate) {
        BigDecimal price;
        BigDecimal confirmQty = (BigDecimal)m.getValue("e_confirmedqty", i);
        BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", i);
        BigDecimal baseQty = (BigDecimal)m.getValue("e_baseunitqty", i);
        BigDecimal unitcoefficient = (BigDecimal)this.model.getValue("e_unitcoefficient", i);
        m.setValue("e_unverifyqty", (Object)quantity, i);
        m.setValue("e_unverifybaseqty", (Object)baseQty, i);
        BigDecimal uninvoicedqty = quantity.subtract((BigDecimal)m.getValue("e_invoicedqty", i));
        m.setValue("e_uninvoicedqty", (Object)uninvoicedqty, i);
        boolean isPeriod = (Boolean)m.getValue("isperiod");
        if (!isPeriod) {
            m.setValue("e_confirmedqty", (Object)BigDecimal.ZERO, i);
            m.setValue("e_unconfirmqty", (Object)quantity, i);
        } else if (this.hasConfirmQty) {
            m.setValue("e_unconfirmqty", (Object)quantity.subtract(confirmQty), i);
            m.setValue("e_confirmedbaseqty", (Object)unitcoefficient.multiply(confirmQty), i);
            m.setValue("e_unconfirmbaseqty", (Object)baseQty.subtract(unitcoefficient.multiply(confirmQty)), i);
        } else {
            m.setValue("e_confirmedqty", (Object)BigDecimal.ZERO, i);
            m.setValue("e_unconfirmqty", (Object)quantity, i);
            m.setValue("e_confirmedbaseqty", (Object)0, i);
            m.setValue("e_unconfirmbaseqty", (Object)baseQty, i);
        }
        if (includeTax) {
            price = (BigDecimal)m.getValue("e_taxunitprice", i);
            m.setValue("e_unitprice", (Object)price, i);
        } else {
            price = (BigDecimal)m.getValue("e_unitprice", i);
            m.setValue("e_taxunitprice", (Object)price, i);
        }
        m.setValue("e_actunitprice", (Object)price, i);
        m.setValue("e_acttaxunitprice", (Object)price, i);
        m.setValue("e_amount", (Object)BigDecimal.ZERO, i);
        m.setValue("e_localamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_tax", (Object)BigDecimal.ZERO, i);
        m.setValue("e_taxlocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_recamount", (Object)BigDecimal.ZERO, i);
        m.setValue("e_reclocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unverifyamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unlockamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unsettleamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unsettlelocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_invoicedlocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvoicedamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvoicedlocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_confirmedamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unconfirmamt", (Object)BigDecimal.ZERO, i);
        String quotation = (String)this.model.getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        BigDecimal discountAmout = price.multiply(quantity).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal discountLocalAmt = "0".equals(quotation) ? discountAmout.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP) : discountAmout.divide(rate, localprecision, RoundingMode.HALF_UP);
        m.setValue("e_discountamount", (Object)discountAmout, i);
        m.setValue("e_discountlocalamt", (Object)discountLocalAmt, i);
    }

    private MaterialRow buildMaterialRow(DynamicObject material, DynamicObject baseunit, long measureUnitPk) {
        MaterialRow row = new MaterialRow();
        row.setMaterialPk(((Long)material.getPkValue()).longValue());
        row.setSpecType(material.getString("modelnum"));
        row.setBaseUnitPk(baseunit != null ? (Long)baseunit.getPkValue() : measureUnitPk);
        row.setMeasureUnitPk(measureUnitPk);
        BigDecimal convertRate = this.getConvertRate(row.getMaterialPk(), row.getMeasureUnitPk(), row.getBaseUnitPk());
        row.setUnitCoefficient(convertRate != null ? convertRate : BigDecimal.ONE);
        DynamicObject taxrate = material.getDynamicObject("taxrate");
        if (!ObjectUtils.isEmpty((Object)taxrate)) {
            row.setTaxRatePk(((Long)taxrate.getPkValue()).longValue());
        }
        return row;
    }

    private void setMaterialRow(IBillModel m, MaterialRow row, int iRow) {
        m.setValue("e_spectype", (Object)row.getSpecType(), iRow);
        m.setValue("e_baseunit", (Object)row.getBaseUnitPk(), iRow);
        m.setValue("e_measureunit", (Object)row.getMeasureUnitPk(), iRow);
        m.setValue("e_unitcoefficient", (Object)row.getUnitCoefficient(), iRow);
        if (EmptyUtils.isNotEmpty((Object)row.getTaxRatePk()) && EmptyUtils.isEmpty((Object)m.getValue("taxrateid", iRow))) {
            m.setValue("taxrateid", (Object)row.getTaxRatePk(), iRow);
        }
    }

    protected void calculatorEntryAmt(IDataModel m, boolean includeTax, boolean ispricetotal, BigDecimal rate, int precision, int localprecision, int index, String type) {
        String quotation;
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        BigDecimal adjustAmount = (BigDecimal)m.getValue("e_adjustamount", index);
        BigDecimal discountAmt = (BigDecimal)m.getValue("e_discountamount", index);
        BigDecimal tax = (BigDecimal)m.getValue("e_tax", index);
        BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
        PriceTotalCalculator calculator = null;
        if (includeTax && !ispricetotal) {
            BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
            calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, adjustAmount, discountAmt);
        } else if (!includeTax && !ispricetotal) {
            BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, adjustAmount, discountAmt);
        } else if (!includeTax && ispricetotal) {
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, adjustAmount, discountAmt);
        } else if (includeTax && ispricetotal) {
            BigDecimal recamount = (BigDecimal)m.getValue("e_recamount", index);
            calculator = new PriceTaxTotalCalculator(qty, recamount, taxRate, discountMode, discountRate, precision, adjustAmount, discountAmt);
        }
        DynamicObject billtype = (DynamicObject)m.getValue("billtype");
        String srcType = (String)m.getValue("sourcebilltype");
        String srcId = (String)m.getValue("sourcebillid");
        boolean isAdujst = srcId != null && !"".equals(srcId) && "ar_finarbill".equals(srcType) && "arfin_borrowar_BT_S".equals(billtype.getString("number")) && "override".equals(type);
        boolean isCalculate = true;
        if (calculator != null) {
            calculator.calculate();
            this.checkAmountRange(m, (AbstractPriceCalculator)calculator, index);
            isCalculate = false;
        }
        if ("1".equals(quotation = (String)this.model.getValue("quotation")) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        if (isAdujst) {
            BigDecimal e_adjustamount = (BigDecimal)m.getValue("e_adjustamount", index);
            FxCalculator fxCalculator = new FxCalculator(tax, amount, tax.add(amount), e_adjustamount, false, false, false, false, false, true);
            BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
            FXPriceLocalCalculator fxPriceLocalCalculator = new FXPriceLocalCalculator(fxCalculator, exchangeRate, precision, quotation);
            fxPriceLocalCalculator.calculate();
            this.adjustResetEntryProp(m, fxPriceLocalCalculator, index);
        } else {
            PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, isCalculate, quotation);
            localCalculator.calculate();
            this.fxLocalCalculate(m, localCalculator, index);
            this.resetEntryProp(m, localCalculator, index);
        }
    }

    private void adjustResetEntryProp(IDataModel m, FXPriceLocalCalculator fxPriceLocalCalculator, int index) {
        BigDecimal amount = fxPriceLocalCalculator.getAmount();
        BigDecimal locAmount = fxPriceLocalCalculator.getAmountLocal();
        BigDecimal tax = fxPriceLocalCalculator.getTax();
        BigDecimal locTax = fxPriceLocalCalculator.getTaxLocal();
        BigDecimal pricetaxTotal = fxPriceLocalCalculator.getPricetaxtotal();
        BigDecimal locPriceTaxTotal = fxPriceLocalCalculator.getPriceTaxTotalLocal();
        BigDecimal adjustAmt = fxPriceLocalCalculator.getAdjustamt();
        BigDecimal locAdjustAmt = fxPriceLocalCalculator.getAdjustamtlocal();
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_localamt", (Object)locAmount, index);
        m.setValue("e_tax", (Object)tax, index);
        m.setValue("e_taxlocalamt", (Object)locTax, index);
        m.setValue("e_recamount", (Object)pricetaxTotal, index);
        m.setValue("e_reclocalamt", (Object)locPriceTaxTotal, index);
        m.setValue("e_adjustamount", (Object)adjustAmt, index);
        m.setValue("e_adjustlocalamt", (Object)locAdjustAmt, index);
        m.setValue("e_uninvoicedamt", (Object)pricetaxTotal, index);
        m.setValue("e_invoicedamt", (Object)BigDecimal.ZERO, index);
        m.setValue("e_uninvoicedlocalamt", (Object)locPriceTaxTotal, index);
        m.setValue("e_invoicedlocalamt", (Object)BigDecimal.ZERO, index);
        m.setValue("e_discountamount", (Object)fxPriceLocalCalculator.getDiscountamount(), index);
        m.setValue("e_unverifyamt", (Object)amount, index);
        m.setValue("e_unlockamt", (Object)pricetaxTotal, index);
        m.setValue("e_unsettleamt", (Object)pricetaxTotal, index);
        m.setValue("e_unsettlelocalamt", (Object)pricetaxTotal, index);
        m.setValue("e_discountlocalamt", (Object)fxPriceLocalCalculator.getDiscountamountLocal(), index);
        boolean isPeriod = (Boolean)m.getValue("isperiod");
        BigDecimal confirmAmt = (BigDecimal)m.getValue("e_confirmedamt", index);
        boolean isPresent = (Boolean)m.getValue("e_ispresent", index);
        if (!isPeriod) {
            m.setValue("e_confirmedamt", (Object)BigDecimal.ZERO, index);
            m.setValue("e_unconfirmamt", (Object)amount, index);
        } else if (isPresent) {
            m.setValue("e_confirmedamt", (Object)BigDecimal.ZERO, index);
            m.setValue("e_unconfirmamt", (Object)BigDecimal.ZERO, index);
        } else if (this.hasConfirmAmt) {
            m.setValue("e_unconfirmamt", (Object)amount.subtract(confirmAmt), index);
        } else {
            m.setValue("e_confirmedamt", (Object)BigDecimal.ZERO, index);
            m.setValue("e_unconfirmamt", (Object)amount, index);
        }
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("e_actunitprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice(), index);
        BigDecimal amount = localCalculator.getAmount();
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_localamt", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("e_taxlocalamt", (Object)localCalculator.getTaxlocal(), index);
        m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        m.setValue("e_recamount", (Object)recamount, index);
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        m.setValue("e_reclocalamt", (Object)reclocalamt, index);
        m.setValue("e_unverifyamt", (Object)amount, index);
        m.setValue("e_unlockamt", (Object)recamount, index);
        m.setValue("e_unsettleamt", (Object)recamount, index);
        m.setValue("e_unsettlelocalamt", (Object)reclocalamt, index);
        m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
        m.setValue("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
        m.setValue("e_unverifyqty", m.getValue("e_quantity", index), index);
        m.setValue("e_unverifybaseqty", m.getValue("e_baseunitqty", index), index);
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)this.model.getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        BigDecimal e_invoicedamt = (BigDecimal)m.getValue("e_invoicedamt", index);
        BigDecimal uninvoicedamt = recamount.subtract(e_invoicedamt);
        BigDecimal e_invoicedLocalamt = "1".equals(quotation) ? e_invoicedamt.divide(rate, localCalculator.getLocalCurrencyPrecison(), RoundingMode.HALF_UP) : e_invoicedamt.multiply(rate).setScale(localCalculator.getLocalCurrencyPrecison(), RoundingMode.HALF_UP);
        m.setValue("e_invoicedlocalamt", (Object)e_invoicedLocalamt, index);
        m.setValue("e_uninvoicedamt", (Object)uninvoicedamt, index);
        BigDecimal uninvoicedLocalamt = reclocalamt.subtract((BigDecimal)m.getValue("e_invoicedlocalamt", index));
        m.setValue("e_uninvoicedlocalamt", (Object)uninvoicedLocalamt, index);
        BigDecimal uninvoicedqty = ((BigDecimal)m.getValue("e_quantity", index)).subtract((BigDecimal)m.getValue("e_invoicedqty", index));
        m.setValue("e_uninvoicedqty", (Object)uninvoicedqty, index);
        boolean isPeriod = (Boolean)m.getValue("isperiod");
        BigDecimal confirmAmt = (BigDecimal)m.getValue("e_confirmedamt", index);
        BigDecimal confirmQty = (BigDecimal)m.getValue("e_confirmedqty", index);
        BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", index);
        boolean isPresent = (Boolean)m.getValue("e_ispresent", index);
        BigDecimal unitcoefficient = (BigDecimal)this.model.getValue("e_unitcoefficient", index);
        BigDecimal baseQty = (BigDecimal)m.getValue("e_baseunitqty", index);
        if (!isPeriod) {
            m.setValue("e_confirmedqty", (Object)BigDecimal.ZERO, index);
            m.setValue("e_confirmedamt", (Object)BigDecimal.ZERO, index);
            m.setValue("e_unconfirmamt", (Object)amount, index);
            m.setValue("e_unconfirmqty", (Object)quantity, index);
        } else {
            if (isPresent) {
                m.setValue("e_confirmedamt", (Object)BigDecimal.ZERO, index);
                m.setValue("e_unconfirmamt", (Object)BigDecimal.ZERO, index);
            } else if (this.hasConfirmAmt) {
                m.setValue("e_unconfirmamt", (Object)amount.subtract(confirmAmt), index);
            } else {
                m.setValue("e_confirmedamt", (Object)BigDecimal.ZERO, index);
                m.setValue("e_unconfirmamt", (Object)amount, index);
            }
            if (this.hasConfirmQty) {
                m.setValue("e_unconfirmqty", (Object)quantity.subtract(confirmQty), index);
                m.setValue("e_confirmedbaseqty", (Object)unitcoefficient.multiply(confirmQty), index);
                m.setValue("e_unconfirmbaseqty", (Object)baseQty.subtract(unitcoefficient.multiply(confirmQty)), index);
            } else {
                m.setValue("e_confirmedqty", (Object)BigDecimal.ZERO, index);
                m.setValue("e_unconfirmqty", (Object)quantity, index);
                m.setValue("e_confirmedbaseqty", (Object)0, index);
                m.setValue("e_unconfirmbaseqty", (Object)baseQty, index);
            }
        }
    }

    private boolean isPlanEntryEmpty(DynamicObjectCollection planEntry) {
        if (planEntry == null || planEntry.isEmpty()) {
            return true;
        }
        for (DynamicObject planRow : planEntry) {
            BigDecimal planAmt = planRow.getBigDecimal("planpricetax");
            if (planAmt == null || planAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private BigDecimal getConvertRate(Long materialId, Long srcUnitId, Long desUnitId) {
        String key = materialId + "_" + srcUnitId + "_" + desUnitId;
        BigDecimal value = this.convertRateMap.get(key);
        if (value != null) {
            return value;
        }
        BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        this.convertRateMap.put(key, unitRateConv);
        return unitRateConv;
    }

    private void checkAmountRange(IDataModel m, AbstractPriceCalculator priceCalculator, int index) {
        boolean isfx = (Boolean)m.getValue("isfx");
        boolean isfxpricetaxtotal = (Boolean)m.getValue("isfxpricetaxtotal");
        if (!isfx && !isfxpricetaxtotal) {
            return;
        }
        BigDecimal tax = (BigDecimal)m.getValue("e_tax", index);
        BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
        BigDecimal recamount = (BigDecimal)m.getValue("e_recamount", index);
        DynamicObject org = (DynamicObject)m.getValue("org");
        Boolean isCheck = this.isFxCheckMap.get(org.getLong("id"));
        if (isCheck == null) {
            isCheck = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"ar_022");
            this.isFxCheckMap.put(org.getLong("id"), isCheck);
        }
        BigDecimal fxRange = null;
        if (isCheck.booleanValue()) {
            fxRange = this.fxRangeMap.get(org.getLong("id"));
            if (fxRange == null) {
                fxRange = (BigDecimal)kd.fi.arapcommon.helper.SystemParameterHelper.getARAppParameter((Long)org.getLong("id"), (String)"ar022_condition");
            }
            if (fxRange == null) {
                fxRange = BigDecimal.ZERO;
            }
            this.fxRangeMap.put(org.getLong("id"), fxRange);
        }
        if (isfx && tax.add(amount).compareTo(priceCalculator.getPricetaxtotal()) == 0) {
            if (isCheck.booleanValue()) {
                BigDecimal taxRange = tax.subtract(priceCalculator.getTax()).abs();
                BigDecimal amountRange = amount.subtract(priceCalculator.getAmount()).abs();
                if (taxRange.compareTo(fxRange) > 0 || amountRange.compareTo(fxRange) > 0) {
                    return;
                }
            }
            priceCalculator.setTax(tax);
            priceCalculator.setAmount(amount);
        } else if (isfxpricetaxtotal) {
            if (BigDecimal.ZERO.compareTo(recamount) == 0) {
                return;
            }
            if (isCheck.booleanValue()) {
                BigDecimal priceTaxTotalRange = recamount.subtract(priceCalculator.getPricetaxtotal()).abs();
                BigDecimal taxRange = tax.subtract(priceCalculator.getTax()).abs();
                if (taxRange.compareTo(fxRange) > 0 || priceTaxTotalRange.compareTo(fxRange) > 0) {
                    return;
                }
            }
            priceCalculator.setTax(tax);
            priceCalculator.setPricetaxtotal(recamount);
            priceCalculator.setAmount(recamount.subtract(tax));
        }
    }

    private void checkIsFx(Map sourceData) {
        boolean isfxpricetaxtotal;
        boolean isfx = sourceData.get("isfx") != null && (Boolean)sourceData.get("isfx") != false;
        boolean bl = isfxpricetaxtotal = sourceData.get("isfxpricetaxtotal") != null && (Boolean)sourceData.get("isfxpricetaxtotal") != false;
        if (isfx && isfxpricetaxtotal) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5fae\u8c03\u91d1\u989d\u4e0e\u5fae\u8c03\u5e94\u6536\u91d1\u989d\u5f00\u5173\u4e0d\u53ef\u540c\u65f6\u6253\u5f00\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"FinArBillImportHelper_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkPriceandAmount(boolean ispresent, boolean includetax, boolean ispricetotal, Map entry, int index) {
        if (!ispresent) {
            if (includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("e_taxunitprice"), ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"FinArBillImportHelper_3", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("e_unitprice"), ResManager.loadKDString((String)"\u5355\u4ef7", (String)"FinArBillImportHelper_4", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_amount"), ResManager.loadKDString((String)"\u91d1\u989d", (String)"FinArBillImportHelper_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            } else if (includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_recamount"), ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"FinArBillImportHelper_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            }
        }
    }

    private void checkEntryNull(Object value, String title, int index) {
        if (!this.isNull(value)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff0c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinArBillImportHelper_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), index, title));
        }
    }

    private boolean isNull(Object value) {
        boolean notNull = false;
        if (!ObjectUtils.isEmpty((Object)value)) {
            if (value instanceof Map) {
                Map vData = (Map)value;
                String importprop = (String)vData.get("importprop");
                if (StringUtils.isNotEmpty((String)importprop) && StringUtils.isNotEmpty((String)((String)vData.get(importprop)))) {
                    notNull = true;
                } else {
                    String vNum = (String)vData.get("number");
                    String vName = (String)vData.get("name");
                    if (!StringUtils.isEmpty((String)vNum) || !StringUtils.isEmpty((String)vName)) {
                        notNull = true;
                    }
                }
            }
            if (value instanceof String) {
                notNull = true;
            }
            if (value instanceof BigDecimal) {
                notNull = true;
            }
            if (value instanceof Double) {
                notNull = true;
            }
            if (value instanceof Integer) {
                notNull = true;
            }
        }
        return notNull;
    }

    private void createByInit(Map sourceData) {
        Date bizDate;
        Date currentDate;
        DynamicObject currency = this.init.getStandardCurrency();
        this.model.setValue("basecurrency", currency.getPkValue());
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exchangerate"))) {
            this.model.setValue("exchangerate", (Object)1);
        }
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        FormServiceHelper.checkMeasureUnitRange((IDataModel)this.model, (String)"entry", (String)"e_material", (String)"e_measureunit");
        DynamicObject srcCurrency = (DynamicObject)this.model.getValue("currency");
        DynamicObject baseCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)srcCurrency) && !ObjectUtils.isEmpty((Object)baseCurrency) && srcCurrency.getPkValue().equals(baseCurrency.getPkValue())) {
            this.model.setValue("quotation", (Object)"0");
            this.model.setValue("exchangerate", (Object)BigDecimal.ONE);
        } else {
            this.getQuotationHelper().getExchangeRate4Import(this.model);
        }
        DynamicObject headOrg = this.model.getDataEntity().getDynamicObject("org");
        boolean isBankOrg = headOrg.getBoolean("fisbankroll");
        if (ObjectUtils.isEmpty(sourceData.get("recorg")) && isBankOrg) {
            this.model.setValue("recorg", (Object)headOrg.getLong("id"));
        }
        boolean isSale = headOrg.getBoolean("fissale");
        if (ObjectUtils.isEmpty(sourceData.get("salesorg")) && isSale) {
            this.model.setValue("salesorg", (Object)headOrg.getLong("id"));
        }
        if (!"true".equals(this.pageCache.get("isWebApi")) && (currentDate = ObjectUtils.isEmpty((Object)this.init.getCurrentDate()) ? this.init.getStartDate() : this.init.getCurrentDate()).after(bizDate = (Date)this.model.getValue("bizdate"))) {
            this.model.setValue("bizdate", (Object)currentDate);
            if (ObjectUtils.isEmpty((Object)"duedate")) {
                this.model.setValue("duedate", (Object)currentDate);
            }
        }
    }

    private void calPlanEntity(boolean isNew) {
        if (!isNew) {
            FinArBillFormHelper.calculateAllPlanRow((IBillModel)this.model);
        } else {
            DynamicObjectCollection planEntry = this.model.getEntryEntity("planentity");
            if (this.isPlanEntryEmpty(planEntry)) {
                if (!QueryServiceHelper.exists((String)"ar_finarbill", (Object)((IBillModel)this.model).getPKValue())) {
                    FinArBillFormHelper.calculateAllPlanRow((IBillModel)this.model);
                }
            } else {
                String quotation = (String)this.model.getValue("quotation");
                BigDecimal exchangeRate = (BigDecimal)this.model.getValue("exchangerate");
                if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                    quotation = "0";
                }
                int localPrecision = FinArBillFormHelper.getLocalPrecision((IBillModel)this.model);
                for (int i = 0; i < planEntry.size(); ++i) {
                    BigDecimal recamount = (BigDecimal)this.model.getValue("planpricetax", i);
                    BigDecimal reclocalamt = BigDecimal.ZERO;
                    reclocalamt = "0".equals(quotation) ? recamount.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP) : recamount.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                    this.model.setValue("planpricetaxloc", (Object)reclocalamt, i);
                    this.model.setValue("unplansettlelocamt", (Object)reclocalamt, i);
                    this.model.setValue("unplansettleamt", (Object)recamount, i);
                    this.model.setValue("unplanlockamt", (Object)recamount, i);
                }
            }
        }
    }

    private void fxLocalCalculate(IDataModel m, PriceLocalCalculator priceCalculator, int index) {
        boolean isFx = (Boolean)m.getValue("isfx");
        boolean isFxPriceTaxTotal = (Boolean)m.getValue("isfxpricetaxtotal");
        boolean isFxLocal = (Boolean)m.getValue("isfxlocal");
        BigDecimal taxLocal = (BigDecimal)m.getValue("e_taxlocalamt", index);
        BigDecimal amtLocal = (BigDecimal)m.getValue("e_localamt", index);
        BigDecimal priceTaxLocal = (BigDecimal)m.getValue("e_reclocalamt", index);
        if (isFxLocal && (isFxPriceTaxTotal || isFx)) {
            boolean overRange;
            if (this.fxLocalAmtHandler == null) {
                this.fxLocalAmtHandler = new FxLocalAmtHandler("ar_finarbill");
            }
            if (overRange = this.fxLocalAmtHandler.getImportToleranceServiceResult(index, m)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u91d1\u989d\u672c\u4f4d\u5e01\u3001\u7a0e\u989d\u672c\u4f4d\u5e01\u3001\u5e94\u6536\u91d1\u989d\u672c\u4f4d\u5e01\u4e0e\u6309\u6c47\u7387\u8ba1\u7b97\u7684\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\uff08\u8def\u5f84\uff1a\u57fa\u7840\u670d\u52a1\u4e91>\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u5bb9\u5dee\u65b9\u6848\uff09\u3002", (String)"FinArBillImportHelper_10", (String)"fi-ar-formplugin", (Object[])new Object[0]), (String)m.getValue("billno"), index + 1));
            }
            if (taxLocal.add(amtLocal).compareTo(priceTaxLocal) == 0) {
                priceCalculator.setTaxlocal(taxLocal);
                priceCalculator.setAmountlocal(amtLocal);
                priceCalculator.setPricetaxtotallocal(priceTaxLocal);
            } else {
                priceCalculator.setTaxlocal(taxLocal);
                priceCalculator.setAmountlocal(priceTaxLocal.subtract(taxLocal));
                priceCalculator.setPricetaxtotallocal(priceTaxLocal);
            }
        }
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(22);
        headFields.add("verifystatus");
        headFields.add("settlestatus");
        headFields.add("billstatus");
        headFields.add("quotation");
        headFields.add("recamount");
        headFields.add("reclocalamt");
        headFields.add("amount");
        headFields.add("localamt");
        headFields.add("tax");
        headFields.add("taxlocamt");
        headFields.add("unverifyamount");
        headFields.add("unsettleamount");
        headFields.add("unsettlelocalamt");
        headFields.add("settleamount");
        headFields.add("settlelocalamt");
        headFields.add("uninvoicedamt");
        headFields.add("uninvoicedlocalamt");
        headFields.add("invoicedamt");
        headFields.add("invoicedlocalamt");
        headFields.add("adjustamount");
        headFields.add("adjustlocalamt");
        headFields.add("issueinvrecamt");
        headFields.add("issueinvreclocalamt");
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(21);
        entryFields.add("e_actunitprice");
        entryFields.add("e_acttaxunitprice");
        entryFields.add("e_verifiedamt");
        entryFields.add("e_unverifyamt");
        entryFields.add("e_lockedamt");
        entryFields.add("e_unlockamt");
        entryFields.add("e_settledamt");
        entryFields.add("e_settledlocalamt");
        entryFields.add("e_unsettleamt");
        entryFields.add("e_unsettlelocalamt");
        entryFields.add("e_verifiedqty");
        entryFields.add("e_unverifyqty");
        entryFields.add("e_verifybaseqty");
        entryFields.add("e_unverifybaseqty");
        entryFields.add("e_uninvoicedamt");
        entryFields.add("e_fixlockedamt");
        entryFields.add("e_fixsettleedamt");
        entryFields.add("e_unconfirmamt");
        entryFields.add("e_unconfirmqty");
        entryFields.add("e_confirmedbaseqty");
        entryFields.add("e_unconfirmbaseqty");
        entryFields.add("subentryentity");
        return entryFields;
    }

    private final List<String> planEntryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(29);
        entryFields.add("unplansettleamt");
        entryFields.add("unplansettlelocamt");
        entryFields.add("plansettledamt");
        entryFields.add("plansettledlocamt");
        entryFields.add("unplanlockamt");
        entryFields.add("planlockedamt");
        return entryFields;
    }

    private final List<String> headRemoveUpFields() {
        ArrayList<String> headUpdFields = new ArrayList<String>(29);
        headUpdFields.add("asstacttype");
        headUpdFields.add("asstact");
        headUpdFields.add("org");
        headUpdFields.add("billtype");
        headUpdFields.add("billstatus");
        headUpdFields.add("salesgroup");
        headUpdFields.add("verifystatus");
        headUpdFields.add("settlestatus");
        headUpdFields.add("istransfer");
        headUpdFields.add("imageno");
        headUpdFields.add("isarchive");
        headUpdFields.add("iswrittenoff");
        headUpdFields.add("hadwrittenoff");
        headUpdFields.add("relationpay");
        headUpdFields.add("bookdate");
        headUpdFields.add("currency");
        headUpdFields.add("recamount");
        headUpdFields.add("amount");
        headUpdFields.add("tax");
        headUpdFields.add("reclocalamt");
        headUpdFields.add("localamt");
        headUpdFields.add("invoicedamt");
        headUpdFields.add("unsettleamount");
        headUpdFields.add("unsettlelocalamt");
        headUpdFields.add("settleamount");
        headUpdFields.add("settlelocalamt");
        headUpdFields.add("adjustamount");
        headUpdFields.add("adjustlocalamt");
        headUpdFields.add("isincludetax");
        return headUpdFields;
    }

    private final List<String> entryRemoveUpFields() {
        ArrayList<String> entryUpdFields = new ArrayList<String>(22);
        entryUpdFields.add("e_material");
        entryUpdFields.add("e_measureunit");
        entryUpdFields.add("e_ispresent");
        entryUpdFields.add("e_corebilltype");
        entryUpdFields.add("e_corebillno");
        entryUpdFields.add("e_corebillentryseq");
        entryUpdFields.add("e_baseunit");
        entryUpdFields.add("e_baseunitqty");
        entryUpdFields.add("e_unitcoefficient");
        entryUpdFields.add("e_invoicedqty");
        entryUpdFields.add("e_invoicedamt");
        entryUpdFields.add("e_uninvoicedamt");
        entryUpdFields.add("e_lockedamt");
        entryUpdFields.add("e_unlockamt");
        entryUpdFields.add("e_settledamt");
        entryUpdFields.add("e_settledlocalamt");
        entryUpdFields.add("e_unsettleamt");
        entryUpdFields.add("e_unsettlelocalamt");
        entryUpdFields.add("e_verifiedqty");
        entryUpdFields.add("e_verifiedamt");
        entryUpdFields.add("e_acttaxunitprice");
        entryUpdFields.add("e_expenseitem");
        return entryUpdFields;
    }
}

