/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.formplugin.formservice.PremiumEditController;
import kd.fi.ar.formplugin.formservice.fin.FinArBillAmtCalculateHandler;
import kd.fi.ar.formplugin.formservice.fin.FinArBillPlanEntryHelper;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.arapcommon.form.AbstractBillEditHandler;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.PrecisionHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.BillStatusCtrlService;
import kd.fi.arapcommon.service.plan.split.PlanRowSplitService;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndFiller;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.sdk.fi.ar.extpoint.plan.IPlanRowSplit;

public class FinArBillPropertyChangeHandler
extends AbstractBillEditHandler {
    private InitHelper initInfo;
    private final BillStatusCtrlService billStatusCtrlService = new BillStatusCtrlService();
    private FinArBillAmtCalculateHandler amtCalculateHandler;
    private Map<String, DynamicObject[]> splitSchemesCache;
    private PluginProxy<IPlanRowSplit> planSplitPlugin;
    private PremiumEditController premiumEditController;

    public FinArBillPropertyChangeHandler(AbstractBillPlugIn billPlugIn) {
        super(billPlugIn);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeDatas = e.getChangeSet();
        Object oldValue = changeDatas[0].getOldValue();
        Object newValue = changeDatas[0].getNewValue();
        int currentIndex = changeDatas[0].getRowIndex();
        IBillModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        if (!this.billStatusCtrlService.isCanChange(billStatus)) {
            return;
        }
        switch (key) {
            case "splitscheme": {
                this.calculatePlanEntryAndSetHeadDueDate();
                break;
            }
            case "currency": {
                int newPrecision;
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"currency", (Object)oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int oldPrecision = ((DynamicObject)oldValue).getInt("amtprecision");
                if (oldPrecision != (newPrecision = ((DynamicObject)newValue).getInt("amtprecision"))) {
                    this.calculateAllAmtByHead();
                    this.calculatePlanEntryAndSetHeadDueDate();
                }
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "billtype": {
                if (newValue != null) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)key, (Object)oldValue);
                return;
            }
            case "exratetable": 
            case "exratedate": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)key, (Object)oldValue);
                    return;
                }
                if (oldValue != null) break;
                return;
            }
            case "exchangerate": {
                BigDecimal oldExrate = BigDecimal.ZERO;
                if (!EmptyUtils.isEmpty((Object)oldValue)) {
                    oldExrate = (BigDecimal)oldValue;
                }
                if (EmptyUtils.isEmpty((Object)newValue) && oldExrate.compareTo(BigDecimal.valueOf(-1L)) != 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"FinArBillEdit_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.calculateAllAmtByHead();
                this.calculatePlanEntryAndSetHeadDueDate();
                break;
            }
            case "e_material": {
                this.getModel().setValue("e_materialversion", null, currentIndex);
                model.setValue("configuredcode", null, currentIndex);
                model.setValue("tracknumber", null, currentIndex);
                model.setValue("e_productline", null, currentIndex);
                this.materialChanged(changeDatas);
                break;
            }
            case "asstact": {
                Map customersMap;
                this.setReceivingcond(newValue);
                String asstactType = (String)model.getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)model.getValue("asstact");
                if (asstact == null) {
                    this.clearAssLinkcustomer();
                    return;
                }
                if ("bd_customer".equals(asstactType) && (customersMap = FinArBillHelper.setCustomersToViewCash((IDataModel)this.getModel(), (IPageCache)this.getView().getPageCache())).size() > 0) {
                    int count = model.getEntryRowCount("entry");
                    Object invCustomerId = customersMap.get("invoiceCustomerId");
                    Object deliverCustomerId = customersMap.get("deliverCustomerId");
                    for (int i = 0; i < count; ++i) {
                        model.setValue("e_invoicecustomerid", invCustomerId, i);
                        model.setValue("e_delivercustomerid", deliverCustomerId, i);
                    }
                }
                boolean isBizPartner = this.isBizPartner(asstact);
                model.setValue("relationpay", (Object)isBizPartner);
                long asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"));
                if (asstactSettleTypeId == 0L) {
                    return;
                }
                model.setValue("settlementtype", (Object)asstactSettleTypeId);
                break;
            }
            case "settlementtype": {
                DynamicObject headSettleType = (DynamicObject)model.getValue("settlementtype");
                if (ObjectUtils.isEmpty((Object)headSettleType)) break;
                int planCount = model.getEntryRowCount("planentity");
                for (int j = 0; j < planCount; ++j) {
                    model.setValue("plansettletype", (Object)headSettleType.getLong("id"), j);
                }
                break;
            }
            case "e_measureunit": {
                this.calculateBaseQty(currentIndex);
                this.calculateQty(currentIndex);
                break;
            }
            case "e_discountamount": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(currentIndex, (IDataModel)this.getModel(), key, BillModelFactory.getModel((String)"ar_finarbill"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "e_discountmode": {
                model.setValue("e_discountrate", (Object)BigDecimal.ZERO, currentIndex);
                if ("TOTAL".equals(newValue)) {
                    model.setValue("e_discountamount", (Object)BigDecimal.ZERO, currentIndex);
                }
                this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                break;
            }
            case "e_discountrate": 
            case "e_taxrate": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(currentIndex, (IDataModel)this.getModel(), key, BillModelFactory.getModel((String)"ar_finarbill"));
                this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                break;
            }
            case "e_ispresent": {
                boolean isPriceTotal = (Boolean)this.getModel().getValue("ispricetotal");
                boolean curIsPresent = (Boolean)newValue;
                BigDecimal rice = (BigDecimal)model.getValue("e_unitprice", currentIndex);
                BigDecimal priceTax = (BigDecimal)model.getValue("e_taxunitprice", currentIndex);
                if (isPriceTotal) {
                    this.getModel().beginInit();
                    if ((BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) && curIsPresent) {
                        model.setValue("e_discountmode", (Object)"PERCENT", currentIndex);
                        model.setValue("e_discountrate", (Object)new BigDecimal(100), currentIndex);
                    } else {
                        model.setValue("e_discountmode", (Object)"NULL", currentIndex);
                        model.setValue("e_discountrate", (Object)BigDecimal.ZERO, currentIndex);
                        model.setValue("e_discountamount", (Object)BigDecimal.ZERO, currentIndex);
                    }
                    this.getModel().endInit();
                    this.getAmtCalculateHandler().calculateAllAmtByDetailEntryPresent(currentIndex, key, oldValue);
                    this.getView().updateView("entry");
                    break;
                }
                if ((BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) && curIsPresent) {
                    model.setValue("e_discountmode", (Object)"PERCENT", currentIndex);
                    model.setValue("e_discountrate", (Object)new BigDecimal(100), currentIndex);
                    break;
                }
                model.setValue("e_discountmode", (Object)"NULL", currentIndex);
                break;
            }
            case "e_quantity": {
                model.setValue("e_unverifyqty", newValue, currentIndex);
                if ("ar_invoice".equals(this.getModel().getValue("sourcebilltype"))) {
                    model.setValue("e_invoicedqty", newValue, currentIndex);
                } else {
                    model.setValue("e_uninvoicedqty", newValue, currentIndex);
                }
                model.setValue("e_unconfirmqty", (Object)((BigDecimal)newValue).subtract((BigDecimal)model.getValue("e_confirmedqty", currentIndex)), currentIndex);
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(currentIndex, (IDataModel)this.getModel(), key, BillModelFactory.getModel((String)"ar_finarbill"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                this.calculateBaseQty(currentIndex);
                this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                break;
            }
            case "e_unitprice": 
            case "e_taxunitprice": {
                boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", currentIndex);
                if (isPresent) {
                    BigDecimal price = (BigDecimal)newValue;
                    if (BigDecimal.ZERO.compareTo(price) == 0) {
                        model.setValue("e_discountmode", (Object)"NULL", currentIndex);
                    } else {
                        model.setValue("e_discountmode", (Object)"PERCENT", currentIndex);
                        model.setValue("e_discountrate", (Object)new BigDecimal(100), currentIndex);
                    }
                }
                this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                break;
            }
            case "isbaddebt": {
                boolean isBaddebt = (Boolean)newValue;
                if (!isBaddebt) {
                    this.getModel().setValue("baddebtamt", null);
                }
                ((FieldEdit)this.getView().getControl("baddebtamt")).setMustInput(isBaddebt);
                this.getView().setEnable(Boolean.valueOf(isBaddebt), new String[]{"baddebtamt"});
                break;
            }
            case "e_recamount": 
            case "e_amount": {
                String billTypeNo = ((DynamicObject)model.getValue("billtype")).getString("number");
                String srcBillType = (String)model.getValue("sourcebilltype");
                if (!(((Boolean)this.getModel().getValue("isfx")).booleanValue() || ((Boolean)this.getModel().getValue("isfxpricetaxtotal")).booleanValue() || "arfin_borrowar_BT_S".equals(billTypeNo) && EmptyUtils.isNotEmpty((Object)srcBillType))) {
                    this.calculateAllAmtByDetailEntry(currentIndex, key, oldValue);
                    break;
                }
            }
            case "e_tax": 
            case "e_adjustamount": {
                this.ifFxCalculate(currentIndex, key, (BigDecimal)oldValue);
                break;
            }
            case "recamount": {
                this.recAmountChanged((BigDecimal)newValue);
                break;
            }
            case "planpricetax": {
                this.entryAmtChanged((BigDecimal)newValue, currentIndex);
                PlanSplitAndFiller.calAmountPlanForView((IFormView)this.getView(), (int)currentIndex);
                break;
            }
            case "e_localamt": 
            case "e_taxlocalamt": {
                boolean isFxLocal = (Boolean)this.getModel().getValue("isfxlocal");
                if (!isFxLocal) break;
                boolean isTansfer = (Boolean)this.getModel().getValue("istransfer");
                boolean isPremium = (Boolean)this.getModel().getValue("ispremium");
                DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
                String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
                boolean isAdjustType = "arfin_borrowar_BT_S".equals(billType.getString("number")) && "ar_finarbill".equals(sourceBillType);
                Map<String, BigDecimal> amountMap = this.getAmountMap(currentIndex, oldValue, key);
                if (isPremium || isTansfer || isAdjustType) {
                    this.getAmtCalculateHandler().ifFxLocalCalculateToSpecialType(currentIndex, key, (BigDecimal)newValue);
                } else {
                    this.getAmtCalculateHandler().ifFxLocalCalculate(currentIndex, key, (BigDecimal)newValue);
                }
                this.updateViewEntry(currentIndex);
                this.getAmtCalculateHandler().updateHeadValue(currentIndex, amountMap);
                FinArBillPlanEntryHelper.calculatePlanEntry(this.getView(), this.getPlanSplitPluginProvider());
                break;
            }
            case "bizdate": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)key, (Object)oldValue);
                    return;
                }
                BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)true);
                this.loadInitInfo();
                Boolean isPeriod = (Boolean)this.getModel().getValue("isperiod");
                if (isPeriod.booleanValue()) {
                    this.setDatePropRangeForPeriod();
                } else {
                    this.setDatePropRange();
                }
                this.calculatePlanEntryAndSetHeadDueDate();
                break;
            }
            case "paycond": {
                if (newValue == null) {
                    this.getModel().setValue("duedate", this.getModel().getValue("bizdate"));
                }
                this.calculatePlanEntryAndSetHeadDueDate();
                break;
            }
            case "duedate": {
                this.setPlanDuedateRange();
                if (newValue != null) break;
                this.getModel().setValue("duedate", this.getModel().getValue("bizdate"));
                break;
            }
            case "payproperty": {
                DynamicObject billtye = (DynamicObject)model.getValue("billtype");
                Object sourceBillType = model.getValue("sourcebilltype");
                if ("arfin_borrowar_BT_S".equals(billtye.getString("number")) && "ar_finarbill".equals(sourceBillType)) break;
                FormServiceHelper.paypropertyChanged((IDataModel)model, (String)"entry", (String)"e_quantity");
                break;
            }
            case "e_corebilltype": {
                model.setValue("e_corebillno", null, currentIndex);
                model.setValue("e_corebillentryseq", null, currentIndex);
                break;
            }
            case "isfx": {
                if (!((Boolean)newValue).booleanValue()) break;
                model.setValue("isfxpricetaxtotal", (Object)Boolean.FALSE);
                break;
            }
            case "isfxpricetaxtotal": {
                if (!((Boolean)newValue).booleanValue()) break;
                model.setValue("isfx", (Object)Boolean.FALSE);
                break;
            }
            case "biztype": {
                DynamicObject supplier;
                if (Objects.equals(newValue, oldValue)) break;
                DynamicObject oldBizType = (DynamicObject)oldValue;
                String type = (String)model.getValue("asstacttype");
                String message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"FinArBillEdit_31", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                if ("bd_supplier".equals(type) && !this.isVmi((DynamicObject)newValue, supplier = (DynamicObject)model.getValue("asstact"))) {
                    message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u5f80\u6765\u6237\u4fe1\u606f\u53ca\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"FinArBillEdit_33", (String)"fi-ar-formplugin", (Object[])new Object[0]);
                }
                this.getView().getPageCache().put("OLDBIZTYPEID", String.valueOf(oldValue == null ? Long.valueOf(0L) : oldBizType.getPkValue()));
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this.getBillPlugIn()));
                break;
            }
            case "asstacttype": {
                this.setAsstactCaption();
                this.clearAssLinkcustomer();
                break;
            }
            case "ispreentry": {
                this.getModel().deleteEntryData("preentry");
                this.getModel().createNewEntryRow("preentry");
                break;
            }
            case "p_recrate": {
                PlanSplitAndFiller.calAmountPlanForView((IFormView)this.getView(), (int)currentIndex);
                break;
            }
            case "planduedate": {
                FinArBillPlanEntryHelper.setHeadDueDate((IDataModel)this.getModel());
                DateEdit headDueDateControl = (DateEdit)this.getView().getControl("duedate");
                headDueDateControl.setMinDate((Date)this.getView().getModel().getValue("duedate"));
                break;
            }
            case "premiumamt": {
                this.premiumAmountChanged(newValue);
                break;
            }
            case "premiumrate": {
                this.premiumRateChanged(newValue);
                break;
            }
        }
        MainEntityType mainEntityType = model.getDataEntityType();
        IDataEntityProperty property = mainEntityType.findProperty(key);
        if (mainEntityType.getProperty(key) != null && (property instanceof BasedataProp || property instanceof TextProp || property instanceof ComboProp || property instanceof BooleanProp) && !"splitscheme".equals(key) && !"billno".equals(key) && "A".equals(this.getModel().getValue("billstatus")) && !((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue() && !((Boolean)this.getModel().getValue("istransfer")).booleanValue()) {
            this.matchSplitSchemeAndSplitPlan();
        }
        if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue() && ((Boolean)this.getModel().getValue("istransfer")).booleanValue()) {
            return;
        }
        DynamicObject splitScheme = (DynamicObject)model.getValue("splitscheme");
        HashMap<String, String> dimensionMappings = new HashMap<String, String>(2);
        if (PlanSplitServiceHelper.isSplitByCoreBill()) {
            dimensionMappings.put("e_corebillno", "plancorebillno");
            dimensionMappings.put("corebillid", "plancorebillid");
        }
        if (splitScheme != null) {
            dimensionMappings.putAll(PlanSplitSchemeServiceHelper.getDimensionMapBySchemeId((long)splitScheme.getLong("id"), (DynamicObjectType)splitScheme.getDynamicObjectType()));
        }
        if (dimensionMappings.get(key) != null) {
            this.calculatePlanEntryAndSetHeadDueDate();
        }
    }

    private void loadInitInfo() {
        if (this.initInfo == null) {
            IBillModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            long orgId = (Long)org.getPkValue();
            this.initInfo = new InitHelper(orgId, "ar_init");
        }
    }

    private void matchSplitSchemeAndSplitPlan() {
        DynamicObject[] matchSchemes;
        IBillModel model = this.getModel();
        DynamicObject finBill = model.getDataEntity(true);
        if (this.splitSchemesCache == null) {
            this.splitSchemesCache = new HashMap<String, DynamicObject[]>();
            matchSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes((DynamicObject)finBill);
            this.splitSchemesCache.put("matchSchemes", matchSchemes);
        } else {
            matchSchemes = this.splitSchemesCache.get("matchSchemes");
        }
        DynamicObject oldSplitScheme = (DynamicObject)this.getModel().getValue("splitscheme");
        DynamicObject splitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finBill, (DynamicObject[])matchSchemes);
        model.beginInit();
        this.getModel().setValue("splitscheme", (Object)splitScheme);
        model.endInit();
        this.getView().updateView("splitscheme");
        if (oldSplitScheme == null) {
            if (splitScheme != null) {
                this.calculatePlanEntryAndSetHeadDueDate();
            }
        } else if (splitScheme == null) {
            this.calculatePlanEntryAndSetHeadDueDate();
        } else if (oldSplitScheme.getLong("id") != splitScheme.getLong("id")) {
            this.calculatePlanEntryAndSetHeadDueDate();
        }
    }

    private void setDatePropRange() {
        if (ObjectUtils.isEmpty((Object)this.initInfo.getInitId())) {
            return;
        }
        Date currentDate = this.initInfo.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = this.initInfo.getStartDate();
        }
        DateEdit bookDate = (DateEdit)this.getView().getControl("bookdate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        if (bizDate == null) {
            bizDate = new Date();
        }
        bookDate.setMinDate(currentDate.before(bizDate) ? bizDate : currentDate);
        DateEdit premDueDate = (DateEdit)this.getView().getControl("premduedate");
        premDueDate.setMinDate(bizDate);
        DateEdit headDueDate = (DateEdit)this.getView().getControl("duedate");
        headDueDate.setMinDate(bizDate);
        DateEdit planDueDate = (DateEdit)this.getView().getControl("planduedate");
        planDueDate.setMinDate(bizDate);
        planDueDate.setMaxDate((Date)this.getModel().getValue("duedate"));
    }

    private void setDatePropRangeForPeriod() {
        if (ObjectUtils.isEmpty((Object)this.initInfo.getInitId())) {
            return;
        }
        Date startDate = this.initInfo.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        DateEdit bizdate = (DateEdit)this.getView().getControl("bizdate");
        bizdate.setMaxDate(lastDay);
        DateEdit bookDate = (DateEdit)this.getView().getControl("bookdate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        bookDate.setMinDate(bizDate);
        bookDate.setMaxDate(lastDay);
        DateEdit premDueDate = (DateEdit)this.getView().getControl("premduedate");
        premDueDate.setMinDate(bizDate);
        DateEdit headDueDate = (DateEdit)this.getView().getControl("duedate");
        headDueDate.setMinDate(bizDate);
        DateEdit planDueDate = (DateEdit)this.getView().getControl("planduedate");
        planDueDate.setMinDate(bizDate);
        planDueDate.setMaxDate((Date)this.getModel().getValue("duedate"));
    }

    private void recAmountChanged(BigDecimal amount) {
        boolean ispremium = (Boolean)this.getModel().getValue("ispremium");
        if (!ispremium) {
            this.getPremiumEditController().amountChanged(amount);
        }
        this.calculatePlanEntryAndSetHeadDueDate();
    }

    private void calculateBaseQty(int rowIndex) {
        IBillModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        DynamicObject material = (DynamicObject)model.getValue("e_material", rowIndex);
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit", rowIndex);
        if (baseUnit == null && (baseUnit = material.getDynamicObject("baseunit")) != null) {
            model.setValue("e_baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit == null) {
            return;
        }
        long baseUnitID = (Long)baseUnit.getPkValue();
        long measureUnitID = (Long)measureUnit.getPkValue();
        long materialID = (Long)material.getPkValue();
        BigDecimal convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (convertRate != null) {
            model.setValue("e_unitcoefficient", (Object)convertRate, rowIndex);
            if (quantity != null) {
                BigDecimal baseQty = convertRate.multiply(quantity);
                model.setValue("e_baseunitqty", (Object)baseQty, rowIndex);
                model.setValue("e_unverifybaseqty", (Object)baseQty, rowIndex);
                model.setValue("e_unconfirmbaseqty", (Object)baseQty.subtract((BigDecimal)model.getValue("e_confirmedbaseqty", rowIndex)), rowIndex);
            }
        }
    }

    private void calculateQty(int rowIndex) {
        IBillModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (quantity != null) {
            model.setValue("e_quantity", (Object)quantity.setScale(measureUnit.getInt("precision"), 4), rowIndex);
        }
    }

    private void materialChanged(ChangeData[] changeDatas) {
        int row = changeDatas[0].getRowIndex();
        Object newValue = changeDatas[0].getNewValue();
        if (newValue != null) {
            DynamicObject productline;
            IBillModel model = this.getModel();
            DynamicObject material = (DynamicObject)newValue;
            model.setValue("e_spectype", (Object)material.getString("modelnum"), row);
            DynamicObject baseunit = material.getDynamicObject("baseunit");
            if (baseunit != null) {
                Object baseunitPk = baseunit.getPkValue();
                model.setValue("e_baseunit", baseunitPk, row);
                model.setValue("e_measureunit", baseunitPk, row);
                model.setValue("e_baseunitqty", model.getValue("e_quantity", row), row);
                model.setValue("e_unitcoefficient", (Object)BigDecimal.ONE, row);
                model.setValue("e_unverifybaseqty", model.getValue("e_baseunitqty", row), row);
                model.setValue("e_unconfirmbaseqty", model.getValue("e_baseunitqty", row), row);
            }
            if ((productline = material.getDynamicObject("productline")) != null) {
                this.getModel().setValue("e_productline", productline.getPkValue(), row);
            }
            if (material.getDynamicObject("taxrate") != null) {
                Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                model.setValue("taxrateid", taxrateId, row);
            }
        } else {
            this.getModel().setValue("e_spectype", null, row);
        }
    }

    private void entryAmtChanged(BigDecimal newValue, int currentIndex) {
        IBillModel m = this.getModel();
        BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
        String quotation = "0";
        if (m.getProperty("quotation") != null) {
            quotation = (String)m.getValue("quotation");
        }
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)m.getValue("basecurrency");
        if (baseCurrency != null) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        BigDecimal localamount = "1".equals(quotation) ? newValue.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP) : newValue.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
        m.setValue("planpricetaxloc", (Object)localamount, currentIndex);
        m.setValue("unplansettlelocamt", (Object)localamount, currentIndex);
        m.setValue("unplansettleamt", (Object)newValue, currentIndex);
        m.setValue("unplanlockamt", (Object)newValue, currentIndex);
    }

    private void clearAssLinkcustomer() {
        this.getModel().setValue("paymentcustomerid", null);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (entrys != null && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("e_invoicecustomerid", null, i);
                this.getModel().setValue("e_delivercustomerid", null, i);
            }
        }
    }

    private boolean isBizPartner(DynamicObject custsupper) {
        DynamicObject asstact;
        DynamicObject intercompany;
        boolean isBizPartner = false;
        if (custsupper != null && (custsupper.getDataEntityType().getName().equals("bd_supplier") || custsupper.getDataEntityType().getName().equals("bd_customer")) && (intercompany = (asstact = BusinessDataServiceHelper.loadSingle((Object)custsupper.getPkValue(), (String)custsupper.getDynamicObjectType().getName(), (String)"internal_company")).getDynamicObject("internal_company")) != null) {
            isBizPartner = true;
        }
        return isBizPartner;
    }

    private boolean isVmi(DynamicObject bizType, DynamicObject asstact) {
        if (ObjectUtils.isEmpty((Object)bizType) || ObjectUtils.isEmpty((Object)asstact)) {
            return true;
        }
        boolean isMatch = true;
        String domain = bizType.getString("domain");
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstact.getLong("id"))});
        boolean enableVmi = supplier.getBoolean("enablevmi");
        if (!enableVmi && "6".equals(domain)) {
            isMatch = false;
        }
        return isMatch;
    }

    private void setAsstactCaption() {
        ItemClassEdit asstact;
        String asstName;
        String asstactType = (String)this.getModel().getValue("asstacttype");
        String customerCaption = ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237", (String)"FinArBillEdit_36", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        String asstactCaption = ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"FinArBillEdit_37", (String)"fi-ar-formplugin", (Object[])new Object[0]);
        if (!asstactCaption.equals(asstName = (asstact = (ItemClassEdit)this.getView().getControl("asstact")).getProperty().getDisplayName().getLocaleValue())) {
            return;
        }
        if ("bd_customer".equals(asstactType)) {
            asstact.setCaption(new LocaleString(customerCaption));
        } else {
            asstact.setCaption(new LocaleString(asstactCaption));
        }
    }

    private void setPlanDuedateRange() {
        DateEdit plandutedate = (DateEdit)this.getView().getControl("planduedate");
        Date maxDate = (Date)this.getModel().getValue("duedate");
        if (maxDate != null) {
            plandutedate.setMaxDate(maxDate);
        }
    }

    private void setReceivingcond(Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("paycond", null);
        } else {
            DynamicObject asstact = (DynamicObject)newValue;
            DynamicObject asstactFieldValue = QueryServiceHelper.queryOne((String)"bd_customer", (String)"receivingcondid", (QFilter[])new QFilter[]{new QFilter("id", "=", asstact.getPkValue())});
            if (asstactFieldValue == null) {
                this.getModel().setValue("paycond", null);
                return;
            }
            long paycondId = asstactFieldValue.getLong("receivingcondid");
            if (paycondId == 0L) {
                this.getModel().setValue("paycond", null);
                return;
            }
            boolean exists = QueryServiceHelper.exists((String)"bd_reccondition", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paycondId), new QFilter("enable", "=", (Object)Boolean.TRUE)});
            if (exists) {
                this.getModel().setValue("paycond", (Object)paycondId);
            } else {
                this.getModel().setValue("paycond", null);
            }
        }
    }

    private void calculateAllAmtByHead() {
        this.getAmtCalculateHandler().calculateAllAmtByHead();
    }

    private void ifFxCalculate(int detailIndex, String key, BigDecimal oldValue) {
        this.getAmtCalculateHandler().ifFxCalculate(detailIndex, key, oldValue, null);
    }

    private void calculateAllAmtByDetailEntry(int entryIndex, String changeKey, Object oldValue) {
        this.getAmtCalculateHandler().calculateAllAmtByDetailEntry(entryIndex, changeKey, oldValue);
    }

    private FinArBillAmtCalculateHandler getAmtCalculateHandler() {
        if (this.amtCalculateHandler == null) {
            this.amtCalculateHandler = new FinArBillAmtCalculateHandler(this.getView());
        }
        return this.amtCalculateHandler;
    }

    private void calculatePlanEntryAndSetHeadDueDate() {
        FinArBillPlanEntryHelper.calculatePlanEntryAndSetHeadDueDate(this.getView(), this.getPlanSplitPluginProvider());
    }

    private PluginProxy<IPlanRowSplit> getPlanSplitPluginProvider() {
        if (this.planSplitPlugin == null) {
            this.planSplitPlugin = PluginProxy.create((Object)PlanRowSplitService.getInstance(), IPlanRowSplit.class, (String)"FI_AR_PLANENTRY_SPLIT");
        }
        return this.planSplitPlugin;
    }

    private void premiumRateChanged(Object premiumRate) {
        this.getPremiumEditController().premiumRateChanged((BigDecimal)premiumRate);
    }

    private void premiumAmountChanged(Object permissionAmount) {
        this.getPremiumEditController().premiumAmountChanged((BigDecimal)permissionAmount);
    }

    private PremiumEditController getPremiumEditController() {
        if (this.premiumEditController == null) {
            this.premiumEditController = new PremiumEditController((IDataModel)this.getModel());
        }
        return this.premiumEditController;
    }

    private Map<String, BigDecimal> getAmountMap(int currentIndex, Object oldValue, String key) {
        if (EmptyUtils.isEmpty((Object)oldValue)) {
            oldValue = BigDecimal.ZERO;
        }
        boolean inputTax = "e_taxlocalamt".equals(key);
        boolean inputAmount = "e_localamt".equals(key);
        BigDecimal taxLocal = inputTax ? (BigDecimal)oldValue : (BigDecimal)this.getModel().getValue("e_taxlocalamt", currentIndex);
        BigDecimal amountLocal = inputAmount ? (BigDecimal)oldValue : (BigDecimal)this.getModel().getValue("e_localamt", currentIndex);
        BigDecimal priceTaxLocal = (BigDecimal)this.getModel().getValue("e_reclocalamt", currentIndex);
        BigDecimal unSettleAmountLocal = (BigDecimal)this.getModel().getValue("e_unsettlelocalamt", currentIndex);
        BigDecimal unInvoiceAmountLocal = (BigDecimal)this.getModel().getValue("e_uninvoicedlocalamt", currentIndex);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(4);
        amountMap.put("oldTaxLocal", taxLocal);
        amountMap.put("oldAmountLocal", amountLocal);
        amountMap.put("oldPriceTaxLocal", priceTaxLocal);
        amountMap.put("oldUnSettleAmountLocal", unSettleAmountLocal);
        amountMap.put("oldUnInvoiceAmountLocal", unInvoiceAmountLocal);
        return amountMap;
    }

    private void updateViewEntry(int currentIndex) {
        this.getView().updateView("e_taxlocalamt", currentIndex);
        this.getView().updateView("e_localamt", currentIndex);
        this.getView().updateView("e_reclocalamt", currentIndex);
        this.getView().updateView("unsettleamtbase", currentIndex);
        this.getView().updateView("e_uninvoicedlocalamt", currentIndex);
    }
}

