/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice.received;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;

public class ReceivedBillImportHelper
extends AbstractBillImport {
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private QuotationHelper quotationHelper;

    public ReceivedBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public ReceivedBillImportHelper(IFormView view, IPageCache pageCache) {
        this.view = view;
        this.model = view.getModel();
        this.pageCache = pageCache;
    }

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map sourceData = e.getSourceData();
        Object currency = sourceData.get("currency");
        if (ObjectUtils.isEmpty(currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivedBillImportHelper_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        this.removeNoAssignField(sourceData, this.headFields);
        Object asstacttype = sourceData.get("asstacttype");
        if (asstacttype == null) {
            sourceData.put("asstacttype", "bd_customer");
        }
        List entryList = null;
        if (sourceData.get("entry") != null) {
            entryList = (List)sourceData.get("entry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                Map entry = (Map)entryList.get(i);
                this.removeNoAssignField(entry, this.entryFields);
                Object actPayAmt = entry.get("e_amount");
                if (!ObjectUtils.isEmpty(actPayAmt)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff0c\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivedBillImportHelper_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map sourceData = e.getSourceData();
        boolean isNew = false;
        String importType = (String)e.getOption().get("importtype");
        if ("overridenew".equals(importType) || importType == null) {
            isNew = ObjectUtils.isEmpty(sourceData.get("_pkid_"));
        } else if ("new".equals(importType)) {
            isNew = true;
        }
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        Long orgPk = (Long)org.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ar_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7:%s\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ReceivedBillImportHelper_2", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        this.init.checkInit();
        if (this.init.isFinishInit()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7:%s\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"ReceivedBillImportHelper_3", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivedBillImportHelper_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        this.createByInit();
        this.createDefaultField();
        this.setCalculatorAmt();
    }

    private void createByInit() {
        DynamicObject currency;
        DynamicObject baseCurrency = this.init.getStandardCurrency();
        this.model.setValue("basecurrency", (Object)baseCurrency);
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        if (!ObjectUtils.isEmpty((Object)(currency = (DynamicObject)this.model.getValue("currency"))) && !ObjectUtils.isEmpty((Object)baseCurrency) && currency.getPkValue().equals(baseCurrency.getPkValue())) {
            this.model.setValue("quotation", (Object)"0");
            this.model.setValue("exchangerate", (Object)BigDecimal.ONE);
        } else if (((BigDecimal)this.model.getValue("exchangerate")).compareTo(BigDecimal.ZERO) == 0) {
            this.getQuotationHelper().getExchangeRate4Import(this.model);
        }
    }

    private void createDefaultField() {
        DynamicObjectCollection entry = this.model.getEntryEntity("entry");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject productLine;
            DynamicObject material = (DynamicObject)this.model.getValue("e_material", i);
            if (ObjectUtils.isEmpty((Object)material) || (productLine = material.getDynamicObject("productline")) == null || !ObjectUtils.isEmpty((Object)this.model.getValue("e_productline", i))) continue;
            this.model.setValue("e_productline", productLine.getPkValue(), i);
        }
    }

    private void setCalculatorAmt() {
        DynamicObject baseCurrency = (DynamicObject)this.model.getValue("basecurrency");
        int precision = 2;
        if (baseCurrency != null) {
            precision = baseCurrency.getInt("amtprecision");
        }
        BigDecimal exchangeRate = (BigDecimal)this.model.getValue("exchangerate");
        String quotation = (String)this.model.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        BigDecimal recAmount = BigDecimal.ZERO;
        BigDecimal localAmount = BigDecimal.ZERO;
        DynamicObjectCollection entry = this.model.getEntryEntity("entry");
        for (int i = 0; i < entry.size(); ++i) {
            BigDecimal e_amount = (BigDecimal)this.model.getValue("e_amount", i);
            BigDecimal e_localAmount = "1".equals(quotation) ? e_amount.divide(exchangeRate, precision, RoundingMode.HALF_UP) : e_amount.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            this.model.setValue("e_localamount", (Object)e_localAmount, i);
            this.model.setValue("e_unsettledamt", (Object)e_amount, i);
            recAmount = recAmount.add(e_amount);
            localAmount = localAmount.add(e_localAmount);
        }
        this.model.setValue("recamount", (Object)recAmount);
        this.model.setValue("localamount", (Object)localAmount);
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(2);
        headFields.add("recamount");
        headFields.add("localamount");
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(5);
        entryFields.add("e_localamount");
        entryFields.add("e_settledamt");
        entryFields.add("e_unsettledamt");
        return entryFields;
    }
}

